/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.profile;

import dotty.tools.dotc.profile.EventType;
import dotty.tools.dotc.profile.EventType$;
import dotty.tools.dotc.profile.GcEventData;
import dotty.tools.dotc.profile.ProfileRange;
import dotty.tools.dotc.profile.ProfileReporter;
import dotty.tools.dotc.profile.RealProfiler;
import java.io.PrintWriter;
import java.util.concurrent.TimeUnit;

public class StreamProfileReporter
implements ProfileReporter {
    private final PrintWriter out;

    public StreamProfileReporter(PrintWriter out) {
        this.out = out;
    }

    @Override
    public void header(RealProfiler profiler) {
        this.out.println(new StringBuilder(28).append("info, ").append(profiler.id()).append(", version, 2, output, ").append(profiler.outDir()).toString());
        this.out.println("header(main/background),startNs,endNs,runId,phaseId,phaseName,purpose,task-count,threadId,threadName,runNs,idleNs,cpuTimeNs,userTimeNs,allocatedByte,heapSize");
        this.out.println("header(GC),startNs,endNs,startMs,endMs,name,action,cause,threads");
    }

    @Override
    public void reportBackground(RealProfiler profiler, ProfileRange threadRange) {
        this.reportCommon(EventType$.BACKGROUND, profiler, threadRange);
    }

    @Override
    public void reportForeground(RealProfiler profiler, ProfileRange threadRange) {
        this.reportCommon(EventType$.MAIN, profiler, threadRange);
    }

    private void reportCommon(EventType tpe, RealProfiler profiler, ProfileRange threadRange) {
        this.out.println(new StringBuilder(16).append(tpe).append(",").append(threadRange.start().snapTimeNanos()).append(",").append(threadRange.end().snapTimeNanos()).append(",").append(profiler.id()).append(",").append(threadRange.phase().id()).append(",").append(threadRange.phase().phaseName().replace(',', ' ')).append(",").append(threadRange.purpose()).append(",").append(threadRange.taskCount()).append(",").append(threadRange.thread().getId()).append(",").append(threadRange.thread().getName()).append(",").append(threadRange.runNs()).append(",").append(threadRange.idleNs()).append(",").append(threadRange.cpuNs()).append(",").append(threadRange.userNs()).append(",").append(threadRange.allocatedBytes()).append(",").append(threadRange.end().heapBytes()).append(" ").toString());
    }

    @Override
    public void reportGc(GcEventData data2) {
        long duration = TimeUnit.MILLISECONDS.toNanos(data2.gcEndMillis() - data2.gcStartMillis() + 1L);
        long start = data2.reportTimeNs() - duration;
        this.out.println(new StringBuilder(9).append(EventType$.GC).append(",").append(start).append(",").append(data2.reportTimeNs()).append(",").append(data2.gcStartMillis()).append(", ").append(data2.gcEndMillis()).append(",").append(data2.name()).append(",").append(data2.action()).append(",").append(data2.cause()).append(",").append(data2.threads()).toString());
    }

    @Override
    public void close(RealProfiler profiler) {
        this.out.flush();
        this.out.close();
    }
}

