/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.io;

import dotty.tools.io.Directory;
import dotty.tools.io.File;
import dotty.tools.io.FileExtension;
import dotty.tools.io.FileExtension$;
import dotty.tools.io.FileOperationException$;
import dotty.tools.io.Path;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import scala.Function1;
import scala.collection.AbstractIterable;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.io.Codec$;
import scala.jdk.CollectionConverters$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.util.Random$;

public final class Path$
implements Serializable {
    public static final Path$ MODULE$ = new Path$();

    private Path$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Path$.class);
    }

    public boolean isExtensionJarOrZip(java.nio.file.Path jpath) {
        return this.isExtensionJarOrZip(jpath.getFileName().toString());
    }

    public boolean isExtensionJarOrZip(String name) {
        return this.fileExtension(name).isJarOrZip();
    }

    public FileExtension fileExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return FileExtension$.Empty;
        }
        return FileExtension$.MODULE$.from(name.substring(i + 1));
    }

    public String extension(String name) {
        return this.fileExtension(name).toLowerCase();
    }

    public String fileName(String name) {
        int i = name.lastIndexOf(46);
        if (i < 0) {
            return name;
        }
        return name.substring(0, i);
    }

    public Iterator<Directory> onlyDirs(Iterator<Path> xs) {
        return xs.filter((Function1<Path, Object>)(Function1<Path, Boolean> & Serializable)_$1 -> _$1.isDirectory()).map((Function1<Path, Directory> & Serializable)_$2 -> _$2.toDirectory());
    }

    public List<Directory> onlyDirs(List<Path> xs) {
        return ((List)xs.filter((Function1<Path, Boolean> & Serializable)_$3 -> _$3.isDirectory())).map((Function1<Path, Directory> & Serializable)_$4 -> _$4.toDirectory());
    }

    public Iterator<File> onlyFiles(Iterator<Path> xs) {
        return xs.filter((Function1<Path, Object>)(Function1<Path, Boolean> & Serializable)_$5 -> _$5.isFile()).map((Function1<Path, File> & Serializable)_$6 -> _$6.toFile());
    }

    public List<Path> roots() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(FileSystems.getDefault().getRootDirectories().iterator()).asScala().map((Function1<java.nio.file.Path, Path> & Serializable)jpath -> MODULE$.apply((java.nio.file.Path)jpath)).toList();
    }

    public Path apply(String path2) {
        return this.apply(new java.io.File(path2).toPath());
    }

    public Path apply(java.nio.file.Path jpath) {
        Path path2;
        block4: {
            try {
                if (Files.isRegularFile(jpath, new LinkOption[0])) {
                    path2 = new File(jpath, Codec$.MODULE$.fallbackSystemCodec());
                    break block4;
                }
                if (Files.isDirectory(jpath, new LinkOption[0])) {
                    path2 = new Directory(jpath);
                    break block4;
                }
                path2 = new Path(jpath);
            }
            catch (SecurityException ex) {
                path2 = new Path(jpath);
            }
        }
        return path2;
    }

    public String randomPrefix() {
        return ((AbstractIterable)Random$.MODULE$.alphanumeric().take(6)).mkString("");
    }

    public Nothing$ fail(String msg) {
        throw FileOperationException$.MODULE$.apply(msg);
    }
}

