/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.parallel.mutable;

import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArraySeq;
import scala.collection.mutable.ArraySeq$;
import scala.collection.parallel.Task;
import scala.collection.parallel.mutable.ExposedArrayBuffer;
import scala.collection.parallel.mutable.LazyCombiner;
import scala.collection.parallel.mutable.ParArray;
import scala.collection.parallel.mutable.ResizableParArrayCombiner$;
import scala.collection.parallel.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public interface ResizableParArrayCombiner<T>
extends LazyCombiner<T, ParArray<T>, ExposedArrayBuffer<T>> {
    public static void sizeHint$(ResizableParArrayCombiner $this, int sz) {
        $this.sizeHint(sz);
    }

    @Override
    default public void sizeHint(int sz) {
        if (this.chain().length() == 1) {
            ((ExposedArrayBuffer)this.chain().apply(0)).sizeHint(sz);
        }
    }

    public static LazyCombiner newLazyCombiner$(ResizableParArrayCombiner $this, ArrayBuffer c) {
        return $this.newLazyCombiner(c);
    }

    @Override
    default public LazyCombiner<T, ParArray<T>, ExposedArrayBuffer<T>> newLazyCombiner(ArrayBuffer<ExposedArrayBuffer<T>> c) {
        return ResizableParArrayCombiner$.MODULE$.apply(c);
    }

    public static ParArray allocateAndCopy$(ResizableParArrayCombiner $this) {
        return $this.allocateAndCopy();
    }

    @Override
    default public ParArray<T> allocateAndCopy() {
        ParArray parArray;
        if (this.chain().size() > 1) {
            Object[] array = new Object[this.size()];
            ArraySeq arrayseq = ArraySeq$.MODULE$.make(array);
            this.combinerTaskSupport().executeAndWaitResult(new CopyChainToArray(this, array, 0, this.size()));
            parArray = new ParArray(arrayseq);
        } else {
            parArray = new ParArray(ArraySeq$.MODULE$.make(((ExposedArrayBuffer)this.chain().apply(0)).internalArray()), this.size());
        }
        return parArray;
    }

    public static String toString$(ResizableParArrayCombiner $this) {
        return $this.toString();
    }

    default public String toString() {
        return "ResizableParArrayCombiner(" + this.size() + "): ";
    }

    public class CopyChainToArray
    implements Task<BoxedUnit, CopyChainToArray> {
        private volatile Throwable throwable;
        private final Object[] array;
        private final int offset;
        private final int howmany;
        private final ResizableParArrayCombiner<T> $outer;

        public CopyChainToArray(ResizableParArrayCombiner $outer, Object[] array, int offset, int howmany) {
            this.array = array;
            this.offset = offset;
            this.howmany = howmany;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Task.$init$(this);
            BoxedUnit result = BoxedUnit.UNIT;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public void throwable_$eq(Throwable x$1) {
            this.throwable = x$1;
        }

        @Override
        public BoxedUnit result() {
            return BoxedUnit.UNIT;
        }

        @Override
        public void result_$eq(BoxedUnit x$1) {
        }

        @Override
        public void leaf(Option<BoxedUnit> prev) {
            if (this.howmany > 0) {
                int totalleft = this.howmany;
                Tuple2<Object, Object> tuple2 = this.findStart(this.offset);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int stbuff = BoxesRunTime.unboxToInt(tuple2._1());
                int stind = BoxesRunTime.unboxToInt(tuple2._2());
                Tuple2<Integer, Integer> tuple22 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(stbuff), BoxesRunTime.boxToInteger(stind));
                int stbuff2 = BoxesRunTime.unboxToInt(tuple22._1());
                int stind2 = BoxesRunTime.unboxToInt(tuple22._2());
                int buffind = stbuff2;
                int ind = stind2;
                int arrayIndex = this.offset;
                while (totalleft > 0) {
                    ExposedArrayBuffer currbuff = (ExposedArrayBuffer)this.$outer.chain().apply(buffind);
                    int chunksize = totalleft < currbuff.size() - ind ? totalleft : currbuff.size() - ind;
                    int until = ind + chunksize;
                    this.copyChunk(currbuff.internalArray(), ind, this.array, arrayIndex, until);
                    arrayIndex += chunksize;
                    ind += chunksize;
                    totalleft -= chunksize;
                    ++buffind;
                    ind = 0;
                }
            }
        }

        private void copyChunk(Object[] buffarr, int buffStart, Object[] ra, int arrayStart, int until) {
            Array$.MODULE$.copy(buffarr, buffStart, ra, arrayStart, until - buffStart);
        }

        private Tuple2<Object, Object> findStart(int pos) {
            int left = pos;
            int buffind = 0;
            while (left >= ((SeqOps)this.$outer.chain().apply(buffind)).size()) {
                left -= ((SeqOps)this.$outer.chain().apply(buffind)).size();
                ++buffind;
            }
            return Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(buffind), BoxesRunTime.boxToInteger(left));
        }

        @Override
        public Seq<Task<BoxedUnit, CopyChainToArray>> split() {
            int fp = this.howmany / 2;
            return (Seq)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new CopyChainToArray[]{new CopyChainToArray(this.$outer, this.array, this.offset, fp), new CopyChainToArray(this.$outer, this.array, this.offset + fp, this.howmany - fp)}));
        }

        @Override
        public boolean shouldSplitFurther() {
            return this.howmany > package$.MODULE$.thresholdFromSize(this.$outer.size(), this.$outer.combinerTaskSupport().parallelismLevel());
        }

        public final ResizableParArrayCombiner<T> scala$collection$parallel$mutable$ResizableParArrayCombiner$CopyChainToArray$$$outer() {
            return this.$outer;
        }
    }
}

