/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import org.nlogo.agent.Agent;
import org.nlogo.agent.DummyLink;
import org.nlogo.agent.Link;
import org.nlogo.agent.Patch;
import org.nlogo.agent.Turtle;
import org.nlogo.api.Perspective;
import org.nlogo.api.PerspectiveJ;
import org.nlogo.swing.WrappingPopupMenu;
import org.nlogo.window.GUIWorkspace;
import org.nlogo.window.View;

public strictfp class AgentMonitorView
extends View {
    private Perspective perspective = PerspectiveJ.OBSERVE();
    private Agent agent;
    private double radius;
    private double fontSizeRatio;
    private final MouseListener popupListener = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AgentMonitorView.this.doPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                AgentMonitorView.this.doPopup(e);
            }
        }
    };

    public AgentMonitorView(GUIWorkspace workspace) {
        super(workspace);
        this.radius = (workspace.world.worldWidth() - 1) / 2;
        this.addMouseListener(this.popupListener);
    }

    public boolean isDead() {
        return this.agent != null && this.agent.id == -1L;
    }

    public Agent agent() {
        return this.agent;
    }

    public void agent(Agent agent) {
        this.agent = agent;
        this.perspective = PerspectiveJ.FOLLOW();
    }

    public double radius() {
        return this.radius;
    }

    public void radius(double radius) {
        this.radius = radius;
        this.patchSize(this.viewWidth * this.patchSize / (radius * 2.0 + 1.0));
        this.viewWidth = radius * 2.0 + 1.0;
        this.viewHeight = radius * 2.0 + 1.0;
        this.incrementalUpdateFromEventThread();
    }

    public void patchSize(double patchSize) {
        Font font = this.getFont();
        int newFontSize = StrictMath.max(1, (int)(patchSize * this.fontSizeRatio));
        this.setFont(new Font(font.getName(), font.getStyle(), newFontSize));
        this.patchSize = patchSize;
    }

    public Perspective perspective() {
        return this.perspective;
    }

    public double viewOffsetX() {
        if (this.perspective == PerspectiveJ.OBSERVE() || this.agent instanceof DummyLink) {
            return 0.0;
        }
        double x2 = 0.0;
        x2 = this.agent instanceof Turtle ? ((Turtle)this.agent).xcor() : (this.agent instanceof Patch ? (double)((Patch)this.agent).pxcor : ((Link)this.agent).midpointX());
        return x2 - this.radius - (double)this.workspace.world.minPxcor();
    }

    public double viewOffsetY() {
        if (this.perspective == PerspectiveJ.OBSERVE() || this.agent instanceof DummyLink) {
            return 0.0;
        }
        double y = 0.0;
        y = this.agent instanceof Turtle ? ((Turtle)this.agent).ycor() : (this.agent instanceof Patch ? (double)((Patch)this.agent).pycor : ((Link)this.agent).midpointY());
        return y + (this.viewHeight - 1.0) / 2.0 - (double)this.workspace.world.maxPycor();
    }

    public double patchSize() {
        return this.patchSize;
    }

    public void applyNewFontSize(int newFontSize, int zoom) {
        this.fontSizeRatio = (double)newFontSize / this.workspace.world.patchSize();
        super.applyNewFontSize(newFontSize, zoom);
    }

    public void setSize(int worldWidth, int worldHeight, double patchSize) {
        this.patchSize(patchSize);
        this.viewWidth = worldWidth;
        this.viewHeight = worldHeight;
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.patchSize((double)width / (this.radius * 2.0 + 1.0));
    }

    public void setBounds(int x2, int y, int width, int height) {
        super.setBounds(x2, y, width, height);
        this.patchSize((double)width / (this.radius * 2.0 + 1.0));
    }

    public boolean drawSpotlight() {
        return false;
    }

    private void doPopup(MouseEvent e) {
        WrappingPopupMenu menu = new WrappingPopupMenu();
        Point p = e.getPoint();
        p = this.populateContextMenu(menu, p, (Component)e.getSource());
        if (menu.getSubElements().length > 0) {
            ((JPopupMenu)menu).show((Component)e.getSource(), p.x, p.y);
        }
        e.consume();
    }
}

