/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.app;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import org.nlogo.agent.ImportPatchColors;
import org.nlogo.api.FileIO;
import org.nlogo.api.I18N;
import org.nlogo.api.LocalFile;
import org.nlogo.api.ModelReader;
import org.nlogo.api.ModelSection;
import org.nlogo.api.ModelSectionJ;
import org.nlogo.api.ModelType;
import org.nlogo.api.ModelTypeJ;
import org.nlogo.api.Version;
import org.nlogo.app.App;
import org.nlogo.app.AppletSaver;
import org.nlogo.app.ModelSaver;
import org.nlogo.app.ModelsLibraryDialog;
import org.nlogo.app.NetLogoWebSaver;
import org.nlogo.app.NetLogoWebSaver$;
import org.nlogo.app.RecentFilesMenu;
import org.nlogo.app.TaskWarning;
import org.nlogo.awt.Hierarchy;
import org.nlogo.awt.UserCancelException;
import org.nlogo.swing.BrowserLauncher;
import org.nlogo.swing.FileDialog;
import org.nlogo.swing.Menu;
import org.nlogo.swing.ModalProgressTask;
import org.nlogo.swing.OptionDialog;
import org.nlogo.util.Exceptions;
import org.nlogo.util.Utils;
import org.nlogo.window.Events;
import org.nlogo.window.InvalidVersionException;
import org.nlogo.window.ModelLoader;
import org.nlogo.window.PlotWidgetExportType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class FileMenu
extends Menu
implements Events.OpenModelEvent.Handler {
    private final App app;
    private final ModelSaver modelSaver;
    private final AppletSaver appletSaver;
    private boolean appletWarningIgnored = false;
    private String savedVersion;
    private boolean firstLoad = true;

    public FileMenu(App app, ModelSaver modelSaver, AppletSaver appletSaver) {
        super(I18N.guiJ().get("menu.file"));
        this.app = app;
        this.modelSaver = modelSaver;
        this.appletSaver = appletSaver;
        this.addMenuItem('N', (Action)new NewAction());
        this.addMenuItem('O', (Action)new OpenAction());
        this.addMenuItem('M', (Action)new ModelsLibraryAction());
        this.add(new RecentFilesMenu(app, this));
        this.addSeparator();
        this.addMenuItem('S', (Action)new SaveAction());
        this.addMenuItem('S', true, (Action)new SaveAsAction());
        this.addMenuItem(new SaveModelingCommonsAction());
        this.addSeparator();
        this.addMenuItem(new SaveAppletAction());
        this.addMenuItem(new SaveAsNetLogoWebAction());
        this.addSeparator();
        this.addMenuItem(I18N.guiJ().get("menu.file.print"), 'P', (Action)app.tabs().printAction());
        this.addSeparator();
        Menu exportMenu = new Menu(I18N.guiJ().get("menu.file.export"));
        exportMenu.addMenuItem(new ExportWorldAction());
        exportMenu.addMenuItem(new ExportPlotAction());
        exportMenu.addMenuItem(new ExportAllPlotsAction());
        exportMenu.addMenuItem(new ExportGraphicsAction());
        exportMenu.addMenuItem(new ExportInterfaceAction());
        exportMenu.addMenuItem(new ExportOutputAction());
        this.add(exportMenu);
        this.addSeparator();
        Menu importMenu = new Menu(I18N.guiJ().get("menu.file.import"));
        importMenu.addMenuItem(new ImportWorldAction());
        importMenu.addMenuItem(new ImportPatchColorsAction());
        importMenu.addMenuItem(new ImportPatchColorsRGBAction());
        if (!Version.is3D()) {
            importMenu.addMenuItem(new ImportDrawingAction());
        }
        importMenu.addMenuItem(new ImportClientAction());
        this.add(importMenu);
        if (!System.getProperty("os.name").startsWith("Mac")) {
            this.addSeparator();
            this.addMenuItem('Q', (Action)new QuitAction());
        }
        this.savedVersion = Version.version();
    }

    public AbstractAction saveClientAppletAction() {
        return new SaveClientAppletAction();
    }

    void quit() throws UserCancelException {
        this.offerSave();
        new Events.AboutToQuitEvent().raise(this);
        this.app.workspace().getExtensionManager().reset();
        System.exit(0);
    }

    private String guessFileName() {
        String fileName = this.app.workspace().getModelFileName();
        if (fileName == null) {
            return "Untitled." + ModelReader.modelSuffix();
        }
        return fileName;
    }

    void newModel() throws UserCancelException, IOException {
        this.openFromURL(ModelReader.emptyModelPath());
    }

    private void openFromURL(String model) throws UserCancelException, IOException {
        String source2 = Utils.url2String(model);
        if (model.equals(ModelReader.emptyModelPath())) {
            this.openFromSource(source2, null, "Clearing...", ModelTypeJ.NEW());
        } else {
            this.openFromSource(source2, null, "Loading...", ModelTypeJ.LIBRARY());
        }
    }

    @Override
    public void handle(Events.OpenModelEvent e) {
        try {
            this.openFromPath(e.path, ModelTypeJ.LIBRARY());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void openFromPath(String path, ModelType modelType) throws IOException {
        try {
            String source2 = FileIO.file2String(path);
            if (source2 == null) {
                throw new IllegalStateException("couldn't open: '" + path + "'");
            }
            this.openFromSource(source2, path, "Loading...", modelType);
        }
        catch (UserCancelException ex) {
            Exceptions.ignore(ex);
        }
    }

    void openFromSource(String source2, String path, String message, ModelType modelType) throws UserCancelException {
        String version;
        Map<ModelSection, String[]> map2 = ModelReader.parseModel(source2);
        if (map2 == null || map2.get(ModelSectionJ.VERSION()).length == 0) {
            this.notifyUserNotValidFile();
        }
        if ((version = ModelReader.parseVersion(map2)) == null || !version.startsWith("NetLogo")) {
            this.notifyUserNotValidFile();
        }
        if (Version.is3D() && !Version.is3D(version)) {
            this.checkWithUserBeforeOpening2DModelin3D();
        }
        if (!Version.is3D() && Version.is3D(version)) {
            this.checkWithUserBeforeOpening3DModelin2D(version);
        } else if (!Version.knownVersion(version)) {
            this.checkWithUserBeforeOpeningModelFromFutureVersion(version);
        }
        this.openFromMap(map2, path, message, modelType);
        this.savedVersion = version;
    }

    private void openFromMap(final Map<ModelSection, String[]> map2, final String path, String message, final ModelType modelType) {
        try {
            if (this.firstLoad) {
                this.firstLoad = false;
                ModelLoader.load((Container)this, path, modelType, map2);
            } else {
                Runnable loader = new Runnable(){

                    public void run() {
                        try {
                            ModelLoader.load((Container)FileMenu.this, path, modelType, map2);
                        }
                        catch (InvalidVersionException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                };
                ModalProgressTask.apply(Hierarchy.getFrame(this), message, loader);
                this.app.tabs().requestFocus();
            }
        }
        catch (InvalidVersionException e) {
            throw new IllegalStateException(e);
        }
    }

    private void save() throws UserCancelException {
        if (this.app.workspace().forceSaveAs()) {
            this.saveAs();
        } else {
            this.doSave(this.app.workspace().getModelPath());
        }
    }

    private void saveAs() throws UserCancelException {
        this.doSave(this.userChooseSavePath());
    }

    private void doSave(String path) throws UserCancelException {
        this.checkWithUserBeforeSavingModelFromOldVersion();
        Saver saver = new Saver(path);
        ModalProgressTask.apply(Hierarchy.getFrame(this), "Saving...", saver);
        if (saver.getException() != null) {
            JOptionPane.showMessageDialog(this, "Save failed.  Error: " + saver.getException().getMessage(), "NetLogo", 0);
        }
        if (!saver.getResult()) {
            throw new UserCancelException();
        }
        this.app.tabs().saveExternalFiles();
    }

    public void offerSave() throws UserCancelException {
        if (this.app.workspace().movieEncoder != null) {
            String message = "There is a movie in progress. Are you sure you want to exit this model? You will lose the contents of your movie.";
            Object[] options = new String[]{I18N.guiJ().get("common.buttons.ok"), I18N.guiJ().get("common.buttons.cancel")};
            if (OptionDialog.show(this, "NetLogo", message, options) == 1) {
                throw new UserCancelException();
            }
            this.app.workspace().movieEncoder.cancel();
            this.app.workspace().movieEncoder = null;
        }
        if (this.app.dirtyMonitor().dirty() && this.userWantsToSaveFirst()) {
            this.save();
        }
    }

    private String suggestedSaveFileName(String suffix) throws UserCancelException {
        this.save();
        String suggestedFileName = this.app.workspace().getModelFileName();
        int suffixIndex = suggestedFileName.lastIndexOf("." + ModelReader.modelSuffix());
        if (suffixIndex > 0 && suffixIndex == suggestedFileName.length() - (ModelReader.modelSuffix().length() + 1)) {
            suggestedFileName = suggestedFileName.substring(0, suggestedFileName.length() - (ModelReader.modelSuffix().length() + 1));
        }
        suggestedFileName = suggestedFileName + suffix;
        return suggestedFileName;
    }

    private String userChooseLoadPath() throws UserCancelException {
        return FileDialog.show(this, "Open", 0, null);
    }

    private String userChooseSavePath() throws UserCancelException {
        String newFileName = this.guessFileName();
        String newDirectoryName = null;
        if (this.app.workspace().getModelType() == ModelTypeJ.NORMAL()) {
            newDirectoryName = this.app.workspace().getModelDir();
        }
        FileDialog.setDirectory(newDirectoryName);
        String path = FileDialog.show(this, "Save As", 1, newFileName);
        if (!path.endsWith("." + ModelReader.modelSuffix())) {
            path = path + "." + ModelReader.modelSuffix();
        }
        return path;
    }

    private boolean userWantsToSaveFirst() throws UserCancelException {
        Object[] options = new String[]{I18N.guiJ().get("common.buttons.save"), "Discard", I18N.guiJ().get("common.buttons.cancel")};
        String message = "Do you want to save the changes you made to this model?";
        switch (OptionDialog.show(this, "NetLogo", message, options)) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        throw new UserCancelException();
    }

    private void checkWithUserBeforeSavingModelFromOldVersion() throws UserCancelException {
        if (!Version.compatibleVersion(this.savedVersion)) {
            Object[] options = new String[]{I18N.guiJ().get("common.buttons.save"), I18N.guiJ().get("common.buttons.cancel")};
            String message = "This model was made with " + this.savedVersion + ". " + "If you save it in " + Version.version() + " it may not work in the old version anymore.";
            if (OptionDialog.show(this, "NetLogo", message, options) != 0) {
                throw new UserCancelException();
            }
            this.savedVersion = Version.version();
        }
    }

    private void checkWithUserBeforeOpeningModelFromFutureVersion(String version) throws UserCancelException {
        Object[] options = new String[]{I18N.guiJ().get("common.buttons.continue"), I18N.guiJ().get("common.buttons.cancel")};
        String message = "You are attempting to open a model that was created in a newer version of NetLogo.  (This is " + Version.version() + "; " + "the model was created in " + version + ".) " + "NetLogo can try to open the model, but it may " + "or may not work.";
        if (OptionDialog.show(this, "NetLogo", message, options) != 0) {
            throw new UserCancelException();
        }
    }

    private void checkWithUserBeforeOpening3DModelin2D(String version) throws UserCancelException {
        Object[] options = new String[]{I18N.guiJ().get("common.buttons.continue"), I18N.guiJ().get("common.buttons.cancel")};
        String message = "You are attempting to open a model that was created in a 3D version of NetLogo.  (This is " + Version.version() + "; " + "the model was created in " + version + ".) " + "NetLogo can try to open the model, but it may " + "or may not work.";
        if (OptionDialog.show(this, "NetLogo", message, options) != 0) {
            throw new UserCancelException();
        }
    }

    private void checkWithUserBeforeOpening2DModelin3D() throws UserCancelException {
        Object[] options = new String[]{I18N.guiJ().get("common.buttons.continue"), I18N.guiJ().get("common.buttons.cancel")};
        String message = "You are attempting to open a 2D model in " + Version.version() + ". " + "You might need to make changes before it will work in 3D.";
        if (OptionDialog.show(this, "NetLogo", message, options) != 0) {
            throw new UserCancelException();
        }
    }

    private void notifyUserNotValidFile() throws UserCancelException {
        Object[] options = new String[]{I18N.guiJ().get("common.buttons.ok")};
        OptionDialog.show(this, "NetLogo", "The file is not a valid NetLogo model file.", options);
        throw new UserCancelException();
    }

    private strictfp class Saver
    implements Runnable {
        private boolean result = true;
        private IOException exception;
        private final String path;

        boolean getResult() {
            return this.result;
        }

        IOException getException() {
            return this.exception;
        }

        Saver(String path) {
            this.path = path;
        }

        public void run() {
            try {
                FileIO.writeFile(this.path, FileMenu.this.modelSaver.save());
                new Events.ModelSavedEvent(this.path).raise(FileMenu.this);
            }
            catch (IOException ex) {
                this.result = false;
                this.exception = ex;
            }
        }
    }

    private strictfp class QuitAction
    extends FileMenuAction {
        QuitAction() {
            super(I18N.guiJ().get("menu.file.quit"));
        }

        void action() {
            try {
                FileMenu.this.quit();
            }
            catch (UserCancelException ex) {
                Exceptions.ignore(ex);
            }
        }
    }

    private strictfp class ImportClientAction
    extends ImportMenuAction {
        ImportClientAction() {
            super(I18N.guiJ().get("menu.file.import.hubNetClientInterface"));
        }

        void action() throws UserCancelException, IOException {
            final String importPath = FileDialog.show(FileMenu.this, "Import HubNet Client Interface", 0, null);
            final IOException[] exception = new IOException[]{null};
            final int choice = OptionDialog.show(FileMenu.this.app.workspace().getFrame(), "Import HubNet Client", "Which section would you like to import from?", new String[]{"Interface Tab", "HubNet client", I18N.guiJ().get("common.buttons.cancel")});
            if (choice != 2) {
                ModalProgressTask.apply(Hierarchy.getFrame(FileMenu.this), "Importing Drawing...", new Runnable(){

                    public void run() {
                        try {
                            FileMenu.this.app.workspace().getHubNetManager().importClientInterface(importPath, choice == 1);
                        }
                        catch (IOException ex) {
                            exception[0] = ex;
                        }
                    }
                });
                if (exception[0] != null) {
                    throw exception[0];
                }
            }
        }
    }

    private strictfp class ImportDrawingAction
    extends ImportMenuAction {
        ImportDrawingAction() {
            super(I18N.guiJ().get("menu.file.import.drawing"));
        }

        void action() throws UserCancelException, IOException {
            final String importPath = FileDialog.show(FileMenu.this, "Import Drawing", 0, null);
            final IOException[] exception = new IOException[]{null};
            ModalProgressTask.apply(Hierarchy.getFrame(FileMenu.this), "Importing Drawing...", new Runnable(){

                public void run() {
                    try {
                        FileMenu.this.app.workspace().importDrawing(importPath);
                        ((FileMenu)FileMenu.this).app.workspace().view.dirty();
                        ((FileMenu)FileMenu.this).app.workspace().view.repaint();
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        }
    }

    private strictfp class ImportPatchColorsRGBAction
    extends ImportMenuAction {
        ImportPatchColorsRGBAction() {
            super(I18N.guiJ().get("menu.file.import.patchColorsRGB"));
        }

        void action() throws UserCancelException, IOException {
            final String importPath = FileDialog.show(FileMenu.this, "Import Patch Colors RGB", 0, null);
            final IOException[] exception = new IOException[]{null};
            ModalProgressTask.apply(Hierarchy.getFrame(FileMenu.this), "Importing Patch Colors...", new Runnable(){

                public void run() {
                    try {
                        ImportPatchColors.importPatchColors(new LocalFile(importPath), FileMenu.this.app.workspace().world(), false);
                        ((FileMenu)FileMenu.this).app.workspace().view.dirty();
                        ((FileMenu)FileMenu.this).app.workspace().view.repaint();
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        }
    }

    private strictfp class ImportPatchColorsAction
    extends ImportMenuAction {
        ImportPatchColorsAction() {
            super(I18N.guiJ().get("menu.file.import.patchColors"));
        }

        void action() throws UserCancelException, IOException {
            final String importPath = FileDialog.show(FileMenu.this, "Import Patch Colors", 0, null);
            final IOException[] exception = new IOException[]{null};
            ModalProgressTask.apply(Hierarchy.getFrame(FileMenu.this), "Importing Patch Colors...", new Runnable(){

                public void run() {
                    try {
                        ImportPatchColors.importPatchColors(new LocalFile(importPath), FileMenu.this.app.workspace().world(), true);
                        ((FileMenu)FileMenu.this).app.workspace().view.dirty();
                        ((FileMenu)FileMenu.this).app.workspace().view.repaint();
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        }
    }

    private strictfp class ImportWorldAction
    extends ImportMenuAction {
        ImportWorldAction() {
            super(I18N.guiJ().get("menu.file.import.world"));
        }

        void action() throws UserCancelException, IOException {
            final String importPath = FileDialog.show(FileMenu.this, "Import World", 0, null);
            final IOException[] exception = new IOException[]{null};
            ModalProgressTask.apply(Hierarchy.getFrame(FileMenu.this), "Importing...", new Runnable(){

                public void run() {
                    try {
                        FileMenu.this.app.workspace().importWorld(importPath);
                        ((FileMenu)FileMenu.this).app.workspace().view.dirty();
                        ((FileMenu)FileMenu.this).app.workspace().view.repaint();
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        }
    }

    private strictfp class ExportAllPlotsAction
    extends FileMenuAction {
        ExportAllPlotsAction() {
            super(I18N.guiJ().get("menu.file.export.allPlots"));
        }

        void action() throws UserCancelException {
            final String exportPath = FileDialog.show(FileMenu.this, "Export All Plots", 1, FileMenu.this.app.workspace().guessExportName("plots.csv"));
            ModalProgressTask.apply(Hierarchy.getFrame(FileMenu.this), "Exporting...", new Runnable(){

                public void run() {
                    new Events.ExportPlotEvent(PlotWidgetExportType.ALL, null, exportPath).raise(FileMenu.this);
                }
            });
        }
    }

    private strictfp class ExportPlotAction
    extends FileMenuAction {
        ExportPlotAction() {
            super(I18N.guiJ().get("menu.file.export.plot"));
        }

        void action() throws UserCancelException {
            final String exportPath = FileDialog.show(FileMenu.this, "Export Plot", 1, FileMenu.this.app.workspace().guessExportName("plot.csv"));
            ModalProgressTask.apply(Hierarchy.getFrame(FileMenu.this), "Exporting...", new Runnable(){

                public void run() {
                    new Events.ExportPlotEvent(PlotWidgetExportType.PROMPT, null, exportPath).raise(FileMenu.this);
                }
            });
        }
    }

    private strictfp class ExportOutputAction
    extends FileMenuAction {
        ExportOutputAction() {
            super(I18N.guiJ().get("menu.file.export.output"));
        }

        void action() throws UserCancelException {
            final String exportPath = FileDialog.show(FileMenu.this, "Export Output", 1, FileMenu.this.app.workspace().guessExportName("output.txt"));
            ModalProgressTask.apply(Hierarchy.getFrame(FileMenu.this), "Exporting...", new Runnable(){

                public void run() {
                    new Events.ExportOutputEvent(exportPath).raise(FileMenu.this);
                }
            });
        }
    }

    private strictfp class ExportInterfaceAction
    extends FileMenuAction {
        ExportInterfaceAction() {
            super(I18N.guiJ().get("menu.file.export.interface"));
        }

        void action() throws UserCancelException, IOException {
            final String exportPath = FileDialog.show(FileMenu.this, "Export Interface", 1, FileMenu.this.app.workspace().guessExportName("interface.png"));
            final IOException[] exception = new IOException[]{null};
            ModalProgressTask.apply(Hierarchy.getFrame(FileMenu.this), "Exporting...", new Runnable(){

                public void run() {
                    try {
                        FileMenu.this.app.workspace().exportInterface(exportPath);
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        }
    }

    private strictfp class ExportGraphicsAction
    extends FileMenuAction {
        ExportGraphicsAction() {
            super(I18N.guiJ().get("menu.file.export.view"));
        }

        void action() throws UserCancelException, IOException {
            final String exportPath = FileDialog.show(FileMenu.this, "Export View", 1, FileMenu.this.app.workspace().guessExportName("view.png"));
            final IOException[] exception = new IOException[]{null};
            ModalProgressTask.apply(Hierarchy.getFrame(FileMenu.this), "Exporting...", new Runnable(){

                public void run() {
                    try {
                        FileMenu.this.app.workspace().exportView(exportPath, "png");
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        }
    }

    private strictfp class ExportWorldAction
    extends FileMenuAction {
        ExportWorldAction() {
            super(I18N.guiJ().get("menu.file.export.world"));
        }

        void action() throws UserCancelException, IOException {
            final String exportPath = FileDialog.show(FileMenu.this, "Export World", 1, FileMenu.this.app.workspace().guessExportName("world.csv"));
            TaskWarning.maybeWarn(Hierarchy.getFrame(FileMenu.this), FileMenu.this.app.workspace().world());
            final IOException[] exception = new IOException[]{null};
            ModalProgressTask.apply(Hierarchy.getFrame(FileMenu.this), "Exporting...", new Runnable(){

                public void run() {
                    try {
                        FileMenu.this.app.workspace().exportWorld(exportPath);
                    }
                    catch (IOException ex) {
                        exception[0] = ex;
                    }
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        }
    }

    private strictfp class SaveClientAppletAction
    extends SaveAppletAction {
        SaveClientAppletAction() {
            super(I18N.guiJ().get("menu.file.saveClientAsApplet"));
        }

        void action() throws UserCancelException {
            String exportPath = this.getExportPath("-client");
            FileMenu.this.app.resetZoom();
            FileMenu.this.appletSaver.saveClient(Hierarchy.getFrame(FileMenu.this), FileMenu.this.app.workspace().getHubNetManager().getInterfaceWidth(), FileMenu.this.app.workspace().getHubNetManager().getInterfaceHeight(), FileMenu.this.app.workspace().modelNameForDisplay(), exportPath);
        }
    }

    private strictfp class SaveAsNetLogoWebAction
    extends FileMenuAction {
        SaveAsNetLogoWebAction() {
            super(I18N.guiJ().get("menu.file.saveAsNetLogoWeb"));
            this.setEnabled(!Version.is3D());
        }

        void action() throws UserCancelException, IOException {
            String exportPath = FileDialog.show(FileMenu.this, "Saving as NetLogo Web HTML Page", 1, this.suggestedFileName());
            File exportFile = new File(exportPath);
            NetLogoWebSaver saver = NetLogoWebSaver$.MODULE$.apply(exportPath);
            saver.save(this.modelToSave(), exportFile.getName());
        }

        private String suggestedFileName() throws UserCancelException {
            if (FileMenu.this.app.workspace().getModelType() == ModelTypeJ.NEW()) {
                return FileMenu.this.suggestedSaveFileName("") + ".html";
            }
            String fileName = FileMenu.this.guessFileName();
            return fileName.substring(0, fileName.length() - 6) + ".html";
        }

        private String modelToSave() throws UserCancelException, IOException {
            String lastSaved = FileIO.file2String(FileMenu.this.app.workspace().getModelPath());
            if (this.doesNotMatchWorkingCopy(lastSaved) && this.userWantsLastSaveExported()) {
                return lastSaved;
            }
            return FileMenu.this.modelSaver.save();
        }

        private boolean userWantsLastSaveExported() throws UserCancelException {
            String message;
            ModelType modelType = FileMenu.this.app.workspace().getModelType();
            String typeKey = modelType == ModelTypeJ.NORMAL() ? "fromSave" : "fromLibrary";
            Object[] options = new String[]{I18N.guiJ().get("menu.file.nlw.prompt." + typeKey), I18N.guiJ().get("menu.file.nlw.prompt.fromCurrentCopy"), I18N.guiJ().get("common.buttons.cancel")};
            String title = I18N.guiJ().get("menu.file.nlw.prompt.title");
            int choice = OptionDialog.show(FileMenu.this, title, message = I18N.guiJ().get("menu.file.nlw.prompt.message." + typeKey), options);
            if (choice == 0) {
                return true;
            }
            if (choice == 1) {
                return false;
            }
            throw new UserCancelException();
        }

        private boolean doesNotMatchWorkingCopy(String lastSaved) {
            return !lastSaved.equals(FileMenu.this.modelSaver.save());
        }
    }

    private strictfp class SaveAppletAction
    extends FileMenuAction {
        SaveAppletAction(String title) {
            super(title);
        }

        SaveAppletAction() {
            super(I18N.guiJ().get("menu.file.saveAsApplet"));
            this.setEnabled(!Version.is3D());
        }

        void action() throws UserCancelException {
            int choice;
            while (!FileMenu.this.appletWarningIgnored && (choice = OptionDialog.show(FileMenu.this.app.workspace().getFrame(), "Applets Are Deprecated", "Use of this feature is no longer recommended.", new String[]{"Why?", "Continue anyway", I18N.guiJ().get("common.buttons.cancel")})) != 1) {
                if (choice == 2) {
                    throw new UserCancelException();
                }
                BrowserLauncher.openURL(FileMenu.this, "https://github.com/NetLogo/NetLogo/wiki/Applets", false);
            }
            FileMenu.this.appletWarningIgnored = true;
            String exportPath = this.getExportPath("");
            FileMenu.this.app.resetZoom();
            FileMenu.this.appletSaver.save(Hierarchy.getFrame(FileMenu.this), FileMenu.this.app.tabs().interfaceTab().getInterfacePanel(), FileMenu.this.app.workspace().modelNameForDisplay(), exportPath, FileMenu.this.app.workspace().getModelFileName(), FileMenu.this.app.tabs().infoTab().info(), FileMenu.this.app.tabs().proceduresTab().getText(), FileMenu.this.app.workspace().getExtensionManager().getJarPaths(), FileMenu.this.app.workspace().getExtensionManager().getExtensionNames());
        }

        String getExportPath(String suffix) throws UserCancelException {
            String suggestedFileName = FileMenu.this.suggestedSaveFileName(suffix + ".html");
            return FileDialog.show(FileMenu.this, "Saving as Applet", 1, suggestedFileName);
        }
    }

    private strictfp class SaveAsAction
    extends FileMenuAction {
        SaveAsAction() {
            super(I18N.guiJ().get("menu.file.saveAs"));
        }

        void action() throws UserCancelException {
            FileMenu.this.saveAs();
        }
    }

    private strictfp class SaveAction
    extends FileMenuAction {
        SaveAction() {
            super(I18N.guiJ().get("menu.file.save"));
        }

        void action() throws UserCancelException {
            FileMenu.this.save();
        }
    }

    private strictfp class SaveModelingCommonsAction
    extends FileMenuAction {
        SaveModelingCommonsAction() {
            super("Upload To Modeling Commons");
        }

        void action() throws UserCancelException {
            FileMenu.this.checkWithUserBeforeSavingModelFromOldVersion();
            FileMenu.this.app.modelingCommons().saveToModelingCommons();
        }
    }

    private strictfp class ModelsLibraryAction
    extends FileMenuAction {
        ModelsLibraryAction() {
            super(I18N.guiJ().get("menu.file.modelsLibrary"));
        }

        void action() throws UserCancelException {
            FileMenu.this.offerSave();
            String source2 = ModelsLibraryDialog.open(Hierarchy.getFrame(FileMenu.this));
            String modelPath = ModelsLibraryDialog.getModelPath();
            FileMenu.this.openFromSource(source2, modelPath, "Loading...", ModelTypeJ.LIBRARY());
        }
    }

    private strictfp class OpenAction
    extends FileMenuAction {
        OpenAction() {
            super(I18N.guiJ().get("menu.file.open"));
        }

        void action() throws UserCancelException, IOException {
            FileMenu.this.offerSave();
            FileMenu.this.openFromPath(FileMenu.this.userChooseLoadPath(), ModelTypeJ.NORMAL());
        }
    }

    private strictfp class NewAction
    extends FileMenuAction {
        NewAction() {
            super(I18N.guiJ().get("menu.file.new"));
        }

        void action() throws UserCancelException, IOException {
            FileMenu.this.offerSave();
            FileMenu.this.newModel();
        }
    }

    private strictfp abstract class ImportMenuAction
    extends AbstractAction {
        ImportMenuAction(String name) {
            super(name);
        }

        abstract void action() throws UserCancelException, IOException;

        public void actionPerformed(ActionEvent e) {
            try {
                this.action();
            }
            catch (UserCancelException ex) {
                Exceptions.ignore(ex);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(FileMenu.this, ex.getMessage(), I18N.guiJ().get("common.messages.error"), 0);
            }
        }
    }

    private strictfp abstract class FileMenuAction
    extends AbstractAction {
        FileMenuAction(String name) {
            super(name);
        }

        abstract void action() throws UserCancelException, IOException;

        public void actionPerformed(ActionEvent e) {
            try {
                this.action();
            }
            catch (UserCancelException ex) {
                Exceptions.ignore(ex);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(FileMenu.this, ex.getMessage(), I18N.guiJ().get("common.messages.error"), 0);
            }
        }
    }
}

