/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.nvm;

import org.nlogo.agent.Agent;
import org.nlogo.agent.AgentSet;
import org.nlogo.api.JobOwner;
import org.nlogo.api.LogoException;
import org.nlogo.nvm.Activation;
import org.nlogo.nvm.Context;
import org.nlogo.nvm.Job;
import org.nlogo.nvm.Procedure;
import org.nlogo.util.MersenneTwisterFast;

public strictfp class ConcurrentJob
extends Job {
    private Context[] contexts;

    public ConcurrentJob(JobOwner owner, AgentSet agentset2, Procedure topLevelProcedure, int address, Context parentContext, MersenneTwisterFast random) {
        super(owner, agentset2, topLevelProcedure, address, parentContext, random);
    }

    boolean exclusive() {
        return false;
    }

    private void initialize() {
        this.contexts = new Context[this.agentset.count()];
        int count2 = 0;
        AgentSet.Iterator iter2 = this.agentset.shufflerator(this.random);
        while (iter2.hasNext()) {
            Agent agent = iter2.next();
            this.newAgentJoining(agent, count2++, this.address);
        }
    }

    public void newAgentJoining(Agent agent, int count2, int address) {
        Context context = new Context(this, agent, address, this.parentContext == null ? new Activation(this.topLevelProcedure, null, 0) : this.parentContext.activation);
        if (count2 == -1) {
            if (this.contexts == null) {
                this.initialize();
            }
            count2 = this.contexts.length;
            Context[] newContexts = new Context[count2 + 1];
            System.arraycopy(this.contexts, 0, newContexts, 0, count2);
            this.contexts = newContexts;
        }
        this.contexts[count2] = context;
    }

    public void step() throws LogoException {
        if (this.contexts == null) {
            this.initialize();
        }
        int max2 = this.contexts.length;
        boolean allContextsDone = true;
        Context context = null;
        try {
            for (int i = 0; i < max2 && this.state == 0; ++i) {
                context = this.contexts[i];
                if (context == null) continue;
                if (!context.finished) {
                    if (!context.waiting) {
                        context.stepConcurrent();
                    }
                    allContextsDone = false;
                    continue;
                }
                this.contexts[i] = null;
            }
        }
        catch (LogoException ex) {
            this.finish();
            if (!Thread.currentThread().isInterrupted()) {
                context.runtimeError(ex);
            }
            throw ex;
        }
        catch (RuntimeException ex) {
            this.finish();
            context.runtimeError(ex);
            throw ex;
        }
        if (this.state == 0 && allContextsDone) {
            this.finish();
        }
    }

    public void finish() {
        super.finish();
        if (this.contexts != null) {
            for (Context context : this.contexts) {
                if (context == null) continue;
                context.finished = true;
            }
        }
    }
}

