/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.nlogo.awt.Fonts;
import org.nlogo.swing.Utils;
import org.nlogo.swing.WrappingPopupMenu;

public strictfp abstract class ToolBarMenu
extends JPanel {
    private final String name;

    public ToolBarMenu(String name) {
        this.name = name;
        this.setBorder(Utils.createWidgetBorder());
        if (System.getProperty("os.name").startsWith("Mac")) {
            this.setBackground(Color.WHITE);
        }
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                WrappingPopupMenu menu = new WrappingPopupMenu();
                ToolBarMenu.this.populate(menu);
                menu.show(ToolBarMenu.this, 0, ToolBarMenu.this.getHeight());
            }
        });
        Fonts.adjustDefaultFont(this);
    }

    protected abstract void populate(JPopupMenu var1);

    public Dimension getMinimumSize() {
        return new Dimension(11, 20);
    }

    public Dimension getPreferredSize() {
        Dimension size2 = this.getMinimumSize();
        int xpad = 5;
        int ypad = 2;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        size2.width = StrictMath.max(size2.width, fontMetrics.stringWidth(this.name) + 2 * xpad + 11);
        size2.height = StrictMath.max(size2.height, fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent() + 2 * ypad);
        return size2;
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paintComponent(g);
        g.setColor(this.getForeground());
        FontMetrics fontMetrics = g.getFontMetrics();
        g.drawString(this.name, 5, fontMetrics.getMaxAscent() + 2);
        int[] xpnts = new int[]{this.getWidth() - 13, this.getWidth() - 9, this.getWidth() - 5};
        int[] ypnts = new int[]{this.getHeight() / 2 - 2, this.getHeight() / 2 + 2, this.getHeight() / 2 - 2};
        g.fillPolygon(xpnts, ypnts, 3);
    }
}

