/*
 * Decompiled with CFR 0.152.
 */
package org.nlogo.workspace;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import org.nlogo.api.APIVersion;
import org.nlogo.api.ClassManager;
import org.nlogo.api.CompilerException;
import org.nlogo.api.Dump;
import org.nlogo.api.ErrorSource;
import org.nlogo.api.ExtensionException;
import org.nlogo.api.ExtensionObject;
import org.nlogo.api.File;
import org.nlogo.api.ImportErrorHandler;
import org.nlogo.api.JavaLibraryPath;
import org.nlogo.api.Primitive;
import org.nlogo.api.RemoteFile;
import org.nlogo.api.Reporter;
import org.nlogo.nvm.FileManager;
import org.nlogo.util.Exceptions;
import org.nlogo.workspace.AbstractWorkspace;
import org.nlogo.workspace.ExtensionPrimitiveManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public strictfp class ExtensionManager
implements org.nlogo.api.ExtensionManager {
    public static final String EXTENSION_NOT_FOUND = "Can't find extension: ";
    private final Map<String, JarContainer> jars = new HashMap<String, JarContainer>();
    private final AbstractWorkspace workspace;
    private int jarsLoaded = 0;
    private Object obj = null;

    public static String extensionPath() {
        return System.getProperty("netlogo.extensions.dir", "extensions");
    }

    public AbstractWorkspace workspace() {
        return this.workspace;
    }

    @Override
    public boolean profilingEnabled() {
        return this.workspace.profilingEnabled();
    }

    public ExtensionManager(AbstractWorkspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public boolean anyExtensionsLoaded() {
        return this.jarsLoaded > 0;
    }

    @Override
    public Iterable<ClassManager> loadedExtensions() {
        ArrayList<ClassManager> result2 = new ArrayList<ClassManager>();
        for (JarContainer jar : this.jars.values()) {
            result2.add(jar.classManager);
        }
        return result2;
    }

    @Override
    public String getSource(String filename) throws IOException {
        return this.workspace.getSource(filename);
    }

    @Override
    public File getFile(String path) throws ExtensionException {
        FileManager fm = this.workspace().fileManager();
        return fm.getFile(this.getFullPath(path));
    }

    @Override
    public void storeObject(Object obj) {
        this.obj = obj;
    }

    @Override
    public Object retrieveObject() {
        return this.obj;
    }

    private String identifierToJar(String id) {
        if (!id.endsWith(".jar")) {
            if (AbstractWorkspace.isApplet()) {
                return id + "/" + id + ".jar";
            }
            return id + java.io.File.separator + id + ".jar";
        }
        return id;
    }

    @Override
    public void importExtension(String extName, ErrorSource errors) throws CompilerException {
        String jarPath = this.identifierToJar(extName);
        try {
            jarPath = this.resolvePathAsURL(jarPath);
            if (AbstractWorkspace.isApplet()) {
                URL url = new URL(jarPath);
                url.openConnection().setUseCaches(false);
            }
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            errors.signalError(EXTENSION_NOT_FOUND + extName);
            return;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            URLClassLoader myClassLoader = this.getClassLoader(jarPath, errors, this.getClass().getClassLoader());
            if (myClassLoader == null) {
                return;
            }
            ClassManager classManager = this.getClassManager(jarPath, myClassLoader, errors);
            if (classManager == null) {
                return;
            }
            JarContainer theJarContainer = this.jars.get(jarPath);
            long modified = this.getModified(jarPath, errors);
            if (theJarContainer == null || theJarContainer.modified != modified) {
                if (theJarContainer != null) {
                    theJarContainer.classManager.unload(this);
                }
                theJarContainer = new JarContainer(extName, jarPath, myClassLoader, modified);
                try {
                    if (!this.workspace.compilerTestingMode()) {
                        classManager.runOnce(this);
                    }
                }
                catch (ExtensionException ex) {
                    System.err.println("Error while initializing extension.");
                    System.err.println("Error is: " + ex);
                    throw ex;
                }
                this.jars.put(jarPath, theJarContainer);
            }
            if (!theJarContainer.loaded) {
                ++this.jarsLoaded;
                theJarContainer.loaded = true;
                theJarContainer.classManager = classManager;
                theJarContainer.primManager = new ExtensionPrimitiveManager(extName);
                classManager.load(theJarContainer.primManager);
            }
            theJarContainer.live = true;
            theJarContainer.prefix = this.getExtensionName(jarPath, errors);
        }
        catch (ExtensionException ex) {
            errors.signalError(ex.getMessage());
            return;
        }
        catch (IncompatibleClassChangeError ex) {
            errors.signalError("This extension doesn't work with this version of NetLogo");
            System.err.println(ex);
        }
    }

    @Override
    public void addToLibraryPath(Object classManager, String directory) {
        JavaLibraryPath.setLibraryPath(classManager.getClass(), directory);
    }

    @Override
    public String resolvePath(String path) {
        try {
            java.io.File result2 = new java.io.File(this.workspace.attachModelDir(path));
            if (AbstractWorkspace.isApplet()) {
                return result2.getPath();
            }
            try {
                return result2.getCanonicalPath();
            }
            catch (IOException ex) {
                return result2.getPath();
            }
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException(path + " is not a valid pathname: " + ex);
        }
    }

    @Override
    public String resolvePathAsURL(String path) {
        if (AbstractWorkspace.isApplet()) {
            try {
                String jarPath = this.workspace.fileManager().attachPrefix(path);
                if (RemoteFile.exists(jarPath)) {
                    return jarPath;
                }
                throw new IllegalStateException(EXTENSION_NOT_FOUND + path + " using URL " + jarPath);
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException(path + " is not a valid pathname: " + ex);
            }
        }
        try {
            URL jarURL = new URL(path);
            return jarURL.toString();
        }
        catch (MalformedURLException ex) {
            java.io.File jarFile;
            Exceptions.ignore(ex);
            if (path.contains(java.io.File.separator)) {
                try {
                    jarFile = new java.io.File(this.workspace.attachModelDir(path));
                    if (jarFile.exists()) {
                        return ExtensionManager.toURL(jarFile).toString();
                    }
                }
                catch (MalformedURLException ex2) {
                    Exceptions.ignore(ex2);
                }
            }
            try {
                jarFile = new java.io.File(this.workspace.attachModelDir(path));
                if (jarFile.exists()) {
                    return ExtensionManager.toURL(jarFile).toString();
                }
            }
            catch (MalformedURLException ex3) {
                Exceptions.ignore(ex3);
            }
            try {
                jarFile = new java.io.File(ExtensionManager.extensionPath() + java.io.File.separator + path);
                if (jarFile.exists()) {
                    return ExtensionManager.toURL(jarFile).toString();
                }
            }
            catch (MalformedURLException ex4) {
                Exceptions.ignore(ex4);
            }
            throw new IllegalStateException(EXTENSION_NOT_FOUND + path);
        }
    }

    public String getFullPath(String path) throws ExtensionException {
        if (AbstractWorkspace.isApplet()) {
            try {
                String fullPath = this.workspace.fileManager().attachPrefix(path);
                if (RemoteFile.exists(fullPath)) {
                    return fullPath;
                }
                throw new ExtensionException("Can't find file " + path + " using " + fullPath);
            }
            catch (MalformedURLException ex) {
                throw new ExtensionException(path + " is not a valid pathname: " + ex);
            }
        }
        try {
            String fullPath = this.workspace.attachModelDir(path);
            java.io.File f2 = new java.io.File(fullPath);
            if (f2.exists()) {
                return fullPath;
            }
        }
        catch (MalformedURLException ex) {
            Exceptions.ignore(ex);
        }
        java.io.File f3 = new java.io.File(ExtensionManager.extensionPath() + java.io.File.separator + path);
        if (f3.exists()) {
            return f3.getPath();
        }
        throw new ExtensionException("Can't find file " + path);
    }

    private URLClassLoader getClassLoader(String jarPath, ErrorSource errors, ClassLoader parentLoader) throws CompilerException {
        JarContainer theJarContainer = this.jars.get(jarPath);
        if (theJarContainer != null) {
            return theJarContainer.jarClassLoader;
        }
        try {
            URL jarURL = new URL(jarPath);
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(jarURL);
            java.io.File folder = new java.io.File(new java.io.File(jarURL.getFile()).getParent());
            urls.addAll(this.getAdditionalJars(folder));
            folder = new java.io.File(ExtensionManager.extensionPath());
            urls.addAll(this.getAdditionalJars(folder));
            return URLClassLoader.newInstance(urls.toArray(new URL[urls.size()]), parentLoader);
        }
        catch (MalformedURLException ex) {
            errors.signalError("Invalid URL: " + jarPath);
            return null;
        }
    }

    private ClassManager getClassManager(String jarPath, URLClassLoader myClassLoader, ErrorSource errors) throws CompilerException {
        JarContainer theJarContainer = this.jars.get(jarPath);
        if (theJarContainer != null && theJarContainer.loaded) {
            return theJarContainer.classManager;
        }
        String classMangName = null;
        try {
            classMangName = this.getClassManagerName(jarPath, errors);
            if (classMangName == null) {
                errors.signalError("Bad extension: Couldn't locate Class-Manager tag in Manifest File");
            }
            Object classMang = myClassLoader.loadClass(classMangName).newInstance();
            try {
                return (ClassManager)classMang;
            }
            catch (ClassCastException ex) {
                errors.signalError("Bad extension: The ClassManager doesn't implement org.nlogo.api.ClassManager");
            }
        }
        catch (FileNotFoundException ex) {
            errors.signalError(EXTENSION_NOT_FOUND + jarPath);
        }
        catch (IOException ex) {
            errors.signalError("Can't open extension " + jarPath);
        }
        catch (InstantiationException ex) {
            throw new IllegalStateException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException(ex);
        }
        catch (ClassNotFoundException ex) {
            errors.signalError("Can't find class " + classMangName + " in extension");
        }
        return null;
    }

    private String getClassManagerName(String jarPath, ErrorSource errors) throws IOException, CompilerException {
        URL jarURL = new URL("jar", "", jarPath + "!/");
        JarURLConnection jarConnection = (JarURLConnection)jarURL.openConnection();
        String name = null;
        if (jarConnection.getManifest() == null) {
            errors.signalError("Bad extension: Can't find a Manifest file in extension");
        }
        Attributes attr = jarConnection.getManifest().getMainAttributes();
        name = attr.getValue("Class-Manager");
        if (!this.checkVersion(attr)) {
            errors.signalError("User halted compilation");
        }
        return name;
    }

    private String getExtensionName(String jarPath, ErrorSource errors) throws CompilerException {
        try {
            Attributes attr;
            URL jarURL = new URL("jar", "", jarPath + "!/");
            JarURLConnection jarConnection = (JarURLConnection)jarURL.openConnection();
            String name = null;
            if (jarConnection.getManifest() == null) {
                errors.signalError("Bad extension: Can't find Manifest file in extension");
            }
            if ((name = (attr = jarConnection.getManifest().getMainAttributes()).getValue("Extension-Name")) == null) {
                errors.signalError("Bad extension: Can't find extension name in Manifest.");
            }
            return name;
        }
        catch (FileNotFoundException ex) {
            errors.signalError(EXTENSION_NOT_FOUND + jarPath);
        }
        catch (IOException ex) {
            errors.signalError(EXTENSION_NOT_FOUND + jarPath);
        }
        return null;
    }

    @Override
    public Object readFromString(String source2) throws CompilerException {
        return this.workspace.readFromString(source2);
    }

    public void clearAll() {
        for (JarContainer jar : this.jars.values()) {
            jar.classManager.clearAll();
        }
    }

    @Override
    public ExtensionObject readExtensionObject(String extName, String typeName, String value2) throws CompilerException {
        JarContainer theJarContainer = null;
        extName = extName.toUpperCase();
        for (Map.Entry<String, JarContainer> entry : this.jars.entrySet()) {
            theJarContainer = entry.getValue();
            String name = theJarContainer.primManager.name().toUpperCase();
            if (!theJarContainer.loaded || name == null || !name.equals(extName)) continue;
            try {
                return theJarContainer.classManager.readExtensionObject(this, typeName, value2);
            }
            catch (ExtensionException ex) {
                System.err.println(ex);
                throw new IllegalStateException("Error reading extension object " + extName + ":" + typeName + " " + value2 + " ==> " + ex.getMessage());
            }
        }
        return null;
    }

    @Override
    public Primitive replaceIdentifier(String name) {
        Primitive prim = null;
        boolean qualified = name.indexOf(58) != -1;
        Iterator<Map.Entry<String, JarContainer>> entries2 = this.jars.entrySet().iterator();
        while (entries2.hasNext() && prim == null) {
            Map.Entry<String, JarContainer> entry = entries2.next();
            JarContainer theJarContainer = entry.getValue();
            String extName = theJarContainer.primManager.name().toUpperCase();
            if (!theJarContainer.live) continue;
            if (qualified) {
                String prefix = name.substring(0, name.indexOf(58));
                String pname = name.substring(name.indexOf(58) + 1);
                if (!prefix.equals(extName)) continue;
                prim = theJarContainer.primManager.getPrimitive(pname);
                continue;
            }
            if (!theJarContainer.primManager.autoImportPrimitives()) continue;
            prim = theJarContainer.primManager.getPrimitive(name);
        }
        return prim;
    }

    @Override
    public String dumpExtensions() {
        String str = "EXTENSION\tLOADED\tMODIFIED\tJARPATH\n";
        str = str + "---------\t------\t---------\t---\n";
        JarContainer theJarContainer2 = null;
        for (JarContainer theJarContainer2 : this.jars.values()) {
            str = str + theJarContainer2.prefix + "\t" + theJarContainer2.loaded + "\t" + theJarContainer2.modified + "\t" + theJarContainer2.jarName + "\n";
        }
        return str;
    }

    @Override
    public List<String> getJarPaths() {
        ArrayList<String> names2 = new ArrayList<String>();
        for (JarContainer jar : this.jars.values()) {
            names2.add(jar.extensionName + '/' + jar.extensionName + ".jar");
            for (String additionalJar : jar.classManager.additionalJars()) {
                names2.add(jar.extensionName + '/' + additionalJar);
            }
        }
        return names2;
    }

    @Override
    public List<String> getExtensionNames() {
        ArrayList<String> names2 = new ArrayList<String>();
        for (JarContainer jar : this.jars.values()) {
            names2.add(jar.extensionName);
        }
        return names2;
    }

    @Override
    public String dumpExtensionPrimitives() {
        String pstr = "\n\nEXTENSION\tPRIMITIVE\tTYPE\n";
        pstr = pstr + "----------\t---------\t----\n";
        JarContainer theJarContainer2 = null;
        for (JarContainer theJarContainer2 : this.jars.values()) {
            Iterator<String> k = theJarContainer2.primManager.getPrimitiveNames();
            while (k.hasNext()) {
                String name = k.next();
                Primitive p = theJarContainer2.primManager.getPrimitive(name);
                String type = p instanceof Reporter ? "Reporter" : "Command";
                pstr = pstr + theJarContainer2.prefix + "\t" + name + "\t" + type + "\n";
            }
        }
        return pstr;
    }

    @Override
    public void reset() {
        for (JarContainer jc : this.jars.values()) {
            try {
                jc.classManager.unload(this);
            }
            catch (ExtensionException ex) {
                System.err.println(ex);
                ex.printStackTrace();
            }
            try {
                Method close2 = URLClassLoader.class.getMethod("close", new Class[0]);
                close2.invoke((Object)jc.jarClassLoader, new Object[0]);
            }
            catch (NoSuchMethodException e) {
            }
            catch (SecurityException e) {
                System.err.println("Failed to close classloader due to security exception");
            }
            catch (Exception e) {
                System.err.println("Error closing classloader " + e.getMessage());
            }
            jc.loaded = false;
            jc.live = false;
            jc.jarClassLoader = null;
        }
        this.jars.clear();
        this.jarsLoaded = 0;
    }

    List<URL> getAdditionalJars(java.io.File folder) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (!AbstractWorkspace.isApplet() && folder.exists() && folder.isDirectory()) {
            java.io.File[] files = folder.listFiles();
            for (int n = 0; n < files.length; ++n) {
                if (!files[n].isFile() || !files[n].getName().toUpperCase().endsWith(".JAR")) continue;
                try {
                    urls.add(ExtensionManager.toURL(files[n]));
                    continue;
                }
                catch (MalformedURLException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        }
        return urls;
    }

    @Override
    public void startFullCompilation() {
        for (JarContainer nextJarContainer : this.jars.values()) {
            nextJarContainer.live = false;
        }
    }

    @Override
    public void finishFullCompilation() {
        for (JarContainer nextJarContainer : this.jars.values()) {
            try {
                if (!nextJarContainer.loaded || nextJarContainer.live) continue;
                --this.jarsLoaded;
                this.jars.remove(nextJarContainer.prefix);
                nextJarContainer.loaded = false;
                nextJarContainer.classManager.unload(this);
            }
            catch (ExtensionException ex) {
                System.err.println("Error unloading extension: " + ex);
            }
        }
    }

    private boolean checkVersion(Attributes attr) {
        String currentVer = APIVersion.version();
        String jarVer = attr.getValue("NetLogo-Extension-API-Version");
        if (jarVer == null) {
            return this.workspace.warningMessage("Could not determine version of NetLogo extension.  NetLogo can try to load the extension, but it might not work.");
        }
        if (!currentVer.equals(jarVer)) {
            return this.workspace.warningMessage("You are attempting to open a NetLogo extension file that was created for a different version of the NetLogo Extension API.  (This NetLogo uses Extension API " + currentVer + "; the extension uses NetLogo Extension API " + jarVer + ".)  NetLogo can try to load the extension, " + "but it might not work.");
        }
        return true;
    }

    private long getModified(String jarPath, ErrorSource errors) throws CompilerException {
        try {
            return new URL(jarPath).openConnection().getLastModified();
        }
        catch (IOException ex) {
            System.err.println(ex);
            errors.signalError("Can't open extension");
            throw new IllegalStateException("this code is unreachable");
        }
    }

    public void exportWorld(PrintWriter writer) {
        writer.println(Dump.csv().encode("EXTENSIONS"));
        writer.println();
        for (JarContainer container : this.jars.values()) {
            StringBuilder data2 = container.classManager.exportWorld();
            if (data2.length() <= 0) continue;
            writer.println(Dump.csv().encode(container.extensionName));
            writer.print(data2);
            writer.println();
        }
    }

    public void importExtensionData(String name, List<String[]> data2, ImportErrorHandler handler) throws ExtensionException {
        JarContainer jar = this.getJarContainerByIdentifier(name);
        if (jar == null) {
            throw new ExtensionException("there is no extension named " + name + "in this model");
        }
        jar.classManager.importWorld(data2, this, handler);
    }

    public boolean isExtensionName(String name) {
        return this.getJarContainerByIdentifier(name) != null;
    }

    private JarContainer getJarContainerByIdentifier(String identifier) {
        for (JarContainer jar : this.jars.values()) {
            if (!jar.extensionName.equalsIgnoreCase(identifier)) continue;
            return jar;
        }
        return null;
    }

    private static URL toURL(java.io.File file) throws MalformedURLException {
        return file.toURL();
    }

    private strictfp class JarContainer {
        public final String extensionName;
        public final String jarName;
        public URLClassLoader jarClassLoader;
        public final long modified;
        public ExtensionPrimitiveManager primManager;
        public ClassManager classManager;
        public boolean loaded;
        public boolean live;
        public String prefix;

        JarContainer(String extensionName, String jarName, URLClassLoader jarClassLoader, long modified) {
            this.extensionName = extensionName;
            this.jarName = jarName;
            this.jarClassLoader = jarClassLoader;
            this.loaded = false;
            this.live = false;
            this.prefix = null;
            this.modified = modified;
        }
    }
}

