/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.gui.server.ext;

import cats.Applicative;
import cats.ApplicativeError;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.IOPlatform;
import cats.effect.kernel.GenConcurrent;
import cats.effect.unsafe.IORuntime;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.RaiseThrowable$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.logging.Level;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.eclipse.jgit.api.Git;
import org.http4s.EntityEncoder$;
import org.http4s.Header;
import org.http4s.MediaType$;
import org.http4s.Response;
import org.http4s.Status$;
import org.http4s.dsl.io$;
import org.http4s.headers.Content$minusDisposition$;
import org.http4s.headers.Content$minusType$;
import org.http4s.multipart.Part;
import org.openmole.core.fileservice.FileService;
import org.openmole.core.format.OMRFormat$;
import org.openmole.core.pluginmanager.PluginManager$;
import org.openmole.core.workspace.TmpDirectory;
import org.openmole.core.workspace.Workspace;
import org.openmole.gui.server.ext.utils;
import org.openmole.gui.server.ext.utils$HTTP$;
import org.openmole.gui.server.git.GitAuthentication;
import org.openmole.gui.server.git.GitService$;
import org.openmole.gui.shared.data.BranchData$;
import org.openmole.gui.shared.data.ErrorData;
import org.openmole.gui.shared.data.ErrorData$;
import org.openmole.gui.shared.data.ErrorStateLevel;
import org.openmole.gui.shared.data.ErrorStateLevel$;
import org.openmole.gui.shared.data.FileListData;
import org.openmole.gui.shared.data.FileListData$;
import org.openmole.gui.shared.data.FileSorting;
import org.openmole.gui.shared.data.FirstLast;
import org.openmole.gui.shared.data.FirstLast$;
import org.openmole.gui.shared.data.GUIOMRContent;
import org.openmole.gui.shared.data.GitPrivateKeyAuthenticationData;
import org.openmole.gui.shared.data.GitStatus;
import org.openmole.gui.shared.data.GitStatus$;
import org.openmole.gui.shared.data.ListSorting;
import org.openmole.gui.shared.data.ListSorting$;
import org.openmole.gui.shared.data.Plugin;
import org.openmole.gui.shared.data.PluginState$;
import org.openmole.gui.shared.data.SafePath;
import org.openmole.gui.shared.data.SafePath$;
import org.openmole.gui.shared.data.ServerFileSystemContext;
import org.openmole.gui.shared.data.ServerFileSystemContext$;
import org.openmole.gui.shared.data.TreeNodeData;
import org.openmole.gui.shared.data.TreeNodeData$;
import org.openmole.tool.archive.package$package$;
import org.openmole.tool.file.FilePackage;
import org.openmole.tool.file.package$;
import org.typelevel.ci.CIString;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.StringContext$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichLong;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.Try$;

public final class utils$
implements Serializable {
    private static final String openmoleFileName;
    private static final String webpakedOpenmoleFileName;
    private static final String depsFileName;
    private static final String openmoleGrammarName;
    private static final String aceModuleSource;
    private static final String openmoleGrammarMode;
    private static final String githubTheme;
    private static final String webpackConfigTemplateName;
    private static final String webpackJsonPackage;
    private static final String nodeModulesFileName;
    public static final utils$HTTP$ HTTP;
    public static final utils$ MODULE$;

    private utils$() {
    }

    static {
        MODULE$ = new utils$();
        openmoleFileName = "main.js";
        webpakedOpenmoleFileName = "openmole-webpacked.js";
        depsFileName = "deps.js";
        openmoleGrammarName = "openmole_grammar_template.js";
        aceModuleSource = "ace-builds/src-noconflict";
        openmoleGrammarMode = "mode-openmole.js";
        githubTheme = "theme-github.js";
        webpackConfigTemplateName = "template.webpack.config.js";
        webpackJsonPackage = "package.json";
        nodeModulesFileName = "node_modules.zip";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(utils$.class);
    }

    public File pluginUpdoadDirectory(String tmpDirectory, TmpDirectory newFile) {
        return package$.MODULE$.FileDecorator(newFile.directory()).$div(tmpDirectory);
    }

    public File projectsDirectory(Workspace workspace) {
        File old = package$.MODULE$.FileDecorator(package$.MODULE$.FileDecorator(workspace.location()).$div("webui")).$div("projects");
        File newProjects = package$.MODULE$.FileDecorator(workspace.userDir()).$div("projects");
        if (old.exists()) {
            package$.MODULE$.FileDecorator(old).move(newProjects);
        }
        newProjects.mkdirs();
        return newProjects;
    }

    public File workspaceRoot(Workspace workspace) {
        return workspace.location();
    }

    public Seq<SafePath> allPluggableIn(SafePath path, Workspace workspace) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.FileDecorator(this.SafePathDecorator(path).toFile(workspace)).listFilesSafe());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)f -> PluginManager$.MODULE$.isBundle(f)));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$1 -> {
            utils.SafePathFileDecorator safePathFileDecorator = MODULE$.SafePathFileDecorator((File)_$1);
            return safePathFileDecorator.toSafePath(safePathFileDecorator.toSafePath$default$1(), workspace);
        }, ClassTag$.MODULE$.apply(SafePath.class)));
        return ArrayOps$.MODULE$.toSeq$extension(object3);
    }

    public SafePath treeNodeToSafePath(TreeNodeData tnd, SafePath parent) {
        return parent.$plus$plus(tnd.name());
    }

    public final utils.SafePathDecorator SafePathDecorator(SafePath s) {
        return new utils.SafePathDecorator(s);
    }

    public final utils.SafePathFileDecorator SafePathFileDecorator(File f) {
        return new utils.SafePathFileDecorator(f);
    }

    public SafePath fileToSafePath(File f, ServerFileSystemContext context, Workspace workspace) {
        ServerFileSystemContext serverFileSystemContext = context;
        ServerFileSystemContext serverFileSystemContext2 = ServerFileSystemContext$.Project;
        ServerFileSystemContext serverFileSystemContext3 = serverFileSystemContext;
        if (!(serverFileSystemContext2 != null ? !serverFileSystemContext2.equals(serverFileSystemContext3) : serverFileSystemContext3 != null)) {
            return SafePath$.MODULE$.apply(this.getPathArray(f, (Option<File>)Some$.MODULE$.apply((Object)this.projectsDirectory(workspace))), context);
        }
        ServerFileSystemContext serverFileSystemContext4 = ServerFileSystemContext$.Absolute;
        ServerFileSystemContext serverFileSystemContext5 = serverFileSystemContext;
        if (!(serverFileSystemContext4 != null ? !serverFileSystemContext4.equals(serverFileSystemContext5) : serverFileSystemContext5 != null)) {
            return SafePath$.MODULE$.apply(this.getPathArray(f, (Option<File>)None$.MODULE$), context);
        }
        ServerFileSystemContext serverFileSystemContext6 = ServerFileSystemContext$.Authentication;
        ServerFileSystemContext serverFileSystemContext7 = serverFileSystemContext;
        if (!(serverFileSystemContext6 != null ? !serverFileSystemContext6.equals(serverFileSystemContext7) : serverFileSystemContext7 != null)) {
            return SafePath$.MODULE$.apply(this.getPathArray(f, (Option<File>)Some$.MODULE$.apply((Object)this.authenticationKeysDirectory(workspace))), context);
        }
        throw new MatchError((Object)serverFileSystemContext);
    }

    public ServerFileSystemContext fileToSafePath$default$2(File f) {
        return ServerFileSystemContext$.Project;
    }

    public File safePathToFile(SafePath s, Workspace workspace) {
        ServerFileSystemContext serverFileSystemContext = s.context();
        ServerFileSystemContext serverFileSystemContext2 = ServerFileSystemContext$.Project;
        ServerFileSystemContext serverFileSystemContext3 = serverFileSystemContext;
        if (!(serverFileSystemContext2 != null ? !serverFileSystemContext2.equals(serverFileSystemContext3) : serverFileSystemContext3 != null)) {
            return this.getFile$1((Option)Some$.MODULE$.apply((Object)this.projectsDirectory(workspace)), s.path().value());
        }
        ServerFileSystemContext serverFileSystemContext4 = ServerFileSystemContext$.Absolute;
        ServerFileSystemContext serverFileSystemContext5 = serverFileSystemContext;
        if (!(serverFileSystemContext4 != null ? !serverFileSystemContext4.equals(serverFileSystemContext5) : serverFileSystemContext5 != null)) {
            return this.getFile$1((Option)Some$.MODULE$.apply((Object)package$.MODULE$.File("/")), s.path().value());
        }
        ServerFileSystemContext serverFileSystemContext6 = ServerFileSystemContext$.Authentication;
        ServerFileSystemContext serverFileSystemContext7 = serverFileSystemContext;
        if (!(serverFileSystemContext6 != null ? !serverFileSystemContext6.equals(serverFileSystemContext7) : serverFileSystemContext7 != null)) {
            return this.getFile$1((Option)Some$.MODULE$.apply((Object)this.authenticationKeysDirectory(workspace)), s.path().value());
        }
        throw new MatchError((Object)serverFileSystemContext);
    }

    public boolean isPlugged(File file, Seq<Plugin> pluggedList, Workspace workspace) {
        SafePath safePath = this.fileToSafePath(file, this.fileToSafePath$default$2(file), workspace);
        return ((SeqOps)pluggedList.map((Function1 & Serializable)_$2 -> _$2.projectSafePath())).contains((Object)safePath);
    }

    public Option<TreeNodeData> fileToTreeNodeData(File f, Seq<Plugin> pluggedList, boolean testPlugin, boolean directorySize, Option<GitStatus> gitStatus, Workspace workspace) {
        if (f.exists()) {
            None$ dirData = f.isDirectory() ? Some$.MODULE$.apply((Object)TreeNodeData.Directory$.MODULE$.apply(package$.MODULE$.FileDecorator(f).isDirectoryEmpty())) : None$.MODULE$;
            long time = Files.readAttributes(package$.MODULE$.file2Path(f), BasicFileAttributes.class, new LinkOption[0]).lastModifiedTime().toMillis();
            return Some$.MODULE$.apply((Object)TreeNodeData$.MODULE$.apply(f.getName(), this.size$1(f, directorySize), time, (Option)dirData, PluginState$.MODULE$.apply(this.isPlugin$1(testPlugin, f), this.isPlugged(f, pluggedList, workspace)), gitStatus));
        }
        return None$.MODULE$;
    }

    public boolean fileToTreeNodeData$default$3() {
        return true;
    }

    public boolean fileToTreeNodeData$default$4() {
        return false;
    }

    public Option<GitStatus> fileToTreeNodeData$default$5() {
        return None$.MODULE$;
    }

    public ErrorStateLevel javaLevelToErrorLevel(Level level) {
        if (level.intValue() >= Level.WARNING.intValue()) {
            return ErrorStateLevel$.Error;
        }
        return ErrorStateLevel$.Debug;
    }

    public Seq<String> getPathArray(File f, Option<File> until) {
        Option canonicalUntil = until.map((Function1 & Serializable)_$3 -> _$3.getCanonicalFile());
        return (Seq)this.getParentsArray0$1(canonicalUntil, f, (Seq)((SeqOps)Nil$.MODULE$)).$colon$plus((Object)f.getName());
    }

    public FileListData listFiles(SafePath path, FileSorting fileFilter, Seq<Plugin> pluggedList, boolean testPlugin, boolean withHidden, boolean directorySize, Workspace workspace) {
        FileListData fileListData;
        block5: {
            LazyRef lazyRef = new LazyRef();
            Option currentDirGit = GitService$.MODULE$.git(this.SafePathDecorator(path).toFile(workspace), this.projectsDirectory(workspace));
            try {
                Seq modified = (Seq)currentDirGit.map((Function1 & Serializable)_$4 -> GitService$.MODULE$.getModified(_$4)).getOrElse(utils$::$anonfun$3);
                Seq conflicting = (Seq)currentDirGit.map((Function1 & Serializable)_$5 -> GitService$.MODULE$.getConflicting(_$5)).getOrElse(utils$::$anonfun$5);
                Seq untracked = (Seq)currentDirGit.map((Function1 & Serializable)_$6 -> GitService$.MODULE$.getUntracked(_$6)).getOrElse(utils$::$anonfun$7);
                File currentFile = this.safePathToFile(path, workspace);
                Seq sorted = (Seq)this.treeNodesData$1(currentFile, currentDirGit, modified, untracked, conflicting, pluggedList, testPlugin, directorySize, workspace, withHidden).sorted(this.fileSortingToOrdering$1(fileFilter));
                int sortedSize = sorted.size();
                Option branchData = currentDirGit.map((Function1 & Serializable)git -> BranchData$.MODULE$.apply((Seq)((SeqOps)GitService$.MODULE$.branchList(git).map((Function1 & Serializable)_$7 -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])_$7.split("/"));
                    return (String)ArrayOps$.MODULE$.last$extension(object);
                })).distinct(), git.getRepository().getBranch()));
                Option option = fileFilter.size();
                if (option instanceof Some) {
                    int s = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                    fileListData = FileListData$.MODULE$.apply((Seq)sorted.take(s), s, sortedSize, branchData);
                    break block5;
                }
                if (None$.MODULE$.equals(option)) {
                    fileListData = FileListData$.MODULE$.apply(sorted, sortedSize, sortedSize, branchData);
                    break block5;
                }
                throw new MatchError((Object)option);
            }
            finally {
                currentDirGit.foreach((Function1)(JProcedure1 & Serializable)_$8 -> _$8.close());
            }
        }
        return fileListData;
    }

    public boolean listFiles$default$4() {
        return true;
    }

    public boolean listFiles$default$5() {
        return true;
    }

    public boolean listFiles$default$6() {
        return false;
    }

    public Seq<Tuple2<SafePath, Object>> recursiveListFiles(SafePath path, Option<String> findString, boolean withHidden, Workspace workspace) {
        LazyRef lazyRef = new LazyRef();
        String fPath = this.safePathToFile(path, workspace).getAbsolutePath();
        Object[] allFiles = package$.MODULE$.FileDecorator(this.safePathToFile(path, workspace)).recursiveListFilesSafe((Function1 & Serializable)f -> {
            if (!this.filterHidden$2(withHidden, (File)f)) return false;
            String string = fPath;
            String string2 = f.getAbsolutePath();
            if (string == null) {
                if (string2 == null) return false;
            } else if (string.equals(string2)) return false;
            if (!BoxesRunTime.unboxToBoolean((Object)findString.map((Function1 & Serializable)s -> f.getName().contains((CharSequence)s)).getOrElse(utils$::$anonfun$10$$anonfun$2))) return false;
            return true;
        });
        Object object = Predef$.MODULE$.refArrayOps(allFiles);
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)f -> Tuple2$.MODULE$.apply((Object)this.fileToSafePath((File)f, this.given_ServerFileSystemContext$2(lazyRef, path), workspace), (Object)BoxesRunTime.boxToBoolean((boolean)f.isDirectory())), ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public boolean recursiveListFiles$default$3() {
        return true;
    }

    public boolean exists(SafePath safePath, Workspace workspace) {
        return this.safePathToFile(safePath, workspace).exists();
    }

    public Seq<SafePath> existsIn(Seq<SafePath> safePaths, SafePath to, Workspace workspace) {
        return (Seq)((IterableOps)safePaths.map((Function1 & Serializable)sp -> to.$plus$plus(sp.name()))).filter((Function1 & Serializable)safePath -> MODULE$.exists((SafePath)safePath, workspace));
    }

    public Seq<SafePath> copyFiles(Seq<Tuple2<SafePath, SafePath>> safePaths, boolean overwrite, Workspace workspace) {
        ListBuffer existing = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SafePath[0]));
        safePaths.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            SafePath safePath = (SafePath)x$1._1();
            SafePath safePath2 = (SafePath)x$1._2();
            File destination = this.SafePathDecorator(safePath2).toFile(workspace);
            if (destination.exists()) {
                existing.append((Object)safePath2);
                if (overwrite) {
                    this.copy$1(safePath, workspace, destination);
                    return;
                }
                return;
            }
            this.copy$1(safePath, workspace, destination);
        });
        return existing.toSeq();
    }

    public void deleteFile(SafePath safePath, Workspace workspace) {
        File f = this.safePathToFile(safePath, workspace);
        if (OMRFormat$.MODULE$.isOMR(f)) {
            OMRFormat$.MODULE$.delete(f);
            return;
        }
        package$.MODULE$.FileDecorator(f).recursiveDelete();
    }

    public void deleteFiles(Seq<SafePath> safePaths, Workspace workspace) {
        safePaths.foreach((Function1)(JProcedure1 & Serializable)sp -> MODULE$.deleteFile((SafePath)sp, workspace));
    }

    public void deleteEmptyDirectories(SafePath s, Workspace workspace) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.FileDecorator(this.safePathToFile(s, workspace)).listFilesSafe());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)f -> {
            if (f.isDirectory() && package$.MODULE$.FileDecorator(f).listFileSafeIterator().isEmpty()) {
                f.delete();
                return;
            }
        });
    }

    public String openmoleFileName() {
        return openmoleFileName;
    }

    public String webpakedOpenmoleFileName() {
        return webpakedOpenmoleFileName;
    }

    public String depsFileName() {
        return depsFileName;
    }

    public String openmoleGrammarName() {
        return openmoleGrammarName;
    }

    public String aceModuleSource() {
        return aceModuleSource;
    }

    public String openmoleGrammarMode() {
        return openmoleGrammarMode;
    }

    public String githubTheme() {
        return githubTheme;
    }

    public String webpackConfigTemplateName() {
        return webpackConfigTemplateName;
    }

    public String webpackJsonPackage() {
        return webpackJsonPackage;
    }

    public String nodeModulesFileName() {
        return nodeModulesFileName;
    }

    public void updateIfChanged(File file, Option<File> hashFile, Function1<File, BoxedUnit> update, FileService fileService, TmpDirectory newFile) {
        package$.MODULE$.FileDecorator(org.openmole.core.fileservice.package$.MODULE$.lockFile(file)).withLock((Function1)(JProcedure1 & Serializable)_$9 -> {
            boolean bl;
            LazyRef lazyRef = new LazyRef();
            File hashFile = this.hash$1(hashFile, file);
            if (!file.exists() || !hashFile.exists()) {
                bl = false;
            } else {
                Try try_ = Try$.MODULE$.apply(() -> utils$.$anonfun$11(hashFile));
                if (try_ instanceof Success) {
                    String v = (String)((Success)try_).value();
                    String string = this.currentHash$1(lazyRef, fileService, file, newFile);
                    String string2 = v;
                    bl = !(string != null ? !string.equals(string2) : string2 != null);
                } else if (try_ instanceof Failure) {
                    hashFile.delete();
                    bl = false;
                } else {
                    throw new MatchError((Object)try_);
                }
            }
            boolean upToDate = bl;
            if (!upToDate) {
                update.apply((Object)file);
                package$.MODULE$.FileDecorator(hashFile).content_$eq(this.currentHash$1(lazyRef, fileService, file, newFile));
                return;
            }
        });
    }

    public Option<File> updateIfChanged$default$2() {
        return None$.MODULE$;
    }

    public <T> Try<T> catchAll(Function0<T> f) {
        Success success;
        try {
            success = Success$.MODULE$.apply(f.apply());
        }
        catch (Throwable t) {
            success = Failure$.MODULE$.apply(t);
        }
        Success res = success;
        return res;
    }

    public File authenticationKeysDirectory(Workspace workspace) {
        return package$.MODULE$.FileDecorator(workspace.userDir()).$div("keys");
    }

    public Seq<ErrorData> addPlugin(SafePath safePath, Workspace workspace, TmpDirectory newFile) {
        File file = this.safePathToFile(safePath, workspace);
        Iterable errors = PluginManager$.MODULE$.tryLoad((Iterable)((SeqOps)new .colon.colon((Object)file, (List)Nil$.MODULE$)));
        return ((IterableOnceOps)errors.map((Function1 & Serializable)e -> ErrorData$.MODULE$.apply((Throwable)e._2(), ErrorData$.MODULE$.apply$default$2()))).toSeq();
    }

    public void removePlugin(SafePath safePath, Workspace workspace) {
        utils$ utils$2 = this;
        synchronized (utils$2) {
            File file = this.safePathToFile(safePath, workspace);
            Option bundle = PluginManager$.MODULE$.bundle(file);
            bundle.foreach((Function1)(JProcedure1 & Serializable)b -> PluginManager$.MODULE$.remove(b));
        }
    }

    public Seq<GitAuthentication.PrivateKey> gitAuthenticationFromData(Seq<GitPrivateKeyAuthenticationData> a2, Workspace x$2) {
        return (Seq)a2.flatMap((Function1 & Serializable)a -> a.privateKeyPath().map((Function1 & Serializable)k -> GitAuthentication.PrivateKey$.MODULE$.apply(MODULE$.safePathToFile((SafePath)k, x$2), a.password())));
    }

    public Option<Throwable> testSSHKeyPassword(String path, String password) {
        Some some;
        try (SSHClient sshClient = new SSHClient();){
            try {
                HostKeyVerifier verifier = new HostKeyVerifier(){

                    public boolean verify(String hostname, int port, PublicKey key) {
                        return true;
                    }

                    public java.util.List findExistingAlgorithms(String hostname, int port) {
                        return new ArrayList<E>();
                    }
                };
                sshClient.addHostKeyVerifier(verifier);
                KeyProvider keyProvider = sshClient.loadKeys(path, password);
                keyProvider.getPublic();
                some = None$.MODULE$;
            }
            catch (IOException e) {
                some = Some$.MODULE$.apply((Object)e);
            }
        }
        return some;
    }

    private static final File getFile0$1$$anonfun$1() {
        return new File("");
    }

    private final File getFile0$1(Seq paths, Option accFile) {
        Option option;
        while (true) {
            if (paths.isEmpty()) {
                return (File)accFile.getOrElse(utils$::getFile0$1$$anonfun$1);
            }
            option = accFile;
            if (None$.MODULE$.equals(option)) {
                return new File((String)paths.head());
            }
            if (!(option instanceof Some)) break;
            File f = (File)((Some)option).value();
            Seq seq = (Seq)paths.tail();
            Some some = Some$.MODULE$.apply((Object)new File(f, (String)paths.head()));
            paths = seq;
            accFile = some;
        }
        throw new MatchError((Object)option);
    }

    private final File getFile$1(Option root, Seq paths) {
        return this.getFile0$1(paths, root);
    }

    private final boolean isPlugin$1(boolean testPlugin$1, File file) {
        return testPlugin$1 && PluginManager$.MODULE$.isBundle(file);
    }

    private static final long size$1$$anonfun$1(File f$2) {
        return OMRFormat$.MODULE$.diskUsage(f$2);
    }

    private static final long size$1$$anonfun$2(File f$3) {
        return f$3.length();
    }

    private final Option size$1(File f$1, boolean directorySize$1) {
        if (!f$1.isDirectory()) {
            return Some$.MODULE$.apply(OMRFormat$.MODULE$.isOMR(f$1) ? Try$.MODULE$.apply(() -> utils$.size$1$$anonfun$1(f$1)).getOrElse(() -> utils$.size$1$$anonfun$2(f$1)) : BoxesRunTime.boxToLong((long)f$1.length()));
        }
        if (directorySize$1) {
            return Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.FileDecorator(f$1).size()));
        }
        return None$.MODULE$;
    }

    private static final boolean sameFile$1$$anonfun$2() {
        return false;
    }

    private final boolean sameFile$1(Option canonicalUntil$2, File parent$1) {
        return BoxesRunTime.unboxToBoolean((Object)canonicalUntil$2.map((Function1 & Serializable)c -> {
            if (c.exists() && parent$1.exists()) {
                return Files.isSameFile(parent$1.toPath(), c.toPath());
            }
            String string = parent$1.getPath();
            String string2 = c.getPath();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).getOrElse(utils$::sameFile$1$$anonfun$2));
    }

    private final Seq getParentsArray0$1(Option canonicalUntil$1, File f, Seq computedParents) {
        File file;
        while ((file = f.getParentFile()) != null) {
            File parent = file;
            if (this.sameFile$1(canonicalUntil$1, parent)) {
                return computedParents;
            }
            String string = parent.getName();
            if ("".equals(string)) {
                return computedParents;
            }
            String parentName = string;
            Seq computed = (Seq)computedParents.$plus$colon((Object)parentName);
            File file2 = parent;
            Seq seq = computed;
            f = file2;
            computedParents = seq;
        }
        return computedParents;
    }

    private final ServerFileSystemContext given_ServerFileSystemContext$lzyINIT1$1(LazyRef given_ServerFileSystemContext$lzy1$1, SafePath path$1) {
        ServerFileSystemContext serverFileSystemContext;
        LazyRef lazyRef = given_ServerFileSystemContext$lzy1$1;
        synchronized (lazyRef) {
            serverFileSystemContext = (ServerFileSystemContext)(given_ServerFileSystemContext$lzy1$1.initialized() ? given_ServerFileSystemContext$lzy1$1.value() : given_ServerFileSystemContext$lzy1$1.initialize((Object)path$1.context()));
        }
        return serverFileSystemContext;
    }

    private final ServerFileSystemContext given_ServerFileSystemContext$1(LazyRef given_ServerFileSystemContext$lzy1$2, SafePath path$2) {
        return (ServerFileSystemContext)(given_ServerFileSystemContext$lzy1$2.initialized() ? given_ServerFileSystemContext$lzy1$2.value() : this.given_ServerFileSystemContext$lzyINIT1$1(given_ServerFileSystemContext$lzy1$2, path$2));
    }

    private final boolean filterHidden$1(boolean withHidden$1, File f) {
        return withHidden$1 || !f.getName().startsWith(".");
    }

    private static final Seq $anonfun$3() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    private static final Seq $anonfun$5() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    private static final Seq $anonfun$7() {
        return (Seq)((SeqOps)Nil$.MODULE$);
    }

    private final Seq treeNodesData$1(File currentFile$1, Option currentDirGit$1, Seq modified$1, Seq untracked$1, Seq conflicting$1, Seq pluggedList$1, boolean testPlugin$2, boolean directorySize$2, Workspace workspace$2, boolean withHidden$2) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.FileDecorator(currentFile$1).listFilesSafe());
        return (Seq)((IterableOps)ArrayOps$.MODULE$.toSeq$extension(object).filter((Function1 & Serializable)f -> this.filterHidden$1(withHidden$2, (File)f))).flatMap((Function1 & Serializable)f -> {
            Object object;
            Git git2;
            Option option = currentDirGit$1;
            if (option instanceof Some && (git2 = (Git)((Some)option).value()) != null) {
                Git g = git2;
                String relativeName = GitService$.MODULE$.relativeName(f, g);
                object = modified$1.contains((Object)relativeName) ? Some$.MODULE$.apply((Object)GitStatus$.Modified) : (untracked$1.contains((Object)relativeName) ? Some$.MODULE$.apply((Object)GitStatus$.Untracked) : (conflicting$1.contains((Object)relativeName) ? Some$.MODULE$.apply((Object)GitStatus$.Conflicting) : Some$.MODULE$.apply((Object)GitStatus$.Versioned)));
            } else if (None$.MODULE$.equals(option)) {
                object = f.isDirectory() ? GitService$.MODULE$.withGit(f, currentFile$1, (Function1 & Serializable)git -> GitStatus$.Root) : None$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            None$ gitStatus = object;
            return MODULE$.fileToTreeNodeData((File)f, (Seq<Plugin>)pluggedList$1, testPlugin$2, directorySize$2, (Option<GitStatus>)gitStatus, workspace$2);
        });
    }

    public static final /* synthetic */ int org$openmole$gui$server$ext$utils$$$_$fileSizeOrdering$1$$anonfun$1(TreeNodeData tnd1, TreeNodeData tnd2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)tnd1.size(), (Object)tnd2.size());
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                long x = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                if (option2 instanceof Some) {
                    long y = BoxesRunTime.unboxToLong((Object)((Some)option2).value());
                    return new RichLong(Predef$.MODULE$.longWrapper(x)).compare((Object)BoxesRunTime.boxToLong((long)y));
                }
                if (None$.MODULE$.equals(option2)) {
                    return -1;
                }
            }
            if (None$.MODULE$.equals(option)) {
                if (option2 instanceof Some) {
                    return 1;
                }
                if (None$.MODULE$.equals(option2)) {
                    return 0;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private final Ordering fileSizeOrdering$1() {
        return new Ordering<TreeNodeData>(){
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }

            public final int compare(TreeNodeData tnd1, TreeNodeData tnd2) {
                return utils$.org$openmole$gui$server$ext$utils$$$_$fileSizeOrdering$1$$anonfun$1(tnd1, tnd2);
            }
        };
    }

    private final Ordering alphaOrdering$1() {
        return new Ordering<TreeNodeData>(){
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }

            public boolean isDirectory(TreeNodeData tnd) {
                Option option = tnd.directory();
                return !None$.MODULE$.equals(option);
            }

            public int compare(TreeNodeData tn1, TreeNodeData tn2) {
                if (this.isDirectory(tn1)) {
                    if (this.isDirectory(tn2)) {
                        return StringOps$.MODULE$.compare$extension(Predef$.MODULE$.augmentString(tn1.name()), tn2.name());
                    }
                    return -1;
                }
                if (this.isDirectory(tn2)) {
                    return 1;
                }
                return StringOps$.MODULE$.compare$extension(Predef$.MODULE$.augmentString(tn1.name()), tn2.name());
            }
        };
    }

    public static final /* synthetic */ int org$openmole$gui$server$ext$utils$$$_$timeOrdering$1$$anonfun$1(TreeNodeData tnd1, TreeNodeData tnd2) {
        return new RichLong(Predef$.MODULE$.longWrapper(tnd1.time())).compare((Object)BoxesRunTime.boxToLong((long)tnd2.time()));
    }

    private final Ordering timeOrdering$1() {
        return new Ordering<TreeNodeData>(){
            {
                PartialOrdering.$init$((PartialOrdering)this);
                Ordering.$init$((Ordering)this);
            }

            public final int compare(TreeNodeData tnd1, TreeNodeData tnd2) {
                return utils$.org$openmole$gui$server$ext$utils$$$_$timeOrdering$1$$anonfun$1(tnd1, tnd2);
            }
        };
    }

    private final Ordering ordering$1(ListSorting fs$1) {
        ListSorting listSorting = fs$1;
        ListSorting listSorting2 = ListSorting$.AlphaSorting;
        ListSorting listSorting3 = listSorting;
        if (!(listSorting2 != null ? !listSorting2.equals(listSorting3) : listSorting3 != null)) {
            return this.alphaOrdering$1();
        }
        ListSorting listSorting4 = ListSorting$.SizeSorting;
        ListSorting listSorting5 = listSorting;
        if (!(listSorting4 != null ? !listSorting4.equals(listSorting5) : listSorting5 != null)) {
            return this.fileSizeOrdering$1();
        }
        ListSorting listSorting6 = ListSorting$.TimeSorting;
        ListSorting listSorting7 = listSorting;
        if (!(listSorting6 != null ? !listSorting6.equals(listSorting7) : listSorting7 != null)) {
            return this.timeOrdering$1();
        }
        throw new MatchError((Object)listSorting);
    }

    private final Ordering fileSortingToOrdering$1(FileSorting filter) {
        ListSorting fs = filter.listSorting();
        FirstLast firstLast = filter.firstLast();
        FirstLast firstLast2 = FirstLast$.First;
        FirstLast firstLast3 = firstLast;
        if (!(firstLast2 != null ? !firstLast2.equals(firstLast3) : firstLast3 != null)) {
            return this.ordering$1(fs);
        }
        FirstLast firstLast4 = FirstLast$.Last;
        FirstLast firstLast5 = firstLast;
        if (!(firstLast4 != null ? !firstLast4.equals(firstLast5) : firstLast5 != null)) {
            return this.ordering$1(fs).reverse();
        }
        throw new MatchError((Object)firstLast);
    }

    private final ServerFileSystemContext given_ServerFileSystemContext$lzyINIT2$1(LazyRef given_ServerFileSystemContext$lzy2$1, SafePath path$3) {
        ServerFileSystemContext serverFileSystemContext;
        LazyRef lazyRef = given_ServerFileSystemContext$lzy2$1;
        synchronized (lazyRef) {
            serverFileSystemContext = (ServerFileSystemContext)(given_ServerFileSystemContext$lzy2$1.initialized() ? given_ServerFileSystemContext$lzy2$1.value() : given_ServerFileSystemContext$lzy2$1.initialize((Object)path$3.context()));
        }
        return serverFileSystemContext;
    }

    private final ServerFileSystemContext given_ServerFileSystemContext$2(LazyRef given_ServerFileSystemContext$lzy2$2, SafePath path$4) {
        return (ServerFileSystemContext)(given_ServerFileSystemContext$lzy2$2.initialized() ? given_ServerFileSystemContext$lzy2$2.value() : this.given_ServerFileSystemContext$lzyINIT2$1(given_ServerFileSystemContext$lzy2$2, path$4));
    }

    private final boolean filterHidden$2(boolean withHidden$3, File f) {
        return withHidden$3 || !f.getName().startsWith(".");
    }

    private static final boolean $anonfun$10$$anonfun$2() {
        return true;
    }

    private final void copy$1(SafePath p$1, Workspace workspace$7, File destination$1) {
        File fromFile = this.SafePathDecorator(p$1).toFile(workspace$7);
        if (OMRFormat$.MODULE$.isOMR(fromFile)) {
            OMRFormat$.MODULE$.copy(fromFile, destination$1);
            return;
        }
        FilePackage.FileDecorator fileDecorator = package$.MODULE$.FileDecorator(fromFile);
        fileDecorator.copy(destination$1, fileDecorator.copy$default$2());
    }

    private static final File hash$1$$anonfun$1(File f$5) {
        return new File(f$5.toString() + "-hash");
    }

    private final File hash$1(Option hashFile$1, File f) {
        return (File)hashFile$1.getOrElse(() -> utils$.hash$1$$anonfun$1(f));
    }

    private final String currentHash$lzyINIT1$1(LazyRef currentHash$lzy1$1, FileService fileService$2, File file$2, TmpDirectory newFile$2) {
        String string;
        LazyRef lazyRef = currentHash$lzy1$1;
        synchronized (lazyRef) {
            string = (String)(currentHash$lzy1$1.initialized() ? currentHash$lzy1$1.value() : currentHash$lzy1$1.initialize((Object)fileService$2.hashNoCache(file$2, fileService$2.hashNoCache$default$2(), newFile$2).toString()));
        }
        return string;
    }

    private final String currentHash$1(LazyRef currentHash$lzy1$2, FileService fileService$3, File file$3, TmpDirectory newFile$3) {
        return (String)(currentHash$lzy1$2.initialized() ? currentHash$lzy1$2.value() : this.currentHash$lzyINIT1$1(currentHash$lzy1$2, fileService$3, file$3, newFile$3));
    }

    private static final String $anonfun$11(File hashFile$3) {
        return package$.MODULE$.FileDecorator(hashFile$3).content();
    }

    public static final /* synthetic */ boolean org$openmole$gui$server$ext$utils$HTTP$$$_$multipartContent$$anonfun$1(String name$1, Part _$10) {
        return _$10.name().contains((Object)name$1);
    }

    public static final /* synthetic */ boolean org$openmole$gui$server$ext$utils$HTTP$$$_$multipartContent$$anonfun$2(boolean shouldBeFile$1, Part f) {
        return !shouldBeFile$1 || f.filename().isDefined();
    }

    public static final /* synthetic */ boolean org$openmole$gui$server$ext$utils$HTTP$$$_$listMultipartContent$$anonfun$1(String name$2, Part _$11) {
        return _$11.name().contains((Object)name$2);
    }

    public static final /* synthetic */ boolean org$openmole$gui$server$ext$utils$HTTP$$$_$listMultipartContent$$anonfun$2(boolean shouldBeFile$2, Part f) {
        return !shouldBeFile$2 || f.filename().isDefined();
    }

    public static final /* synthetic */ String org$openmole$gui$server$ext$utils$HTTP$$$_$multipartStringContent$$anonfun$1(IORuntime x$3$1, Part _$12) {
        return (String)((IOPlatform)_$12.bodyText(RaiseThrowable$.MODULE$.fromApplicativeError((ApplicativeError)IO$.MODULE$.asyncForIO()), _$12.bodyText$default$2()).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).string((.less.colon.less)$less$colon$less$.MODULE$.refl())).unsafeRunSync(x$3$1);
    }

    public static final /* synthetic */ void org$openmole$gui$server$ext$utils$HTTP$$$_$recieveFile$$anonfun$1(File destination$2, BoxedUnit _$13) {
        destination$2.setWritable(true);
    }

    private static final void $anonfun$12$$anonfun$1(Function1 stream$2, OutputStream out$1) {
        stream$2.apply((Object)out$1);
    }

    public static final /* synthetic */ IO org$openmole$gui$server$ext$utils$HTTP$$$_$_$$anonfun$12(Function1 stream$1, OutputStream out) {
        return IO$.MODULE$.blocking((Function0 & Serializable)() -> {
            utils$.$anonfun$12$$anonfun$1(stream$1, out);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ Response org$openmole$gui$server$ext$utils$HTTP$$$_$sendFileStream$$anonfun$1(String fileName$1, Response r) {
        Object[] objectArray = new Header.ToRaw[1];
        Object[] objectArray2 = new Tuple2[1];
        CIString cIString = (CIString)Predef$.MODULE$.ArrowAssoc((Object)org.typelevel.ci.package$.MODULE$.CIStringSyntax(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"filename"}))).ci((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0])));
        objectArray2[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)cIString, (Object)String.valueOf(fileName$1));
        objectArray[0] = Header.ToRaw$.MODULE$.modelledHeadersToRaw((Object)Content$minusDisposition$.MODULE$.apply("attachment", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), Content$minusDisposition$.MODULE$.headerInstance());
        return (Response)r.withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public static final IO org$openmole$gui$server$ext$utils$HTTP$$$_$sendFile$$anonfun$1(File f$6) {
        return (IO)io$.MODULE$.http4sNotFoundSyntax(Status$.MODULE$.NotFound()).apply((Object)(f$6.getName() + " not found"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Header.ToRaw[0]), (Applicative)IO$.MODULE$.asyncForIO(), EntityEncoder$.MODULE$.stringEncoder(EntityEncoder$.MODULE$.stringEncoder$default$1()));
    }

    public static final /* synthetic */ Response org$openmole$gui$server$ext$utils$HTTP$$$_$sendFile$$anonfun$2(File f$7, Option name$3, Response r) {
        return utils$HTTP$.MODULE$.setFileHeaders(f$7, (Response<IO>)r, (Option<String>)name$3);
    }

    public static final String org$openmole$gui$server$ext$utils$HTTP$$$_$setFileHeaders$$anonfun$1(File f$8) {
        return f$8.getName();
    }

    public static final /* synthetic */ void org$openmole$gui$server$ext$utils$HTTP$$$_$convertOMRHistory$$anonfun$1(Seq history$1, TmpDirectory tmpDirectory$1, GUIOMRContent.ExportFormat format$1, File omrFile$1, OutputStream out) {
        try (TarArchiveOutputStream tos = package$package$.MODULE$.TarArchiveOutputStream((OutputStream)org.openmole.tool.stream.package$.MODULE$.OutputStreamDecorator(out).toGZ(), (Option)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)65536)));){
            ((IterableOnceOps)history$1.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                block5: {
                    String string = (String)x$1._1();
                    int n = BoxesRunTime.unboxToInt((Object)x$1._2());
                    File f = tmpDirectory$1.newFile("history" + n, tmpDirectory$1.newFile$default$2(), tmpDirectory$1);
                    try {
                        GUIOMRContent.ExportFormat exportFormat = format$1;
                        GUIOMRContent.ExportFormat exportFormat2 = GUIOMRContent.ExportFormat$.JSON;
                        GUIOMRContent.ExportFormat exportFormat3 = exportFormat;
                        if (!(exportFormat2 != null ? !exportFormat2.equals(exportFormat3) : exportFormat3 != null)) {
                            OMRFormat$.MODULE$.writeJSON(omrFile$1, f, (Option)Some$.MODULE$.apply((Object)string));
                            package$package$.MODULE$.TarOutputStreamDecorator(tos).addFile(f, n + ".json");
                            break block5;
                        }
                        GUIOMRContent.ExportFormat exportFormat4 = GUIOMRContent.ExportFormat$.CSV;
                        GUIOMRContent.ExportFormat exportFormat5 = exportFormat;
                        if (!(exportFormat4 != null ? !exportFormat4.equals(exportFormat5) : exportFormat5 != null)) {
                            OMRFormat$.MODULE$.writeCSV(omrFile$1, f, (Option)Some$.MODULE$.apply((Object)string), OMRFormat$.MODULE$.writeCSV$default$4(), OMRFormat$.MODULE$.writeCSV$default$5(), OMRFormat$.MODULE$.writeCSV$default$6());
                            package$package$.MODULE$.TarOutputStreamDecorator(tos).addFile(f, n + ".csv");
                            break block5;
                        }
                        throw new MatchError((Object)exportFormat);
                    }
                    finally {
                        f.delete();
                    }
                }
            });
        }
    }

    private static final void deleteExportFile$1$$anonfun$1(File exportFile$2) {
        exportFile$2.delete();
    }

    public static /* bridge */ /* synthetic */ Object org$openmole$gui$server$ext$utils$HTTP$$$_$deleteExportFile$1$$anonfun$adapted$1(File exportFile$4) {
        utils$.deleteExportFile$1$$anonfun$1(exportFile$4);
        return BoxedUnit.UNIT;
    }

    public static final IO org$openmole$gui$server$ext$utils$HTTP$$$_$convertOMR$$anonfun$2() {
        return (IO)io$.MODULE$.http4sNotFoundSyntax(Status$.MODULE$.NotFound()).apply((Applicative)IO$.MODULE$.asyncForIO());
    }

    public static final /* synthetic */ Response org$openmole$gui$server$ext$utils$HTTP$$$_$convertOMR$$anonfun$3(File exportFile$3, String exportName$1, Response r) {
        return utils$HTTP$.MODULE$.setFileHeaders(exportFile$3, (Response<IO>)r, (Option<String>)Some$.MODULE$.apply((Object)exportName$1));
    }

    private static final List $anonfun$13() {
        Encoder encodeA;
        Encoder encodeA2;
        EncoderNotDeriveSum f$proxy2;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy2 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy2 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy3 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeOption(Encoder$.MODULE$.encodeString());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    public static final List org$openmole$gui$server$ext$utils$HTTP$$$_$stackError$$anonfun$1() {
        Encoder encodeA;
        EncoderNotDeriveSum f$proxy1;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy1 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        String string = "message";
        String string2 = "stackTrace";
        Encoder encoder = encodeA = Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(utils$::$anonfun$13, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())));
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder);
    }

    public static final /* synthetic */ Response org$openmole$gui$server$ext$utils$HTTP$$$_$stackError$$anonfun$2(Response _$14) {
        return (Response)_$14.withContentType(Content$minusType$.MODULE$.apply(MediaType$.MODULE$.application().json()));
    }
}

