/*
 * Decompiled with CFR 0.152.
 */
package gridscale.condor;

import gridscale.cluster.BatchScheduler;
import gridscale.cluster.BatchScheduler$;
import gridscale.cluster.HeadNode;
import gridscale.cluster.Requirement$;
import gridscale.condor.CondorJobDescription;
import gridscale.condor.CondorRequirement$;
import gridscale.package;
import gridscale.tools.package$package$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class impl$
implements Serializable {
    public static final impl$ MODULE$ = new impl$();

    private impl$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(impl$.class);
    }

    public String toScript(CondorJobDescription description, String uniqId) {
        String string;
        String header = "#!/bin/bash\n";
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"output = ");
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"error = ");
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"request_memory = ");
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"initialdir = ");
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"executable = ");
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"arguments = ");
        Seq core = (Seq)((SeqOps)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Some$.MODULE$.apply((Object)BatchScheduler$.MODULE$.output(uniqId))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Some$.MODULE$.apply((Object)BatchScheduler$.MODULE$.error(uniqId))), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)description.memory().map((Function1 & Serializable)m -> package$package$.MODULE$.InformationDecorator(m).toMBString() + " MB")), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Some$.MODULE$.apply((Object)description.workDirectory())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)Some$.MODULE$.apply((Object)description.executable())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)Some$.MODULE$.apply((Object)("\"" + description.arguments() + "\""))), (List)Nil$.MODULE$)))))));
        Option<Object> option = description.nodes();
        if (option instanceof Some) {
            int n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            string = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("universe = parallel\n          |machine_count = " + n + "\n          |\n          |request_cpus = " + description.coreByNode().getOrElse(impl$::$anonfun$2) + "\n          "));
        } else if (None$.MODULE$.equals(option)) {
            string = "universe = vanilla";
        } else {
            throw new MatchError(option);
        }
        String universe = string;
        Seq reqAll = (Seq)((SeqOps)new .colon.colon(description.requirements(), (List)new .colon.colon((Object)description.coreByNode().map((Function1 & Serializable)c -> CondorRequirement$.MODULE$.apply(BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)c)).toString())), (List)Nil$.MODULE$)));
        Seq reqList = (Seq)reqAll.foldLeft((Object)package$.MODULE$.Seq().empty(), (Function2 & Serializable)(_$1, _$2) -> (Seq)_$1.$plus$plus((IterableOnce)_$2));
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(header + "\n         |" + universe + "\n         |" + Requirement$.MODULE$.requirementsString(Requirement$.MODULE$.pairs2Requirements(core), Requirement$.MODULE$.requirementsString$default$2()) + "\n         |\n         |" + (String)(reqList.nonEmpty() ? "requirements = " + CondorRequirement$.MODULE$.apply(reqList.mkString()).toCondor() : "") + "\n         |\n         |getenv = True\n         |\n         |queue 1\n         |"));
    }

    public String retrieveJobId(String out) {
        return StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.tail$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(out.trim()))))), (Function1 & Serializable)_$3 -> impl$.retrieveJobId$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$3)))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public package.JobState translateStatus(String status, String command) {
        String string = status;
        switch (string == null ? 0 : string.hashCode()) {
            case 48: {
                if ("0".equals(string)) return package.JobState$.Submitted;
                throw new RuntimeException("Unrecognized state " + status + " retrieved from " + command);
            }
            case 49: {
                if ("1".equals(string)) return package.JobState$.Submitted;
                throw new RuntimeException("Unrecognized state " + status + " retrieved from " + command);
            }
            case 50: {
                if (!"2".equals(string)) throw new RuntimeException("Unrecognized state " + status + " retrieved from " + command);
                return package.JobState$.Running;
            }
            case 51: {
                if ("3".equals(string)) return package.JobState$.Done;
                throw new RuntimeException("Unrecognized state " + status + " retrieved from " + command);
            }
            case 52: {
                if ("4".equals(string)) return package.JobState$.Done;
                throw new RuntimeException("Unrecognized state " + status + " retrieved from " + command);
            }
            case 53: {
                if ("5".equals(string)) return package.JobState$.Submitted;
                throw new RuntimeException("Unrecognized state " + status + " retrieved from " + command);
            }
            case 54: {
                if (!"6".equals(string)) throw new RuntimeException("Unrecognized state " + status + " retrieved from " + command);
                return package.JobState$.Failed$.MODULE$.apply(package.JobState$.Failed$.MODULE$.$lessinit$greater$default$1());
            }
        }
        throw new RuntimeException("Unrecognized state " + status + " retrieved from " + command);
    }

    public RuntimeException formatError(String command, package.ExecutionResult cmdRet) {
        return new RuntimeException("Could not retrieve job state from " + command + " [output: " + cmdRet.stdOut() + "] [error: " + cmdRet.stdErr() + "]");
    }

    public String parseStateInQueue(String output) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(output), '='));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$4 -> _$4.trim(), ClassTag$.MODULE$.apply(String.class)));
        return (String)ArrayOps$.MODULE$.last$extension(object2);
    }

    public String parseStateFinished(String output) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])output.split("\n"));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)_$5 -> _$5.matches("^JobStatus = .*")));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString((String)ArrayOps$.MODULE$.head$extension(object2)), '='));
        Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)_$6 -> _$6.trim(), ClassTag$.MODULE$.apply(String.class)));
        return (String)ArrayOps$.MODULE$.last$extension(object4);
    }

    public package.JobState queryState(HeadNode server, BatchScheduler.BatchJob job) {
        package.JobState jobState;
        String queryInQueueCommand = "condor_q " + job.jobId() + " -long -attributes JobStatus";
        String queryFinishedCommand = "condor_history " + job.jobId() + " -long";
        package.ExecutionResult cmdRet = server.execute(queryInQueueCommand);
        package.ExecutionResult executionResult = cmdRet;
        if (executionResult == null) {
            throw new MatchError((Object)executionResult);
        }
        package.ExecutionResult executionResult2 = package.ExecutionResult$.MODULE$.unapply(executionResult);
        int n = executionResult2._1();
        String string = executionResult2._2();
        String string2 = executionResult2._3();
        int ret = n;
        String stdOut = string;
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)ret), (Object)stdOut);
        int ret2 = BoxesRunTime.unboxToInt((Object)tuple2._1());
        String stdOut2 = (String)tuple2._2();
        if (ret2 != 0) {
            throw this.formatError(queryInQueueCommand, cmdRet);
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(stdOut2))) {
            String state = this.parseStateInQueue(stdOut2);
            jobState = this.translateStatus(state, queryInQueueCommand);
        } else {
            package.ExecutionResult cmdRet2 = server.execute(queryFinishedCommand);
            String state = this.parseStateFinished(cmdRet2.stdOut());
            jobState = this.translateStatus(state, queryFinishedCommand);
        }
        package.JobState state = jobState;
        return state;
    }

    private static final int $anonfun$2() {
        return 1;
    }

    private static final /* synthetic */ boolean retrieveJobId$$anonfun$1(char _$3) {
        return _$3 != ' ';
    }
}

