/*
 * Decompiled with CFR 0.152.
 */
package fs2.compression;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.LiftIO;
import cats.effect.LiftIO$;
import cats.effect.kernel.Sync;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.Pull$StreamPullOps$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.compression.Compression;
import fs2.compression.CompressionCompanionPlatform$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipExtraFlag$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipFlag$;
import fs2.compression.CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$;
import fs2.compression.CompressionCompanionPlatformLowPriority;
import fs2.compression.DeflateParams;
import fs2.compression.GunzipResult;
import fs2.compression.GunzipResult$;
import fs2.compression.InflateParams;
import fs2.compression.ZLibParams;
import fs2.compression.ZLibParams$Header$GZIP$;
import java.io.EOFException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import scala.$less$colon$less$;
import scala.Array;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;

public interface CompressionCompanionPlatform
extends CompressionCompanionPlatformLowPriority {
    public static Compression forIO$(CompressionCompanionPlatform $this) {
        return $this.forIO();
    }

    default public Compression<IO> forIO() {
        return this.forLiftIO((Sync)IO$.MODULE$.asyncForIO(), (LiftIO)LiftIO$.MODULE$.ioLiftIO());
    }

    public static Compression forLiftIO$(CompressionCompanionPlatform $this, Sync evidence$1, LiftIO evidence$2) {
        return $this.forLiftIO(evidence$1, evidence$2);
    }

    default public <F> Compression<F> forLiftIO(Sync<F> evidence$1, LiftIO<F> evidence$2) {
        LiftIO liftIO = LiftIO$.MODULE$.apply(evidence$2);
        return this.forSync(evidence$1);
    }

    public static Compression forSync$(CompressionCompanionPlatform $this, Sync F) {
        return $this.forSync(F);
    }

    default public <F> Compression<F> forSync(Sync<F> F) {
        return new Compression.UnsealedCompression<F>(F){
            private final Sync F$1;
            public static final long OFFSET$3;
            public static final long OFFSET$2;
            public static final long OFFSET$1;
            public static final long OFFSET$0;
            private final int gzipHeaderBytes;
            private final byte gzipMagicFirstByte;
            private final byte gzipMagicSecondByte;
            private volatile Object gzipCompressionMethod$lzy1;
            private volatile Object gzipFlag$lzy1;
            private volatile Object gzipExtraFlag$lzy1;
            private final int gzipOptionalExtraFieldLengthBytes;
            private final int gzipHeaderCrcBytes;
            private volatile Object gzipOperatingSystem$lzy1;
            private final int gzipTrailerBytes;
            private final byte zeroByte;
            private final int fileNameBytesSoftLimit;
            private final int fileCommentBytesSoftLimit;
            {
                this.F$1 = F$2;
                this.gzipHeaderBytes = 10;
                this.gzipMagicFirstByte = (byte)31;
                this.gzipMagicSecondByte = (byte)139;
                this.gzipOptionalExtraFieldLengthBytes = 2;
                this.gzipHeaderCrcBytes = 2;
                int gzipInputCrcBytes = 4;
                int gzipInputSizeBytes = 4;
                this.gzipTrailerBytes = gzipInputCrcBytes + gzipInputSizeBytes;
                this.zeroByte = 0;
                this.fileNameBytesSoftLimit = 1024;
                this.fileCommentBytesSoftLimit = 0x100000;
            }

            static {
                OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("gzipOperatingSystem$lzy1"));
                OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("gzipExtraFlag$lzy1"));
                OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("gzipFlag$lzy1"));
                OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic($anon$1.class.getDeclaredField("gzipCompressionMethod$lzy1"));
            }

            public Function1 deflate(DeflateParams deflateParams) {
                return (Function1 & Serializable)stream -> Stream$.MODULE$.bracket(this.F$1.delay(() -> CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$deflate$$anonfun$1$$anonfun$1(deflateParams)), (Function1 & Serializable)deflater -> this.F$1.delay(() -> CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$deflate$$anonfun$1$$anonfun$2$$anonfun$adapted$1(deflater))).flatMap((Function1 & Serializable)deflater -> (Stream)this._deflate(deflateParams, (Deflater)deflater, (Option)None$.MODULE$).apply(stream), NotGiven$.MODULE$.value());
            }

            private Function1 _deflate(DeflateParams deflateParams, Deflater deflater, Option crc32) {
                return (Function1 & Serializable)in -> Stream$.MODULE$.suspend(() -> this._deflate$$anonfun$1$$anonfun$1(deflateParams, deflater, crc32, in));
            }

            private Pull _deflate_chunk(DeflateParams deflateParams, Deflater deflater, Option crc32, Chunk chunk, byte[] deflatedBuffer, boolean isFinalChunk) {
                Chunk.ArraySlice<O2> bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
                deflater.setInput((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                if (isFinalChunk) {
                    deflater.finish();
                }
                crc32.foreach((Function1)((JProcedure1 & Serializable)arg_0 -> CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_deflate_chunk$$anonfun$1(bytesChunk, arg_0)));
                return this.pull$1(deflatedBuffer, deflater, deflateParams, isFinalChunk);
            }

            private Function1 _deflate_stream(DeflateParams deflateParams, Deflater deflater, Option crc32, byte[] deflatedBuffer) {
                return (Function1 & Serializable)_$6 -> {
                    Stream stream = Stream$.MODULE$.InvariantOps(_$6);
                    Stream<F, O> stream2 = new Stream.ToPull<F, O>(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                    return Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2;
                        Option option = x$1;
                        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                            Chunk inflatedChunk = (Chunk)tuple2._1();
                            Stream inflatedStream = (Stream)tuple2._2();
                            return this._deflate_chunk(deflateParams, deflater, crc32, inflatedChunk, deflatedBuffer, false).$greater$greater(() -> this._deflate_stream$$anonfun$1$$anonfun$1$$anonfun$1(deflateParams, deflater, crc32, deflatedBuffer, inflatedStream));
                        }
                        if (None$.MODULE$.equals(option)) {
                            return this._deflate_chunk(deflateParams, deflater, crc32, Chunk$.MODULE$.empty(), deflatedBuffer, true);
                        }
                        throw new MatchError((Object)option);
                    });
                };
            }

            public Function1 inflate(InflateParams inflateParams) {
                return (Function1 & Serializable)stream -> {
                    Pull pull = Pull$.MODULE$.StreamPullOps(Pull$.MODULE$.bracketCase(Pull$.MODULE$.eval(this.F$1.delay(() -> CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$inflate$$anonfun$1$$anonfun$1(inflateParams))), (Function1 & Serializable)inflater -> (Pull)this._inflate(inflateParams, (Inflater)inflater, (Option)None$.MODULE$).apply(stream), (Function2 & Serializable)(inflater, _$7) -> Pull$.MODULE$.eval(this.F$1.delay(() -> CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$inflate$$anonfun$1$$anonfun$3$$anonfun$adapted$1(inflater)))));
                    return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
                };
            }

            private Function1 _inflate(InflateParams inflateParams, Inflater inflater, Option crc32) {
                return (Function1 & Serializable)in -> Pull$.MODULE$.suspend(() -> this._inflate$$anonfun$1$$anonfun$1(inflateParams, in, inflater, crc32));
            }

            private Pull _inflate_chunk(Inflater inflater, Option crc32, Chunk chunk, byte[] inflatedBuffer) {
                Chunk.ArraySlice<O2> bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
                inflater.setInput((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                return this.pull$2(inflater, bytesChunk, inflatedBuffer, crc32);
            }

            private Function1 _inflate_stream(InflateParams inflateParams, Inflater inflater, Option crc32, byte[] inflatedBuffer) {
                return (Function1 & Serializable)_$9 -> {
                    Stream stream = Stream$.MODULE$.InvariantOps(_$9);
                    Stream<F, O> stream2 = new Stream.ToPull<F, O>(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                    return Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2;
                        Option option = x$1;
                        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                            Chunk deflatedChunk = (Chunk)tuple2._1();
                            Stream deflatedStream = (Stream)tuple2._2();
                            return this._inflate_chunk(inflater, crc32, deflatedChunk, inflatedBuffer).$greater$greater(() -> this._inflate_stream$$anonfun$1$$anonfun$1$$anonfun$1(inflateParams, inflater, crc32, inflatedBuffer, deflatedStream));
                        }
                        if (None$.MODULE$.equals(option)) {
                            if (!inflater.finished()) {
                                return Pull$.MODULE$.raiseError(new DataFormatException("Insufficient data"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                            }
                            return Pull$.MODULE$.done();
                        }
                        throw new MatchError((Object)option);
                    });
                };
            }

            public Function1 gzip(Option fileName, Option modificationTime, Option comment, DeflateParams deflateParams) {
                return (Function1 & Serializable)stream -> {
                    DeflateParams deflateParams = deflateParams;
                    if (deflateParams != null) {
                        DeflateParams deflateParams2;
                        DeflateParams params = deflateParams2 = deflateParams;
                        ZLibParams.Header header = params.header();
                        ZLibParams$Header$GZIP$ zLibParams$Header$GZIP$ = ZLibParams$Header$GZIP$.MODULE$;
                        if (!(header != null ? !header.equals(zLibParams$Header$GZIP$) : zLibParams$Header$GZIP$ != null)) {
                            return Stream$.MODULE$.bracket(this.F$1.delay(() -> CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gzip$$anonfun$5$$anonfun$1(params)), (Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    Deflater deflater = (Deflater)tuple2._1();
                                    return this.F$1.delay(() -> CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gzip$$anonfun$5$$anonfun$2$$anonfun$adapted$1(deflater));
                                }
                                throw new MatchError((Object)tuple2);
                            }).flatMap((Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    Deflater deflater = (Deflater)tuple2._1();
                                    CRC32 crc32 = (CRC32)tuple2._2();
                                    return this._gzip_header(fileName, modificationTime, comment, params.level().juzDeflaterLevel(), params.fhCrcEnabled()).$plus$plus(() -> this.gzip$$anonfun$5$$anonfun$3$$anonfun$1(params, deflater, crc32, stream)).$plus$plus(() -> this.gzip$$anonfun$5$$anonfun$3$$anonfun$2(deflater, crc32));
                                }
                                throw new MatchError((Object)tuple2);
                            }, NotGiven$.MODULE$.value());
                        }
                        DeflateParams params2 = deflateParams2;
                        return Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(28).append(ZLibParams$Header$GZIP$.MODULE$).append(" header type required, not ").append(params2.header()).append(".").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                    }
                    throw new MatchError((Object)deflateParams);
                };
            }

            private Stream _gzip_header(Option fileName, Option modificationTime, Option comment, int deflateLevel, boolean fhCrcEnabled) {
                int n;
                long secondsSince197001010000 = BoxesRunTime.unboxToLong((Object)modificationTime.map(CompressionCompanionPlatform::fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_$$anonfun$1).getOrElse(CompressionCompanionPlatform::fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_$$anonfun$2));
                byte[] header = new byte[]{this.gzipMagicFirstByte, this.gzipMagicSecondByte, this.gzipCompressionMethod().DEFLATE(), (byte)((fhCrcEnabled ? this.gzipFlag().FHCRC() : this.zeroByte) + BoxesRunTime.unboxToByte((Object)fileName.map((Function1 & Serializable)_$11 -> this.gzipFlag().FNAME()).getOrElse(this::$anonfun$4)) + BoxesRunTime.unboxToByte((Object)comment.map((Function1 & Serializable)_$12 -> this.gzipFlag().FCOMMENT()).getOrElse(this::$anonfun$6))), (byte)(secondsSince197001010000 & 0xFFL), (byte)(secondsSince197001010000 >> 8 & 0xFFL), (byte)(secondsSince197001010000 >> 16 & 0xFFL), (byte)(secondsSince197001010000 >> 24 & 0xFFL), 9 == (n = deflateLevel) ? this.gzipExtraFlag().DEFLATE_MAX_COMPRESSION_SLOWEST_ALGO() : (1 == n ? this.gzipExtraFlag().DEFLATE_FASTEST_ALGO() : this.zeroByte), this.gzipOperatingSystem().THIS()};
                CRC32 crc32 = new CRC32();
                crc32.update(header);
                Option fileNameEncoded = fileName.map((Function1 & Serializable)string -> {
                    byte[] bytes = string.replaceAll("\u0000", "_").getBytes(StandardCharsets.ISO_8859_1);
                    crc32.update(bytes);
                    crc32.update(this.zeroByte);
                    return bytes;
                });
                Option commentEncoded = comment.map((Function1 & Serializable)string -> {
                    byte[] bytes = string.replaceAll("\u0000", " ").getBytes(StandardCharsets.ISO_8859_1);
                    crc32.update(bytes);
                    crc32.update(this.zeroByte);
                    return bytes;
                });
                long crc32Value = crc32.getValue();
                byte[] crc16 = fhCrcEnabled ? new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL)} : Array$.MODULE$.emptyByteArray();
                return Stream$.MODULE$.chunk(this.moveAsChunkBytes(header)).$plus$plus(() -> this._gzip_header$$anonfun$1(fileNameEncoded)).$plus$plus(() -> this._gzip_header$$anonfun$2(commentEncoded)).$plus$plus(() -> this._gzip_header$$anonfun$3(crc16));
            }

            private Stream _gzip_trailer(Deflater deflater, CRC32 crc32) {
                long crc32Value = crc32.getValue();
                int bytesIn = deflater.getTotalIn();
                byte[] trailer = new byte[]{(byte)(crc32Value & 0xFFL), (byte)(crc32Value >> 8 & 0xFFL), (byte)(crc32Value >> 16 & 0xFFL), (byte)(crc32Value >> 24 & 0xFFL), (byte)(bytesIn & 0xFF), (byte)(bytesIn >> 8 & 0xFF), (byte)(bytesIn >> 16 & 0xFF), (byte)(bytesIn >> 24 & 0xFF)};
                return Stream$.MODULE$.chunk(this.moveAsChunkBytes(trailer));
            }

            public Function1 gunzip(InflateParams inflateParams) {
                return (Function1 & Serializable)stream -> {
                    InflateParams inflateParams = inflateParams;
                    if (inflateParams != null) {
                        InflateParams inflateParams2;
                        InflateParams params = inflateParams2 = inflateParams;
                        ZLibParams.Header header = params.header();
                        ZLibParams$Header$GZIP$ zLibParams$Header$GZIP$ = ZLibParams$Header$GZIP$.MODULE$;
                        if (!(header != null ? !header.equals(zLibParams$Header$GZIP$) : zLibParams$Header$GZIP$ != null)) {
                            Pull pull = Pull$.MODULE$.StreamPullOps(Pull$.MODULE$.bracketCase(Pull$.MODULE$.eval(this.F$1.delay(CompressionCompanionPlatform::fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gunzip$$anonfun$1$$anonfun$1)), (Function1 & Serializable)x$12 -> {
                                Tuple3 tuple3 = x$12;
                                if (tuple3 != null) {
                                    Inflater inflater = (Inflater)tuple3._1();
                                    CRC32 headerCrc32 = (CRC32)tuple3._2();
                                    CRC32 contentCrc32 = (CRC32)tuple3._3();
                                    Stream stream = Stream$.MODULE$.InvariantOps(stream);
                                    Stream<F, O> stream2 = new Stream.ToPull<F, O>(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                                    return Stream$ToPull$.MODULE$.unconsN$extension(stream2, this.gzipHeaderBytes, Stream$ToPull$.MODULE$.unconsN$default$2$extension(stream2)).flatMap((Function1 & Serializable)x$1 -> {
                                        Tuple2 tuple2;
                                        Option option = x$1;
                                        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                                            Chunk mandatoryHeaderChunk = (Chunk)tuple2._1();
                                            Stream streamAfterMandatoryHeader = (Stream)tuple2._2();
                                            return this._gunzip_matchMandatoryHeader(params, mandatoryHeaderChunk, streamAfterMandatoryHeader, headerCrc32, contentCrc32, inflater);
                                        }
                                        if (None$.MODULE$.equals(option)) {
                                            return Pull$.MODULE$.output1(GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.$lessinit$greater$default$2(), GunzipResult$.MODULE$.$lessinit$greater$default$3(), GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                                        }
                                        throw new MatchError((Object)option);
                                    });
                                }
                                throw new MatchError((Object)tuple3);
                            }, (Function2 & Serializable)(x$1, x$2) -> {
                                Tuple3 tuple3;
                                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                                if (tuple2 != null && (tuple3 = (Tuple3)tuple2._1()) != null) {
                                    Inflater inflater = (Inflater)tuple3._1();
                                    return Pull$.MODULE$.eval(this.F$1.delay(() -> CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gunzip$$anonfun$1$$anonfun$3$$anonfun$adapted$1(inflater)));
                                }
                                throw new MatchError((Object)tuple2);
                            }));
                            return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
                        }
                        InflateParams params2 = inflateParams2;
                        return Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(28).append(ZLibParams$Header$GZIP$.MODULE$).append(" header type required, not ").append(params2.header()).append(".").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                    }
                    throw new MatchError((Object)inflateParams);
                };
            }

            private Pull _gunzip_matchMandatoryHeader(InflateParams inflateParams, Chunk mandatoryHeaderChunk, Stream streamAfterMandatoryHeader, CRC32 headerCrc32, CRC32 contentCrc32, Inflater inflater) {
                Chunk.ArraySlice<O2> mandatoryHeaderSlice = mandatoryHeaderChunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
                byte[] mandatoryHeaderBytes = mandatoryHeaderSlice.offset() == 0 ? (byte[])mandatoryHeaderSlice.values() : (byte[])mandatoryHeaderSlice.compact(ClassTag$.MODULE$.apply(Byte.TYPE)).values();
                Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)mandatoryHeaderChunk.size()), (Object)mandatoryHeaderBytes);
                if (tuple2 != null) {
                    Object object;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    int n = BoxesRunTime.unboxToInt((Object)tuple2._1());
                    byte[] byArray = (byte[])tuple2._2();
                    if (this.gzipHeaderBytes == n && byArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object5 = Array$.MODULE$.unapplySeq((Object)byArray), 4) >= 0) {
                        byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object5, 0));
                        byte by2 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object5, 1));
                        byte by3 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object5, 2));
                        byte by4 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object5, 3));
                        if (this.gzipMagicFirstByte == by && this.gzipMagicSecondByte == by2 && this.gzipCompressionMethod().DEFLATE() == by3) {
                            byte flags = by4;
                            Seq seq = Array.UnapplySeqWrapper$.MODULE$.drop$extension(object5, 4);
                            if (this.gzipFlag().reserved5(flags)) {
                                return Pull$.MODULE$.output1(GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 5 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.$lessinit$greater$default$2(), GunzipResult$.MODULE$.$lessinit$greater$default$3(), GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                            }
                        }
                    }
                    if (this.gzipHeaderBytes == n && byArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object4 = Array$.MODULE$.unapplySeq((Object)byArray), 4) >= 0) {
                        byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object4, 0));
                        byte by5 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object4, 1));
                        byte by6 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object4, 2));
                        byte by7 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object4, 3));
                        if (this.gzipMagicFirstByte == by && this.gzipMagicSecondByte == by5 && this.gzipCompressionMethod().DEFLATE() == by6) {
                            byte flags = by7;
                            Seq seq = Array.UnapplySeqWrapper$.MODULE$.drop$extension(object4, 4);
                            if (this.gzipFlag().reserved6(flags)) {
                                return Pull$.MODULE$.output1(GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 6 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.$lessinit$greater$default$2(), GunzipResult$.MODULE$.$lessinit$greater$default$3(), GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                            }
                        }
                    }
                    if (this.gzipHeaderBytes == n && byArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object3 = Array$.MODULE$.unapplySeq((Object)byArray), 4) >= 0) {
                        byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object3, 0));
                        byte by8 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object3, 1));
                        byte by9 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object3, 2));
                        byte by10 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object3, 3));
                        if (this.gzipMagicFirstByte == by && this.gzipMagicSecondByte == by8 && this.gzipCompressionMethod().DEFLATE() == by9) {
                            byte flags = by10;
                            Seq seq = Array.UnapplySeqWrapper$.MODULE$.drop$extension(object3, 4);
                            if (this.gzipFlag().reserved7(flags)) {
                                return Pull$.MODULE$.output1(GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Unsupported gzip flag reserved bit 7 is non-zero"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.$lessinit$greater$default$2(), GunzipResult$.MODULE$.$lessinit$greater$default$3(), GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                            }
                        }
                    }
                    if (this.gzipHeaderBytes == n && byArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object2 = Array$.MODULE$.unapplySeq((Object)byArray), 4) >= 0) {
                        byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 0));
                        byte by11 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 1));
                        byte by12 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 2));
                        byte by13 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object2, 3));
                        if (this.gzipMagicFirstByte == by && this.gzipMagicSecondByte == by11 && this.gzipCompressionMethod().DEFLATE() == by12) {
                            byte flags = by13;
                            Seq seq = Array.UnapplySeqWrapper$.MODULE$.drop$extension(object2, 4);
                            byte[] header = byArray;
                            headerCrc32.update(header);
                            long secondsSince197001010000 = this.unsignedToLong(header[4], header[5], header[6], header[7]);
                            Stream stream = Stream$.MODULE$.InvariantOps(this._gunzip_readOptionalHeader(inflateParams, streamAfterMandatoryHeader, flags, headerCrc32, contentCrc32, secondsSince197001010000, inflater));
                            Stream<F, O> stream2 = new Stream.ToPull<F, O>(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                            return Stream$ToPull$.MODULE$.uncons1$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
                                Tuple2 tuple2;
                                Option option = x$1;
                                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                                    GunzipResult gunzipResult = (GunzipResult)tuple2._1();
                                    return Pull$.MODULE$.output1(gunzipResult);
                                }
                                if (None$.MODULE$.equals(option)) {
                                    return Pull$.MODULE$.output1(GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.$lessinit$greater$default$2(), GunzipResult$.MODULE$.$lessinit$greater$default$3(), GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                                }
                                throw new MatchError((Object)option);
                            });
                        }
                    }
                    if (this.gzipHeaderBytes == n && byArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)byArray), 3) >= 0) {
                        byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0));
                        byte by14 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1));
                        byte by15 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 2));
                        if (this.gzipMagicFirstByte == by && this.gzipMagicSecondByte == by14) {
                            byte compressionMethod = by15;
                            Seq seq = Array.UnapplySeqWrapper$.MODULE$.drop$extension(object, 3);
                            return Pull$.MODULE$.output1(GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(37).append("Unsupported gzip compression method: ").append(compressionMethod).toString()), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.$lessinit$greater$default$2(), GunzipResult$.MODULE$.$lessinit$greater$default$3(), GunzipResult$.MODULE$.$lessinit$greater$default$4()));
                        }
                    }
                }
                return Pull$.MODULE$.output1(GunzipResult$.MODULE$.apply(Stream$.MODULE$.raiseError(new ZipException("Not in gzip format"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1)), GunzipResult$.MODULE$.$lessinit$greater$default$2(), GunzipResult$.MODULE$.$lessinit$greater$default$3(), GunzipResult$.MODULE$.$lessinit$greater$default$4()));
            }

            private Stream _gunzip_readOptionalHeader(InflateParams inflateParams, Stream streamAfterMandatoryHeader, byte flags, CRC32 headerCrc32, CRC32 contentCrc32, long secondsSince197001010000, Inflater inflater) {
                return streamAfterMandatoryHeader.through(this._gunzip_skipOptionalExtraField(this.gzipFlag().fextra(flags), headerCrc32)).through(this._gunzip_readOptionalStringField(this.gzipFlag().fname(flags), headerCrc32, "file name", this.fileNameBytesSoftLimit)).flatMap((Function1 & Serializable)x$12 -> {
                    Tuple2 tuple2 = x$12;
                    if (tuple2 != null) {
                        Option fileName = (Option)tuple2._1();
                        Stream streamAfterFileName = (Stream)tuple2._2();
                        return streamAfterFileName.through(this._gunzip_readOptionalStringField(this.gzipFlag().fcomment(flags), headerCrc32, "file comment", this.fileCommentBytesSoftLimit)).flatMap((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                Option comment = (Option)tuple2._1();
                                Stream streamAfterComment = (Stream)tuple2._2();
                                None$ none$ = secondsSince197001010000 != 0L ? Some$.MODULE$.apply((Object)Instant.ofEpochSecond(secondsSince197001010000)) : None$.MODULE$;
                                Stream<F2, O2> stream = streamAfterComment.through(this._gunzip_validateHeader((byte)(flags & this.gzipFlag().FHCRC()) == this.gzipFlag().FHCRC(), headerCrc32)).through((Function1 & Serializable)s2 -> {
                                    Pull pull = Pull$.MODULE$.StreamPullOps((Pull)this._inflate(inflateParams, inflater, (Option)Some$.MODULE$.apply((Object)contentCrc32)).apply(s2));
                                    return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
                                }).through(this._gunzip_validateTrailer(contentCrc32, inflater));
                                return Stream$.MODULE$.emit(GunzipResult$.MODULE$.apply(stream, (Option<Instant>)none$, (Option<String>)fileName, (Option<String>)comment));
                            }
                            throw new MatchError((Object)tuple2);
                        }, NotGiven$.MODULE$.value());
                    }
                    throw new MatchError((Object)tuple2);
                }, NotGiven$.MODULE$.value());
            }

            private Function1 _gunzip_skipOptionalExtraField(boolean isPresent, CRC32 crc32) {
                return (Function1 & Serializable)stream -> {
                    if (isPresent) {
                        Stream stream2 = Stream$.MODULE$.InvariantOps(stream);
                        Stream<F, O> stream3 = new Stream.ToPull<F, O>(Stream$InvariantOps$.MODULE$.pull$extension(stream2)).fs2$Stream$ToPull$$self();
                        Pull pull = Pull$.MODULE$.StreamPullOps(Stream$ToPull$.MODULE$.unconsN$extension(stream3, this.gzipOptionalExtraFieldLengthBytes, Stream$ToPull$.MODULE$.unconsN$default$2$extension(stream3)).flatMap((Function1 & Serializable)x$12 -> {
                            Tuple2 tuple2;
                            Option option = x$12;
                            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                                Chunk optionalExtraFieldLengthChunk = (Chunk)tuple2._1();
                                Stream streamAfterOptionalExtraFieldLength = (Stream)tuple2._2();
                                Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)optionalExtraFieldLengthChunk.size()), optionalExtraFieldLengthChunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE)).values());
                                if (tuple22 != null) {
                                    Object object;
                                    byte[] byArray = (byte[])tuple22._2();
                                    if (this.gzipOptionalExtraFieldLengthBytes == BoxesRunTime.unboxToInt((Object)tuple22._1()) && byArray != null && Array.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(object = Array$.MODULE$.unapplySeq((Object)byArray), 2) == 0) {
                                        byte by = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 0));
                                        byte by2 = BoxesRunTime.unboxToByte((Object)Array.UnapplySeqWrapper$.MODULE$.apply$extension(object, 1));
                                        byte firstByte = by;
                                        byte secondByte = by2;
                                        byte[] lengthBytes = byArray;
                                        crc32.update(lengthBytes);
                                        int optionalExtraFieldLength = this.unsignedToInt(firstByte, secondByte);
                                        Stream stream = Stream$.MODULE$.InvariantOps(streamAfterOptionalExtraFieldLength);
                                        Stream<F, O> stream2 = new Stream.ToPull<F, O>(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                                        return Stream$ToPull$.MODULE$.unconsN$extension(stream2, optionalExtraFieldLength, Stream$ToPull$.MODULE$.unconsN$default$2$extension(stream2)).flatMap((Function1 & Serializable)x$1 -> {
                                            Tuple2 tuple2;
                                            Option option = x$1;
                                            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                                                Chunk optionalExtraFieldChunk = (Chunk)tuple2._1();
                                                Stream streamAfterOptionalExtraField = (Stream)tuple2._2();
                                                Chunk.ArraySlice<O2> fieldBytes = optionalExtraFieldChunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
                                                crc32.update((byte[])fieldBytes.values(), fieldBytes.offset(), fieldBytes.length());
                                                return Pull$.MODULE$.output1(streamAfterOptionalExtraField);
                                            }
                                            if (None$.MODULE$.equals(option)) {
                                                return Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                                            }
                                            throw new MatchError((Object)option);
                                        });
                                    }
                                }
                                return Pull$.MODULE$.raiseError(new ZipException("Failed to read optional extra field header length"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                            }
                            if (None$.MODULE$.equals(option)) {
                                return Pull$.MODULE$.raiseError(new EOFException(), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                            }
                            throw new MatchError((Object)option);
                        }));
                        return Pull$StreamPullOps$.MODULE$.stream$extension(pull).flatten($less$colon$less$.MODULE$.refl());
                    }
                    return stream;
                };
            }

            private Function1 _gunzip_readOptionalStringField(boolean isPresent, CRC32 crc32, String fieldName, int fieldBytesSoftLimit) {
                return (Function1 & Serializable)stream -> {
                    if (isPresent) {
                        Pull pull = Pull$.MODULE$.StreamPullOps(((Pull)this.unconsUntil((Function1 & Serializable)_$13 -> this._gunzip_readOptionalStringField$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToByte((Object)_$13)), fieldBytesSoftLimit, ClassTag$.MODULE$.apply(Byte.TYPE)).apply(stream)).flatMap((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2;
                            Option option = x$1;
                            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                                Some some;
                                Chunk chunk = (Chunk)tuple2._1();
                                Stream rest = (Stream)tuple2._2();
                                if (chunk.isEmpty()) {
                                    some = Some$.MODULE$.apply((Object)"");
                                } else {
                                    Chunk.ArraySlice<O2> bytesChunk = chunk.toArraySlice(ClassTag$.MODULE$.apply(Byte.TYPE));
                                    crc32.update((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length());
                                    some = Some$.MODULE$.apply((Object)new String((byte[])bytesChunk.values(), bytesChunk.offset(), bytesChunk.length(), StandardCharsets.ISO_8859_1));
                                }
                                return Pull$.MODULE$.output1(Tuple2$.MODULE$.apply((Object)some, rest.dropWhile((Function1 & Serializable)object -> this._gunzip_readOptionalStringField$$anonfun$1$$anonfun$2$$anonfun$1(crc32, BoxesRunTime.unboxToByte((Object)object))).drop(1L)));
                            }
                            if (None$.MODULE$.equals(option)) {
                                return Pull$.MODULE$.output1(Tuple2$.MODULE$.apply((Object)Option$.MODULE$.empty(), Stream$.MODULE$.raiseError(new ZipException(new StringBuilder(21).append("Failed to read ").append(fieldName).append(" field").toString()), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1))));
                            }
                            throw new MatchError((Object)option);
                        }));
                        return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
                    }
                    return Stream$.MODULE$.emit(Tuple2$.MODULE$.apply((Object)Option$.MODULE$.empty(), stream));
                };
            }

            private Function1 _gunzip_validateHeader(boolean isPresent, CRC32 crc32) {
                return (Function1 & Serializable)stream -> {
                    if (isPresent) {
                        Stream stream2 = Stream$.MODULE$.InvariantOps(stream);
                        Stream<F, O> stream3 = new Stream.ToPull<F, O>(Stream$InvariantOps$.MODULE$.pull$extension(stream2)).fs2$Stream$ToPull$$self();
                        Pull pull = Pull$.MODULE$.StreamPullOps(Stream$ToPull$.MODULE$.unconsN$extension(stream3, this.gzipHeaderCrcBytes, Stream$ToPull$.MODULE$.unconsN$default$2$extension(stream3)).flatMap((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2;
                            Option option = x$1;
                            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                                long actualHeaderCrc16;
                                Chunk headerCrcChunk = (Chunk)tuple2._1();
                                Stream streamAfterHeaderCrc = (Stream)tuple2._2();
                                int expectedHeaderCrc16 = this.unsignedToInt(BoxesRunTime.unboxToByte(headerCrcChunk.apply(0)), BoxesRunTime.unboxToByte(headerCrcChunk.apply(1)));
                                if ((long)expectedHeaderCrc16 != (actualHeaderCrc16 = crc32.getValue() & 0xFFFFL)) {
                                    return Pull$.MODULE$.raiseError(new ZipException("Header failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                                }
                                return Pull$.MODULE$.output1(streamAfterHeaderCrc);
                            }
                            if (None$.MODULE$.equals(option)) {
                                return Pull$.MODULE$.raiseError(new ZipException("Failed to read header CRC"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                            }
                            throw new MatchError((Object)option);
                        }));
                        return Pull$StreamPullOps$.MODULE$.stream$extension(pull).flatten($less$colon$less$.MODULE$.refl());
                    }
                    return stream;
                };
            }

            private Function1 _gunzip_validateTrailer(CRC32 crc32, Inflater inflater) {
                return (Function1 & Serializable)stream -> {
                    Pull pull = Pull$.MODULE$.StreamPullOps((Pull)this.streamUntilTrailer$1(inflater, crc32, Chunk$.MODULE$.empty()).apply(stream));
                    return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
                };
            }

            private Function1 unconsUntil(Function1 predicate, int softLimit, ClassTag evidence$1) {
                return arg_0 -> CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$unconsUntil$$anonfun$1(predicate, evidence$1, softLimit, arg_0);
            }

            private final CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$ gzipCompressionMethod() {
                Object object = this.gzipCompressionMethod$lzy1;
                if (object instanceof CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$) {
                    return (CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$)this.gzipCompressionMethod$lzyINIT1();
            }

            private Object gzipCompressionMethod$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.gzipCompressionMethod$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$ compressionCompanionPlatform$$anon$1$gzipCompressionMethod$ = null;
                            try {
                                compressionCompanionPlatform$$anon$1$gzipCompressionMethod$ = new CompressionCompanionPlatform$$anon$1$gzipCompressionMethod$();
                                object2 = compressionCompanionPlatform$$anon$1$gzipCompressionMethod$ == null ? LazyVals.NullValue$.MODULE$ : compressionCompanionPlatform$$anon$1$gzipCompressionMethod$;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.gzipCompressionMethod$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return compressionCompanionPlatform$$anon$1$gzipCompressionMethod$;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            private final CompressionCompanionPlatform$$anon$1$gzipFlag$ gzipFlag() {
                Object object = this.gzipFlag$lzy1;
                if (object instanceof CompressionCompanionPlatform$$anon$1$gzipFlag$) {
                    return (CompressionCompanionPlatform$$anon$1$gzipFlag$)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (CompressionCompanionPlatform$$anon$1$gzipFlag$)this.gzipFlag$lzyINIT1();
            }

            private Object gzipFlag$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.gzipFlag$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            CompressionCompanionPlatform$$anon$1$gzipFlag$ compressionCompanionPlatform$$anon$1$gzipFlag$ = null;
                            try {
                                compressionCompanionPlatform$$anon$1$gzipFlag$ = new CompressionCompanionPlatform$$anon$1$gzipFlag$();
                                object2 = compressionCompanionPlatform$$anon$1$gzipFlag$ == null ? LazyVals.NullValue$.MODULE$ : compressionCompanionPlatform$$anon$1$gzipFlag$;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.gzipFlag$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return compressionCompanionPlatform$$anon$1$gzipFlag$;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            private final CompressionCompanionPlatform$$anon$1$gzipExtraFlag$ gzipExtraFlag() {
                Object object = this.gzipExtraFlag$lzy1;
                if (object instanceof CompressionCompanionPlatform$$anon$1$gzipExtraFlag$) {
                    return (CompressionCompanionPlatform$$anon$1$gzipExtraFlag$)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (CompressionCompanionPlatform$$anon$1$gzipExtraFlag$)this.gzipExtraFlag$lzyINIT1();
            }

            private Object gzipExtraFlag$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.gzipExtraFlag$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            CompressionCompanionPlatform$$anon$1$gzipExtraFlag$ compressionCompanionPlatform$$anon$1$gzipExtraFlag$ = null;
                            try {
                                compressionCompanionPlatform$$anon$1$gzipExtraFlag$ = new CompressionCompanionPlatform$$anon$1$gzipExtraFlag$();
                                object2 = compressionCompanionPlatform$$anon$1$gzipExtraFlag$ == null ? LazyVals.NullValue$.MODULE$ : compressionCompanionPlatform$$anon$1$gzipExtraFlag$;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.gzipExtraFlag$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return compressionCompanionPlatform$$anon$1$gzipExtraFlag$;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            private final CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$ gzipOperatingSystem() {
                Object object = this.gzipOperatingSystem$lzy1;
                if (object instanceof CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$) {
                    return (CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$)object;
                }
                if (object == LazyVals.NullValue$.MODULE$) {
                    return null;
                }
                return (CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$)this.gzipOperatingSystem$lzyINIT1();
            }

            private Object gzipOperatingSystem$lzyINIT1() {
                Object object;
                block8: {
                    while (true) {
                        if ((object = this.gzipOperatingSystem$lzy1) == null) {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                            Object object2 = null;
                            CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$ compressionCompanionPlatform$$anon$1$gzipOperatingSystem$ = null;
                            try {
                                compressionCompanionPlatform$$anon$1$gzipOperatingSystem$ = new CompressionCompanionPlatform$$anon$1$gzipOperatingSystem$();
                                object2 = compressionCompanionPlatform$$anon$1$gzipOperatingSystem$ == null ? LazyVals.NullValue$.MODULE$ : compressionCompanionPlatform$$anon$1$gzipOperatingSystem$;
                            }
                            finally {
                                if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                    LazyVals.Waiting waiting = (LazyVals.Waiting)this.gzipOperatingSystem$lzy1;
                                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                                    waiting.countDown();
                                }
                            }
                            return compressionCompanionPlatform$$anon$1$gzipOperatingSystem$;
                        }
                        if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                        if (object == LazyVals.Evaluating$.MODULE$) {
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                            continue;
                        }
                        if (!(object instanceof LazyVals.Waiting)) break;
                        ((LazyVals.Waiting)object).await();
                    }
                    return null;
                }
                return object;
            }

            private Chunk moveAsChunkBytes(byte[] values) {
                return this.moveAsChunkBytes(values, values.length);
            }

            private Chunk moveAsChunkBytes(byte[] values, int length) {
                if (length > 0) {
                    return Chunk$.MODULE$.array(values, 0, length, ClassTag$.MODULE$.apply(Byte.TYPE));
                }
                return Chunk$.MODULE$.empty();
            }

            private Chunk copyAsChunkBytes(byte[] values, int length) {
                if (length > 0) {
                    byte[] target = new byte[length];
                    System.arraycopy(values, 0, target, 0, length);
                    return Chunk$.MODULE$.array(target, 0, length, ClassTag$.MODULE$.apply(Byte.TYPE));
                }
                return Chunk$.MODULE$.empty();
            }

            private int unsignedToInt(byte lsb, byte msb) {
                return (msb & 0xFF) << 8 | lsb & 0xFF;
            }

            private long unsignedToLong(byte lsb, byte byte2, byte byte3, byte msb) {
                return ((long)msb & 0xFFL) << 24 | (long)((byte3 & 0xFF) << 16) | (long)((byte2 & 0xFF) << 8) | (long)(lsb & 0xFF);
            }

            private final Stream _deflate$$anonfun$1$$anonfun$1(DeflateParams deflateParams$5, Deflater deflater$3, Option crc32$2, Stream in$1) {
                byte[] deflatedBuffer = new byte[deflateParams$5.bufferSizeOrMinimum()];
                Pull pull = Pull$.MODULE$.StreamPullOps((Pull)this._deflate_stream(deflateParams$5, deflater$3, crc32$2, deflatedBuffer).apply((Object)in$1));
                return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
            }

            private final Pull pull$1$$anonfun$1(byte[] deflatedBuffer$6, Deflater deflater$14, DeflateParams deflateParams$12, boolean isFinalChunk$4) {
                return this.pull$1(deflatedBuffer$6, deflater$14, deflateParams$12, isFinalChunk$4);
            }

            private final Pull pull$1(byte[] deflatedBuffer$2, Deflater deflater$6, DeflateParams deflateParams$7, boolean isFinalChunk$3) {
                int deflatedBytes = CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$runDeflate$1(deflater$6, deflatedBuffer$2, deflateParams$7, isFinalChunk$3);
                if (CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$isDone$1(isFinalChunk$3, deflater$6)) {
                    return Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$2, deflatedBytes));
                }
                return Pull$.MODULE$.output(this.copyAsChunkBytes(deflatedBuffer$2, deflatedBytes)).$greater$greater(() -> this.pull$1$$anonfun$1(deflatedBuffer$2, deflater$6, deflateParams$7, isFinalChunk$3));
            }

            private final Pull _deflate_stream$$anonfun$1$$anonfun$1$$anonfun$1(DeflateParams deflateParams$10, Deflater deflater$9, Option crc32$5, byte[] deflatedBuffer$5, Stream inflatedStream$1) {
                return (Pull)this._deflate_stream(deflateParams$10, deflater$9, crc32$5, deflatedBuffer$5).apply((Object)inflatedStream$1);
            }

            private final Pull _inflate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(InflateParams inflateParams$7, Inflater inflater$5, Option crc32$9, byte[] inflatedBuffer$2, Stream deflatedStream$1) {
                return (Pull)this._inflate_stream(inflateParams$7, inflater$5, crc32$9, inflatedBuffer$2).apply((Object)deflatedStream$1);
            }

            private final Pull _inflate$$anonfun$1$$anonfun$1(InflateParams inflateParams$5, Stream in$2, Inflater inflater$3, Option crc32$7) {
                byte[] inflatedBuffer = new byte[inflateParams$5.bufferSizeOrMinimum()];
                Stream stream = Stream$.MODULE$.InvariantOps(in$2);
                Stream<F, O> stream2 = new Stream.ToPull<F, O>(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                return Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2;
                    Option option = x$1;
                    if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                        Chunk deflatedChunk = (Chunk)tuple2._1();
                        Stream deflatedStream = (Stream)tuple2._2();
                        return this._inflate_chunk(inflater$3, crc32$7, deflatedChunk, inflatedBuffer).$greater$greater(() -> this._inflate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(inflateParams$5, inflater$3, crc32$7, inflatedBuffer, deflatedStream));
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Pull$.MODULE$.done();
                    }
                    throw new MatchError((Object)option);
                });
            }

            private final Pull pull$2$$anonfun$2(Inflater inflater$26, Chunk.ArraySlice bytesChunk$4, byte[] inflatedBuffer$9, Option crc32$36) {
                return this.pull$2(inflater$26, bytesChunk$4, inflatedBuffer$9, crc32$36);
            }

            private final Pull pull$2(Inflater inflater$7, Chunk.ArraySlice bytesChunk$2, byte[] inflatedBuffer$5, Option crc32$11) {
                int n = CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$runInflate$1(inflater$7, inflatedBuffer$5, crc32$11);
                int inflatedBytes = n;
                if (inflatedBytes <= -2) {
                    int n2 = inflater$7.getRemaining();
                    int bytesRemaining = n2;
                    if (bytesRemaining > 0) {
                        return Pull$.MODULE$.output(Chunk$.MODULE$.array(bytesChunk$2.values(), bytesChunk$2.offset() + bytesChunk$2.length() - bytesRemaining, bytesRemaining, ClassTag$.MODULE$.apply(Byte.TYPE)));
                    }
                    return Pull$.MODULE$.done();
                }
                int inflatedBytes2 = n;
                if (inflatedBytes2 == -1) {
                    return Pull$.MODULE$.done();
                }
                int inflatedBytes3 = n;
                if (inflatedBytes3 < inflatedBuffer$5.length) {
                    if (inflater$7.finished()) {
                        int n3 = inflater$7.getRemaining();
                        int bytesRemaining = n3;
                        if (bytesRemaining > 0) {
                            return Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes3)).$greater$greater(() -> CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$pull$2$$anonfun$1(bytesChunk$2, bytesRemaining));
                        }
                        return Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes3));
                    }
                    return Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes3));
                }
                int inflatedBytes4 = n;
                return Pull$.MODULE$.output(this.copyAsChunkBytes(inflatedBuffer$5, inflatedBytes4)).$greater$greater(() -> this.pull$2$$anonfun$2(inflater$7, bytesChunk$2, inflatedBuffer$5, crc32$11));
            }

            private final Pull _inflate_stream$$anonfun$1$$anonfun$1$$anonfun$1(InflateParams inflateParams$10, Inflater inflater$10, Option crc32$14, byte[] inflatedBuffer$8, Stream deflatedStream$2) {
                return (Pull)this._inflate_stream(inflateParams$10, inflater$10, crc32$14, inflatedBuffer$8).apply((Object)deflatedStream$2);
            }

            private final Stream gzip$$anonfun$5$$anonfun$3$$anonfun$1(DeflateParams params$3, Deflater deflater$11, CRC32 crc32$15, Stream stream$4) {
                return (Stream)this._deflate(params$3, deflater$11, (Option)Some$.MODULE$.apply((Object)crc32$15)).apply((Object)stream$4);
            }

            private final Stream gzip$$anonfun$5$$anonfun$3$$anonfun$2(Deflater deflater$12, CRC32 crc32$16) {
                return this._gzip_trailer(deflater$12, crc32$16);
            }

            private final byte $anonfun$4() {
                return this.zeroByte;
            }

            private final byte $anonfun$6() {
                return this.zeroByte;
            }

            private final Stream _gzip_header$$anonfun$1$$anonfun$1$$anonfun$1() {
                return Stream$.MODULE$.emit(BoxesRunTime.boxToByte((byte)this.zeroByte));
            }

            private final Stream _gzip_header$$anonfun$1(Option fileNameEncoded$1) {
                return (Stream)fileNameEncoded$1.map((Function1 & Serializable)bytes -> Stream$.MODULE$.chunk(this.moveAsChunkBytes((byte[])bytes)).$plus$plus(this::_gzip_header$$anonfun$1$$anonfun$1$$anonfun$1)).getOrElse(CompressionCompanionPlatform::fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_gzip_header$$anonfun$1$$anonfun$2);
            }

            private final Stream _gzip_header$$anonfun$2$$anonfun$1$$anonfun$1() {
                return Stream$.MODULE$.emit(BoxesRunTime.boxToByte((byte)this.zeroByte));
            }

            private final Stream _gzip_header$$anonfun$2(Option commentEncoded$1) {
                return (Stream)commentEncoded$1.map((Function1 & Serializable)bytes -> Stream$.MODULE$.chunk(this.moveAsChunkBytes((byte[])bytes)).$plus$plus(this::_gzip_header$$anonfun$2$$anonfun$1$$anonfun$1)).getOrElse(CompressionCompanionPlatform::fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_gzip_header$$anonfun$2$$anonfun$2);
            }

            private final Stream _gzip_header$$anonfun$3(byte[] crc16$1) {
                return Stream$.MODULE$.chunk(this.moveAsChunkBytes(crc16$1));
            }

            private final /* synthetic */ boolean _gunzip_readOptionalStringField$$anonfun$1$$anonfun$1(byte _$13) {
                return _$13 == this.zeroByte;
            }

            private final /* synthetic */ boolean _gunzip_readOptionalStringField$$anonfun$1$$anonfun$2$$anonfun$1(CRC32 crc32$24, byte by) {
                crc32$24.update(by);
                return by != this.zeroByte;
            }

            private final Pull validateTrailer$1(CRC32 crc32$28, Inflater inflater$17, Chunk trailerChunk) {
                if (trailerChunk.size() == this.gzipTrailerBytes) {
                    long expectedInputCrc32 = this.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(0)), BoxesRunTime.unboxToByte(trailerChunk.apply(1)), BoxesRunTime.unboxToByte(trailerChunk.apply(2)), BoxesRunTime.unboxToByte(trailerChunk.apply(3)));
                    long actualInputCrc32 = crc32$28.getValue();
                    long expectedInputSize = this.unsignedToLong(BoxesRunTime.unboxToByte(trailerChunk.apply(4)), BoxesRunTime.unboxToByte(trailerChunk.apply(5)), BoxesRunTime.unboxToByte(trailerChunk.apply(6)), BoxesRunTime.unboxToByte(trailerChunk.apply(7)));
                    long actualInputSize = inflater$17.getBytesWritten() & 0xFFFFFFFFL;
                    if (expectedInputCrc32 != actualInputCrc32) {
                        return Pull$.MODULE$.raiseError(new ZipException("Content failed CRC validation"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                    }
                    if (expectedInputSize != actualInputSize) {
                        return Pull$.MODULE$.raiseError(new ZipException("Content failed size validation"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
                    }
                    return Pull$.MODULE$.done();
                }
                return Pull$.MODULE$.raiseError(new ZipException("Failed to read trailer (1)"), RaiseThrowable$.MODULE$.fromApplicativeError(this.F$1));
            }

            private final Pull streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$1(Chunk next$1, Stream rest$1, Inflater inflater$21, CRC32 crc32$32) {
                return (Pull)this.streamUntilTrailer$1(inflater$21, crc32$32, next$1).apply((Object)rest$1);
            }

            private final Pull streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$3(Stream rest$2, Inflater inflater$22, CRC32 crc32$33) {
                return (Pull)this.streamUntilTrailer$1(inflater$22, crc32$33, Chunk$.MODULE$.empty()).apply((Object)rest$2);
            }

            private final Pull streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$4(Stream rest$3, Inflater inflater$23, CRC32 crc32$34) {
                return (Pull)this.streamUntilTrailer$1(inflater$23, crc32$34, Chunk$.MODULE$.empty()).apply((Object)rest$3);
            }

            private final Pull streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$5(Chunk last$3, int preTrailerBytes$1, CRC32 crc32$35, Inflater inflater$24) {
                return this.validateTrailer$1(crc32$35, inflater$24, last$3.drop(preTrailerBytes$1));
            }

            private final Function1 streamUntilTrailer$1(Inflater inflater$18, CRC32 crc32$29, Chunk last) {
                return (Function1 & Serializable)_$14 -> {
                    Stream stream = Stream$.MODULE$.InvariantOps(_$14);
                    Stream<F, O> stream2 = new Stream.ToPull<F, O>(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                    return Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2;
                        Option option = x$1;
                        if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                            Chunk next = (Chunk)tuple2._1();
                            Stream rest = (Stream)tuple2._2();
                            if (inflater$18.finished()) {
                                if (next.size() >= this.gzipTrailerBytes) {
                                    if (last.nonEmpty()) {
                                        return Pull$.MODULE$.output(last).$greater$greater(() -> this.streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$1(next, rest, inflater$18, crc32$29));
                                    }
                                    return (Pull)this.streamUntilTrailer$1(inflater$18, crc32$29, next).apply((Object)rest);
                                }
                                return (Pull)this.streamUntilTrailer$1(inflater$18, crc32$29, last.$plus$plus(next)).apply((Object)rest);
                            }
                            if (last.nonEmpty()) {
                                return Pull$.MODULE$.output(last).$greater$greater(() -> CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$2(next)).$greater$greater(() -> this.streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$3(rest, inflater$18, crc32$29));
                            }
                            return Pull$.MODULE$.output(next).$greater$greater(() -> this.streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$4(rest, inflater$18, crc32$29));
                        }
                        if (None$.MODULE$.equals(option)) {
                            int preTrailerBytes = last.size() - this.gzipTrailerBytes;
                            if (preTrailerBytes > 0) {
                                return Pull$.MODULE$.output(last.take(preTrailerBytes)).$greater$greater(() -> this.streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$5(last, preTrailerBytes, crc32$29, inflater$18));
                            }
                            return this.validateTrailer$1(crc32$29, inflater$18, last);
                        }
                        throw new MatchError((Object)option);
                    });
                };
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{deflate$$anonfun$1(fs2.compression.DeflateParams fs2.Stream ), _deflate$$anonfun$1(fs2.compression.DeflateParams java.util.zip.Deflater scala.Option fs2.Stream ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_deflate_chunk$$anonfun$1(fs2.Chunk$ArraySlice java.util.zip.CRC32 ), _deflate_stream$$anonfun$1(fs2.compression.DeflateParams java.util.zip.Deflater scala.Option byte[] fs2.Stream ), inflate$$anonfun$1(fs2.compression.InflateParams fs2.Stream ), _inflate$$anonfun$1(fs2.compression.InflateParams java.util.zip.Inflater scala.Option fs2.Stream ), _inflate_stream$$anonfun$1(java.util.zip.Inflater scala.Option byte[] fs2.compression.InflateParams fs2.Stream ), gzip$$anonfun$5(fs2.compression.DeflateParams scala.Option scala.Option scala.Option fs2.Stream ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_$$anonfun$1(java.time.Instant ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_$$anonfun$2(), $anonfun$3(java.lang.String ), $anonfun$4(), $anonfun$5(java.lang.String ), $anonfun$6(), $anonfun$7(java.util.zip.CRC32 java.lang.String ), $anonfun$8(java.util.zip.CRC32 java.lang.String ), _gzip_header$$anonfun$1(scala.Option ), _gzip_header$$anonfun$2(scala.Option ), _gzip_header$$anonfun$3(byte[] ), gunzip$$anonfun$1(fs2.compression.InflateParams fs2.Stream ), _gunzip_matchMandatoryHeader$$anonfun$1(scala.Option ), _gunzip_readOptionalHeader$$anonfun$1(byte java.util.zip.CRC32 long fs2.compression.InflateParams java.util.zip.Inflater java.util.zip.CRC32 scala.Tuple2 ), _gunzip_skipOptionalExtraField$$anonfun$1(boolean java.util.zip.CRC32 fs2.Stream ), _gunzip_readOptionalStringField$$anonfun$1(boolean int java.util.zip.CRC32 java.lang.String fs2.Stream ), _gunzip_validateHeader$$anonfun$1(boolean java.util.zip.CRC32 fs2.Stream ), _gunzip_validateTrailer$$anonfun$1(java.util.zip.CRC32 java.util.zip.Inflater fs2.Stream ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$unconsUntil$$anonfun$1(scala.Function1 scala.reflect.ClassTag int fs2.Stream ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$deflate$$anonfun$1$$anonfun$2$$anonfun$adapted$1(java.util.zip.Deflater ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$deflate$$anonfun$1$$anonfun$1(fs2.compression.DeflateParams ), deflate$$anonfun$1$$anonfun$2(java.util.zip.Deflater ), deflate$$anonfun$1$$anonfun$3(fs2.compression.DeflateParams fs2.Stream java.util.zip.Deflater ), _deflate$$anonfun$1$$anonfun$1(fs2.compression.DeflateParams java.util.zip.Deflater scala.Option fs2.Stream ), pull$1$$anonfun$1(byte[] java.util.zip.Deflater fs2.compression.DeflateParams boolean ), _deflate_stream$$anonfun$1$$anonfun$1$$anonfun$1(fs2.compression.DeflateParams java.util.zip.Deflater scala.Option byte[] fs2.Stream ), _deflate_stream$$anonfun$1$$anonfun$1(fs2.compression.DeflateParams java.util.zip.Deflater scala.Option byte[] scala.Option ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$inflate$$anonfun$1$$anonfun$3$$anonfun$adapted$1(java.util.zip.Inflater ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$inflate$$anonfun$1$$anonfun$1(fs2.compression.InflateParams ), inflate$$anonfun$1$$anonfun$2(fs2.compression.InflateParams fs2.Stream java.util.zip.Inflater ), inflate$$anonfun$1$$anonfun$3(java.util.zip.Inflater cats.effect.kernel.Resource$ExitCase ), _inflate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(fs2.compression.InflateParams java.util.zip.Inflater scala.Option byte[] fs2.Stream ), _inflate$$anonfun$1$$anonfun$1$$anonfun$1(java.util.zip.Inflater scala.Option byte[] fs2.compression.InflateParams scala.Option ), _inflate$$anonfun$1$$anonfun$1(fs2.compression.InflateParams fs2.Stream java.util.zip.Inflater scala.Option ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$pull$2$$anonfun$1(fs2.Chunk$ArraySlice int ), pull$2$$anonfun$2(java.util.zip.Inflater fs2.Chunk$ArraySlice byte[] scala.Option ), _inflate_stream$$anonfun$1$$anonfun$1$$anonfun$1(fs2.compression.InflateParams java.util.zip.Inflater scala.Option byte[] fs2.Stream ), _inflate_stream$$anonfun$1$$anonfun$1(java.util.zip.Inflater scala.Option byte[] fs2.compression.InflateParams scala.Option ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gzip$$anonfun$5$$anonfun$2$$anonfun$adapted$1(java.util.zip.Deflater ), gzip$$anonfun$5$$anonfun$3$$anonfun$1(fs2.compression.DeflateParams java.util.zip.Deflater java.util.zip.CRC32 fs2.Stream ), gzip$$anonfun$5$$anonfun$3$$anonfun$2(java.util.zip.Deflater java.util.zip.CRC32 ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gzip$$anonfun$5$$anonfun$1(fs2.compression.DeflateParams ), gzip$$anonfun$5$$anonfun$2(scala.Tuple2 ), gzip$$anonfun$5$$anonfun$3(scala.Option scala.Option scala.Option fs2.compression.DeflateParams fs2.Stream scala.Tuple2 ), _gzip_header$$anonfun$1$$anonfun$1$$anonfun$1(), _gzip_header$$anonfun$1$$anonfun$1(byte[] ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_gzip_header$$anonfun$1$$anonfun$2(), _gzip_header$$anonfun$2$$anonfun$1$$anonfun$1(), _gzip_header$$anonfun$2$$anonfun$1(byte[] ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_gzip_header$$anonfun$2$$anonfun$2(), gunzip$$anonfun$1$$anonfun$2$$anonfun$1(fs2.compression.InflateParams java.util.zip.CRC32 java.util.zip.CRC32 java.util.zip.Inflater scala.Option ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gunzip$$anonfun$1$$anonfun$3$$anonfun$adapted$1(java.util.zip.Inflater ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gunzip$$anonfun$1$$anonfun$1(), gunzip$$anonfun$1$$anonfun$2(fs2.Stream fs2.compression.InflateParams scala.Tuple3 ), gunzip$$anonfun$1$$anonfun$3(scala.Tuple3 cats.effect.kernel.Resource$ExitCase ), $anonfun$9(fs2.compression.InflateParams java.util.zip.Inflater java.util.zip.CRC32 fs2.Stream ), _gunzip_readOptionalHeader$$anonfun$1$$anonfun$1(long byte java.util.zip.CRC32 fs2.compression.InflateParams java.util.zip.Inflater java.util.zip.CRC32 scala.Option scala.Tuple2 ), _gunzip_skipOptionalExtraField$$anonfun$1$$anonfun$1$$anonfun$1(java.util.zip.CRC32 scala.Option ), _gunzip_skipOptionalExtraField$$anonfun$1$$anonfun$1(java.util.zip.CRC32 scala.Option ), _gunzip_readOptionalStringField$$anonfun$1$$anonfun$2$$anonfun$adapted$1(java.util.zip.CRC32 java.lang.Object ), $anonfun$adapted$1(java.lang.Object ), _gunzip_readOptionalStringField$$anonfun$1$$anonfun$2(java.util.zip.CRC32 java.lang.String scala.Option ), _gunzip_validateHeader$$anonfun$1$$anonfun$1(java.util.zip.CRC32 scala.Option ), streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$1(fs2.Chunk fs2.Stream java.util.zip.Inflater java.util.zip.CRC32 ), fs2$compression$CompressionCompanionPlatform$$anon$1$$_$streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$2(fs2.Chunk ), streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$3(fs2.Stream java.util.zip.Inflater java.util.zip.CRC32 ), streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$4(fs2.Stream java.util.zip.Inflater java.util.zip.CRC32 ), streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$5(fs2.Chunk int java.util.zip.CRC32 java.util.zip.Inflater ), streamUntilTrailer$1$$anonfun$1$$anonfun$1(java.util.zip.Inflater fs2.Chunk java.util.zip.CRC32 scala.Option ), streamUntilTrailer$1$$anonfun$1(java.util.zip.Inflater fs2.Chunk java.util.zip.CRC32 fs2.Stream )}, serializedLambda);
            }
        };
    }

    public static Deflater fs2$compression$CompressionCompanionPlatform$$anon$1$$_$deflate$$anonfun$1$$anonfun$1(DeflateParams deflateParams$2) {
        Deflater deflater = new Deflater(deflateParams$2.level().juzDeflaterLevel(), deflateParams$2.header().juzDeflaterNoWrap());
        deflater.setStrategy(deflateParams$2.strategy().juzDeflaterStrategy());
        return deflater;
    }

    private static void deflate$$anonfun$1$$anonfun$2$$anonfun$1(Deflater deflater$1) {
        deflater$1.end();
    }

    public static /* bridge */ /* synthetic */ Object fs2$compression$CompressionCompanionPlatform$$anon$1$$_$deflate$$anonfun$1$$anonfun$2$$anonfun$adapted$1(Deflater deflater$13) {
        CompressionCompanionPlatform.deflate$$anonfun$1$$anonfun$2$$anonfun$1(deflater$13);
        return BoxedUnit.UNIT;
    }

    public static /* synthetic */ void fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_deflate_chunk$$anonfun$1(Chunk.ArraySlice bytesChunk$1, CRC32 _$5) {
        _$5.update((byte[])bytesChunk$1.values(), bytesChunk$1.offset(), bytesChunk$1.length());
    }

    public static boolean fs2$compression$CompressionCompanionPlatform$$anon$1$$_$isDone$1(boolean isFinalChunk$1, Deflater deflater$4) {
        return isFinalChunk$1 && deflater$4.finished() || !isFinalChunk$1 && deflater$4.needsInput();
    }

    public static int fs2$compression$CompressionCompanionPlatform$$anon$1$$_$runDeflate$1(Deflater deflater$5, byte[] deflatedBuffer$1, DeflateParams deflateParams$6, boolean isFinalChunk$2) {
        if (CompressionCompanionPlatform.fs2$compression$CompressionCompanionPlatform$$anon$1$$_$isDone$1(isFinalChunk$2, deflater$5)) {
            return 0;
        }
        return deflater$5.deflate(deflatedBuffer$1, 0, deflateParams$6.bufferSizeOrMinimum(), deflateParams$6.flushMode().juzDeflaterFlushMode());
    }

    public static Inflater fs2$compression$CompressionCompanionPlatform$$anon$1$$_$inflate$$anonfun$1$$anonfun$1(InflateParams inflateParams$2) {
        return new Inflater(inflateParams$2.header().juzDeflaterNoWrap());
    }

    private static void inflate$$anonfun$1$$anonfun$3$$anonfun$1(Inflater inflater$1) {
        inflater$1.end();
    }

    public static /* bridge */ /* synthetic */ Object fs2$compression$CompressionCompanionPlatform$$anon$1$$_$inflate$$anonfun$1$$anonfun$3$$anonfun$adapted$1(Inflater inflater$25) {
        CompressionCompanionPlatform.inflate$$anonfun$1$$anonfun$3$$anonfun$1(inflater$25);
        return BoxedUnit.UNIT;
    }

    public static int fs2$compression$CompressionCompanionPlatform$$anon$1$$_$runInflate$1(Inflater inflater$6, byte[] inflatedBuffer$3, Option crc32$10) {
        if (inflater$6.finished()) {
            return -2;
        }
        if (inflater$6.needsInput()) {
            return -1;
        }
        int byteCount = inflater$6.inflate(inflatedBuffer$3);
        crc32$10.foreach((Function1)(JProcedure1 & Serializable)_$8 -> _$8.update(inflatedBuffer$3, 0, byteCount));
        return byteCount;
    }

    public static Pull fs2$compression$CompressionCompanionPlatform$$anon$1$$_$pull$2$$anonfun$1(Chunk.ArraySlice bytesChunk$3, int bytesRemaining$1) {
        return Pull$.MODULE$.output(Chunk$.MODULE$.array(bytesChunk$3.values(), bytesChunk$3.offset() + bytesChunk$3.length() - bytesRemaining$1, bytesRemaining$1, ClassTag$.MODULE$.apply(Byte.TYPE)));
    }

    public static Tuple2 fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gzip$$anonfun$5$$anonfun$1(DeflateParams params$1) {
        Deflater deflater = new Deflater(params$1.level().juzDeflaterLevel(), true);
        deflater.setStrategy(params$1.strategy().juzDeflaterStrategy());
        return Tuple2$.MODULE$.apply((Object)deflater, (Object)new CRC32());
    }

    private static void gzip$$anonfun$5$$anonfun$2$$anonfun$1(Deflater deflater$10) {
        deflater$10.end();
    }

    public static /* bridge */ /* synthetic */ Object fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gzip$$anonfun$5$$anonfun$2$$anonfun$adapted$1(Deflater deflater$15) {
        CompressionCompanionPlatform.gzip$$anonfun$5$$anonfun$2$$anonfun$1(deflater$15);
        return BoxedUnit.UNIT;
    }

    public static /* synthetic */ long fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_$$anonfun$1(Instant _$10) {
        return _$10.getEpochSecond();
    }

    public static long fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_$$anonfun$2() {
        return 0L;
    }

    public static Stream fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_gzip_header$$anonfun$1$$anonfun$2() {
        return Stream$.MODULE$.empty();
    }

    public static Stream fs2$compression$CompressionCompanionPlatform$$anon$1$$_$_gzip_header$$anonfun$2$$anonfun$2() {
        return Stream$.MODULE$.empty();
    }

    public static Tuple3 fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gunzip$$anonfun$1$$anonfun$1() {
        return Tuple3$.MODULE$.apply((Object)new Inflater(true), (Object)new CRC32(), (Object)new CRC32());
    }

    private static void gunzip$$anonfun$1$$anonfun$3$$anonfun$1(Inflater inflater$12) {
        inflater$12.end();
    }

    public static /* bridge */ /* synthetic */ Object fs2$compression$CompressionCompanionPlatform$$anon$1$$_$gunzip$$anonfun$1$$anonfun$3$$anonfun$adapted$1(Inflater inflater$27) {
        CompressionCompanionPlatform.gunzip$$anonfun$1$$anonfun$3$$anonfun$1(inflater$27);
        return BoxedUnit.UNIT;
    }

    public static Pull fs2$compression$CompressionCompanionPlatform$$anon$1$$_$streamUntilTrailer$1$$anonfun$1$$anonfun$1$$anonfun$2(Chunk next$2) {
        return Pull$.MODULE$.output(next$2);
    }

    private static Pull go$1(Function1 predicate$2, ClassTag evidence$1$2, int softLimit$2, List acc, Stream rest, int size) {
        Stream stream = Stream$.MODULE$.InvariantOps(rest);
        Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
        return Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.pure(None$.MODULE$);
            }
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                Chunk hd = (Chunk)tuple2._1();
                Stream tl = (Stream)tuple2._2();
                Option<Object> option2 = hd.indexWhere(predicate$2);
                if (option2 instanceof Some) {
                    int i = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    Tuple2 tuple22 = hd.splitAt(i);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    Chunk pfx = (Chunk)tuple22._1();
                    Chunk sfx = (Chunk)tuple22._2();
                    Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)pfx, (Object)sfx);
                    Chunk pfx2 = (Chunk)tuple23._1();
                    Chunk sfx2 = (Chunk)tuple23._2();
                    Chunk chunk = (Chunk)Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc.$colon$colon((Object)pfx2).reverse(), evidence$1$2));
                    return Pull$.MODULE$.pure(Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)chunk, tl.cons(sfx2))));
                }
                if (None$.MODULE$.equals(option2)) {
                    int newSize = size + hd.size();
                    if (newSize < softLimit$2) {
                        return CompressionCompanionPlatform.go$1(predicate$2, evidence$1$2, softLimit$2, acc.$colon$colon((Object)hd), tl, newSize);
                    }
                    Chunk chunk = (Chunk)Predef$.MODULE$.ArrowAssoc(Chunk$.MODULE$.concat(acc.$colon$colon((Object)hd).reverse(), evidence$1$2));
                    return Pull$.MODULE$.pure(Some$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)chunk, (Object)tl)));
                }
                throw new MatchError(option2);
            }
            throw new MatchError((Object)option);
        });
    }

    private static int go$default$3$1() {
        return 0;
    }

    public static /* synthetic */ Pull fs2$compression$CompressionCompanionPlatform$$anon$1$$_$unconsUntil$$anonfun$1(Function1 predicate$1, ClassTag evidence$1$1, int softLimit$1, Stream stream) {
        return CompressionCompanionPlatform.go$1(predicate$1, evidence$1$1, softLimit$1, (List)package$.MODULE$.Nil(), stream, CompressionCompanionPlatform.go$default$3$1());
    }
}

