/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.file;

import cats.effect.IO;
import cats.effect.LiftIO;
import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.effect.std.Hotswap;
import cats.effect.std.Hotswap$;
import cats.kernel.Eq$;
import cats.kernel.Order;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplicativeIdOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Pull;
import fs2.Pull$;
import fs2.Pull$StreamPullOps$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.io.file.CopyFlags;
import fs2.io.file.CopyFlags$;
import fs2.io.file.FileHandle;
import fs2.io.file.Files$;
import fs2.io.file.FilesPlatform;
import fs2.io.file.Flag$;
import fs2.io.file.Flags;
import fs2.io.file.Flags$;
import fs2.io.file.Path;
import fs2.io.file.PathInfo;
import fs2.io.file.Permissions;
import fs2.io.file.PosixPermissions;
import fs2.io.file.ReadCursor;
import fs2.io.file.ReadCursor$;
import fs2.io.file.WalkOptions;
import fs2.io.file.WalkOptions$;
import fs2.io.file.WriteCursor;
import fs2.io.file.WriteCursor$;
import fs2.text$;
import fs2.text$utf8$;
import java.io.Serializable;
import java.nio.file.NoSuchFileException;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.NotGiven$;

public interface Files<F>
extends FilesPlatform<F> {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Files$.class.getDeclaredField("fs2$io$file$FilesCompanionPlatform$$NioFileKey$lzy1"));

    public static <F> Files<F> apply(Files<F> files) {
        return Files$.MODULE$.apply(files);
    }

    public static <F> Files<F> forAsync(Async<F> async) {
        return Files$.MODULE$.forAsync((Async)async);
    }

    public static Files<IO> forIO() {
        return Files$.MODULE$.forIO();
    }

    public static <F> Files<F> forLiftIO(Async<F> async, LiftIO<F> liftIO) {
        return Files$.MODULE$.forLiftIO(async, liftIO);
    }

    public static <F> Files<F> implicitForAsync(Async<F> async) {
        return Files$.MODULE$.implicitForAsync((Async)async);
    }

    public static Object copy$(Files $this, Path source, Path target) {
        return $this.copy(source, target);
    }

    default public F copy(Path source, Path target) {
        return this.copy(source, target, CopyFlags$.MODULE$.empty());
    }

    public F copy(Path var1, Path var2, CopyFlags var3);

    public static Object createDirectory$(Files $this, Path path) {
        return $this.createDirectory(path);
    }

    default public F createDirectory(Path path) {
        return this.createDirectory(path, (Option<Permissions>)None$.MODULE$);
    }

    public F createDirectory(Path var1, Option<Permissions> var2);

    public static Object createDirectories$(Files $this, Path path) {
        return $this.createDirectories(path);
    }

    default public F createDirectories(Path path) {
        return this.createDirectories(path, (Option<Permissions>)None$.MODULE$);
    }

    public F createDirectories(Path var1, Option<Permissions> var2);

    public static Object createFile$(Files $this, Path path) {
        return $this.createFile(path);
    }

    default public F createFile(Path path) {
        return this.createFile(path, (Option<Permissions>)None$.MODULE$);
    }

    public F createFile(Path var1, Option<Permissions> var2);

    public F createLink(Path var1, Path var2);

    public static Object createSymbolicLink$(Files $this, Path link, Path target) {
        return $this.createSymbolicLink(link, target);
    }

    default public F createSymbolicLink(Path link, Path target) {
        return this.createSymbolicLink(link, target, (Option<Permissions>)None$.MODULE$);
    }

    public F createSymbolicLink(Path var1, Path var2, Option<Permissions> var3);

    public static Object createTempFile$(Files $this) {
        return $this.createTempFile();
    }

    default public F createTempFile() {
        return this.createTempFile((Option<Path>)None$.MODULE$, "", ".tmp", (Option<Permissions>)None$.MODULE$);
    }

    public F createTempFile(Option<Path> var1, String var2, String var3, Option<Permissions> var4);

    public static Object createTempDirectory$(Files $this) {
        return $this.createTempDirectory();
    }

    default public F createTempDirectory() {
        return this.createTempDirectory((Option<Path>)None$.MODULE$, "", (Option<Permissions>)None$.MODULE$);
    }

    public F createTempDirectory(Option<Path> var1, String var2, Option<Permissions> var3);

    public F currentWorkingDirectory();

    public F delete(Path var1);

    public F deleteIfExists(Path var1);

    public static Object deleteRecursively$(Files $this, Path path) {
        return $this.deleteRecursively(path);
    }

    default public F deleteRecursively(Path path) {
        return this.deleteRecursively(path, false);
    }

    public F deleteRecursively(Path var1, boolean var2);

    public static Object exists$(Files $this, Path path) {
        return $this.exists(path);
    }

    default public F exists(Path path) {
        return this.exists(path, true);
    }

    public F exists(Path var1, boolean var2);

    public static Object getBasicFileAttributes$(Files $this, Path path) {
        return $this.getBasicFileAttributes(path);
    }

    default public F getBasicFileAttributes(Path path) {
        return this.getBasicFileAttributes(path, false);
    }

    public F getBasicFileAttributes(Path var1, boolean var2);

    public static Object getLastModifiedTime$(Files $this, Path path) {
        return $this.getLastModifiedTime(path);
    }

    default public F getLastModifiedTime(Path path) {
        return this.getLastModifiedTime(path, true);
    }

    public F getLastModifiedTime(Path var1, boolean var2);

    public static Object getPosixFileAttributes$(Files $this, Path path) {
        return $this.getPosixFileAttributes(path);
    }

    default public F getPosixFileAttributes(Path path) {
        return this.getPosixFileAttributes(path, false);
    }

    public F getPosixFileAttributes(Path var1, boolean var2);

    public static Object getPosixPermissions$(Files $this, Path path) {
        return $this.getPosixPermissions(path);
    }

    default public F getPosixPermissions(Path path) {
        return this.getPosixPermissions(path, true);
    }

    public F getPosixPermissions(Path var1, boolean var2);

    public static Object isDirectory$(Files $this, Path path) {
        return $this.isDirectory(path);
    }

    default public F isDirectory(Path path) {
        return this.isDirectory(path, true);
    }

    public F isDirectory(Path var1, boolean var2);

    public F isExecutable(Path var1);

    public F isHidden(Path var1);

    public F isReadable(Path var1);

    public static Object isRegularFile$(Files $this, Path path) {
        return $this.isRegularFile(path);
    }

    default public F isRegularFile(Path path) {
        return this.isRegularFile(path, true);
    }

    public F isRegularFile(Path var1, boolean var2);

    public F isSymbolicLink(Path var1);

    public F isWritable(Path var1);

    public F isSameFile(Path var1, Path var2);

    public String lineSeparator();

    public Stream<F, Path> list(Path var1);

    public static Object move$(Files $this, Path source, Path target) {
        return $this.move(source, target);
    }

    default public F move(Path source, Path target) {
        return this.move(source, target, CopyFlags$.MODULE$.empty());
    }

    public F move(Path var1, Path var2, CopyFlags var3);

    public Resource<F, FileHandle<F>> open(Path var1, Flags var2);

    public static Stream readAll$(Files $this, Path path) {
        return $this.readAll(path);
    }

    default public Stream<F, Object> readAll(Path path) {
        return this.readAll(path, 65536, Flags$.MODULE$.Read());
    }

    public Stream<F, Object> readAll(Path var1, int var2, Flags var3);

    public static Resource readCursor$(Files $this, Path path, Flags flags) {
        return $this.readCursor(path, flags);
    }

    default public Resource<F, ReadCursor<F>> readCursor(Path path, Flags flags) {
        return this.open(path, flags.addIfAbsent(Flag$.MODULE$.Read())).map((Function1 & Serializable)fileHandle -> ReadCursor$.MODULE$.apply(fileHandle, 0L));
    }

    public Stream<F, Object> readRange(Path var1, int var2, long var3, long var5);

    public static Stream readUtf8$(Files $this, Path path) {
        return $this.readUtf8(path);
    }

    default public Stream<F, String> readUtf8(Path path) {
        return this.readAll(path).through(text$utf8$.MODULE$.decode());
    }

    public static Stream readUtf8Lines$(Files $this, Path path) {
        return $this.readUtf8Lines(path);
    }

    default public Stream<F, String> readUtf8Lines(Path path) {
        return this.readUtf8(path).through(text$.MODULE$.lines());
    }

    public F realPath(Path var1);

    public F setFileTimes(Path var1, Option<FiniteDuration> var2, Option<FiniteDuration> var3, Option<FiniteDuration> var4, boolean var5);

    public F setPosixPermissions(Path var1, PosixPermissions var2);

    public F size(Path var1);

    public Stream<F, Object> tail(Path var1, int var2, long var3, FiniteDuration var5);

    public static int tail$default$2$(Files $this) {
        return $this.tail$default$2();
    }

    default public int tail$default$2() {
        return 65536;
    }

    public static long tail$default$3$(Files $this) {
        return $this.tail$default$3();
    }

    default public long tail$default$3() {
        return 0L;
    }

    public static FiniteDuration tail$default$4$(Files $this) {
        return $this.tail$default$4();
    }

    default public FiniteDuration tail$default$4() {
        return new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1)).second();
    }

    public static Resource tempFile$(Files $this) {
        return $this.tempFile();
    }

    default public Resource<F, Path> tempFile() {
        return this.tempFile((Option<Path>)None$.MODULE$, "", ".tmp", (Option<Permissions>)None$.MODULE$);
    }

    public Resource<F, Path> tempFile(Option<Path> var1, String var2, String var3, Option<Permissions> var4);

    public static Resource tempDirectory$(Files $this) {
        return $this.tempDirectory();
    }

    default public Resource<F, Path> tempDirectory() {
        return this.tempDirectory((Option<Path>)None$.MODULE$, "", (Option<Permissions>)None$.MODULE$);
    }

    public Resource<F, Path> tempDirectory(Option<Path> var1, String var2, Option<Permissions> var3);

    public F userHome();

    public static Stream walk$(Files $this, Path start) {
        return $this.walk(start);
    }

    default public Stream<F, Path> walk(Path start) {
        return this.walk(start, WalkOptions$.MODULE$.Default());
    }

    public static Stream walk$(Files $this, Path start, WalkOptions options) {
        return $this.walk(start, options);
    }

    default public Stream<F, Path> walk(Path start, WalkOptions options) {
        return this.walkWithAttributes(start, options).map((Function1 & Serializable)_$2 -> _$2.path());
    }

    public static Stream walk$(Files $this, Path start, int maxDepth, boolean followLinks) {
        return $this.walk(start, maxDepth, followLinks);
    }

    default public Stream<F, Path> walk(Path start, int maxDepth, boolean followLinks) {
        return this.walk(start, WalkOptions$.MODULE$.Default().withMaxDepth(maxDepth).withFollowLinks(followLinks));
    }

    public static Stream walkWithAttributes$(Files $this, Path start) {
        return $this.walkWithAttributes(start);
    }

    default public Stream<F, PathInfo> walkWithAttributes(Path start) {
        return this.walkWithAttributes(start, WalkOptions$.MODULE$.Default());
    }

    public Stream<F, PathInfo> walkWithAttributes(Path var1, WalkOptions var2);

    public static Function1 writeAll$(Files $this, Path path) {
        return $this.writeAll(path);
    }

    default public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeAll(Path path) {
        return this.writeAll(path, Flags$.MODULE$.Write());
    }

    public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeAll(Path var1, Flags var2);

    public Resource<F, WriteCursor<F>> writeCursor(Path var1, Flags var2);

    public F writeCursorFromFileHandle(FileHandle<F> var1, boolean var2);

    public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeRotate(F var1, long var2, Flags var4);

    public static Function1 writeUtf8$(Files $this, Path path) {
        return $this.writeUtf8(path);
    }

    default public Function1<Stream<F, String>, Stream<F, Nothing$>> writeUtf8(Path path) {
        return this.writeUtf8(path, Flags$.MODULE$.Write());
    }

    public static Function1 writeUtf8$(Files $this, Path path, Flags flags) {
        return $this.writeUtf8(path, flags);
    }

    default public Function1<Stream<F, String>, Stream<F, Nothing$>> writeUtf8(Path path, Flags flags) {
        return (Function1 & Serializable)in -> in.through(text$utf8$.MODULE$.encode()).through(this.writeAll(path, flags));
    }

    public static Function1 writeUtf8Lines$(Files $this, Path path) {
        return $this.writeUtf8Lines(path);
    }

    default public Function1<Stream<F, String>, Stream<F, Nothing$>> writeUtf8Lines(Path path) {
        return this.writeUtf8Lines(path, Flags$.MODULE$.Write());
    }

    public static Function1 writeUtf8Lines$(Files $this, Path path, Flags flags) {
        return $this.writeUtf8Lines(path, flags);
    }

    default public Function1<Stream<F, String>, Stream<F, Nothing$>> writeUtf8Lines(Path path, Flags flags) {
        return (Function1 & Serializable)in -> {
            Stream stream = Stream$.MODULE$.InvariantOps(in);
            Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            Pull pull = Pull$.MODULE$.StreamPullOps(Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    return in.intersperse(this.lineSeparator()).append(this::writeUtf8Lines$$anonfun$1$$anonfun$1$$anonfun$1).underlying();
                }
                if (None$.MODULE$.equals(option)) {
                    return Pull$.MODULE$.done();
                }
                throw new MatchError((Object)option);
            }));
            return Pull$StreamPullOps$.MODULE$.stream$extension(pull).through(this.writeUtf8(path, flags));
        };
    }

    private Stream writeUtf8Lines$$anonfun$1$$anonfun$1$$anonfun$1() {
        return Stream$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.lineSeparator()}));
    }

    public static abstract class UnsealedFiles<F>
    implements Files<F> {
        private final Async<F> F;

        public UnsealedFiles(Async<F> F) {
            this.F = F;
        }

        @Override
        public Stream<F, Object> readAll(Path path, int chunkSize, Flags flags) {
            return Stream$.MODULE$.resource(this.readCursor(path, flags), this.F).flatMap((Function1 & Serializable)cursor -> {
                Pull pull = Pull$.MODULE$.StreamPullOps(cursor.readAll(chunkSize).void());
                return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public Stream<F, Object> readRange(Path path, int chunkSize, long start, long end) {
            return Stream$.MODULE$.resource(this.readCursor(path, Flags$.MODULE$.Read()), this.F).flatMap((Function1 & Serializable)cursor -> {
                Pull pull = Pull$.MODULE$.StreamPullOps(cursor.seek(start).readUntil(chunkSize, end).void());
                return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public Stream<F, Object> tail(Path path, int chunkSize, long offset, FiniteDuration pollDelay) {
            return Stream$.MODULE$.resource(this.readCursor(path, Flags$.MODULE$.Read()), this.F).flatMap((Function1 & Serializable)cursor -> {
                Pull pull = Pull$.MODULE$.StreamPullOps(cursor.seek(offset).tail(chunkSize, pollDelay, this.F).void());
                return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public Resource<F, Path> tempFile(Option<Path> dir, String prefix, String suffix, Option<Permissions> permissions) {
            return package$.MODULE$.Resource().make(this.createTempFile(dir, prefix, suffix, permissions), (Function1 & Serializable)_$6 -> package.all$.MODULE$.toFunctorOps(this.deleteIfExists((Path)_$6), this.F).void(), this.F);
        }

        @Override
        public Resource<F, Path> tempDirectory(Option<Path> dir, String prefix, Option<Permissions> permissions) {
            return package$.MODULE$.Resource().make(this.createTempDirectory(dir, prefix, permissions), (Function1 & Serializable)_$7 -> {
                Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.deleteRecursively((Path)_$7), this.F);
                return ApplicativeErrorOps$.MODULE$.recover$extension(object, (PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        return throwable instanceof NoSuchFileException;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable instanceof NoSuchFileException) {
                            return BoxedUnit.UNIT;
                        }
                        return function1.apply((Object)x);
                    }
                }, this.F);
            }, this.F);
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeAll(Path path, Flags flags) {
            return (Function1 & Serializable)in -> Stream$.MODULE$.resource(this.writeCursor(path, flags), this.F).flatMap((Function1 & Serializable)_$8 -> {
                Pull pull = Pull$.MODULE$.StreamPullOps(_$8.writeAll(in).void());
                return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public Resource<F, WriteCursor<F>> writeCursor(Path path, Flags flags) {
            return this.open(path, flags.addIfAbsent(Flag$.MODULE$.Write())).flatMap((Function1 & Serializable)fileHandle -> {
                Object object;
                if (flags.contains(Flag$.MODULE$.Append())) {
                    object = fileHandle.size();
                } else {
                    Long l = (Long)package.all$.MODULE$.catsSyntaxApplicativeId((Object)BoxesRunTime.boxToLong((long)0L));
                    object = ApplicativeIdOps$.MODULE$.pure$extension((Object)l, this.F);
                }
                Object size = object;
                Object cursor = package.all$.MODULE$.toFunctorOps(size, this.F).map((Function1 & Serializable)s2 -> this.$anonfun$1((FileHandle)fileHandle, BoxesRunTime.unboxToLong((Object)s2)));
                return package$.MODULE$.Resource().eval(cursor);
            });
        }

        @Override
        public F writeCursorFromFileHandle(FileHandle<F> file, boolean append) {
            if (append) {
                return (F)package.all$.MODULE$.toFunctorOps(file.size(), this.F).map((Function1 & Serializable)s2 -> this.writeCursorFromFileHandle$$anonfun$1(file, BoxesRunTime.unboxToLong((Object)s2)));
            }
            WriteCursor writeCursor = (WriteCursor)package.all$.MODULE$.catsSyntaxApplicativeId(WriteCursor$.MODULE$.apply(file, 0L));
            return (F)ApplicativeIdOps$.MODULE$.pure$extension((Object)writeCursor, this.F);
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, Nothing$>> writeRotate(F computePath, long limit, Flags flags) {
            return (Function1 & Serializable)in -> Stream$.MODULE$.resource(Hotswap$.MODULE$.apply(this.openNewFile$1(computePath, flags), this.F), this.F).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Hotswap fileHotswap = (Hotswap)tuple2._1();
                    FileHandle fileHandle = (FileHandle)tuple2._2();
                    return Stream$.MODULE$.eval(this.newCursor$1(flags, fileHandle)).flatMap((Function1 & Serializable)cursor -> {
                        Pull pull = Pull$.MODULE$.StreamPullOps(this.go$1(limit, computePath, flags, fileHotswap, (WriteCursor)cursor, 0L, (Stream)in));
                        return Pull$StreamPullOps$.MODULE$.stream$extension(pull).drain();
                    }, NotGiven$.MODULE$.value());
                }
                throw new MatchError((Object)tuple2);
            }, NotGiven$.MODULE$.value());
        }

        private final /* synthetic */ WriteCursor $anonfun$1(FileHandle fileHandle$1, long s2) {
            return WriteCursor$.MODULE$.apply(fileHandle$1, s2);
        }

        private final /* synthetic */ WriteCursor writeCursorFromFileHandle$$anonfun$1(FileHandle file$1, long s2) {
            return WriteCursor$.MODULE$.apply(file$1, s2);
        }

        private final Resource openNewFile$1(Object computePath$1, Flags flags$5) {
            return package$.MODULE$.Resource().eval(computePath$1).flatMap((Function1 & Serializable)p -> this.open((Path)p, flags$5.addIfAbsent(Flag$.MODULE$.Write())));
        }

        private final Object newCursor$1(Flags flags$7, FileHandle file) {
            return this.writeCursorFromFileHandle(file, flags$7.contains(Flag$.MODULE$.Append()));
        }

        private final Pull go$1(long limit$1, Object computePath$2, Flags flags$8, Hotswap fileHotswap, WriteCursor cursor, long acc, Stream s2) {
            int toWrite = (int)BoxesRunTime.unboxToLong((Object)package.all$.MODULE$.catsSyntaxOrder((Object)BoxesRunTime.boxToLong((long)(limit$1 - acc)), (Order)Eq$.MODULE$.catsKernelInstancesForLong()).min((Object)BoxesRunTime.boxToLong((long)Integer.MAX_VALUE)));
            Stream stream = Stream$.MODULE$.InvariantOps(s2);
            Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            return Stream$ToPull$.MODULE$.unconsLimit$extension(stream2, toWrite).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Option option = x$1;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Chunk hd = (Chunk)tuple2._1();
                    Stream tl = (Stream)tuple2._2();
                    long newAcc = acc + (long)hd.size();
                    return cursor.writePull(hd).flatMap((Function1 & Serializable)nc2 -> {
                        if (newAcc >= limit$1) {
                            return Pull$.MODULE$.eval(package.all$.MODULE$.toFlatMapOps(fileHotswap.swap(this.openNewFile$1(computePath$2, flags$8)), this.F).flatMap((Function1 & Serializable)file -> this.newCursor$1(flags$8, (FileHandle)file))).flatMap((Function1 & Serializable)nc -> this.go$1(limit$1, computePath$2, flags$8, fileHotswap, (WriteCursor)nc, 0L, tl));
                        }
                        return this.go$1(limit$1, computePath$2, flags$8, fileHotswap, (WriteCursor)nc2, newAcc, tl);
                    });
                }
                if (None$.MODULE$.equals(option)) {
                    return Pull$.MODULE$.done();
                }
                throw new MatchError((Object)option);
            });
        }
    }
}

