/*
 * Decompiled with CFR 0.152.
 */
package fs2.io.net.unixsocket;

import cats.Apply;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.LiftIO;
import cats.effect.LiftIO$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Resource$;
import cats.effect.kernel.syntax.GenSpawnOps$;
import cats.effect.std.Mutex;
import cats.effect.std.Mutex$;
import cats.effect.syntax.package;
import cats.syntax.ApplicativeByNameOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.IfMOps$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$PureOps$;
import fs2.io.file.Files;
import fs2.io.file.Files$;
import fs2.io.file.Path$;
import fs2.io.net.Socket;
import fs2.io.net.Socket$;
import fs2.io.net.SocketCompanionPlatform;
import fs2.io.net.unixsocket.JdkUnixSockets$;
import fs2.io.net.unixsocket.JnrUnixSockets$;
import fs2.io.net.unixsocket.UnixSocketAddress;
import fs2.io.net.unixsocket.UnixSockets;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;
import scala.util.Right;

public interface UnixSocketsCompanionPlatform {
    public static UnixSockets forIO$(UnixSocketsCompanionPlatform $this) {
        return $this.forIO();
    }

    default public UnixSockets<IO> forIO() {
        return this.forLiftIO(IO$.MODULE$.asyncForIO(), LiftIO$.MODULE$.ioLiftIO());
    }

    public static UnixSockets forLiftIO$(UnixSocketsCompanionPlatform $this, Async evidence$1, LiftIO evidence$2) {
        return $this.forLiftIO(evidence$1, evidence$2);
    }

    default public <F> UnixSockets<F> forLiftIO(Async<F> evidence$1, LiftIO<F> evidence$2) {
        LiftIO liftIO = LiftIO$.MODULE$.apply(evidence$2);
        return this.forAsyncAndFiles(evidence$1, Files$.MODULE$.forLiftIO(evidence$1, evidence$2));
    }

    public static UnixSockets forAsyncAndFiles$(UnixSocketsCompanionPlatform $this, Async evidence$1, Files evidence$2) {
        return $this.forAsyncAndFiles(evidence$1, evidence$2);
    }

    default public <F> UnixSockets<F> forAsyncAndFiles(Async<F> evidence$1, Files<F> evidence$2) {
        if (JdkUnixSockets$.MODULE$.supported()) {
            return JdkUnixSockets$.MODULE$.forAsyncAndFiles(evidence$1, evidence$2);
        }
        if (JnrUnixSockets$.MODULE$.supported()) {
            return JnrUnixSockets$.MODULE$.forAsyncAndFiles(evidence$1, evidence$2);
        }
        throw new UnsupportedOperationException("Must either run on JDK 16+ or have \"com.github.jnr\" % \"jnr-unixsocket\" % <version> on the classpath");
    }

    public static UnixSockets forAsync$(UnixSocketsCompanionPlatform $this, Async F) {
        return $this.forAsync(F);
    }

    default public <F> UnixSockets<F> forAsync(Async<F> F) {
        return this.forAsyncAndFiles(F, Files$.MODULE$.forAsync((Async)F));
    }

    public static Object fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$$makeSocket$(UnixSocketsCompanionPlatform $this, SocketChannel ch, Async evidence$1) {
        return $this.fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$$makeSocket(ch, evidence$1);
    }

    default public <F> Object fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$$makeSocket(SocketChannel ch, Async<F> evidence$1) {
        return package.all$.MODULE$.catsSyntaxTuple2Semigroupal(Tuple2$.MODULE$.apply(Mutex$.MODULE$.apply(evidence$1), Mutex$.MODULE$.apply(evidence$1))).mapN((Function2 & Serializable)(readMutex, writeMutex) -> new AsyncSocket(this, ch, readMutex, writeMutex, evidence$1), evidence$1, evidence$1);
    }

    public static boolean fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$AsyncSocket$$_$go$1$$anonfun$2(ByteBuffer buff$3) {
        return buff$3.remaining() <= 0;
    }

    public static ByteBuffer fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$AsyncSocket$$_$write$$anonfun$1(Chunk bytes$1) {
        return bytes$1.toByteBuffer($less$colon$less$.MODULE$.refl());
    }

    public final class AsyncSocket<F>
    extends SocketCompanionPlatform.BufferedReads<F> {
        private final SocketChannel ch;
        private final Mutex<F> writeMutex;
        private final Async<F> F;
        private final /* synthetic */ UnixSocketsCompanionPlatform $outer;

        public AsyncSocket(UnixSocketsCompanionPlatform $outer, SocketChannel ch, Mutex<F> readMutex, Mutex<F> writeMutex, Async<F> F) {
            this.ch = ch;
            this.writeMutex = writeMutex;
            this.F = F;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(Socket$.MODULE$, readMutex, F);
        }

        @Override
        public F readChunk(ByteBuffer buff) {
            Object object = package.all$.MODULE$.genSpawnOps(this.F.blocking(() -> this.readChunk$$anonfun$1(buff)), this.F);
            return (F)GenSpawnOps$.MODULE$.cancelable$extension(object, this.close(), this.F);
        }

        @Override
        public F write(Chunk<Object> bytes) {
            return (F)this.writeMutex.lock().surround(package.all$.MODULE$.toFlatMapOps(this.F.delay(() -> UnixSocketsCompanionPlatform.fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$AsyncSocket$$_$write$$anonfun$1(bytes)), this.F).flatMap((Function1 & Serializable)buff -> this.go$1((ByteBuffer)buff)), this.F);
        }

        @Override
        public F localAddress() {
            return this.raiseIpAddressError();
        }

        @Override
        public F remoteAddress() {
            return this.raiseIpAddressError();
        }

        private <A> F raiseIpAddressError() {
            return (F)this.F.raiseError((Object)new UnsupportedOperationException("UnixSockets do not use IP addressing"));
        }

        @Override
        public F isOpen() {
            return (F)this.F.blocking(this::isOpen$$anonfun$1);
        }

        public F close() {
            return (F)this.F.blocking((Function0 & Serializable)() -> {
                this.close$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public F endOfOutput() {
            return (F)this.F.blocking((Function0 & Serializable)() -> {
                this.endOfOutput$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        @Override
        public F endOfInput() {
            return (F)this.F.blocking((Function0 & Serializable)() -> {
                this.endOfInput$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        public final /* synthetic */ UnixSocketsCompanionPlatform fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$AsyncSocket$$$outer() {
            return this.$outer;
        }

        private final int readChunk$$anonfun$1(ByteBuffer buff$1) {
            return this.ch.read(buff$1);
        }

        private final int go$1$$anonfun$1(ByteBuffer buff$2) {
            return this.ch.write(buff$2);
        }

        private final Object go$1$$anonfun$3() {
            return this.F.unit();
        }

        private final Object go$1$$anonfun$4(ByteBuffer buff$4) {
            return this.go$1(buff$4);
        }

        private final Object go$1(ByteBuffer buff) {
            Object object = package.all$.MODULE$.genSpawnOps(this.F.blocking(() -> this.go$1$$anonfun$1(buff)), this.F);
            Object object2 = package.all$.MODULE$.catsSyntaxApplyOps(GenSpawnOps$.MODULE$.cancelable$extension(object, this.close(), this.F));
            Object object3 = package.all$.MODULE$.catsSyntaxIfM(this.F.delay(() -> UnixSocketsCompanionPlatform.fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$AsyncSocket$$_$go$1$$anonfun$2(buff)), this.F);
            return ApplyOps$.MODULE$.$times$greater$extension(object2, IfMOps$.MODULE$.ifM$extension(object3, this::go$1$$anonfun$3, () -> this.go$1$$anonfun$4(buff), this.F), this.F);
        }

        private final boolean isOpen$$anonfun$1() {
            return this.ch.isOpen();
        }

        private final void close$$anonfun$1() {
            this.ch.close();
        }

        private final void endOfOutput$$anonfun$1() {
            this.ch.shutdownOutput();
        }

        private final void endOfInput$$anonfun$1() {
            this.ch.shutdownInput();
        }
    }

    public abstract class AsyncUnixSockets<F>
    implements UnixSockets<F> {
        private final Files<F> evidence$1;
        private final Async<F> F;
        private final /* synthetic */ UnixSocketsCompanionPlatform $outer;

        public AsyncUnixSockets(UnixSocketsCompanionPlatform $outer, Files<F> evidence$1, Async<F> F) {
            this.evidence$1 = evidence$1;
            this.F = F;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public abstract Resource<F, SocketChannel> openChannel(UnixSocketAddress var1);

        public abstract Resource<F, Resource<F, SocketChannel>> openServerChannel(UnixSocketAddress var1);

        @Override
        public Resource<F, Socket<F>> client(UnixSocketAddress address) {
            return this.openChannel(address).evalMap((Function1 & Serializable)_$5 -> this.$outer.fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$$makeSocket((SocketChannel)_$5, this.F));
        }

        @Override
        public Stream<F, Socket<F>> server(UnixSocketAddress address, boolean deleteIfExists, boolean deleteOnClose) {
            Function0 function0 = package.all$.MODULE$.catsSyntaxApplicativeByName(() -> this.$anonfun$1(address));
            Resource delete = Resource$.MODULE$.make(ApplicativeByNameOps$.MODULE$.whenA$extension(function0, deleteIfExists, this.F), (Function1 & Serializable)_$6 -> {
                Function0 function0 = package.all$.MODULE$.catsSyntaxApplicativeByName(() -> this.$anonfun$2$$anonfun$1(address));
                return ApplicativeByNameOps$.MODULE$.whenA$extension(function0, deleteOnClose, this.F);
            }, this.F);
            Resource resource = (Resource)package.all$.MODULE$.catsSyntaxApplyOps((Object)delete);
            return Stream$.MODULE$.resource((Resource)ApplyOps$.MODULE$.$times$greater$extension((Object)resource, this.openServerChannel(address), (Apply)Resource$.MODULE$.catsEffectAsyncForResource(this.F)), this.F).flatMap((Function1 & Serializable)accept -> Stream$.MODULE$.resource(accept.attempt(this.F), this.F).flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Stream stream = Stream$.MODULE$.PureOps(Stream$.MODULE$.empty());
                    return Stream$PureOps$.MODULE$.apply$extension(stream);
                }
                if (either instanceof Right) {
                    SocketChannel accepted = (SocketChannel)((Right)either).value();
                    return Stream$.MODULE$.eval(this.$outer.fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$$makeSocket(accepted, this.F));
                }
                throw new MatchError((Object)either);
            }, NotGiven$.MODULE$.value()).repeat(), NotGiven$.MODULE$.value());
        }

        public final /* synthetic */ UnixSocketsCompanionPlatform fs2$io$net$unixsocket$UnixSocketsCompanionPlatform$AsyncUnixSockets$$$outer() {
            return this.$outer;
        }

        private final Object $anonfun$1(UnixSocketAddress address$1) {
            return Files$.MODULE$.apply(this.evidence$1).deleteIfExists(Path$.MODULE$.apply(address$1.path()));
        }

        private final Object $anonfun$2$$anonfun$1(UnixSocketAddress address$3) {
            return Files$.MODULE$.apply(this.evidence$1).deleteIfExists(Path$.MODULE$.apply(address$3.path()));
        }
    }
}

