/*
 * Decompiled with CFR 0.152.
 */
package fs2.timeseries;

import cats.effect.kernel.GenTemporal;
import fs2.Chunk;
import fs2.Pull;
import fs2.Pull$;
import fs2.Pull$StreamPullOps$;
import fs2.Scan;
import fs2.Scan$;
import fs2.Stream;
import fs2.Stream$;
import fs2.Stream$InvariantOps$;
import fs2.Stream$ToPull$;
import fs2.timeseries.TimeStamped;
import fs2.timeseries.TimeStamped$;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class TimeSeries$
implements Serializable {
    public static final TimeSeries$ MODULE$ = new TimeSeries$();

    private TimeSeries$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TimeSeries$.class);
    }

    public <F, A> Stream<F, TimeStamped<Option<A>>> apply(Stream<F, TimeStamped<A>> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, GenTemporal<F, Throwable> evidence$1) {
        return this.apply(source, tickPeriod, reorderOver, false, evidence$1);
    }

    public <F, A> Stream<F, TimeStamped<Option<A>>> apply(Stream<F, TimeStamped<A>> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, boolean monotonic, GenTemporal<F, Throwable> evidence$1) {
        Stream src = source.map((Function1 & Serializable)tsa -> tsa.map((Function1 & Serializable)_$3 -> Some$.MODULE$.apply(_$3)));
        Stream ticks = this.timeTicks(tickPeriod, monotonic, evidence$1).map((Function1 & Serializable)tsu -> tsu.map((Function1 & Serializable)_$4 -> None$.MODULE$));
        return src.merge(ticks, evidence$1).through(TimeStamped$.MODULE$.reorderLocally(reorderOver));
    }

    public <F, A> Stream<F, TimeStamped<Option<A>>> timePulled(Stream<F, A> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, GenTemporal<F, Throwable> evidence$1) {
        return this.apply(source.map((Function1 & Serializable)a -> TimeStamped$.MODULE$.unsafeRealTime(a)), tickPeriod, reorderOver, evidence$1);
    }

    public <F, A> Stream<F, TimeStamped<Option<A>>> timePulled(Stream<F, A> source, FiniteDuration tickPeriod, FiniteDuration reorderOver, boolean monotonic, GenTemporal<F, Throwable> evidence$1) {
        return this.apply(source.map((Function1 & Serializable)a -> {
            if (monotonic) {
                return TimeStamped$.MODULE$.unsafeMonotonic(a);
            }
            return TimeStamped$.MODULE$.unsafeRealTime(a);
        }), tickPeriod, reorderOver, monotonic, evidence$1);
    }

    public <F, A, B> Function1<Stream<F, TimeStamped<Option<A>>>, Stream<F, TimeStamped<Option<B>>>> lift(Function1<A, B> f) {
        return (Function1 & Serializable)_$8 -> _$8.map((Function1 & Serializable)_$9 -> _$9.map((Function1 & Serializable)_$10 -> _$10.map(f)));
    }

    public <F, L, R> Function1<Stream<F, TimeStamped<Option<Either<L, R>>>>, Stream<F, TimeStamped<Option<L>>>> drainRight() {
        return (Function1 & Serializable)_$12 -> _$12.collect(new Serializable(){

            public final boolean isDefinedAt(TimeStamped x) {
                TimeStamped timeStamped = x;
                if (timeStamped != null) {
                    Either either;
                    TimeStamped<A> timeStamped2 = TimeStamped$.MODULE$.unapply(timeStamped);
                    FiniteDuration finiteDuration = timeStamped2._1();
                    Option option = (Option)timeStamped2._2();
                    if (None$.MODULE$.equals(option)) {
                        TimeStamped tick = timeStamped;
                        return true;
                    }
                    FiniteDuration ts = finiteDuration;
                    if (option instanceof Some && (either = (Either)((Some)option).value()) instanceof Left) {
                        Object l = ((Left)either).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(TimeStamped x, Function1 function1) {
                TimeStamped timeStamped = x;
                if (timeStamped != null) {
                    Either either;
                    TimeStamped<A> timeStamped2 = TimeStamped$.MODULE$.unapply(timeStamped);
                    FiniteDuration finiteDuration = timeStamped2._1();
                    Option option = (Option)timeStamped2._2();
                    if (None$.MODULE$.equals(option)) {
                        TimeStamped tick = timeStamped;
                        return tick;
                    }
                    FiniteDuration ts = finiteDuration;
                    if (option instanceof Some && (either = (Either)((Some)option).value()) instanceof Left) {
                        Object l = ((Left)either).value();
                        return TimeStamped$.MODULE$.apply(ts, Some$.MODULE$.apply(l));
                    }
                }
                return function1.apply((Object)x);
            }
        });
    }

    public <F, L, R> Function1<Stream<F, TimeStamped<Option<Either<L, R>>>>, Stream<F, TimeStamped<Option<R>>>> drainLeft() {
        return (Function1 & Serializable)_$14 -> _$14.collect(new Serializable(){

            public final boolean isDefinedAt(TimeStamped x) {
                TimeStamped timeStamped = x;
                if (timeStamped != null) {
                    Either either;
                    TimeStamped<A> timeStamped2 = TimeStamped$.MODULE$.unapply(timeStamped);
                    FiniteDuration finiteDuration = timeStamped2._1();
                    Option option = (Option)timeStamped2._2();
                    if (None$.MODULE$.equals(option)) {
                        TimeStamped tick = timeStamped;
                        return true;
                    }
                    FiniteDuration ts = finiteDuration;
                    if (option instanceof Some && (either = (Either)((Some)option).value()) instanceof Right) {
                        Object r = ((Right)either).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(TimeStamped x, Function1 function1) {
                TimeStamped timeStamped = x;
                if (timeStamped != null) {
                    Either either;
                    TimeStamped<A> timeStamped2 = TimeStamped$.MODULE$.unapply(timeStamped);
                    FiniteDuration finiteDuration = timeStamped2._1();
                    Option option = (Option)timeStamped2._2();
                    if (None$.MODULE$.equals(option)) {
                        TimeStamped tick = timeStamped;
                        return tick;
                    }
                    FiniteDuration ts = finiteDuration;
                    if (option instanceof Some && (either = (Either)((Some)option).value()) instanceof Right) {
                        Object r = ((Right)either).value();
                        return TimeStamped$.MODULE$.apply(ts, Some$.MODULE$.apply(r));
                    }
                }
                return function1.apply((Object)x);
            }
        });
    }

    private <F> Stream<F, TimeStamped<BoxedUnit>> timeTicks(FiniteDuration tickPeriod, boolean monotonic, GenTemporal<F, Throwable> evidence$1) {
        return Stream$.MODULE$.awakeEvery(tickPeriod, evidence$1).map((Function1 & Serializable)_$16 -> {
            if (monotonic) {
                return TimeStamped$.MODULE$.unsafeMonotonic(BoxedUnit.UNIT);
            }
            return TimeStamped$.MODULE$.unsafeRealTime(BoxedUnit.UNIT);
        });
    }

    public <F, A> Function1<Stream<F, TimeStamped<A>>, Stream<F, TimeStamped<Option<A>>>> interpolateTicks(FiniteDuration tickPeriod) {
        return (Function1 & Serializable)in -> {
            Stream stream = Stream$.MODULE$.InvariantOps(in);
            Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            Pull pull = Pull$.MODULE$.StreamPullOps(Stream$ToPull$.MODULE$.uncons1$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Option option = x$1;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    TimeStamped hd = (TimeStamped)tuple2._1();
                    Stream tl = (Stream)tuple2._2();
                    return Pull$.MODULE$.output1(hd.map((Function1 & Serializable)_$23 -> Some$.MODULE$.apply(_$23))).$greater$greater(() -> this.interpolateTicks$$anonfun$1$$anonfun$1$$anonfun$2(hd, tickPeriod, tl));
                }
                if (None$.MODULE$.equals(option)) {
                    return Pull$.MODULE$.done();
                }
                throw new MatchError((Object)option);
            }));
            return Pull$StreamPullOps$.MODULE$.stream$extension(pull);
        };
    }

    public <S, I, O> Scan<S, TimeStamped<Option<I>>, TimeStamped<Option<O>>> preserve(Scan<S, I, O> t) {
        return this.preserveTicks(TimeStamped$.MODULE$.preserve(t));
    }

    public <S, I, O> Scan<S, TimeStamped<Option<I>>, TimeStamped<Option<O>>> preserveTicks(Scan<S, TimeStamped<I>, TimeStamped<O>> t) {
        return t.semilens((Function1 & Serializable)tsi -> (Either)((Option)tsi.value()).map((Function1 & Serializable)v -> package$.MODULE$.Right().apply(TimeStamped$.MODULE$.apply(tsi.time(), v))).getOrElse(() -> this.preserveTicks$$anonfun$1$$anonfun$2(tsi)), (Function2 & Serializable)(_$24, tso) -> tso.map((Function1 & Serializable)_$25 -> Some$.MODULE$.apply(_$25)));
    }

    public <LS, L, RS, R, O> Scan<Tuple2<LS, RS>, TimeStamped<Option<Either<L, R>>>, O> choice(Scan<LS, TimeStamped<Option<L>>, O> l, Scan<RS, TimeStamped<Option<R>>, O> r) {
        return Scan$.MODULE$.apply(Tuple2$.MODULE$.apply(l.initial(), r.initial()), (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                Object lState = tuple2._1();
                Object rState = tuple2._2();
                TimeStamped tsv = (TimeStamped)tuple22._2();
                TimeStamped timeStamped = tsv;
                if (timeStamped != null) {
                    TimeStamped timeStamped2 = TimeStamped$.MODULE$.unapply(timeStamped);
                    FiniteDuration finiteDuration = timeStamped2._1();
                    Option option = (Option)timeStamped2._2();
                    FiniteDuration t = finiteDuration;
                    if (option instanceof Some) {
                        Either either = (Either)((Some)option).value();
                        if (either instanceof Left) {
                            Object lValue = ((Left)either).value();
                            Tuple2 tuple23 = l.transform(lState, TimeStamped$.MODULE$.apply(t, Some$.MODULE$.apply(lValue)));
                            if (tuple23 == null) {
                                throw new MatchError(tuple23);
                            }
                            Object s2 = tuple23._1();
                            Chunk out = (Chunk)tuple23._2();
                            Tuple2 tuple24 = Tuple2$.MODULE$.apply(s2, (Object)out);
                            Object s3 = tuple24._1();
                            Chunk out2 = (Chunk)tuple24._2();
                            Object object = Predef$.MODULE$.ArrowAssoc(s3);
                            return Tuple2$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, rState), (Object)out2);
                        }
                        FiniteDuration t2 = finiteDuration;
                        if (either instanceof Right) {
                            Object rValue = ((Right)either).value();
                            Tuple2 tuple25 = r.transform(rState, TimeStamped$.MODULE$.apply(t2, Some$.MODULE$.apply(rValue)));
                            if (tuple25 == null) {
                                throw new MatchError(tuple25);
                            }
                            Object s4 = tuple25._1();
                            Chunk out = (Chunk)tuple25._2();
                            Tuple2 tuple26 = Tuple2$.MODULE$.apply(s4, (Object)out);
                            Object s5 = tuple26._1();
                            Chunk out3 = (Chunk)tuple26._2();
                            Object object = Predef$.MODULE$.ArrowAssoc(lState);
                            return Tuple2$.MODULE$.apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, s5), (Object)out3);
                        }
                    }
                    FiniteDuration t3 = finiteDuration;
                    if (None$.MODULE$.equals(option)) {
                        Tuple2 tuple27 = l.transform(lState, TimeStamped$.MODULE$.apply(t3, None$.MODULE$));
                        if (tuple27 == null) {
                            throw new MatchError(tuple27);
                        }
                        Object ls = tuple27._1();
                        Chunk lout = (Chunk)tuple27._2();
                        Tuple2 tuple28 = Tuple2$.MODULE$.apply(ls, (Object)lout);
                        Object ls2 = tuple28._1();
                        Chunk lout2 = (Chunk)tuple28._2();
                        Tuple2 tuple29 = r.transform(rState, TimeStamped$.MODULE$.apply(t3, None$.MODULE$));
                        if (tuple29 == null) {
                            throw new MatchError(tuple29);
                        }
                        Object rs = tuple29._1();
                        Chunk rout = (Chunk)tuple29._2();
                        Tuple2 tuple210 = Tuple2$.MODULE$.apply(rs, (Object)rout);
                        Object rs2 = tuple210._1();
                        Chunk rout2 = (Chunk)tuple210._2();
                        return Tuple2$.MODULE$.apply((Object)Tuple2$.MODULE$.apply(ls2, rs2), lout2.$plus$plus(rout2));
                    }
                }
                throw new MatchError((Object)timeStamped);
            }
            throw new MatchError((Object)tuple22);
        }, (Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object lState = tuple2._1();
                Object rState = tuple2._2();
                return l.onComplete(lState).$plus$plus(r.onComplete(rState));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private final FiniteDuration tickTime$1(FiniteDuration nextTick$1, FiniteDuration tickPeriod$1, int x) {
        return nextTick$1.$plus(package.IntMult$.MODULE$.$times$extension(scala.concurrent.duration.package$.MODULE$.IntMult(x), tickPeriod$1));
    }

    private final Pull go$1$$anonfun$1$$anonfun$3(FiniteDuration nextTick$4, Stream tl$1, FiniteDuration tickPeriod$4) {
        return this.go$1(tickPeriod$4, nextTick$4, tl$1);
    }

    private final /* synthetic */ TimeStamped $anonfun$4(FiniteDuration nextTick$6, FiniteDuration tickPeriod$9, int i) {
        return TimeStamped$.MODULE$.tick(this.tickTime$1(nextTick$6, tickPeriod$9, i));
    }

    private final Pull $anonfun$5(int tickCount$1, Stream tl$2, Chunk suffix$1, FiniteDuration tickPeriod$5, FiniteDuration nextTick$5) {
        return this.go$1(tickPeriod$5, this.tickTime$1(nextTick$5, tickPeriod$5, tickCount$1), tl$2.cons(suffix$1));
    }

    private final Pull go$1$$anonfun$1$$anonfun$4(Pull rest$1) {
        return rest$1;
    }

    private final Pull go$1(FiniteDuration tickPeriod$2, FiniteDuration nextTick, Stream s2) {
        Stream stream = Stream$.MODULE$.InvariantOps(s2);
        Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
        return Stream$ToPull$.MODULE$.uncons$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                Chunk hd = (Chunk)tuple2._1();
                Stream tl = (Stream)tuple2._2();
                Option<Object> option2 = hd.indexWhere((Function1 & Serializable)_$18 -> _$18.time().$greater$eq((Object)nextTick));
                if (None$.MODULE$.equals(option2)) {
                    return Pull$.MODULE$.output(hd.map((Function1 & Serializable)_$19 -> _$19.map((Function1 & Serializable)_$20 -> Some$.MODULE$.apply(_$20)))).$greater$greater(() -> this.go$1$$anonfun$1$$anonfun$3(nextTick, tl, tickPeriod$2));
                }
                if (option2 instanceof Some) {
                    int idx = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
                    Tuple2 tuple22 = hd.splitAt(idx);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    Chunk prefix = (Chunk)tuple22._1();
                    Chunk suffix = (Chunk)tuple22._2();
                    Tuple2 tuple23 = Tuple2$.MODULE$.apply((Object)prefix, (Object)suffix);
                    Chunk prefix2 = (Chunk)tuple23._1();
                    Chunk suffix2 = (Chunk)tuple23._2();
                    Pull out = Pull$.MODULE$.output(prefix2.map((Function1 & Serializable)_$21 -> _$21.map((Function1 & Serializable)_$22 -> Some$.MODULE$.apply(_$22))));
                    TimeStamped next = (TimeStamped)suffix2.apply(0);
                    int tickCount = (int)((next.time().toMillis() - nextTick.toMillis()) / tickPeriod$2.toMillis() + 1L);
                    Stream ticks = Stream$.MODULE$.range(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToInteger((int)tickCount), Numeric.IntIsIntegral$.MODULE$).map((Function1 & Serializable)i -> this.$anonfun$4(nextTick, tickPeriod$2, BoxesRunTime.unboxToInt((Object)i)));
                    Stream stream = Stream$.MODULE$.InvariantOps(ticks);
                    Stream stream2 = new Stream.ToPull(Stream$InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
                    Pull rest = Stream$ToPull$.MODULE$.echo$extension(stream2).$greater$greater(() -> this.$anonfun$5(tickCount, tl, suffix2, tickPeriod$2, nextTick));
                    return out.$greater$greater(() -> this.go$1$$anonfun$1$$anonfun$4(rest));
                }
                throw new MatchError(option2);
            }
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.done();
            }
            throw new MatchError((Object)option);
        });
    }

    private final Pull interpolateTicks$$anonfun$1$$anonfun$1$$anonfun$2(TimeStamped hd$1, FiniteDuration tickPeriod$6, Stream tl$3) {
        return this.go$1(tickPeriod$6, hd$1.time().$plus(tickPeriod$6), tl$3);
    }

    private final Either preserveTicks$$anonfun$1$$anonfun$2(TimeStamped tsi$2) {
        return package$.MODULE$.Left().apply(TimeStamped$.MODULE$.tick(tsi$2.time()));
    }
}

