/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.channel;

import java.io.Closeable;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import org.http4s.blaze.channel.ServerChannel$Closed$;
import org.http4s.blaze.channel.ServerChannel$Closing$;
import org.http4s.blaze.channel.ServerChannel$Hook$;
import org.http4s.blaze.channel.ServerChannel$Open$;
import org.http4s.blaze.util.Execution$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ReusableBuilder;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.control.NonFatal$;

public abstract class ServerChannel
implements Closeable {
    private final Logger logger;
    private State state;
    private final ReusableBuilder<Hook, Vector<Hook>> shutdownHooks;
    public final ServerChannel$Hook$ Hook$lzy1 = new ServerChannel$Hook$(this);

    public ServerChannel() {
        this.logger = LoggerFactory.getLogger((String)"org.http4s.blaze.channel.ServerChannel");
        this.state = ServerChannel$Open$.MODULE$;
        this.shutdownHooks = package$.MODULE$.Vector().newBuilder();
    }

    public Logger logger() {
        return this.logger;
    }

    public abstract void closeChannel();

    public abstract InetSocketAddress socketAddress();

    @Override
    public final void close() {
        Vector vector;
        ReusableBuilder<Hook, Vector<Hook>> reusableBuilder = this.shutdownHooks;
        synchronized (reusableBuilder) {
            Vector vector2;
            State state = this.state;
            ServerChannel$Open$ serverChannel$Open$ = ServerChannel$Open$.MODULE$;
            if (state == null ? serverChannel$Open$ != null : !state.equals(serverChannel$Open$)) {
                vector2 = package$.MODULE$.Vector().empty();
            } else {
                this.state = ServerChannel$Closing$.MODULE$;
                this.closeChannel();
                Vector hooks = (Vector)this.shutdownHooks.result();
                this.shutdownHooks.clear();
                vector2 = hooks;
            }
            vector = vector2;
        }
        Vector hooks = vector;
        this.scheduleHooks((Vector<Hook>)hooks);
    }

    public final void join() {
        ReusableBuilder<Hook, Vector<Hook>> reusableBuilder = this.shutdownHooks;
        synchronized (reusableBuilder) {
            while (true) {
                State state = this.state;
                ServerChannel$Closed$ serverChannel$Closed$ = ServerChannel$Closed$.MODULE$;
                if (!(state == null ? serverChannel$Closed$ != null : !state.equals(serverChannel$Closed$))) break;
                this.shutdownHooks.wait();
            }
        }
    }

    public final boolean addShutdownHook(Function0<BoxedUnit> f, ExecutionContext ec) {
        boolean bl;
        ReusableBuilder<Hook, Vector<Hook>> reusableBuilder = this.shutdownHooks;
        synchronized (reusableBuilder) {
            boolean bl2;
            State state = this.state;
            ServerChannel$Open$ serverChannel$Open$ = ServerChannel$Open$.MODULE$;
            if (state == null ? serverChannel$Open$ != null : !state.equals(serverChannel$Open$)) {
                bl2 = false;
            } else {
                this.shutdownHooks.$plus$eq((Object)this.Hook().apply(f, ec));
                bl2 = true;
            }
            bl = bl2;
        }
        return bl;
    }

    public ExecutionContext addShutdownHook$default$2(Function0<BoxedUnit> f) {
        return Execution$.MODULE$.directec();
    }

    private void scheduleHooks(Vector<Hook> hooks) {
        if (hooks.isEmpty()) {
            this.org$http4s$blaze$channel$ServerChannel$$closeAndNotify();
            return;
        }
        AtomicInteger countdown = new AtomicInteger(hooks.size());
        hooks.foreach((Function1)(JProcedure1 & Serializable)hook -> hook.ec().execute((Runnable)new HookRunnable(this, countdown, hook.task())));
    }

    public void org$http4s$blaze$channel$ServerChannel$$closeAndNotify() {
        ReusableBuilder<Hook, Vector<Hook>> reusableBuilder = this.shutdownHooks;
        synchronized (reusableBuilder) {
            this.state = ServerChannel$Closed$.MODULE$;
            this.shutdownHooks.notifyAll();
        }
    }

    private final ServerChannel$Hook$ Hook() {
        return this.Hook$lzy1;
    }

    public class Hook
    implements Product,
    Serializable {
        private final Function0 task;
        private final ExecutionContext ec;
        private final /* synthetic */ ServerChannel $outer;

        public Hook(ServerChannel $outer, Function0<BoxedUnit> task, ExecutionContext ec) {
            this.task = task;
            this.ec = ec;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Hook)) return false;
            if (((Hook)object).org$http4s$blaze$channel$ServerChannel$Hook$$$outer() != this.$outer) return false;
            Hook hook = (Hook)object;
            Function0<BoxedUnit> function0 = this.task();
            Function0<BoxedUnit> function02 = hook.task();
            if (function0 == null) {
                if (function02 != null) {
                    return false;
                }
            } else if (!function0.equals(function02)) return false;
            ExecutionContext executionContext = this.ec();
            ExecutionContext executionContext2 = hook.ec();
            if (executionContext == null) {
                if (executionContext2 != null) {
                    return false;
                }
            } else if (!executionContext.equals(executionContext2)) return false;
            if (!hook.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Hook;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Hook";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "task";
            }
            if (1 == n2) {
                return "ec";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function0<BoxedUnit> task() {
            return this.task;
        }

        public ExecutionContext ec() {
            return this.ec;
        }

        public Hook copy(Function0<BoxedUnit> task, ExecutionContext ec) {
            return new Hook(this.$outer, task, ec);
        }

        public Function0<BoxedUnit> copy$default$1() {
            return this.task();
        }

        public ExecutionContext copy$default$2() {
            return this.ec();
        }

        public Function0<BoxedUnit> _1() {
            return this.task();
        }

        public ExecutionContext _2() {
            return this.ec();
        }

        public final /* synthetic */ ServerChannel org$http4s$blaze$channel$ServerChannel$Hook$$$outer() {
            return this.$outer;
        }
    }

    public class HookRunnable
    implements Runnable {
        private final AtomicInteger countdown;
        private final Function0<BoxedUnit> hook;
        private final /* synthetic */ ServerChannel $outer;

        public HookRunnable(ServerChannel $outer, AtomicInteger countdown, Function0<BoxedUnit> hook) {
            this.countdown = countdown;
            this.hook = hook;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        @Override
        public void run() {
            block8: {
                try {
                    try {
                        this.hook.apply$mcV$sp();
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable t = throwable3 = (Throwable)option.get();
                            Logger Logger_this = this.$outer.logger();
                            if (Logger_this.isErrorEnabled()) {
                                Logger_this.error("Exception occurred during Channel shutdown.", t);
                            }
                            break block8;
                        }
                        throw throwable;
                    }
                }
                finally {
                    if (this.countdown.decrementAndGet() == 0) {
                        this.$outer.org$http4s$blaze$channel$ServerChannel$$closeAndNotify();
                    }
                }
            }
        }

        public final /* synthetic */ ServerChannel org$http4s$blaze$channel$ServerChannel$HookRunnable$$$outer() {
            return this.$outer;
        }
    }

    public static interface State {
    }
}

