/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.channel.nio1;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import org.http4s.blaze.channel.ChannelOptions;
import org.http4s.blaze.channel.ServerChannel;
import org.http4s.blaze.channel.ServerChannelGroup;
import org.http4s.blaze.channel.SocketConnection;
import org.http4s.blaze.channel.nio1.NIO1Channel;
import org.http4s.blaze.channel.nio1.NIO1ClientChannel;
import org.http4s.blaze.channel.nio1.NIO1Connection$;
import org.http4s.blaze.channel.nio1.NIO1HeadStage;
import org.http4s.blaze.channel.nio1.NIO1SocketServerGroup$;
import org.http4s.blaze.channel.nio1.Selectable;
import org.http4s.blaze.channel.nio1.SelectorLoop;
import org.http4s.blaze.channel.nio1.SelectorLoopPool;
import org.http4s.blaze.pipeline.Command$Connected$;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.util.Connections;
import org.http4s.blaze.util.Connections$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashSet;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class NIO1SocketServerGroup
implements ServerChannelGroup {
    private final SelectorLoopPool acceptorPool;
    private final SelectorLoopPool workerPool;
    private final ChannelOptions channelOptions;
    public final Logger org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$logger;
    public final HashSet<ServerChannelImpl> org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$listeningSet;
    private boolean isClosed;
    public final Connections org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$connections;

    public static ServerChannelGroup create(SelectorLoopPool selectorLoopPool, SelectorLoopPool selectorLoopPool2, ChannelOptions channelOptions, int n) {
        return NIO1SocketServerGroup$.MODULE$.create(selectorLoopPool, selectorLoopPool2, channelOptions, n);
    }

    public static ServerChannelGroup fixed(int n, int n2, ChannelOptions channelOptions, ThreadFactory threadFactory, int n3, ThreadFactory threadFactory2, int n4) {
        return NIO1SocketServerGroup$.MODULE$.fixed(n, n2, channelOptions, threadFactory, n3, threadFactory2, n4);
    }

    public static int fixed$default$1() {
        return NIO1SocketServerGroup$.MODULE$.fixed$default$1();
    }

    public static int fixed$default$2() {
        return NIO1SocketServerGroup$.MODULE$.fixed$default$2();
    }

    public static ChannelOptions create$default$3() {
        return NIO1SocketServerGroup$.MODULE$.create$default$3();
    }

    public static ChannelOptions fixed$default$3() {
        return NIO1SocketServerGroup$.MODULE$.fixed$default$3();
    }

    public static int create$default$4() {
        return NIO1SocketServerGroup$.MODULE$.create$default$4();
    }

    public static ThreadFactory fixed$default$4() {
        return NIO1SocketServerGroup$.MODULE$.fixed$default$4();
    }

    public static int fixed$default$5() {
        return NIO1SocketServerGroup$.MODULE$.fixed$default$5();
    }

    public static ThreadFactory fixed$default$6() {
        return NIO1SocketServerGroup$.MODULE$.fixed$default$6();
    }

    public static int fixed$default$7() {
        return NIO1SocketServerGroup$.MODULE$.fixed$default$7();
    }

    public NIO1SocketServerGroup(SelectorLoopPool acceptorPool, SelectorLoopPool workerPool, ChannelOptions channelOptions, int maxConnections) {
        this.acceptorPool = acceptorPool;
        this.workerPool = workerPool;
        this.channelOptions = channelOptions;
        this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$logger = LoggerFactory.getLogger((String)"org.http4s.blaze.channel.nio1.NIO1SocketServerGroup");
        this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$listeningSet = new HashSet();
        this.isClosed = false;
        this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$connections = Connections$.MODULE$.apply(maxConnections);
    }

    @Override
    public void closeGroup() {
        Seq seq;
        HashSet<ServerChannelImpl> hashSet = this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$listeningSet;
        synchronized (hashSet) {
            Seq seq2;
            if (this.isClosed) {
                seq2 = (Seq)package$.MODULE$.Seq().empty();
            } else {
                this.isClosed = true;
                Vector toClose = this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$listeningSet.toVector();
                this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$listeningSet.clear();
                seq2 = toClose;
            }
            seq = seq2;
        }
        Seq toClose = seq;
        toClose.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.close());
    }

    @Override
    public Try<ServerChannel> bind(InetSocketAddress address, Function1<SocketConnection, Future<LeafBuilder<ByteBuffer>>> service) {
        return Try$.MODULE$.apply(() -> this.bind$$anonfun$1(address, service));
    }

    private Selectable buildSocketAcceptor(ServerChannelImpl ch, Function1<SocketConnection, Future<LeafBuilder<ByteBuffer>>> service, SelectionKey key) {
        SelectionKey selectionKey;
        SocketAcceptor acceptor = new SocketAcceptor(this, key, ch, service);
        try {
            selectionKey = key.interestOps(16);
        }
        catch (CancelledKeyException ex) {
            acceptor.close((Option<Throwable>)Some$.MODULE$.apply((Object)ex));
            selectionKey = BoxedUnit.UNIT;
        }
        return acceptor;
    }

    public void org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$handleClientChannel(NIO1ClientChannel clientChannel, Function1<SocketConnection, Future<LeafBuilder<ByteBuffer>>> service) {
        block8: {
            try {
                clientChannel.configureBlocking(false);
                clientChannel.configureOptions(this.channelOptions);
                SocketAddress address = clientChannel.getRemoteAddress();
                SelectorLoop loop = this.workerPool.nextLoop();
                SocketConnection conn = NIO1Connection$.MODULE$.apply(clientChannel);
                loop.initChannel(clientChannel, (Function1<SelectionKey, Selectable>)(Function1 & Serializable)key -> this.fromKey$1(clientChannel, loop, (Function1)service, conn, address, (SelectionKey)key));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    Logger Logger_this = this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$logger;
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Error handling client channel. Closing.", t);
                    }
                    try {
                        clientChannel.close();
                    }
                    catch (Throwable throwable4) {
                        Option option2;
                        Throwable throwable5 = throwable4;
                        if (throwable5 != null && !(option2 = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                            Throwable throwable6;
                            Throwable t2 = throwable6 = (Throwable)option2.get();
                            Logger Logger_this2 = this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$logger;
                            if (Logger_this2.isErrorEnabled()) {
                                Logger_this2.error("Error closing client channel after error", t2);
                            }
                            break block8;
                        }
                        throw throwable4;
                    }
                }
                throw throwable;
            }
        }
    }

    private final ServerChannelImpl bind$$anonfun$1(InetSocketAddress address$1, Function1 service$1) {
        boolean bl;
        ServerSocketChannel ch = ServerSocketChannel.open().bind(address$1);
        ch.configureBlocking(false);
        SelectorLoop loop = this.acceptorPool.nextLoop();
        ServerChannelImpl serverChannel = new ServerChannelImpl(this, ch, loop);
        HashSet<ServerChannelImpl> hashSet = this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$listeningSet;
        synchronized (hashSet) {
            boolean bl2;
            if (this.isClosed) {
                bl2 = true;
            } else {
                this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$listeningSet.$plus$eq((Object)serverChannel);
                bl2 = false;
            }
            bl = bl2;
        }
        boolean closed = bl;
        if (closed) {
            Logger Logger_this = this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$logger;
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info("Group closed");
            }
            serverChannel.close();
        } else {
            Logger Logger_this = this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$logger;
            if (Logger_this.isInfoEnabled()) {
                Logger_this.info(new StringBuilder(25).append("Service bound to address ").append(serverChannel.socketAddress()).toString());
            }
            loop.initChannel(serverChannel, (Function1<SelectionKey, Selectable>)(Function1 & Serializable)key -> this.buildSocketAcceptor(serverChannel, (Function1<SocketConnection, Future<LeafBuilder<ByteBuffer>>>)service$1, (SelectionKey)key));
        }
        return serverChannel;
    }

    private final Selectable fromKey$1(NIO1ClientChannel clientChannel$1, SelectorLoop loop$1, Function1 service$3, SocketConnection conn$1, SocketAddress address$2, SelectionKey key) {
        NIO1HeadStage head = new NIO1HeadStage(clientChannel$1, loop$1, key);
        ((Future)service$3.apply((Object)conn$1)).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                LeafBuilder tail = (LeafBuilder)((Success)try_).value();
                tail.base(head);
                head.inboundCommand(Command$Connected$.MODULE$);
                Logger Logger_this = this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$logger;
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug(new StringBuilder(25).append("Accepted connection from ").append(address$2).toString());
                    return;
                }
                return;
            }
            if (try_ instanceof Failure) {
                Throwable ex = ((Failure)try_).exception();
                head.close((Option<Throwable>)None$.MODULE$);
                Logger Logger_this = this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$logger;
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info(new StringBuilder(25).append("Rejected connection from ").append(address$2).toString(), ex);
                    return;
                }
                return;
            }
            throw new MatchError((Object)try_);
        }, (ExecutionContext)loop$1);
        return head;
    }

    public final class ServerChannelImpl
    extends ServerChannel
    implements NIO1Channel {
        private final ServerSocketChannel selectableChannel;
        private final SelectorLoop selectorLoop;
        private volatile boolean closed;
        private final InetSocketAddress socketAddress;
        private final /* synthetic */ NIO1SocketServerGroup $outer;

        public ServerChannelImpl(NIO1SocketServerGroup $outer, ServerSocketChannel selectableChannel, SelectorLoop selectorLoop) {
            this.selectableChannel = selectableChannel;
            this.selectorLoop = selectorLoop;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.closed = false;
            this.socketAddress = (InetSocketAddress)selectableChannel.getLocalAddress();
        }

        @Override
        public ServerSocketChannel selectableChannel() {
            return this.selectableChannel;
        }

        public boolean channelClosed() {
            return this.closed;
        }

        @Override
        public InetSocketAddress socketAddress() {
            return this.socketAddress;
        }

        @Override
        public void closeChannel() {
            try {
                this.selectorLoop.enqueueTask(new Runnable(this){
                    private final /* synthetic */ ServerChannelImpl $outer;
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public void run() {
                        this.$outer.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$ServerChannelImpl$$_$doClose$1();
                    }
                });
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                Logger Logger_this = this.logger();
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info("Selector loop closed. Closing in local thread.");
                }
                this.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$ServerChannelImpl$$_$doClose$1();
            }
        }

        public final /* synthetic */ NIO1SocketServerGroup org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$ServerChannelImpl$$$outer() {
            return this.$outer;
        }

        public final void org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$ServerChannelImpl$$_$doClose$1() {
            block11: {
                Logger Logger_this = this.logger();
                if (Logger_this.isInfoEnabled()) {
                    Logger_this.info(new StringBuilder(21).append("Closing NIO1 channel ").append(this.socketAddress()).toString());
                }
                this.closed = true;
                HashSet<ServerChannelImpl> hashSet = this.$outer.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$listeningSet;
                synchronized (hashSet) {
                    this.$outer.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$listeningSet.remove((Object)this);
                }
                try {
                    try {
                        this.selectableChannel().close();
                    }
                    catch (Throwable throwable) {
                        Option option;
                        Throwable throwable2 = throwable;
                        if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                            Throwable throwable3;
                            Throwable t = throwable3 = (Throwable)option.get();
                            Logger Logger_this2 = this.logger();
                            if (Logger_this2.isWarnEnabled()) {
                                Logger_this2.warn("Failure during channel close.", t);
                            }
                            break block11;
                        }
                        throw throwable;
                    }
                }
                finally {
                    this.$outer.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$connections.close();
                }
            }
        }
    }

    public class SocketAcceptor
    implements Selectable {
        private final SelectionKey key;
        private final ServerChannelImpl ch;
        private final Function1<SocketConnection, Future<LeafBuilder<ByteBuffer>>> service;
        private final AtomicBoolean closed;
        private final /* synthetic */ NIO1SocketServerGroup $outer;

        public SocketAcceptor(NIO1SocketServerGroup $outer, SelectionKey key, ServerChannelImpl ch, Function1<SocketConnection, Future<LeafBuilder<ByteBuffer>>> service) {
            this.key = key;
            this.ch = ch;
            this.service = service;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.closed = new AtomicBoolean(false);
        }

        @Override
        public void opsReady(ByteBuffer unused) {
            if (this.key.isAcceptable()) {
                try {
                    this.acceptNewConnections();
                }
                catch (IOException ex) {
                    this.close((Option<Throwable>)Some$.MODULE$.apply((Object)ex));
                }
                return;
            }
        }

        @Override
        public void close(Option<Throwable> cause) {
            if (this.closed.compareAndSet(false, true) && !this.ch.channelClosed()) {
                Option<Throwable> option = cause;
                if (option instanceof Some) {
                    Throwable c = (Throwable)((Some)option).value();
                    Logger Logger_this = this.$outer.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$logger;
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error(new StringBuilder(35).append("Listening socket(").append(this.ch.socketAddress()).append(") closed forcibly.").toString(), c);
                    }
                } else if (None$.MODULE$.equals(option)) {
                    Logger Logger_this = this.$outer.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$logger;
                    if (Logger_this.isInfoEnabled()) {
                        Logger_this.info(new StringBuilder(26).append("Listening socket(").append(this.ch.socketAddress()).append(") closed.").toString());
                    }
                } else {
                    throw new MatchError(option);
                }
                this.doClose();
                return;
            }
        }

        private void doClose() {
            this.ch.close();
        }

        private void acceptNewConnections() {
            while (true) {
                this.$outer.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$connections.acquire();
                SocketChannel child = this.ch.selectableChannel().accept();
                if (child == null) break;
                NIO1ClientChannel channel = new NIO1ClientChannel(child, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.$outer.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$connections.release());
                this.$outer.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$handleClientChannel(channel, this.service);
            }
            this.$outer.org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$$connections.release();
        }

        public final /* synthetic */ NIO1SocketServerGroup org$http4s$blaze$channel$nio1$NIO1SocketServerGroup$SocketAcceptor$$$outer() {
            return this.$outer;
        }
    }
}

