/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.channel.nio2;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ShutdownChannelGroupException;
import java.util.concurrent.TimeUnit;
import org.http4s.blaze.channel.ChannelHead;
import org.http4s.blaze.pipeline.Command$EOF$;
import org.http4s.blaze.util.BufferTools$;
import org.http4s.blaze.util.package$;
import org.slf4j.Logger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Null$;

public final class ByteBufferHead
extends ChannelHead {
    private final AsynchronousSocketChannel channel;
    private final int bufferSize;
    private volatile Option<Throwable> closeReason;
    public final ByteBuffer org$http4s$blaze$channel$nio2$ByteBufferHead$$scratchBuffer;

    public ByteBufferHead(AsynchronousSocketChannel channel, int bufferSize) {
        this.channel = channel;
        this.bufferSize = bufferSize;
        this.closeReason = None$.MODULE$;
        this.org$http4s$blaze$channel$nio2$ByteBufferHead$$scratchBuffer = ByteBuffer.allocateDirect(bufferSize);
    }

    @Override
    public String name() {
        return "ByteBufferHeadStage";
    }

    @Override
    public Future<BoxedUnit> writeRequest(ByteBuffer data) {
        return this.writeRequest((Seq<ByteBuffer>)scala.package$.MODULE$.Nil().$colon$colon((Object)data));
    }

    @Override
    public Future<BoxedUnit> writeRequest(Seq<ByteBuffer> data) {
        Option<Throwable> option = this.closeReason;
        if (option instanceof Some) {
            Throwable cause = (Throwable)((Some)option).value();
            return Future$.MODULE$.failed(cause);
        }
        if (None$.MODULE$.equals(option)) {
            if (data.isEmpty()) {
                return package$.MODULE$.FutureUnit();
            }
            Promise p = Promise$.MODULE$.apply();
            ByteBuffer[] srcs = (ByteBuffer[])data.toArray(ClassTag$.MODULE$.apply(ByteBuffer.class));
            this.org$http4s$blaze$channel$nio2$ByteBufferHead$$_$go$1(srcs, p, 0);
            return p.future();
        }
        throw new MatchError(option);
    }

    @Override
    public Future<ByteBuffer> readRequest(int size) {
        Promise p = Promise$.MODULE$.apply();
        this.org$http4s$blaze$channel$nio2$ByteBufferHead$$scratchBuffer.clear();
        if (size >= 0 && size < this.bufferSize) {
            this.org$http4s$blaze$channel$nio2$ByteBufferHead$$scratchBuffer.limit(size);
        }
        this.channel.read(this.org$http4s$blaze$channel$nio2$ByteBufferHead$$scratchBuffer, null, new CompletionHandler<Integer, Null$>(p, this){
            private final Promise p$3;
            private final /* synthetic */ ByteBufferHead $outer;
            {
                this.p$3 = p$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void failed(Throwable exc, Null$ attachment) {
                Throwable e = this.$outer.checkError(exc);
                this.p$3.failure(e);
            }

            public void completed(Integer i, Null$ attachment) {
                int n = i;
                if (0 == n) {
                    this.p$3.success((Object)BufferTools$.MODULE$.emptyBuffer());
                    return;
                }
                int i2 = n;
                if (i2 < 0) {
                    this.p$3.failure((Throwable)Command$EOF$.MODULE$);
                    return;
                }
                this.$outer.org$http4s$blaze$channel$nio2$ByteBufferHead$$scratchBuffer.flip();
                this.p$3.success((Object)BufferTools$.MODULE$.copyBuffer(this.$outer.org$http4s$blaze$channel$nio2$ByteBufferHead$$scratchBuffer));
            }
        });
        return p.future();
    }

    @Override
    public Throwable checkError(Throwable e) {
        Throwable throwable = e;
        if (throwable instanceof ShutdownChannelGroupException) {
            ShutdownChannelGroupException e2 = (ShutdownChannelGroupException)throwable;
            Logger Logger_this = this.logger();
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug("Channel Group was shutdown", (Throwable)e2);
            }
            return Command$EOF$.MODULE$;
        }
        Throwable t = throwable;
        return super.checkError(t);
    }

    @Override
    public void doClosePipeline(Option<Throwable> cause) {
        boolean bl;
        ByteBufferHead byteBufferHead = this;
        synchronized (byteBufferHead) {
            Option<Throwable> reason;
            Option<Throwable> option = reason = this.closeReason;
            if (None$.MODULE$.equals(option) || option instanceof Some && Command$EOF$.MODULE$.equals(((Some)option).value())) {
                this.closeReason = Some$.MODULE$.apply(cause.getOrElse(ByteBufferHead::$anonfun$1));
            }
            bl = reason.isEmpty();
        }
        boolean needsClose = bl;
        Option<Throwable> option = cause;
        if (option instanceof Some) {
            Throwable t = (Throwable)((Some)option).value();
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("NIO2 channel closed with error", t);
            }
        } else if (None$.MODULE$.equals(option)) {
            Logger Logger_this = this.logger();
            if (Logger_this.isDebugEnabled()) {
                Logger_this.debug("doClosePipeline(None)");
            }
        } else {
            throw new MatchError(option);
        }
        if (needsClose) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {}
            return;
        }
    }

    public final void org$http4s$blaze$channel$nio2$ByteBufferHead$$_$go$1(ByteBuffer[] srcs$1, Promise p$1, int index) {
        this.channel.write(srcs$1, index, srcs$1.length - index, -1L, TimeUnit.MILLISECONDS, null, new CompletionHandler<Long, Null$>(p$1, srcs$1, this){
            private final Promise p$2;
            private final ByteBuffer[] srcs$2;
            private final /* synthetic */ ByteBufferHead $outer;
            {
                this.p$2 = p$4;
                this.srcs$2 = srcs$3;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void failed(Throwable exc, Null$ attachment) {
                Throwable e = this.$outer.checkError(exc);
                this.p$2.tryFailure(e);
            }

            public void completed(Long result, Null$ attachment) {
                if (!BufferTools$.MODULE$.checkEmpty(this.srcs$2)) {
                    this.$outer.org$http4s$blaze$channel$nio2$ByteBufferHead$$_$go$1(this.srcs$2, this.p$2, BufferTools$.MODULE$.dropEmpty(this.srcs$2));
                    return;
                }
                this.p$2.success((Object)BoxedUnit.UNIT);
            }
        });
    }

    private static final Throwable $anonfun$1() {
        return Command$EOF$.MODULE$;
    }
}

