/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.http.http2;

import com.twitter.hpack.Decoder;
import com.twitter.hpack.HeaderListener;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.http4s.blaze.http.http2.ByteBufferInputStream;
import org.http4s.blaze.http.http2.Continue$;
import org.http4s.blaze.http.http2.Error$;
import org.http4s.blaze.http.http2.Http2Exception$;
import org.http4s.blaze.http.http2.Http2Settings$DefaultSettings$;
import org.http4s.blaze.http.http2.MaybeError;
import org.http4s.blaze.util.BufferTools$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.immutable.VectorBuilder;
import scala.util.control.NonFatal$;

public final class HeaderDecoder {
    private final int maxHeaderListSize;
    public final boolean org$http4s$blaze$http$http2$HeaderDecoder$$discardOverflowHeaders;
    private final int maxTableSize;
    public final VectorBuilder<Tuple2<String, String>> org$http4s$blaze$http$http2$HeaderDecoder$$acc;
    private ByteBuffer leftovers;
    public int org$http4s$blaze$http$http2$HeaderDecoder$$headerBlockSize;
    private boolean sawEndHeaders;
    private final Decoder decoder;
    private final HeaderListener listener;

    public HeaderDecoder(int maxHeaderListSize, boolean discardOverflowHeaders, int maxTableSize) {
        this.maxHeaderListSize = maxHeaderListSize;
        this.org$http4s$blaze$http$http2$HeaderDecoder$$discardOverflowHeaders = discardOverflowHeaders;
        this.maxTableSize = maxTableSize;
        Predef$.MODULE$.require(maxTableSize >= Http2Settings$DefaultSettings$.MODULE$.HEADER_TABLE_SIZE());
        this.org$http4s$blaze$http$http2$HeaderDecoder$$acc = new VectorBuilder();
        this.leftovers = null;
        this.org$http4s$blaze$http$http2$HeaderDecoder$$headerBlockSize = 0;
        this.sawEndHeaders = false;
        this.decoder = new Decoder(maxHeaderListSize, maxTableSize);
        this.listener = new HeaderListener(this){
            private final /* synthetic */ HeaderDecoder $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void addHeader(byte[] name, byte[] value, boolean sensitive) {
                this.$outer.org$http4s$blaze$http$http2$HeaderDecoder$$headerBlockSize += 32 + name.length + value.length;
                if (!this.$outer.org$http4s$blaze$http$http2$HeaderDecoder$$discardOverflowHeaders || !this.$outer.headerListSizeOverflow()) {
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)new String(name, StandardCharsets.US_ASCII));
                    this.$outer.org$http4s$blaze$http$http2$HeaderDecoder$$acc.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)new String(value, StandardCharsets.US_ASCII)));
                    return;
                }
            }
        };
    }

    public int maxTableSize() {
        return this.maxTableSize;
    }

    public void setMaxHeaderTableSize(int max2) {
        this.decoder.setMaxHeaderTableSize(max2);
    }

    public Seq<Tuple2<String, String>> finish() {
        if (!this.sawEndHeaders) {
            throw new IllegalStateException("Should only be called after decoding the a terminating header fragment");
        }
        this.leftovers = null;
        this.org$http4s$blaze$http$http2$HeaderDecoder$$headerBlockSize = 0;
        this.sawEndHeaders = false;
        Vector result = this.org$http4s$blaze$http$http2$HeaderDecoder$$acc.result();
        this.org$http4s$blaze$http$http2$HeaderDecoder$$acc.clear();
        return result;
    }

    public int currentHeaderBlockSize() {
        return this.org$http4s$blaze$http$http2$HeaderDecoder$$headerBlockSize;
    }

    public boolean headerListSizeOverflow() {
        return this.currentHeaderBlockSize() > this.maxHeaderListSize;
    }

    public MaybeError decode(ByteBuffer buffer, int streamId, boolean endHeaders) {
        return this.doDecode(buffer, streamId, endHeaders, this.listener);
    }

    private MaybeError doDecode(ByteBuffer buffer, int streamId, boolean endHeaders, HeaderListener listener) {
        MaybeError maybeError;
        if (this.sawEndHeaders) {
            throw new IllegalStateException("called doDecode() after receiving an endHeaders flag");
        }
        try {
            this.sawEndHeaders = endHeaders;
            ByteBuffer buff = BufferTools$.MODULE$.concatBuffers(this.leftovers, buffer);
            this.decoder.decode(new ByteBufferInputStream(buff), listener);
            if (!buff.hasRemaining()) {
                this.leftovers = null;
            } else if (buff != buffer) {
                this.leftovers = buff;
            } else {
                ByteBuffer b = BufferTools$.MODULE$.allocate(buff.remaining());
                b.put(buff).flip();
                this.leftovers = b;
            }
            if (endHeaders) {
                this.decoder.endHeaderBlock();
            }
            maybeError = Continue$.MODULE$;
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                maybeError = Error$.MODULE$.apply(Http2Exception$.MODULE$.COMPRESSION_ERROR().goaway(new StringBuilder(28).append("Compression error on stream ").append(streamId).toString()));
            }
            throw throwable;
        }
        return maybeError;
    }
}

