/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.pipeline;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import org.http4s.blaze.pipeline.Command$Connected$;
import org.http4s.blaze.pipeline.Command$Disconnected$;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.HeadStage;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.util.Cancelable;
import org.http4s.blaze.util.Execution$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.control.NonFatal$;

public interface Tail<I>
extends Stage {
    public static void $init$(Tail $this) {
        $this._prevStage_$eq(null);
    }

    public Head<I> _prevStage();

    public void _prevStage_$eq(Head<I> var1);

    public static void closePipeline$(Tail $this, Option cause) {
        $this.closePipeline((Option<Throwable>)cause);
    }

    @Override
    default public void closePipeline(Option<Throwable> cause) {
        this.stageShutdown();
        Head<I> prev = this._prevStage();
        if (prev != null) {
            prev.closePipeline(cause);
            return;
        }
    }

    public static Future channelRead$(Tail $this, int size, Duration timeout) {
        return $this.channelRead(size, timeout);
    }

    default public Future<I> channelRead(int size, Duration timeout) {
        Object object;
        try {
            if (this._prevStage() != null) {
                Future<I> f = this._prevStage().readRequest(size);
                object = this.checkTimeout(timeout, f);
            } else {
                object = this._stageDisconnected();
            }
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable t = throwable3 = (Throwable)option.get();
                object = Future$.MODULE$.failed(t);
            }
            throw throwable;
        }
        return object;
    }

    public static int channelRead$default$1$(Tail $this) {
        return $this.channelRead$default$1();
    }

    default public int channelRead$default$1() {
        return -1;
    }

    public static Duration channelRead$default$2$(Tail $this) {
        return $this.channelRead$default$2();
    }

    default public Duration channelRead$default$2() {
        return Duration$.MODULE$.Inf();
    }

    public static Future channelWrite$(Tail $this, Object data) {
        return $this.channelWrite(data);
    }

    default public Future<BoxedUnit> channelWrite(I data) {
        if (this._prevStage() != null) {
            Future future;
            try {
                future = this._prevStage().writeRequest(data);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    future = Future$.MODULE$.failed(t);
                }
                throw throwable;
            }
            return future;
        }
        return this._stageDisconnected();
    }

    public static Future channelWrite$(Tail $this, Object data, Duration timeout) {
        return $this.channelWrite(data, timeout);
    }

    default public Future<BoxedUnit> channelWrite(I data, Duration timeout) {
        Future<BoxedUnit> f = this.channelWrite(data);
        return this.checkTimeout(timeout, f);
    }

    public static Future channelWrite$(Tail $this, Seq data) {
        return $this.channelWrite(data);
    }

    default public Future<BoxedUnit> channelWrite(Seq<I> data) {
        if (this._prevStage() != null) {
            Future future;
            try {
                future = this._prevStage().writeRequest(data);
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable t = throwable3 = (Throwable)option.get();
                    future = Future$.MODULE$.failed(t);
                }
                throw throwable;
            }
            return future;
        }
        return this._stageDisconnected();
    }

    public static Future channelWrite$(Tail $this, Seq data, Duration timeout) {
        return $this.channelWrite(data, timeout);
    }

    default public Future<BoxedUnit> channelWrite(Seq<I> data, Duration timeout) {
        Future<BoxedUnit> f = this.channelWrite(data);
        return this.checkTimeout(timeout, f);
    }

    public static void spliceBefore$(Tail $this, MidStage stage) {
        $this.spliceBefore(stage);
    }

    default public void spliceBefore(MidStage<I, I> stage) {
        if (this._prevStage() != null) {
            stage._prevStage_$eq(this._prevStage());
            stage._nextStage_$eq(this);
            this._prevStage()._nextStage_$eq(stage);
            this._prevStage_$eq(stage);
            return;
        }
        Exception e = new Exception("Cannot splice stage before a disconnected stage");
        throw e;
    }

    public static Option findOutboundStage$(Tail $this, String name) {
        return $this.findOutboundStage(name);
    }

    default public Option<Stage> findOutboundStage(String name) {
        Head<I> head;
        while (true) {
            String string = this_.name();
            String string2 = name;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                return Some$.MODULE$.apply((Object)this_);
            }
            if (this_._prevStage() == null) {
                return None$.MODULE$;
            }
            head = this_._prevStage();
            if (!(head instanceof Tail)) break;
            Head s2 = (Head)((Object)((Tail)((Object)head)));
            Tail this_ = (Tail)((Object)s2);
        }
        Head<I> t = head;
        String string = t.name();
        String string3 = name;
        if (!(string != null ? !string.equals(string3) : string3 != null)) {
            return Some$.MODULE$.apply(t);
        }
        return None$.MODULE$;
    }

    public static Option findOutboundStage$(Tail $this, Class clazz) {
        return $this.findOutboundStage(clazz);
    }

    default public <C extends Stage> Option<C> findOutboundStage(Class<C> clazz) {
        Head<I> head;
        while (true) {
            if (clazz.isAssignableFrom(this_.getClass())) {
                return Some$.MODULE$.apply((Object)this_);
            }
            if (this_._prevStage() == null) {
                return None$.MODULE$;
            }
            head = this_._prevStage();
            if (!(head instanceof Tail)) break;
            Head s2 = (Head)((Object)((Tail)((Object)head)));
            Tail this_ = (Tail)((Object)s2);
        }
        Head<I> t = head;
        if (clazz.isAssignableFrom(t.getClass())) {
            return Some$.MODULE$.apply(t);
        }
        return None$.MODULE$;
    }

    public static Tail replaceTail$(Tail $this, LeafBuilder leafBuilder, boolean startup) {
        return $this.replaceTail(leafBuilder, startup);
    }

    default public Tail replaceTail(LeafBuilder<I> leafBuilder, boolean startup) {
        this.stageShutdown();
        if (this._prevStage() != null) {
            Object object;
            Tail tail = this;
            if (tail instanceof MidStage) {
                MidStage m = (MidStage)tail;
                m.sendInboundCommand(Command$Disconnected$.MODULE$);
                m._nextStage_$eq(null);
            }
            Head<I> prev = this._prevStage();
            this._prevStage()._nextStage_$eq(null);
            this._prevStage_$eq(null);
            Head<I> head = prev;
            if (head instanceof MidStage) {
                MidStage m = (MidStage)head;
                object = leafBuilder.prepend(m);
            } else if (head instanceof HeadStage) {
                HeadStage h = (HeadStage)head;
                object = leafBuilder.base(h);
            } else {
                throw new MatchError(head);
            }
            if (startup) {
                prev.sendInboundCommand(Command$Connected$.MODULE$);
            }
        }
        return this;
    }

    private <T> Future<T> checkTimeout(Duration timeout, Future<T> f) {
        if (timeout.isFinite()) {
            Promise p = Promise$.MODULE$.apply();
            this.scheduleTimeout(p, f, timeout);
            return p.future();
        }
        return f;
    }

    private <T> void scheduleTimeout(Promise<T> p, Future<T> f, Duration timeout) {
        Runnable r = new Runnable(p){
            private final Promise p$1;
            {
                this.p$1 = p$3;
            }

            public void run() {
                TimeoutException a = new TimeoutException("Read request timed out");
                this.p$1.tryFailure((Throwable)a);
            }
        };
        Cancelable ecf = Execution$.MODULE$.scheduler().schedule(r, timeout);
        f.onComplete((Function1 & Serializable)t -> {
            ecf.cancel();
            return p.tryComplete(t);
        }, Execution$.MODULE$.directec());
    }

    private Future<Nothing$> _stageDisconnected() {
        return Future$.MODULE$.failed((Throwable)new Exception(new StringBuilder(30).append("This stage '").append(this.name()).append("' isn't connected!").toString()));
    }
}

