/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.util;

import java.util.ArrayDeque;
import org.http4s.blaze.util.Execution$;
import org.http4s.blaze.util.TickWheelExecutor;
import scala.Option;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class Execution {
    public static ExecutionContext directec() {
        return Execution$.MODULE$.directec();
    }

    public static TickWheelExecutor scheduler() {
        return Execution$.MODULE$.scheduler();
    }

    public static ExecutionContext trampoline() {
        return Execution$.MODULE$.trampoline();
    }

    public static <T> Future<T> withTimeout(Duration duration, Try<T> try_, Future<T> future) {
        return Execution$.MODULE$.withTimeout(duration, try_, future);
    }

    public static final class ThreadLocalTrampoline
    implements ExecutionContext {
        private boolean running;
        private Runnable r0;
        private Runnable r1;
        private Runnable r2;
        private ArrayDeque<Runnable> rest;

        public ThreadLocalTrampoline() {
            ExecutionContext.$init$((ExecutionContext)this);
            this.running = false;
            this.r0 = null;
            this.r1 = null;
            this.r2 = null;
            this.rest = null;
        }

        public void execute(Runnable runnable) {
            Object object;
            if (this.r0 == null) {
                this.r0 = runnable;
                object = BoxedUnit.UNIT;
            } else if (this.r1 == null) {
                this.r1 = runnable;
                object = BoxedUnit.UNIT;
            } else if (this.r2 == null) {
                this.r2 = runnable;
                object = BoxedUnit.UNIT;
            } else {
                if (this.rest == null) {
                    this.rest = new ArrayDeque();
                }
                object = BoxesRunTime.boxToBoolean((boolean)this.rest.add(runnable));
            }
            if (!this.running) {
                this.running = true;
                this.run();
                return;
            }
        }

        public void reportFailure(Throwable cause) {
            Execution$.MODULE$.org$http4s$blaze$util$Execution$$$trampolineFailure(cause);
        }

        private void run() {
            Throwable throwable2;
            while (true) {
                Runnable r;
                if ((r = this.next()) == null) {
                    this.rest = null;
                    this.running = false;
                    return;
                }
                try {
                    r.run();
                }
                catch (Throwable throwable2) {
                    Throwable throwable3;
                    Option option;
                    Throwable throwable4 = throwable2;
                    if (throwable4 == null || (option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) break;
                    Throwable t = throwable3 = (Throwable)option.get();
                    this.reportFailure(t);
                }
            }
            {
                throw throwable2;
            }
        }

        private Runnable next() {
            Runnable r = this.r0;
            this.r0 = this.r1;
            this.r1 = this.r2;
            this.r2 = this.rest != null ? this.rest.pollFirst() : null;
            return r;
        }
    }
}

