/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blaze.util;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReference;
import org.http4s.blaze.util.TaskQueue$;
import org.http4s.blaze.util.TaskQueue$Closed$;
import org.http4s.blaze.util.TaskQueue$Enqueued$;
import org.http4s.blaze.util.TaskQueue$FirstEnqueued$;
import org.slf4j.Logger;
import scala.Option;
import scala.Product;
import scala.deriving.Mirror;
import scala.util.control.ControlThrowable;
import scala.util.control.NonFatal$;

public final class TaskQueue {
    private final AtomicReference<Node> queueHead = new AtomicReference<Object>(null);
    private final AtomicReference<Node> queueTail = new AtomicReference<Object>(null);

    public boolean isClosed() {
        return this.queueTail.get() == TaskQueue$.org$http4s$blaze$util$TaskQueue$$$ClosedNode;
    }

    public boolean needsExecution() {
        return this.queueHead.get() != null;
    }

    public void close() {
        Node tail = this.queueTail.getAndSet(TaskQueue$.org$http4s$blaze$util$TaskQueue$$$ClosedNode);
        if (tail != null) {
            tail.lazySet(TaskQueue$.org$http4s$blaze$util$TaskQueue$$$ClosedNode);
            this.executeTasks();
            return;
        }
    }

    public Result enqueueTask(Runnable runnable) {
        Node node = new Node(runnable);
        return this.loop$1(node);
    }

    public void executeTasks() {
        Node t = this.queueHead.getAndSet(null);
        if (t != null) {
            this.go$1(t);
            return;
        }
    }

    private final Result loop$1(Node node$1) {
        Mirror.Singleton singleton;
        Node tail;
        do {
            Node node = tail = this.queueTail.get();
            Node node2 = TaskQueue$.org$http4s$blaze$util$TaskQueue$$$ClosedNode;
            if (node != null ? !node.equals(node2) : node2 != null) continue;
            return TaskQueue$Closed$.MODULE$;
        } while (!this.queueTail.compareAndSet(tail, node$1));
        if (tail != null) {
            tail.lazySet(node$1);
            singleton = TaskQueue$Enqueued$.MODULE$;
        } else {
            this.queueHead.set(node$1);
            singleton = TaskQueue$FirstEnqueued$.MODULE$;
        }
        return singleton;
    }

    private static final Node spin$1(Node node) {
        Node next;
        while ((next = (Node)node.get()) == null) {
        }
        return next;
    }

    private final void go$1(Node node) {
        while (node != TaskQueue$.org$http4s$blaze$util$TaskQueue$$$ClosedNode) {
            try {
                node.runnable().run();
            }
            catch (Throwable throwable) {
                block9: {
                    Throwable throwable2;
                    block8: {
                        block7: {
                            Option option;
                            throwable2 = throwable;
                            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) break block7;
                            Throwable throwable3 = (Throwable)option.get();
                            break block8;
                        }
                        if (!(throwable2 instanceof ControlThrowable)) break block9;
                    }
                    Throwable t = throwable2;
                    Logger Logger_this = TaskQueue$.org$http4s$blaze$util$TaskQueue$$$logger;
                    if (Logger_this.isErrorEnabled()) {
                        Logger_this.error("Caught exception in queued task", t);
                    }
                }
                throw throwable;
            }
            Node next = (Node)node.get();
            if (next == null) {
                if (!this.queueTail.compareAndSet(node, null)) {
                    node = TaskQueue.spin$1(node);
                    continue;
                }
                return;
            }
            node = next;
        }
    }

    public static class Node
    extends AtomicReference<Node> {
        private final Runnable runnable;

        public Node(Runnable runnable) {
            this.runnable = runnable;
        }

        public Runnable runnable() {
            return this.runnable;
        }
    }

    public static interface Result
    extends Product,
    Serializable {
    }
}

