/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blazecore;

import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.http4s.blaze.pipeline.Command;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.MidStage;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.util.Cancelable;
import org.http4s.blaze.util.Execution$;
import org.http4s.blaze.util.TickWheelExecutor;
import org.http4s.blaze.util.TickWheelExecutor$AlreadyShutdownException$;
import org.http4s.blazecore.IdleTimeoutStage$Disabled$;
import org.http4s.blazecore.IdleTimeoutStage$Enabled$;
import org.http4s.blazecore.IdleTimeoutStage$ShutDown$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Try;
import scala.util.control.NonFatal$;

public final class IdleTimeoutStage<A>
implements MidStage<A, A> {
    private Logger logger;
    private Head _prevStage;
    private Tail _nextStage;
    public final FiniteDuration org$http4s$blazecore$IdleTimeoutStage$$timeout;
    private final TickWheelExecutor exec;
    private final ExecutionContext ec;
    private final AtomicReference<State> timeoutState;

    public IdleTimeoutStage(FiniteDuration timeout, TickWheelExecutor exec, ExecutionContext ec) {
        this.org$http4s$blazecore$IdleTimeoutStage$$timeout = timeout;
        this.exec = exec;
        this.ec = ec;
        Stage.$init$(this);
        Tail.$init$(this);
        Head.$init$(this);
        this.timeoutState = new AtomicReference<IdleTimeoutStage$Disabled$>(IdleTimeoutStage$Disabled$.MODULE$);
        Statics.releaseFence();
    }

    @Override
    public final Logger logger() {
        return this.logger;
    }

    @Override
    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    @Override
    public Head _prevStage() {
        return this._prevStage;
    }

    @Override
    public void _prevStage_$eq(Head x$1) {
        this._prevStage = x$1;
    }

    @Override
    public Tail _nextStage() {
        return this._nextStage;
    }

    @Override
    public void _nextStage_$eq(Tail x$1) {
        this._nextStage = x$1;
    }

    @Override
    public /* synthetic */ void org$http4s$blaze$pipeline$Head$$super$inboundCommand(Command.InboundCommand cmd) {
        Stage.inboundCommand$(this, cmd);
    }

    @Override
    public String name() {
        return "IdleTimeoutStage";
    }

    @Override
    public Future<A> readRequest(int size) {
        return this.channelRead(size, this.channelRead$default$2()).andThen((PartialFunction)new Serializable(this){
            private final /* synthetic */ IdleTimeoutStage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Try x) {
                Try try_ = x;
                return true;
            }

            public final Object applyOrElse(Try x, Function1 function1) {
                Try try_ = x;
                this.$outer.org$http4s$blazecore$IdleTimeoutStage$$resetTimeout();
                return BoxedUnit.UNIT;
            }
        }, Execution$.MODULE$.directec());
    }

    @Override
    public Future<BoxedUnit> writeRequest(A data) {
        this.org$http4s$blazecore$IdleTimeoutStage$$resetTimeout();
        return this.channelWrite(data);
    }

    @Override
    public Future<BoxedUnit> writeRequest(Seq<A> data) {
        this.org$http4s$blazecore$IdleTimeoutStage$$resetTimeout();
        return this.channelWrite((Seq)data);
    }

    @Override
    public void stageShutdown() {
        Logger Logger_this = this.logger();
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug("Shutting down idle timeout stage");
        }
        this.go$1();
        Stage.stageShutdown$(this);
    }

    public void init(Function1<Either<Throwable, TimeoutException>, BoxedUnit> cb) {
        this.setTimeout(cb);
    }

    public void setTimeout(Function1<Either<Throwable, TimeoutException>, BoxedUnit> cb) {
        Logger Logger_this = this.logger();
        if (Logger_this.isDebugEnabled()) {
            Logger_this.debug(new StringBuilder(41).append("Starting idle timeout with timeout of ").append(this.org$http4s$blazecore$IdleTimeoutStage$$timeout.toMillis()).append(" ms").toString());
        }
        Runnable timeoutTask = new Runnable(cb, this){
            private final Function1 cb$1;
            private final /* synthetic */ IdleTimeoutStage $outer;
            {
                this.cb$1 = cb$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void run() {
                TimeoutException t = new TimeoutException(new StringBuilder(23).append("Idle timeout after ").append(this.$outer.org$http4s$blazecore$IdleTimeoutStage$$timeout.toMillis()).append(" ms.").toString());
                Logger Logger_this = this.$outer.logger();
                if (Logger_this.isDebugEnabled()) {
                    Logger_this.debug(t.getMessage());
                }
                this.cb$1.apply((Object)package$.MODULE$.Right().apply((Object)t));
            }
        };
        this.go$2(timeoutTask);
    }

    public void org$http4s$blazecore$IdleTimeoutStage$$resetTimeout() {
        State state;
        while ((state = this.timeoutState.get()) instanceof Enabled) {
            Enabled enabled = (Enabled)state;
            Enabled enabled2 = IdleTimeoutStage$Enabled$.MODULE$.unapply(enabled);
            Runnable runnable = enabled2._1();
            Cancelable cancelable = enabled2._2();
            Runnable timeoutTask = runnable;
            Cancelable oldCancel = cancelable;
            Enabled old = enabled;
            Option<Cancelable> option = this.tryScheduling(timeoutTask);
            if (option instanceof Some) {
                Cancelable newCancel = (Cancelable)((Some)option).value();
                if (this.timeoutState.compareAndSet(old, IdleTimeoutStage$Enabled$.MODULE$.apply(timeoutTask, newCancel))) {
                    oldCancel.cancel();
                    return;
                }
                newCancel.cancel();
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                return;
            }
            throw new MatchError(option);
        }
    }

    public void cancelTimeout() {
        State state;
        while ((state = this.timeoutState.get()) instanceof Enabled) {
            Cancelable cancelable;
            Enabled enabled = (Enabled)state;
            Enabled enabled2 = IdleTimeoutStage$Enabled$.MODULE$.unapply(enabled);
            Runnable runnable = enabled2._1();
            Cancelable cancel = cancelable = enabled2._2();
            Enabled old = enabled;
            if (!this.timeoutState.compareAndSet(old, IdleTimeoutStage$Disabled$.MODULE$)) continue;
            cancel.cancel();
            return;
        }
    }

    public Option<Cancelable> tryScheduling(Runnable timeoutTask) {
        if (this.exec.isAlive()) {
            Some some;
            try {
                some = Some$.MODULE$.apply((Object)this.exec.schedule(timeoutTask, this.ec, (Duration)this.org$http4s$blazecore$IdleTimeoutStage$$timeout));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (TickWheelExecutor$AlreadyShutdownException$.MODULE$.equals(throwable2)) {
                    Logger Logger_this = this.logger();
                    if (Logger_this.isWarnEnabled()) {
                        Logger_this.warn("Resetting timeout after tickwheelexecutor is shutdown");
                    }
                    some = None$.MODULE$;
                }
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e = throwable3 = (Throwable)option.get();
                    throw e;
                }
                throw throwable;
            }
            return some;
        }
        return None$.MODULE$;
    }

    private final void go$1() {
        while (true) {
            State state;
            if ((state = this.timeoutState.get()) instanceof Enabled) {
                Cancelable cancelable;
                Enabled enabled = (Enabled)state;
                Enabled enabled2 = IdleTimeoutStage$Enabled$.MODULE$.unapply(enabled);
                Runnable runnable = enabled2._1();
                Cancelable cancel = cancelable = enabled2._2();
                Enabled old = enabled;
                if (!this.timeoutState.compareAndSet(old, IdleTimeoutStage$ShutDown$.MODULE$)) continue;
                cancel.cancel();
                return;
            }
            State old = state;
            if (this.timeoutState.compareAndSet(old, IdleTimeoutStage$ShutDown$.MODULE$)) break;
        }
    }

    private final void go$2(Runnable timeoutTask$1) {
        block7: {
            Option<Cancelable> option;
            while (true) {
                Cancelable cancelable;
                State state;
                if (IdleTimeoutStage$Disabled$.MODULE$.equals(state = this.timeoutState.get())) {
                    Option<Cancelable> option2 = this.tryScheduling(timeoutTask$1);
                    if (option2 instanceof Some) {
                        Cancelable newCancel = (Cancelable)((Some)option2).value();
                        if (this.timeoutState.compareAndSet(IdleTimeoutStage$Disabled$.MODULE$, IdleTimeoutStage$Enabled$.MODULE$.apply(timeoutTask$1, newCancel))) {
                            return;
                        }
                        newCancel.cancel();
                        continue;
                    }
                    if (None$.MODULE$.equals(option2)) {
                        return;
                    }
                    throw new MatchError(option2);
                }
                if (!(state instanceof Enabled)) break block7;
                Enabled enabled = (Enabled)state;
                Enabled enabled2 = IdleTimeoutStage$Enabled$.MODULE$.unapply(enabled);
                Runnable runnable = enabled2._1();
                Cancelable oldCancel = cancelable = enabled2._2();
                Enabled old = enabled;
                option = this.tryScheduling(timeoutTask$1);
                if (!(option instanceof Some)) break;
                Cancelable newCancel = (Cancelable)((Some)option).value();
                if (this.timeoutState.compareAndSet(old, IdleTimeoutStage$Enabled$.MODULE$.apply(timeoutTask$1, newCancel))) {
                    oldCancel.cancel();
                    return;
                }
                newCancel.cancel();
            }
            if (None$.MODULE$.equals(option)) {
                return;
            }
            throw new MatchError(option);
        }
    }

    public static class Enabled
    implements State,
    Product,
    Serializable {
        private final Runnable timeoutTask;
        private final Cancelable cancel;

        public static Enabled apply(Runnable runnable, Cancelable cancelable) {
            return IdleTimeoutStage$Enabled$.MODULE$.apply(runnable, cancelable);
        }

        public static Enabled fromProduct(Product product) {
            return IdleTimeoutStage$Enabled$.MODULE$.fromProduct(product);
        }

        public static Enabled unapply(Enabled enabled) {
            return IdleTimeoutStage$Enabled$.MODULE$.unapply(enabled);
        }

        public Enabled(Runnable timeoutTask, Cancelable cancel) {
            this.timeoutTask = timeoutTask;
            this.cancel = cancel;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Enabled)) return false;
            Enabled enabled = (Enabled)object;
            Runnable runnable = this.timeoutTask();
            Runnable runnable2 = enabled.timeoutTask();
            if (runnable == null) {
                if (runnable2 != null) {
                    return false;
                }
            } else if (!runnable.equals(runnable2)) return false;
            Cancelable cancelable = this.cancel();
            Cancelable cancelable2 = enabled.cancel();
            if (cancelable == null) {
                if (cancelable2 != null) {
                    return false;
                }
            } else if (!cancelable.equals(cancelable2)) return false;
            if (!enabled.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Enabled;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Enabled";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "timeoutTask";
            }
            if (1 == n2) {
                return "cancel";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Runnable timeoutTask() {
            return this.timeoutTask;
        }

        public Cancelable cancel() {
            return this.cancel;
        }

        public Enabled copy(Runnable timeoutTask, Cancelable cancel) {
            return new Enabled(timeoutTask, cancel);
        }

        public Runnable copy$default$1() {
            return this.timeoutTask();
        }

        public Cancelable copy$default$2() {
            return this.cancel();
        }

        public Runnable _1() {
            return this.timeoutTask();
        }

        public Cancelable _2() {
            return this.cancel();
        }
    }

    public static interface State {
    }
}

