/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.blazecore.websocket;

import cats.effect.kernel.Async;
import cats.effect.std.Dispatcher;
import cats.effect.std.Semaphore;
import cats.syntax.ApplicativeErrorOps$;
import cats.syntax.ApplyOps$;
import cats.syntax.FlatMapOps$;
import cats.syntax.IfMOps$;
import cats.syntax.package;
import fs2.Compiler$;
import fs2.Compiler$Target$;
import fs2.Stream;
import fs2.Stream$;
import fs2.concurrent.SignallingRef;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.ProtocolException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.http4s.blaze.pipeline.Command$EOF$;
import org.http4s.blaze.pipeline.Head;
import org.http4s.blaze.pipeline.LeafBuilder;
import org.http4s.blaze.pipeline.Stage;
import org.http4s.blaze.pipeline.Tail;
import org.http4s.blaze.pipeline.TailStage;
import org.http4s.blaze.util.Execution$;
import org.http4s.blazecore.websocket.Http4sWSStage$;
import org.http4s.websocket.ReservedOpcodeException;
import org.http4s.websocket.UnknownOpcodeException;
import org.http4s.websocket.WebSocket;
import org.http4s.websocket.WebSocketCombinedPipe;
import org.http4s.websocket.WebSocketCombinedPipe$;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.WebSocketFrame$Close$;
import org.http4s.websocket.WebSocketFrame$Ping$;
import org.http4s.websocket.WebSocketFrame$Pong$;
import org.http4s.websocket.WebSocketSeparatePipe;
import org.http4s.websocket.WebSocketSeparatePipe$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scodec.bits.ByteVector;

public class Http4sWSStage<F>
implements TailStage<WebSocketFrame> {
    private Logger logger;
    private Head _prevStage;
    private final WebSocket<F> ws;
    private final AtomicBoolean sentClose;
    private final SignallingRef<F, Object> deadSignal;
    private final Semaphore<F> writeSemaphore;
    private final Dispatcher<F> dispatcher;
    public final Async<F> org$http4s$blazecore$websocket$Http4sWSStage$$F;
    private final Object isClosed;
    private final Object setClosed;
    private final Some<F> shutdownCancelToken;

    public static <F> Object apply(WebSocket<F> webSocket, AtomicBoolean atomicBoolean, SignallingRef<F, Object> signallingRef, Dispatcher<F> dispatcher, Async<F> async) {
        return Http4sWSStage$.MODULE$.apply(webSocket, atomicBoolean, signallingRef, dispatcher, async);
    }

    public static <F> LeafBuilder<WebSocketFrame> bufferingSegment(Http4sWSStage<F> http4sWSStage) {
        return Http4sWSStage$.MODULE$.bufferingSegment(http4sWSStage);
    }

    public Http4sWSStage(WebSocket<F> ws, AtomicBoolean sentClose, SignallingRef<F, Object> deadSignal, Semaphore<F> writeSemaphore, Dispatcher<F> dispatcher, Async<F> F) {
        this.ws = ws;
        this.sentClose = sentClose;
        this.deadSignal = deadSignal;
        this.writeSemaphore = writeSemaphore;
        this.dispatcher = dispatcher;
        this.org$http4s$blazecore$websocket$Http4sWSStage$$F = F;
        Stage.$init$(this);
        Tail.$init$(this);
        this.isClosed = F.delay(() -> Http4sWSStage.$init$$$anonfun$1(sentClose));
        this.setClosed = F.delay(() -> Http4sWSStage.$init$$$anonfun$2(sentClose));
        this.shutdownCancelToken = Some$.MODULE$.apply(F.delay((Function0 & Serializable)() -> {
            this.$init$$$anonfun$3();
            return BoxedUnit.UNIT;
        }));
        Statics.releaseFence();
    }

    @Override
    public final Logger logger() {
        return this.logger;
    }

    @Override
    public void org$http4s$blaze$pipeline$Stage$_setter_$logger_$eq(Logger x$0) {
        this.logger = x$0;
    }

    @Override
    public Head _prevStage() {
        return this._prevStage;
    }

    @Override
    public void _prevStage_$eq(Head x$1) {
        this._prevStage = x$1;
    }

    @Override
    public String name() {
        return "Http4s WebSocket Stage";
    }

    public F isClosed() {
        return (F)this.isClosed;
    }

    public F setClosed() {
        return (F)this.setClosed;
    }

    public F evalFrame(WebSocketFrame frame) {
        WebSocketFrame webSocketFrame = frame;
        if (webSocketFrame instanceof WebSocketFrame.Close) {
            WebSocketFrame.Close c = (WebSocketFrame.Close)webSocketFrame;
            Object object = package.all$.MODULE$.catsSyntaxIfM(this.setClosed(), this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
            return (F)IfMOps$.MODULE$.ifM$extension(object, () -> this.evalFrame$$anonfun$1(c), this::evalFrame$$anonfun$2, this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
        }
        return this.writeFrame(frame, Execution$.MODULE$.directec());
    }

    public F snkFun(WebSocketFrame frame) {
        Object object = package.all$.MODULE$.catsSyntaxIfM(this.isClosed(), this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
        return (F)IfMOps$.MODULE$.ifM$extension(object, this::snkFun$$anonfun$1, () -> this.snkFun$$anonfun$2(frame), this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
    }

    private F writeFrame(WebSocketFrame frame, ExecutionContext ec) {
        return (F)this.writeSemaphore.permit().surround(this.org$http4s$blazecore$websocket$Http4sWSStage$$F.async((Function1 & Serializable)cb -> package.all$.MODULE$.toFunctorOps(this.org$http4s$blazecore$websocket$Http4sWSStage$$F.delay((Function0 & Serializable)() -> {
            this.writeFrame$$anonfun$1$$anonfun$1(frame, (Function1)cb, ec);
            return BoxedUnit.UNIT;
        }), this.org$http4s$blazecore$websocket$Http4sWSStage$$F).as(this.shutdownCancelToken)), this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
    }

    private F readFrameTrampoline() {
        return (F)this.org$http4s$blazecore$websocket$Http4sWSStage$$F.async((Function1 & Serializable)cb -> package.all$.MODULE$.toFunctorOps(this.org$http4s$blazecore$websocket$Http4sWSStage$$F.delay((Function0 & Serializable)() -> {
            this.readFrameTrampoline$$anonfun$1$$anonfun$1((Function1)cb);
            return BoxedUnit.UNIT;
        }), this.org$http4s$blazecore$websocket$Http4sWSStage$$F).as(this.shutdownCancelToken));
    }

    private F handleRead() {
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.readFrameTrampoline(), this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
        return (F)package.all$.MODULE$.toFlatMapOps(ApplicativeErrorOps$.MODULE$.recoverWith$extension(object, (PartialFunction)new Serializable(this){
            private final /* synthetic */ Http4sWSStage $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof ReservedOpcodeException) {
                    ReservedOpcodeException t = (ReservedOpcodeException)throwable;
                    return true;
                }
                if (throwable instanceof UnknownOpcodeException) {
                    UnknownOpcodeException t = (UnknownOpcodeException)throwable;
                    return true;
                }
                if (throwable instanceof ProtocolException) {
                    ProtocolException t = (ProtocolException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof ReservedOpcodeException) {
                    ReservedOpcodeException t = (ReservedOpcodeException)throwable;
                    Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.$outer.org$http4s$blazecore$websocket$Http4sWSStage$$F.delay((Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$1(t);
                        return BoxedUnit.UNIT;
                    }));
                    return ApplyOps$.MODULE$.$times$greater$extension(object, this.$outer.org$http4s$blazecore$websocket$Http4sWSStage$$F.fromEither(WebSocketFrame$Close$.MODULE$.apply(1003)), this.$outer.org$http4s$blazecore$websocket$Http4sWSStage$$F);
                }
                if (throwable instanceof UnknownOpcodeException) {
                    UnknownOpcodeException t = (UnknownOpcodeException)throwable;
                    Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.$outer.org$http4s$blazecore$websocket$Http4sWSStage$$F.delay((Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$2(t);
                        return BoxedUnit.UNIT;
                    }));
                    return ApplyOps$.MODULE$.$times$greater$extension(object, this.$outer.org$http4s$blazecore$websocket$Http4sWSStage$$F.fromEither(WebSocketFrame$Close$.MODULE$.apply(1002)), this.$outer.org$http4s$blazecore$websocket$Http4sWSStage$$F);
                }
                if (throwable instanceof ProtocolException) {
                    ProtocolException t = (ProtocolException)throwable;
                    Object object = package.all$.MODULE$.catsSyntaxApplyOps(this.$outer.org$http4s$blazecore$websocket$Http4sWSStage$$F.delay((Function0 & Serializable)() -> {
                        this.applyOrElse$$anonfun$3(t);
                        return BoxedUnit.UNIT;
                    }));
                    return ApplyOps$.MODULE$.$times$greater$extension(object, this.$outer.org$http4s$blazecore$websocket$Http4sWSStage$$F.fromEither(WebSocketFrame$Close$.MODULE$.apply(1002)), this.$outer.org$http4s$blazecore$websocket$Http4sWSStage$$F);
                }
                return function1.apply((Object)x);
            }

            private final void applyOrElse$$anonfun$1(ReservedOpcodeException t$1) {
                Logger Logger_this = this.$outer.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Decoded a websocket frame with a reserved opcode", (Throwable)t$1);
                    return;
                }
            }

            private final void applyOrElse$$anonfun$2(UnknownOpcodeException t$2) {
                Logger Logger_this = this.$outer.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Decoded a websocket frame with an unknown opcode", (Throwable)t$2);
                    return;
                }
            }

            private final void applyOrElse$$anonfun$3(ProtocolException t$3) {
                Logger Logger_this = this.$outer.logger();
                if (Logger_this.isErrorEnabled()) {
                    Logger_this.error("Websocket protocol violation", (Throwable)t$3);
                    return;
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$adapted$2(org.http4s.websocket.ReservedOpcodeException ), $anonfun$adapted$3(org.http4s.websocket.UnknownOpcodeException ), $anonfun$adapted$4(java.net.ProtocolException )}, serializedLambda);
            }
        }, this.org$http4s$blazecore$websocket$Http4sWSStage$$F), this.org$http4s$blazecore$websocket$Http4sWSStage$$F).flatMap((Function1 & Serializable)x$1 -> {
            WebSocketFrame webSocketFrame = x$1;
            if (webSocketFrame instanceof WebSocketFrame.Close) {
                WebSocketFrame.Close c = (WebSocketFrame.Close)webSocketFrame;
                return package.all$.MODULE$.toFlatMapOps(this.org$http4s$blazecore$websocket$Http4sWSStage$$F.delay(this::handleRead$$anonfun$1$$anonfun$1), this.org$http4s$blazecore$websocket$Http4sWSStage$$F).flatMap((Function1 & Serializable)s2 -> this.handleRead$$anonfun$1$$anonfun$2(c, BoxesRunTime.unboxToBoolean((Object)s2)));
            }
            if (webSocketFrame instanceof WebSocketFrame.Ping) {
                ByteVector byteVector;
                WebSocketFrame.Ping ping = (WebSocketFrame.Ping)webSocketFrame;
                WebSocketFrame.Ping ping2 = WebSocketFrame$Ping$.MODULE$.unapply(ping);
                ByteVector d = byteVector = ping2._1();
                WebSocketFrame.Ping p = ping;
                Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(this.writeFrame(WebSocketFrame$Pong$.MODULE$.apply(d), Execution$.MODULE$.trampoline()), this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
                return FlatMapOps$.MODULE$.$greater$greater$extension(object, () -> this.handleRead$$anonfun$1$$anonfun$3(p), this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
            }
            WebSocketFrame rest = webSocketFrame;
            return this.org$http4s$blazecore$websocket$Http4sWSStage$$F.pure((Object)rest);
        });
    }

    public Stream<F, WebSocketFrame> inputstream() {
        return Stream$.MODULE$.repeatEval(this.handleRead());
    }

    @Override
    public void stageStartup() {
        Stream stream;
        Stage.stageStartup$(this);
        Object sendClose = this.org$http4s$blazecore$websocket$Http4sWSStage$$F.delay((Function0 & Serializable)() -> {
            this.$anonfun$1();
            return BoxedUnit.UNIT;
        });
        WebSocket<F> webSocket = this.ws;
        if (webSocket instanceof WebSocketSeparatePipe) {
            WebSocketSeparatePipe webSocketSeparatePipe = WebSocketSeparatePipe$.MODULE$.unapply((WebSocketSeparatePipe)webSocket);
            Stream stream2 = webSocketSeparatePipe._1();
            Function1 function1 = webSocketSeparatePipe._2();
            Object f = webSocketSeparatePipe._3();
            Stream send = stream2;
            Function1 receive = function1;
            stream = send.concurrently((Stream)receive.apply(this.inputstream()), this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
        } else if (webSocket instanceof WebSocketCombinedPipe) {
            WebSocketCombinedPipe webSocketCombinedPipe = WebSocketCombinedPipe$.MODULE$.unapply((WebSocketCombinedPipe)webSocket);
            Function1 function1 = webSocketCombinedPipe._1();
            Object f = webSocketCombinedPipe._2();
            Function1 receiveSend = function1;
            stream = (Stream)receiveSend.apply(this.inputstream());
        } else {
            throw new MatchError(webSocket);
        }
        Stream receiveSent = stream;
        Object object = package.all$.MODULE$.catsSyntaxApplicativeError(this.ws.onClose(), this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
        Object wsStream = receiveSent.evalMap((Function1<WebSocketFrame, Object>)(Function1 & Serializable)frame -> this.snkFun((WebSocketFrame)frame)).drain().interruptWhen(this.deadSignal, this.org$http4s$blazecore$websocket$Http4sWSStage$$F).onFinalizeWeak(package.all$.MODULE$.toFunctorOps(ApplicativeErrorOps$.MODULE$.attempt$extension(object, this.org$http4s$blazecore$websocket$Http4sWSStage$$F), this.org$http4s$blazecore$websocket$Http4sWSStage$$F).void(), this.org$http4s$blazecore$websocket$Http4sWSStage$$F).onFinalizeWeak(sendClose, this.org$http4s$blazecore$websocket$Http4sWSStage$$F).compile(Compiler$.MODULE$.target(Compiler$Target$.MODULE$.forConcurrent(this.org$http4s$blazecore$websocket$Http4sWSStage$$F))).drain();
        Object result = this.org$http4s$blazecore$websocket$Http4sWSStage$$F.handleErrorWith(wsStream, (Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (Command$EOF$.MODULE$.equals(throwable)) {
                return this.org$http4s$blazecore$websocket$Http4sWSStage$$F.delay((Function0 & Serializable)() -> {
                    this.$anonfun$3$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
            }
            Throwable t = throwable;
            return this.org$http4s$blazecore$websocket$Http4sWSStage$$F.delay((Function0 & Serializable)() -> {
                this.$anonfun$3$$anonfun$2(t);
                return BoxedUnit.UNIT;
            });
        });
        this.dispatcher.unsafeRunAndForget(result);
    }

    @Override
    public void stageShutdown() {
        Object fa = this.org$http4s$blazecore$websocket$Http4sWSStage$$F.handleError(this.deadSignal.set(BoxesRunTime.boxToBoolean((boolean)true)), (Function1)(JProcedure1 & Serializable)t -> {
            Logger Logger_this = this.logger();
            if (Logger_this.isErrorEnabled()) {
                Logger_this.error("Error setting dead signal", t);
                return;
            }
        });
        this.dispatcher.unsafeRunAndForget(fa);
        Stage.stageShutdown$(this);
    }

    private static final boolean $init$$$anonfun$1(AtomicBoolean sentClose$1) {
        return sentClose$1.get();
    }

    private static final boolean $init$$$anonfun$2(AtomicBoolean sentClose$2) {
        return sentClose$2.compareAndSet(false, true);
    }

    private final void $init$$$anonfun$3() {
        this.stageShutdown();
    }

    private final Object evalFrame$$anonfun$1(WebSocketFrame.Close c$1) {
        return this.writeFrame(c$1, Execution$.MODULE$.directec());
    }

    private final Object evalFrame$$anonfun$2() {
        return this.org$http4s$blazecore$websocket$Http4sWSStage$$F.unit();
    }

    private final Object snkFun$$anonfun$1() {
        return this.org$http4s$blazecore$websocket$Http4sWSStage$$F.unit();
    }

    private final Object snkFun$$anonfun$2(WebSocketFrame frame$1) {
        return this.evalFrame(frame$1);
    }

    private final void writeFrame$$anonfun$1$$anonfun$1(WebSocketFrame frame$3, Function1 cb$1, ExecutionContext ec$2) {
        this.channelWrite(frame$3).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                BoxedUnit res = (BoxedUnit)((Success)try_).value();
                cb$1.apply((Object)package$.MODULE$.Right().apply((Object)res));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable t = ((Failure)try_).exception();
                cb$1.apply((Object)package$.MODULE$.Left().apply((Object)t));
                return;
            }
            throw new MatchError((Object)try_);
        }, ec$2);
    }

    private final void readFrameTrampoline$$anonfun$1$$anonfun$1(Function1 cb$3) {
        this.channelRead(this.channelRead$default$1(), this.channelRead$default$2()).onComplete((Function1)(JProcedure1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                WebSocketFrame ws = (WebSocketFrame)((Success)try_).value();
                cb$3.apply((Object)package$.MODULE$.Right().apply((Object)ws));
                return;
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                cb$3.apply((Object)package$.MODULE$.Left().apply((Object)exception));
                return;
            }
            throw new MatchError((Object)try_);
        }, Execution$.MODULE$.trampoline());
    }

    private final boolean maybeSendClose$1$$anonfun$1() {
        return this.sentClose.compareAndSet(false, true);
    }

    private final /* synthetic */ Object maybeSendClose$1$$anonfun$2(WebSocketFrame.Close c$2, boolean cond) {
        if (cond) {
            return this.writeFrame(c$2, Execution$.MODULE$.trampoline());
        }
        return this.org$http4s$blazecore$websocket$Http4sWSStage$$F.unit();
    }

    private final Object maybeSendClose$1$$anonfun$3() {
        return this.deadSignal.set(BoxesRunTime.boxToBoolean((boolean)true));
    }

    private final Object maybeSendClose$1(WebSocketFrame.Close c) {
        Object object = package.all$.MODULE$.catsSyntaxFlatMapOps(package.all$.MODULE$.toFlatMapOps(this.org$http4s$blazecore$websocket$Http4sWSStage$$F.delay(this::maybeSendClose$1$$anonfun$1), this.org$http4s$blazecore$websocket$Http4sWSStage$$F).flatMap((Function1 & Serializable)cond -> this.maybeSendClose$1$$anonfun$2(c, BoxesRunTime.unboxToBoolean((Object)cond))), this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
        return FlatMapOps$.MODULE$.$greater$greater$extension(object, this::maybeSendClose$1$$anonfun$3, this.org$http4s$blazecore$websocket$Http4sWSStage$$F);
    }

    private final boolean handleRead$$anonfun$1$$anonfun$1() {
        return this.sentClose.get();
    }

    private final /* synthetic */ Object handleRead$$anonfun$1$$anonfun$2(WebSocketFrame.Close c$3, boolean s2) {
        return package.all$.MODULE$.toFunctorOps(s2 ? this.deadSignal.set(BoxesRunTime.boxToBoolean((boolean)true)) : this.maybeSendClose$1(c$3), this.org$http4s$blazecore$websocket$Http4sWSStage$$F).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return c$3;
        });
    }

    private final Object handleRead$$anonfun$1$$anonfun$3(WebSocketFrame.Ping p$1) {
        return this.org$http4s$blazecore$websocket$Http4sWSStage$$F.pure((Object)p$1);
    }

    private final void $anonfun$1() {
        this.closePipeline((Option)None$.MODULE$);
    }

    private final void $anonfun$3$$anonfun$1() {
        this.stageShutdown();
    }

    private final void $anonfun$3$$anonfun$2(Throwable t$4) {
        Logger Logger_this = this.logger();
        if (Logger_this.isErrorEnabled()) {
            Logger_this.error("Error closing Web Socket", t$4);
            return;
        }
    }
}

