/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.internal;

import java.io.Serializable;
import java.util.Arrays;
import org.http4s.internal.CharPredicate$;
import org.http4s.internal.CharPredicate$ApplyMagnet$;
import org.http4s.internal.CharPredicate$General$;
import org.http4s.internal.CharPredicate$MaskBased$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.immutable.NumericRange;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class CharPredicate
implements Function1<Object, Object> {
    public static CharPredicate All() {
        return CharPredicate$.MODULE$.All();
    }

    public static CharPredicate Alpha() {
        return CharPredicate$.MODULE$.Alpha();
    }

    public static CharPredicate AlphaNum() {
        return CharPredicate$.MODULE$.AlphaNum();
    }

    public static CharPredicate Digit() {
        return CharPredicate$.MODULE$.Digit();
    }

    public static CharPredicate Digit19() {
        return CharPredicate$.MODULE$.Digit19();
    }

    public static CharPredicate Empty() {
        return CharPredicate$.MODULE$.Empty();
    }

    public static CharPredicate HexDigit() {
        return CharPredicate$.MODULE$.HexDigit();
    }

    public static CharPredicate HexLetter() {
        return CharPredicate$.MODULE$.HexLetter();
    }

    public static CharPredicate LowerAlpha() {
        return CharPredicate$.MODULE$.LowerAlpha();
    }

    public static CharPredicate LowerHexLetter() {
        return CharPredicate$.MODULE$.LowerHexLetter();
    }

    public static CharPredicate Printable() {
        return CharPredicate$.MODULE$.Printable();
    }

    public static CharPredicate UpperAlpha() {
        return CharPredicate$.MODULE$.UpperAlpha();
    }

    public static CharPredicate UpperHexLetter() {
        return CharPredicate$.MODULE$.UpperHexLetter();
    }

    public static CharPredicate Visible() {
        return CharPredicate$.MODULE$.Visible();
    }

    public static CharPredicate from(Function1<Object, Object> function1) {
        return CharPredicate$.MODULE$.from(function1);
    }

    public boolean isMaskBased() {
        return this instanceof MaskBased;
    }

    public MaskBased asMaskBased() {
        CharPredicate charPredicate = this;
        if (charPredicate instanceof MaskBased) {
            MaskBased x = (MaskBased)charPredicate;
            return x;
        }
        throw scala.sys.package$.MODULE$.error("CharPredicate is not MaskBased");
    }

    public Option<MaskBased> asMaskBasedOpt() {
        CharPredicate charPredicate = this;
        if (charPredicate instanceof MaskBased) {
            MaskBased x = (MaskBased)charPredicate;
            return Some$.MODULE$.apply((Object)x);
        }
        return None$.MODULE$;
    }

    public abstract CharPredicate $plus$plus(CharPredicate var1);

    public abstract CharPredicate $plus$plus(scala.collection.immutable.Seq<Object> var1);

    public abstract CharPredicate $minus$minus(CharPredicate var1);

    public abstract CharPredicate $minus$minus(scala.collection.immutable.Seq<Object> var1);

    public CharPredicate $plus$plus(char c) {
        return this.$plus$plus((scala.collection.immutable.Seq<Object>)package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToCharacter((char)c)));
    }

    public CharPredicate $minus$minus(char c) {
        return this.$minus$minus((scala.collection.immutable.Seq<Object>)package$.MODULE$.Nil().$colon$colon((Object)BoxesRunTime.boxToCharacter((char)c)));
    }

    public CharPredicate $plus$plus(String chars) {
        return this.$plus$plus((scala.collection.immutable.Seq<Object>)Predef$.MODULE$.wrapString(chars).toIndexedSeq());
    }

    public CharPredicate $minus$minus(String chars) {
        return this.$minus$minus((scala.collection.immutable.Seq<Object>)Predef$.MODULE$.wrapString(chars).toIndexedSeq());
    }

    public abstract CharPredicate intersect(CharPredicate var1);

    public CharPredicate negated() {
        CharPredicate charPredicate = this;
        CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
        CharPredicate charPredicate3 = charPredicate;
        if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
            return CharPredicate$.MODULE$.All();
        }
        CharPredicate charPredicate4 = CharPredicate$.MODULE$.All();
        CharPredicate charPredicate5 = charPredicate;
        if (!(charPredicate4 != null ? !charPredicate4.equals(charPredicate5) : charPredicate5 != null)) {
            return CharPredicate$.MODULE$.Empty();
        }
        CharPredicate x = charPredicate;
        return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> CharPredicate.negated$$anonfun$1(x, BoxesRunTime.unboxToChar((Object)c)));
    }

    public boolean matchesAny(String string) {
        return this.rec$1(string, 0);
    }

    public boolean matchesAll(String string) {
        return this.rec$2(string, 0);
    }

    public int indexOfFirstMatch(String string) {
        return this.rec$3(string, 0);
    }

    public int indexOfFirstMismatch(String string) {
        return this.rec$4(string, 0);
    }

    public Option<Object> firstMatch(String string) {
        int n = this.indexOfFirstMatch(string);
        if (-1 == n) {
            return None$.MODULE$;
        }
        int ix = n;
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)string.charAt(ix)));
    }

    public Option<Object> firstMismatch(String string) {
        int n = this.indexOfFirstMismatch(string);
        if (-1 == n) {
            return None$.MODULE$;
        }
        int ix = n;
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToCharacter((char)string.charAt(ix)));
    }

    public CharPredicate or(Function1<Object, Object> that) {
        CharPredicate charPredicate = this;
        CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
        return CharPredicate$.MODULE$.from(!(charPredicate != null ? !charPredicate.equals(charPredicate2) : charPredicate2 != null) ? that : (Function1 & Serializable)c -> this.or$$anonfun$1(that, BoxesRunTime.unboxToChar((Object)c)));
    }

    public CharPredicate and(Function1<Object, Object> that) {
        CharPredicate charPredicate = this;
        CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
        if (!(charPredicate != null ? !charPredicate.equals(charPredicate2) : charPredicate2 != null)) {
            return CharPredicate$.MODULE$.Empty();
        }
        return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.and$$anonfun$1(that, BoxesRunTime.unboxToChar((Object)c)));
    }

    public CharPredicate andNot(Function1<Object, Object> that) {
        CharPredicate charPredicate = this;
        CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
        if (!(charPredicate != null ? !charPredicate.equals(charPredicate2) : charPredicate2 != null)) {
            return CharPredicate$.MODULE$.Empty();
        }
        return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.andNot$$anonfun$1(that, BoxesRunTime.unboxToChar((Object)c)));
    }

    private static final /* synthetic */ boolean negated$$anonfun$1(CharPredicate x$1, char c) {
        return !BoxesRunTime.unboxToBoolean((Object)x$1.apply(BoxesRunTime.boxToCharacter((char)c)));
    }

    private final boolean rec$1(String string$1, int ix) {
        while (ix != string$1.length()) {
            if (BoxesRunTime.unboxToBoolean((Object)this.apply(BoxesRunTime.boxToCharacter((char)string$1.charAt(ix))))) {
                return true;
            }
            ++ix;
        }
        return false;
    }

    private final boolean rec$2(String string$2, int ix) {
        while (ix != string$2.length()) {
            if (!BoxesRunTime.unboxToBoolean((Object)this.apply(BoxesRunTime.boxToCharacter((char)string$2.charAt(ix))))) {
                return false;
            }
            ++ix;
        }
        return true;
    }

    private final int rec$3(String string$3, int ix) {
        while (ix != string$3.length()) {
            if (BoxesRunTime.unboxToBoolean((Object)this.apply(BoxesRunTime.boxToCharacter((char)string$3.charAt(ix))))) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    private final int rec$4(String string$4, int ix) {
        while (true) {
            if (ix == string$4.length()) {
                return -1;
            }
            if (!BoxesRunTime.unboxToBoolean((Object)this.apply(BoxesRunTime.boxToCharacter((char)string$4.charAt(ix))))) break;
            ++ix;
        }
        return ix;
    }

    private final /* synthetic */ boolean or$$anonfun$1(Function1 that$1, char c) {
        return BoxesRunTime.unboxToBoolean((Object)this.apply(BoxesRunTime.boxToCharacter((char)c))) || BoxesRunTime.unboxToBoolean((Object)that$1.apply((Object)BoxesRunTime.boxToCharacter((char)c)));
    }

    private final /* synthetic */ boolean and$$anonfun$1(Function1 that$2, char c) {
        return BoxesRunTime.unboxToBoolean((Object)this.apply(BoxesRunTime.boxToCharacter((char)c))) && BoxesRunTime.unboxToBoolean((Object)that$2.apply((Object)BoxesRunTime.boxToCharacter((char)c)));
    }

    private final /* synthetic */ boolean andNot$$anonfun$1(Function1 that$3, char c) {
        return BoxesRunTime.unboxToBoolean((Object)this.apply(BoxesRunTime.boxToCharacter((char)c))) && !BoxesRunTime.unboxToBoolean((Object)that$3.apply((Object)BoxesRunTime.boxToCharacter((char)c)));
    }

    public static class ApplyMagnet {
        private final CharPredicate predicate;

        public static ApplyMagnet fromChar(char c) {
            return CharPredicate$ApplyMagnet$.MODULE$.fromChar(c);
        }

        public static ApplyMagnet fromCharArray(char[] cArray) {
            return CharPredicate$ApplyMagnet$.MODULE$.fromCharArray(cArray);
        }

        public static ApplyMagnet fromChars(scala.collection.immutable.Seq<Object> seq) {
            return CharPredicate$ApplyMagnet$.MODULE$.fromChars(seq);
        }

        public static ApplyMagnet fromPredicate(Function1<Object, Object> function1) {
            return CharPredicate$ApplyMagnet$.MODULE$.fromPredicate(function1);
        }

        public static ApplyMagnet fromString(String string) {
            return CharPredicate$ApplyMagnet$.MODULE$.fromString(string);
        }

        public ApplyMagnet(CharPredicate predicate) {
            this.predicate = predicate;
        }

        public CharPredicate predicate() {
            return this.predicate;
        }
    }

    public static final class ArrayBased
    extends CharPredicate {
        private final char[] chars;

        public ArrayBased(char[] chars) {
            this.chars = chars;
            Arrays.sort(chars);
        }

        private char[] chars() {
            return this.chars;
        }

        public boolean apply(char c) {
            return Arrays.binarySearch(this.chars(), c) >= 0;
        }

        @Override
        public CharPredicate $plus$plus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            if (charPredicate instanceof ArrayBased) {
                ArrayBased x = (ArrayBased)charPredicate;
                Object object = Predef$.MODULE$.charArrayOps(x.chars());
                return this.$plus$plus((scala.collection.immutable.Seq<Object>)ArrayOps$.MODULE$.toIndexedSeq$extension(object));
            }
            return this.or(that);
        }

        @Override
        public CharPredicate $plus$plus(scala.collection.immutable.Seq<Object> other) {
            if (other.nonEmpty()) {
                Object object = Predef$.MODULE$.charArrayOps(super.chars());
                return new ArrayBased((char[])ArrayOps$.MODULE$.$plus$plus$extension(object, other.toArray(ClassTag$.MODULE$.apply(Character.TYPE)), ClassTag$.MODULE$.apply(Character.TYPE)));
            }
            return this;
        }

        @Override
        public CharPredicate $minus$minus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            if (charPredicate instanceof ArrayBased) {
                ArrayBased x = (ArrayBased)charPredicate;
                Object object = Predef$.MODULE$.charArrayOps(x.chars());
                return this.$minus$minus((scala.collection.immutable.Seq)ArrayOps$.MODULE$.toIndexedSeq$extension(object));
            }
            return this.andNot(that);
        }

        @Override
        public ArrayBased $minus$minus(scala.collection.immutable.Seq<Object> other) {
            if (other.nonEmpty()) {
                char[] otherChars = (char[])other.toArray(ClassTag$.MODULE$.apply(Character.TYPE));
                Object object = Predef$.MODULE$.charArrayOps(this.chars());
                return new ArrayBased((char[])ArrayOps$.MODULE$.filter$extension(object, arg_0 -> CharPredicate$.org$http4s$internal$CharPredicate$ArrayBased$$_$$minus$minus$$anonfun$adapted$2(otherChars, arg_0)));
            }
            return this;
        }

        @Override
        public CharPredicate intersect(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return CharPredicate$.MODULE$.Empty();
            }
            if (charPredicate instanceof ArrayBased) {
                ArrayBased x = (ArrayBased)charPredicate;
                Object object = Predef$.MODULE$.charArrayOps(this.chars());
                return new ArrayBased((char[])ArrayOps$.MODULE$.intersect$extension(object, (Seq)Predef$.MODULE$.wrapCharArray(x.chars())));
            }
            return this.and(that);
        }

        @Override
        public String toString() {
            return new StringBuilder(36).append("CharPredicate.ArrayBased(").append(new String(this.chars())).append(')').toString();
        }
    }

    public static final class General
    extends CharPredicate
    implements Product,
    Serializable {
        private final Function1 predicate;

        public static General fromProduct(Product product) {
            return CharPredicate$General$.MODULE$.fromProduct(product);
        }

        public static General unapply(General general) {
            return CharPredicate$General$.MODULE$.unapply(general);
        }

        public General(Function1<Object, Object> predicate) {
            this.predicate = predicate;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof General)) return false;
            General general = (General)object;
            Function1<Object, Object> function1 = this.predicate();
            Function1<Object, Object> function12 = general.predicate();
            if (function1 != null) {
                if (!function1.equals(function12)) return false;
                return true;
            }
            if (function12 == null) return true;
            return false;
        }

        public boolean canEqual(Object that) {
            return that instanceof General;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "General";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "predicate";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Function1<Object, Object> predicate() {
            return this.predicate;
        }

        public boolean apply(char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c)));
        }

        @Override
        public CharPredicate $plus$plus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            if (charPredicate instanceof General) {
                Function1<Object, Object> function1;
                General general = CharPredicate$General$.MODULE$.unapply((General)charPredicate);
                Function1<Object, Object> thatPredicate = function1 = general._1();
                return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$plus$plus$$anonfun$2(thatPredicate, BoxesRunTime.unboxToChar((Object)c)));
            }
            return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$plus$plus$$anonfun$3(that, BoxesRunTime.unboxToChar((Object)c)));
        }

        @Override
        public CharPredicate $plus$plus(scala.collection.immutable.Seq<Object> chars) {
            if (chars.nonEmpty()) {
                ArrayBased abp = new ArrayBased((char[])chars.toArray(ClassTag$.MODULE$.apply(Character.TYPE)));
                return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$plus$plus$$anonfun$4(abp, BoxesRunTime.unboxToChar((Object)c)));
            }
            return this;
        }

        @Override
        public CharPredicate $minus$minus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            if (charPredicate instanceof General) {
                Function1<Object, Object> function1;
                General general = CharPredicate$General$.MODULE$.unapply((General)charPredicate);
                Function1<Object, Object> thatPredicate = function1 = general._1();
                return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$minus$minus$$anonfun$3(thatPredicate, BoxesRunTime.unboxToChar((Object)c)));
            }
            return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$minus$minus$$anonfun$4(that, BoxesRunTime.unboxToChar((Object)c)));
        }

        @Override
        public CharPredicate $minus$minus(scala.collection.immutable.Seq<Object> chars) {
            if (chars.nonEmpty()) {
                ArrayBased abp = new ArrayBased((char[])chars.toArray(ClassTag$.MODULE$.apply(Character.TYPE)));
                return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.$minus$minus$$anonfun$5(abp, BoxesRunTime.unboxToChar((Object)c)));
            }
            return this;
        }

        @Override
        public CharPredicate intersect(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return CharPredicate$.MODULE$.Empty();
            }
            if (charPredicate instanceof General) {
                General general = CharPredicate$General$.MODULE$.unapply((General)charPredicate);
                Function1<Object, Object> function1 = general._1();
                return CharPredicate$.MODULE$.from((Function1<Object, Object>)(Function1 & Serializable)c -> this.intersect$$anonfun$1(that, BoxesRunTime.unboxToChar((Object)c)));
            }
            return this.and(that);
        }

        @Override
        public String toString() {
            return new StringBuilder(22).append("CharPredicate.General@").append(System.identityHashCode(this)).toString();
        }

        public General copy(Function1<Object, Object> predicate) {
            return new General(predicate);
        }

        public Function1<Object, Object> copy$default$1() {
            return this.predicate();
        }

        public Function1<Object, Object> _1() {
            return this.predicate();
        }

        private final /* synthetic */ boolean $plus$plus$$anonfun$2(Function1 thatPredicate$1, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) || BoxesRunTime.unboxToBoolean((Object)thatPredicate$1.apply((Object)BoxesRunTime.boxToCharacter((char)c)));
        }

        private final /* synthetic */ boolean $plus$plus$$anonfun$3(CharPredicate that$4, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) || BoxesRunTime.unboxToBoolean((Object)that$4.apply(BoxesRunTime.boxToCharacter((char)c)));
        }

        private final /* synthetic */ boolean $plus$plus$$anonfun$4(ArrayBased abp$1, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) || abp$1.apply(c);
        }

        private final /* synthetic */ boolean $minus$minus$$anonfun$3(Function1 thatPredicate$2, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) && !BoxesRunTime.unboxToBoolean((Object)thatPredicate$2.apply((Object)BoxesRunTime.boxToCharacter((char)c)));
        }

        private final /* synthetic */ boolean $minus$minus$$anonfun$4(CharPredicate that$5, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) && !BoxesRunTime.unboxToBoolean((Object)that$5.apply(BoxesRunTime.boxToCharacter((char)c)));
        }

        private final /* synthetic */ boolean $minus$minus$$anonfun$5(ArrayBased abp$2, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) && !abp$2.apply(c);
        }

        private final /* synthetic */ boolean intersect$$anonfun$1(CharPredicate that$6, char c) {
            return BoxesRunTime.unboxToBoolean((Object)this.predicate().apply((Object)BoxesRunTime.boxToCharacter((char)c))) && BoxesRunTime.unboxToBoolean((Object)that$6.apply(BoxesRunTime.boxToCharacter((char)c)));
        }
    }

    public static final class MaskBased
    extends CharPredicate
    implements Product,
    Serializable {
        private final long lowMask;
        private final long highMask;

        public static double apply$mcDDD$sp(double d, double d2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcDDD$sp(d, d2);
        }

        public static double apply$mcDDI$sp(double d, int n) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcDDI$sp(d, n);
        }

        public static double apply$mcDDJ$sp(double d, long l) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcDDJ$sp(d, l);
        }

        public static double apply$mcDID$sp(int n, double d) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcDID$sp(n, d);
        }

        public static double apply$mcDII$sp(int n, int n2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcDII$sp(n, n2);
        }

        public static double apply$mcDIJ$sp(int n, long l) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcDIJ$sp(n, l);
        }

        public static double apply$mcDJD$sp(long l, double d) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcDJD$sp(l, d);
        }

        public static double apply$mcDJI$sp(long l, int n) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcDJI$sp(l, n);
        }

        public static double apply$mcDJJ$sp(long l, long l2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcDJJ$sp(l, l2);
        }

        public static float apply$mcFDD$sp(double d, double d2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcFDD$sp(d, d2);
        }

        public static float apply$mcFDI$sp(double d, int n) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcFDI$sp(d, n);
        }

        public static float apply$mcFDJ$sp(double d, long l) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcFDJ$sp(d, l);
        }

        public static float apply$mcFID$sp(int n, double d) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcFID$sp(n, d);
        }

        public static float apply$mcFII$sp(int n, int n2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcFII$sp(n, n2);
        }

        public static float apply$mcFIJ$sp(int n, long l) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcFIJ$sp(n, l);
        }

        public static float apply$mcFJD$sp(long l, double d) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcFJD$sp(l, d);
        }

        public static float apply$mcFJI$sp(long l, int n) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcFJI$sp(l, n);
        }

        public static float apply$mcFJJ$sp(long l, long l2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcFJJ$sp(l, l2);
        }

        public static int apply$mcIDD$sp(double d, double d2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcIDD$sp(d, d2);
        }

        public static int apply$mcIDI$sp(double d, int n) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcIDI$sp(d, n);
        }

        public static int apply$mcIDJ$sp(double d, long l) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcIDJ$sp(d, l);
        }

        public static int apply$mcIID$sp(int n, double d) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcIID$sp(n, d);
        }

        public static int apply$mcIII$sp(int n, int n2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcIII$sp(n, n2);
        }

        public static int apply$mcIIJ$sp(int n, long l) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcIIJ$sp(n, l);
        }

        public static int apply$mcIJD$sp(long l, double d) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcIJD$sp(l, d);
        }

        public static int apply$mcIJI$sp(long l, int n) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcIJI$sp(l, n);
        }

        public static int apply$mcIJJ$sp(long l, long l2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcIJJ$sp(l, l2);
        }

        public static long apply$mcJDD$sp(double d, double d2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcJDD$sp(d, d2);
        }

        public static long apply$mcJDI$sp(double d, int n) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcJDI$sp(d, n);
        }

        public static long apply$mcJDJ$sp(double d, long l) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcJDJ$sp(d, l);
        }

        public static long apply$mcJID$sp(int n, double d) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcJID$sp(n, d);
        }

        public static long apply$mcJII$sp(int n, int n2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcJII$sp(n, n2);
        }

        public static long apply$mcJIJ$sp(int n, long l) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcJIJ$sp(n, l);
        }

        public static long apply$mcJJD$sp(long l, double d) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcJJD$sp(l, d);
        }

        public static long apply$mcJJI$sp(long l, int n) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcJJI$sp(l, n);
        }

        public static long apply$mcJJJ$sp(long l, long l2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcJJJ$sp(l, l2);
        }

        public static void apply$mcVDD$sp(double d, double d2) {
            CharPredicate$MaskBased$.MODULE$.apply$mcVDD$sp(d, d2);
        }

        public static void apply$mcVDI$sp(double d, int n) {
            CharPredicate$MaskBased$.MODULE$.apply$mcVDI$sp(d, n);
        }

        public static void apply$mcVDJ$sp(double d, long l) {
            CharPredicate$MaskBased$.MODULE$.apply$mcVDJ$sp(d, l);
        }

        public static void apply$mcVID$sp(int n, double d) {
            CharPredicate$MaskBased$.MODULE$.apply$mcVID$sp(n, d);
        }

        public static void apply$mcVII$sp(int n, int n2) {
            CharPredicate$MaskBased$.MODULE$.apply$mcVII$sp(n, n2);
        }

        public static void apply$mcVIJ$sp(int n, long l) {
            CharPredicate$MaskBased$.MODULE$.apply$mcVIJ$sp(n, l);
        }

        public static void apply$mcVJD$sp(long l, double d) {
            CharPredicate$MaskBased$.MODULE$.apply$mcVJD$sp(l, d);
        }

        public static void apply$mcVJI$sp(long l, int n) {
            CharPredicate$MaskBased$.MODULE$.apply$mcVJI$sp(l, n);
        }

        public static void apply$mcVJJ$sp(long l, long l2) {
            CharPredicate$MaskBased$.MODULE$.apply$mcVJJ$sp(l, l2);
        }

        public static boolean apply$mcZDD$sp(double d, double d2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcZDD$sp(d, d2);
        }

        public static boolean apply$mcZDI$sp(double d, int n) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcZDI$sp(d, n);
        }

        public static boolean apply$mcZDJ$sp(double d, long l) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcZDJ$sp(d, l);
        }

        public static boolean apply$mcZID$sp(int n, double d) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcZID$sp(n, d);
        }

        public static boolean apply$mcZII$sp(int n, int n2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcZII$sp(n, n2);
        }

        public static boolean apply$mcZIJ$sp(int n, long l) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcZIJ$sp(n, l);
        }

        public static boolean apply$mcZJD$sp(long l, double d) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcZJD$sp(l, d);
        }

        public static boolean apply$mcZJI$sp(long l, int n) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcZJI$sp(l, n);
        }

        public static boolean apply$mcZJJ$sp(long l, long l2) {
            return CharPredicate$MaskBased$.MODULE$.apply$mcZJJ$sp(l, l2);
        }

        public static Function1<Object, Function1<Object, MaskBased>> curried() {
            return CharPredicate$MaskBased$.MODULE$.curried();
        }

        public static MaskBased fromProduct(Product product) {
            return CharPredicate$MaskBased$.MODULE$.fromProduct(product);
        }

        public static Function1<Tuple2<Object, Object>, MaskBased> tupled() {
            return CharPredicate$MaskBased$.MODULE$.tupled();
        }

        public static MaskBased unapply(MaskBased maskBased) {
            return CharPredicate$MaskBased$.MODULE$.unapply(maskBased);
        }

        public MaskBased(long lowMask, long highMask) {
            this.lowMask = lowMask;
            this.highMask = highMask;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.lowMask()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.highMask()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MaskBased)) return false;
            MaskBased maskBased = (MaskBased)object;
            if (this.lowMask() != maskBased.lowMask()) return false;
            if (this.highMask() != maskBased.highMask()) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof MaskBased;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MaskBased";
        }

        public Object productElement(int n) {
            long l;
            int n2 = n;
            if (0 == n2) {
                l = this._1();
            } else if (1 == n2) {
                l = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)l);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "lowMask";
            }
            if (1 == n2) {
                return "highMask";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long lowMask() {
            return this.lowMask;
        }

        public long highMask() {
            return this.highMask;
        }

        public boolean apply(char c) {
            long mask = c < '@' ? this.lowMask() : this.highMask();
            return (1L << (int)((long)c) & (long)(c - 128 >> 31) & mask) != 0L;
        }

        @Override
        public CharPredicate $plus$plus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            MaskBased maskBased = this;
            CharPredicate charPredicate4 = CharPredicate$.MODULE$.Empty();
            if (!(maskBased != null ? !((Object)maskBased).equals(charPredicate4) : charPredicate4 != null)) {
                return that;
            }
            if (charPredicate instanceof MaskBased) {
                MaskBased maskBased2 = CharPredicate$MaskBased$.MODULE$.unapply((MaskBased)charPredicate);
                long l = maskBased2._1();
                long l2 = maskBased2._2();
                long low = l;
                long high = l2;
                return CharPredicate$MaskBased$.MODULE$.apply(this.lowMask() | low, this.highMask() | high);
            }
            return this.or(that);
        }

        @Override
        public CharPredicate $plus$plus(scala.collection.immutable.Seq<Object> chars) {
            return (CharPredicate)chars.foldLeft((Object)this, (Function2 & Serializable)(x$1, x$2) -> this.$plus$plus$$anonfun$1(chars, (CharPredicate)x$1, BoxesRunTime.unboxToChar((Object)x$2)));
        }

        @Override
        public CharPredicate $minus$minus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            MaskBased maskBased = this;
            CharPredicate charPredicate4 = CharPredicate$.MODULE$.Empty();
            if (!(maskBased != null ? !((Object)maskBased).equals(charPredicate4) : charPredicate4 != null)) {
                return this;
            }
            if (charPredicate instanceof MaskBased) {
                MaskBased maskBased2 = CharPredicate$MaskBased$.MODULE$.unapply((MaskBased)charPredicate);
                long l = maskBased2._1();
                long l2 = maskBased2._2();
                long low = l;
                long high = l2;
                return CharPredicate$MaskBased$.MODULE$.apply(this.lowMask() & (low ^ 0xFFFFFFFFFFFFFFFFL), this.highMask() & (high ^ 0xFFFFFFFFFFFFFFFFL));
            }
            return this.andNot(that);
        }

        @Override
        public CharPredicate $minus$minus(scala.collection.immutable.Seq<Object> chars) {
            MaskBased maskBased = this;
            CharPredicate charPredicate = CharPredicate$.MODULE$.Empty();
            if (maskBased == null ? charPredicate != null : !((Object)maskBased).equals(charPredicate)) {
                return (CharPredicate)chars.foldLeft((Object)this, (Function2 & Serializable)(x$1, x$2) -> this.$minus$minus$$anonfun$1(chars, (CharPredicate)x$1, BoxesRunTime.unboxToChar((Object)x$2)));
            }
            return this;
        }

        @Override
        public CharPredicate intersect(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return CharPredicate$.MODULE$.Empty();
            }
            MaskBased maskBased = this;
            CharPredicate charPredicate4 = CharPredicate$.MODULE$.Empty();
            if (!(maskBased != null ? !((Object)maskBased).equals(charPredicate4) : charPredicate4 != null)) {
                return CharPredicate$.MODULE$.Empty();
            }
            if (charPredicate instanceof MaskBased) {
                MaskBased maskBased2 = CharPredicate$MaskBased$.MODULE$.unapply((MaskBased)charPredicate);
                long l = maskBased2._1();
                long l2 = maskBased2._2();
                long low = l;
                long high = l2;
                return CharPredicate$MaskBased$.MODULE$.apply(this.lowMask() & low, this.highMask() & high);
            }
            return this.and(that);
        }

        public int size() {
            return Long.bitCount(this.lowMask()) + Long.bitCount(this.highMask());
        }

        public char[] toArray() {
            char[] array = new char[this.size()];
            this.getChars(array, 0);
            return array;
        }

        public void getChars(char[] array, int startIx) {
            this.rec$6(array, this.highMask(), 64, Long.numberOfTrailingZeros(this.highMask()), this.rec$6(array, this.lowMask(), 0, Long.numberOfTrailingZeros(this.lowMask()), startIx));
        }

        @Override
        public String toString() {
            return new StringBuilder(35).append("CharPredicate.MaskBased(").append(new String(this.toArray())).append(')').toString();
        }

        public MaskBased copy(long lowMask, long highMask) {
            return new MaskBased(lowMask, highMask);
        }

        public long copy$default$1() {
            return this.lowMask();
        }

        public long copy$default$2() {
            return this.highMask();
        }

        public long _1() {
            return this.lowMask();
        }

        public long _2() {
            return this.highMask();
        }

        private final /* synthetic */ CharPredicate $plus$plus$$anonfun$1(scala.collection.immutable.Seq chars$2, CharPredicate x$1, char x$2) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToCharacter((char)x$2));
            if (tuple2 != null) {
                CharPredicate charPredicate = (CharPredicate)tuple2._1();
                char c = BoxesRunTime.unboxToChar((Object)tuple2._2());
                if (charPredicate instanceof MaskBased) {
                    char c2 = c;
                    if (CharPredicate$.MODULE$.org$http4s$internal$CharPredicate$$$unmaskable(c2)) {
                        return new ArrayBased((char[])chars$2.toArray(ClassTag$.MODULE$.apply(Character.TYPE))).$plus$plus(new ArrayBased(this.toArray()));
                    }
                    MaskBased maskBased = CharPredicate$MaskBased$.MODULE$.unapply((MaskBased)charPredicate);
                    long l = maskBased._1();
                    long l2 = maskBased._2();
                    long low = l;
                    long high = l2;
                    char c3 = c;
                    if (c3 < '@') {
                        return CharPredicate$MaskBased$.MODULE$.apply(low | 1L << (int)((long)c3), high);
                    }
                    long low2 = l;
                    long high2 = l2;
                    char c4 = c;
                    return CharPredicate$MaskBased$.MODULE$.apply(low2, high2 | 1L << (int)((long)c4));
                }
                CharPredicate x = charPredicate;
                return x;
            }
            throw new MatchError((Object)tuple2);
        }

        private final /* synthetic */ CharPredicate $minus$minus$$anonfun$1(scala.collection.immutable.Seq chars$3, CharPredicate x$1, char x$2) {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)x$1, (Object)BoxesRunTime.boxToCharacter((char)x$2));
            if (tuple2 != null) {
                CharPredicate charPredicate = (CharPredicate)tuple2._1();
                char c = BoxesRunTime.unboxToChar((Object)tuple2._2());
                if (charPredicate instanceof MaskBased) {
                    char c2 = c;
                    if (CharPredicate$.MODULE$.org$http4s$internal$CharPredicate$$$unmaskable(c2)) {
                        return this.andNot(new ArrayBased((char[])chars$3.toArray(ClassTag$.MODULE$.apply(Character.TYPE))));
                    }
                    MaskBased maskBased = CharPredicate$MaskBased$.MODULE$.unapply((MaskBased)charPredicate);
                    long l = maskBased._1();
                    long l2 = maskBased._2();
                    long low = l;
                    long high = l2;
                    char c3 = c;
                    if (c3 < '@') {
                        return CharPredicate$MaskBased$.MODULE$.apply(low & (1L << (int)((long)c3) ^ 0xFFFFFFFFFFFFFFFFL), high);
                    }
                    long low2 = l;
                    long high2 = l2;
                    char c4 = c;
                    return CharPredicate$MaskBased$.MODULE$.apply(low2, high2 & (1L << (int)((long)c4) ^ 0xFFFFFFFFFFFFFFFFL));
                }
                CharPredicate x = charPredicate;
                return x;
            }
            throw new MatchError((Object)tuple2);
        }

        private final int rec$6(char[] array$1, long mask, int offset, int bit, int ix) {
            while (bit < 64 && ix < array$1.length) {
                if ((mask & 1L << bit) > 0L) {
                    array$1[ix] = (char)(offset + bit);
                    int n = bit + 1;
                    int n2 = ix + 1;
                    bit = n;
                    ix = n2;
                    continue;
                }
                ++bit;
            }
            return ix;
        }
    }

    public static final class RangeBased
    extends CharPredicate {
        private final NumericRange range;

        public RangeBased(NumericRange<Object> range) {
            this.range = range;
        }

        private NumericRange<Object> range() {
            return this.range;
        }

        public boolean apply(char c) {
            return this.range().contains((Object)BoxesRunTime.boxToCharacter((char)c));
        }

        @Override
        public CharPredicate $plus$plus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            return this.or(that);
        }

        @Override
        public CharPredicate $plus$plus(scala.collection.immutable.Seq<Object> other) {
            if (other.nonEmpty()) {
                return this.$plus$plus(CharPredicate$.MODULE$.apply((scala.collection.immutable.Seq<ApplyMagnet>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApplyMagnet[]{CharPredicate$ApplyMagnet$.MODULE$.fromChars(other)})));
            }
            return this;
        }

        @Override
        public CharPredicate $minus$minus(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return this;
            }
            return this.andNot(that);
        }

        @Override
        public CharPredicate $minus$minus(scala.collection.immutable.Seq<Object> other) {
            if (other.nonEmpty()) {
                return this.$minus$minus(CharPredicate$.MODULE$.apply((scala.collection.immutable.Seq<ApplyMagnet>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ApplyMagnet[]{CharPredicate$ApplyMagnet$.MODULE$.fromChars(other)})));
            }
            return this;
        }

        @Override
        public CharPredicate intersect(CharPredicate that) {
            CharPredicate charPredicate = that;
            CharPredicate charPredicate2 = CharPredicate$.MODULE$.Empty();
            CharPredicate charPredicate3 = charPredicate;
            if (!(charPredicate2 != null ? !charPredicate2.equals(charPredicate3) : charPredicate3 != null)) {
                return CharPredicate$.MODULE$.Empty();
            }
            return this.and(that);
        }

        @Override
        public String toString() {
            return new StringBuilder(43).append("CharPredicate.RangeBased(start = ").append(this.range().start()).append(", end = ").append(this.range().end()).append(", ").append(new StringBuilder(22).append("step = ").append((int)BoxesRunTime.unboxToChar((Object)this.range().step())).append(", inclusive = ").append(this.range().isInclusive()).append(")").toString()).toString();
        }
    }
}

