/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import org.http4s.websocket.WebSocketFrame$;
import org.http4s.websocket.WebSocketFrame$Binary$;
import org.http4s.websocket.WebSocketFrame$Close$;
import org.http4s.websocket.WebSocketFrame$Continuation$;
import org.http4s.websocket.WebSocketFrame$Ping$;
import org.http4s.websocket.WebSocketFrame$Pong$;
import org.http4s.websocket.WebSocketFrame$Text$;
import org.http4s.websocket.package$;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.hashing.MurmurHash3$;
import scodec.bits.ByteVector;
import scodec.bits.ByteVector$;

public abstract class WebSocketFrame {
    public abstract int opcode();

    public abstract ByteVector data();

    public abstract boolean last();

    public final int length() {
        return (int)this.data().length();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (!(object instanceof WebSocketFrame)) return false;
        WebSocketFrame wf = (WebSocketFrame)object;
        if (this.opcode() != wf.opcode()) return false;
        if (this.last() != wf.last()) return false;
        ByteVector byteVector = this.data();
        ByteVector byteVector2 = wf.data();
        if (byteVector != null) {
            if (!((Object)byteVector).equals(byteVector2)) return false;
            return true;
        }
        if (byteVector2 == null) return true;
        return false;
    }

    public int hashCode() {
        int hash2 = WebSocketFrame$.org$http4s$websocket$WebSocketFrame$$$hashSeed;
        hash2 = MurmurHash3$.MODULE$.mix(hash2, Statics.anyHash((Object)BoxesRunTime.boxToInteger((int)this.opcode())));
        hash2 = MurmurHash3$.MODULE$.mix(hash2, Statics.anyHash((Object)this.data()));
        hash2 = MurmurHash3$.MODULE$.mixLast(hash2, Statics.anyHash((Object)BoxesRunTime.boxToBoolean((boolean)this.last())));
        return hash2;
    }

    public static final class Binary
    extends WebSocketFrame
    implements Product,
    Serializable {
        private final ByteVector data;
        private final boolean last;

        public static Binary apply(ByteVector byteVector, boolean bl) {
            return WebSocketFrame$Binary$.MODULE$.apply(byteVector, bl);
        }

        public static Binary fromProduct(Product product) {
            return WebSocketFrame$Binary$.MODULE$.fromProduct(product);
        }

        public static Binary unapply(Binary binary) {
            return WebSocketFrame$Binary$.MODULE$.unapply(binary);
        }

        public static boolean $lessinit$greater$default$2() {
            return WebSocketFrame$Binary$.MODULE$.$lessinit$greater$default$2();
        }

        public Binary(ByteVector data, boolean last) {
            this.data = data;
            this.last = last;
        }

        public boolean canEqual(Object that) {
            return that instanceof Binary;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Binary";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            if (1 == n2) {
                return "last";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ByteVector data() {
            return this.data;
        }

        @Override
        public boolean last() {
            return this.last;
        }

        @Override
        public int opcode() {
            return package$.MODULE$.BINARY();
        }

        public String toString() {
            return new StringBuilder(23).append("Binary(Array(").append(this.data().length()).append("), last: ").append(this.last()).append(")").toString();
        }

        public Binary copy(ByteVector data, boolean last) {
            return new Binary(data, last);
        }

        public ByteVector copy$default$1() {
            return this.data();
        }

        public boolean copy$default$2() {
            return this.last();
        }

        public ByteVector _1() {
            return this.data();
        }

        public boolean _2() {
            return this.last();
        }
    }

    public static class BinaryText
    extends Text {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BinaryText.class.getDeclaredField("str$lzy1"));
        private final ByteVector data;
        private final boolean last;
        private volatile Object str$lzy1;

        public BinaryText(ByteVector data, boolean last) {
            this.data = data;
            this.last = last;
        }

        @Override
        public ByteVector data() {
            return this.data;
        }

        @Override
        public boolean last() {
            return this.last;
        }

        @Override
        public String str() {
            Object object = this.str$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.str$lzyINIT1();
        }

        private Object str$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.str$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = new String(this.data().toArray(), StandardCharsets.UTF_8);
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.str$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }

    public static final class Close
    extends ControlFrame
    implements Product,
    Serializable {
        private final ByteVector data;

        public static Close apply(ByteVector byteVector) {
            return WebSocketFrame$Close$.MODULE$.apply(byteVector);
        }

        public static Either<InvalidCloseDataException, Close> apply(int n) {
            return WebSocketFrame$Close$.MODULE$.apply(n);
        }

        public static Either<InvalidCloseDataException, Close> apply(int n, String string) {
            return WebSocketFrame$Close$.MODULE$.apply(n, string);
        }

        public static Close fromProduct(Product product) {
            return WebSocketFrame$Close$.MODULE$.fromProduct(product);
        }

        public static Close unapply(Close close) {
            return WebSocketFrame$Close$.MODULE$.unapply(close);
        }

        public static ByteVector $lessinit$greater$default$1() {
            return WebSocketFrame$Close$.MODULE$.$lessinit$greater$default$1();
        }

        public Close(ByteVector data) {
            this.data = data;
        }

        public boolean canEqual(Object that) {
            return that instanceof Close;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Close";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ByteVector data() {
            return this.data;
        }

        @Override
        public int opcode() {
            return package$.MODULE$.CLOSE();
        }

        public int closeCode() {
            if (this.data().length() > 0L) {
                return this.data().apply(0L) << 8 & 0xFF00 | this.data().apply(1L) & 0xFF;
            }
            return 1005;
        }

        public String reason() {
            if (this.data().length() > 2L) {
                return new String(this.data().drop(2L).toArray(), StandardCharsets.UTF_8);
            }
            return "";
        }

        public String toString() {
            if (this.data().length() > 0L) {
                return new StringBuilder(14).append("Close(Array(").append(this.data().length()).append("))").toString();
            }
            return "Close";
        }

        public Close copy(ByteVector data) {
            return new Close(data);
        }

        public ByteVector copy$default$1() {
            return this.data();
        }

        public ByteVector _1() {
            return this.data();
        }
    }

    public static final class Continuation
    extends WebSocketFrame
    implements Product,
    Serializable {
        private final ByteVector data;
        private final boolean last;

        public static Continuation apply(ByteVector byteVector, boolean bl) {
            return WebSocketFrame$Continuation$.MODULE$.apply(byteVector, bl);
        }

        public static Continuation fromProduct(Product product) {
            return WebSocketFrame$Continuation$.MODULE$.fromProduct(product);
        }

        public static Continuation unapply(Continuation continuation) {
            return WebSocketFrame$Continuation$.MODULE$.unapply(continuation);
        }

        public Continuation(ByteVector data, boolean last) {
            this.data = data;
            this.last = last;
        }

        public boolean canEqual(Object that) {
            return that instanceof Continuation;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Continuation";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return BoxesRunTime.boxToBoolean((boolean)this._2());
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            if (1 == n2) {
                return "last";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ByteVector data() {
            return this.data;
        }

        @Override
        public boolean last() {
            return this.last;
        }

        @Override
        public int opcode() {
            return package$.MODULE$.CONTINUATION();
        }

        public String toString() {
            return new StringBuilder(29).append("Continuation(Array(").append(this.data().length()).append("), last: ").append(this.last()).append(")").toString();
        }

        public Continuation copy(ByteVector data, boolean last) {
            return new Continuation(data, last);
        }

        public ByteVector copy$default$1() {
            return this.data();
        }

        public boolean copy$default$2() {
            return this.last();
        }

        public ByteVector _1() {
            return this.data();
        }

        public boolean _2() {
            return this.last();
        }
    }

    public static abstract class ControlFrame
    extends WebSocketFrame {
        @Override
        public final boolean last() {
            return true;
        }
    }

    public static class InvalidCloseCodeException
    extends InvalidCloseDataException {
        private final int i;

        public InvalidCloseCodeException(int i) {
            this.i = i;
        }

        public int i() {
            return this.i;
        }
    }

    public static abstract class InvalidCloseDataException
    extends RuntimeException {
    }

    public static final class Ping
    extends ControlFrame
    implements Product,
    Serializable {
        private final ByteVector data;

        public static Ping apply(ByteVector byteVector) {
            return WebSocketFrame$Ping$.MODULE$.apply(byteVector);
        }

        public static Ping fromProduct(Product product) {
            return WebSocketFrame$Ping$.MODULE$.fromProduct(product);
        }

        public static Ping unapply(Ping ping) {
            return WebSocketFrame$Ping$.MODULE$.unapply(ping);
        }

        public static ByteVector $lessinit$greater$default$1() {
            return WebSocketFrame$Ping$.MODULE$.$lessinit$greater$default$1();
        }

        public Ping(ByteVector data) {
            this.data = data;
        }

        public boolean canEqual(Object that) {
            return that instanceof Ping;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Ping";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ByteVector data() {
            return this.data;
        }

        @Override
        public int opcode() {
            return package$.MODULE$.PING();
        }

        public String toString() {
            if (this.data().length() > 0L) {
                return new StringBuilder(13).append("Ping(Array(").append(this.data().length()).append("))").toString();
            }
            return "Ping";
        }

        public Ping copy(ByteVector data) {
            return new Ping(data);
        }

        public ByteVector copy$default$1() {
            return this.data();
        }

        public ByteVector _1() {
            return this.data();
        }
    }

    public static final class Pong
    extends ControlFrame
    implements Product,
    Serializable {
        private final ByteVector data;

        public static Pong apply(ByteVector byteVector) {
            return WebSocketFrame$Pong$.MODULE$.apply(byteVector);
        }

        public static Pong fromProduct(Product product) {
            return WebSocketFrame$Pong$.MODULE$.fromProduct(product);
        }

        public static Pong unapply(Pong pong) {
            return WebSocketFrame$Pong$.MODULE$.unapply(pong);
        }

        public static ByteVector $lessinit$greater$default$1() {
            return WebSocketFrame$Pong$.MODULE$.$lessinit$greater$default$1();
        }

        public Pong(ByteVector data) {
            this.data = data;
        }

        public boolean canEqual(Object that) {
            return that instanceof Pong;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Pong";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "data";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public ByteVector data() {
            return this.data;
        }

        @Override
        public int opcode() {
            return package$.MODULE$.PONG();
        }

        public String toString() {
            if (this.data().length() > 0L) {
                return new StringBuilder(13).append("Pong(Array(").append(this.data().length()).append("))").toString();
            }
            return "Pong";
        }

        public Pong copy(ByteVector data) {
            return new Pong(data);
        }

        public ByteVector copy$default$1() {
            return this.data();
        }

        public ByteVector _1() {
            return this.data();
        }
    }

    public static class ReasonTooLongException
    extends InvalidCloseDataException {
        private final String s;

        public ReasonTooLongException(String s2) {
            this.s = s2;
        }

        public String s() {
            return this.s;
        }
    }

    public static class StringText
    extends Text {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(StringText.class.getDeclaredField("data$lzy1"));
        private final String str;
        private final boolean last;
        private volatile Object data$lzy1;

        public StringText(String str, boolean last) {
            this.str = str;
            this.last = last;
        }

        @Override
        public String str() {
            return this.str;
        }

        @Override
        public boolean last() {
            return this.last;
        }

        @Override
        public ByteVector data() {
            Object object = this.data$lzy1;
            if (object instanceof ByteVector) {
                return (ByteVector)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (ByteVector)this.data$lzyINIT1();
        }

        private Object data$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.data$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        ByteVector byteVector = null;
                        try {
                            byteVector = ByteVector$.MODULE$.view(this.str().getBytes(StandardCharsets.UTF_8));
                            object2 = byteVector == null ? LazyVals.NullValue$.MODULE$ : byteVector;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.data$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return byteVector;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }

    public static abstract class Text
    extends WebSocketFrame {
        public static Text apply(ByteVector byteVector) {
            return WebSocketFrame$Text$.MODULE$.apply(byteVector);
        }

        public static Text apply(ByteVector byteVector, boolean bl) {
            return WebSocketFrame$Text$.MODULE$.apply(byteVector, bl);
        }

        public static Text apply(String string, boolean bl) {
            return WebSocketFrame$Text$.MODULE$.apply(string, bl);
        }

        public static Option<Tuple2<String, Object>> unapply(Text text2) {
            return WebSocketFrame$Text$.MODULE$.unapply(text2);
        }

        public static boolean apply$default$2() {
            return WebSocketFrame$Text$.MODULE$.apply$default$2();
        }

        public abstract String str();

        @Override
        public int opcode() {
            return package$.MODULE$.TEXT();
        }

        public String toString() {
            return new StringBuilder(16).append("Text('").append(this.str()).append("', last: ").append(this.last()).append(")").toString();
        }
    }
}

