/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.websocket;

import java.io.Serializable;
import java.net.ProtocolException;
import org.http4s.websocket.ReservedOpcodeException;
import org.http4s.websocket.UnknownOpcodeException;
import org.http4s.websocket.WebSocketFrame;
import org.http4s.websocket.WebSocketFrame$Binary$;
import org.http4s.websocket.WebSocketFrame$Close$;
import org.http4s.websocket.WebSocketFrame$Continuation$;
import org.http4s.websocket.WebSocketFrame$Ping$;
import org.http4s.websocket.WebSocketFrame$Pong$;
import org.http4s.websocket.WebSocketFrame$Text$;
import scala.runtime.ModuleSerializationProxy;
import scodec.bits.ByteVector;

public final class package$
implements Serializable {
    private static final int OP_CODE;
    private static final int FINISHED;
    private static final int MASK;
    private static final int LENGTH;
    private static final int RESERVED;
    private static final int CONTINUATION;
    private static final int TEXT;
    private static final int BINARY;
    private static final int CLOSE;
    private static final int PING;
    private static final int PONG;
    public static final package$ MODULE$;

    private package$() {
    }

    static {
        MODULE$ = new package$();
        OP_CODE = 15;
        FINISHED = 128;
        MASK = 128;
        LENGTH = 127;
        RESERVED = 14;
        CONTINUATION = 0;
        TEXT = 1;
        BINARY = 2;
        CLOSE = 8;
        PING = 9;
        PONG = 10;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$.class);
    }

    public int OP_CODE() {
        return OP_CODE;
    }

    public int FINISHED() {
        return FINISHED;
    }

    public int MASK() {
        return MASK;
    }

    public int LENGTH() {
        return LENGTH;
    }

    public int RESERVED() {
        return RESERVED;
    }

    public int CONTINUATION() {
        return CONTINUATION;
    }

    public int TEXT() {
        return TEXT;
    }

    public int BINARY() {
        return BINARY;
    }

    public int CLOSE() {
        return CLOSE;
    }

    public int PING() {
        return PING;
    }

    public int PONG() {
        return PONG;
    }

    public WebSocketFrame makeFrame(int opcode, ByteVector data, boolean last) throws ProtocolException {
        WebSocketFrame webSocketFrame;
        int n = opcode;
        switch (n) {
            case 0: {
                webSocketFrame = WebSocketFrame$Continuation$.MODULE$.apply(data, last);
                break;
            }
            case 1: {
                webSocketFrame = WebSocketFrame$Text$.MODULE$.apply(data, last);
                break;
            }
            case 2: {
                webSocketFrame = WebSocketFrame$Binary$.MODULE$.apply(data, last);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                throw new ReservedOpcodeException(opcode);
            }
            case 8: {
                if (data.length() == 1L) {
                    throw new ProtocolException("Close frame must have 0 data bits or at least 2");
                }
                if (!last) {
                    throw new ProtocolException("Control frame cannot be fragmented: Close");
                }
                webSocketFrame = WebSocketFrame$Close$.MODULE$.apply(data);
                break;
            }
            case 9: {
                if (!last) {
                    throw new ProtocolException("Control frame cannot be fragmented: Ping");
                }
                webSocketFrame = WebSocketFrame$Ping$.MODULE$.apply(data);
                break;
            }
            case 10: {
                if (!last) {
                    throw new ProtocolException("Control frame cannot be fragmented: Pong");
                }
                webSocketFrame = WebSocketFrame$Pong$.MODULE$.apply(data);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                throw new ReservedOpcodeException(opcode);
            }
            default: {
                throw new UnknownOpcodeException(opcode);
            }
        }
        return webSocketFrame;
    }
}

