/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.internal;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.ModuleSerializationProxy;
import sttp.client4.ByteArrayBody;
import sttp.client4.ByteArrayBody$;
import sttp.client4.ByteBufferBody;
import sttp.client4.ByteBufferBody$;
import sttp.client4.FileBody;
import sttp.client4.FileBody$;
import sttp.client4.GenericRequest;
import sttp.client4.GenericRequestBody;
import sttp.client4.InputStreamBody;
import sttp.client4.InputStreamBody$;
import sttp.client4.MultipartBody;
import sttp.client4.NoBody$;
import sttp.client4.StreamBody;
import sttp.client4.StreamBody$;
import sttp.client4.StringBody;
import sttp.client4.StringBody$;
import sttp.client4.internal.SttpFile;
import sttp.model.HeaderNames$;
import sttp.model.MediaType;
import sttp.model.Part;

public final class ToCurlConverter$
implements Serializable {
    public static final ToCurlConverter$ MODULE$ = new ToCurlConverter$();

    private ToCurlConverter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ToCurlConverter$.class);
    }

    public String apply(GenericRequest<?, ?> request, boolean omitAcceptEncoding, Set<String> sensitiveHeaders, Set<String> sensitiveQueryParams) {
        String params2 = (String)((Function1)((List)new .colon.colon((Function1 & Serializable)_$1 -> MODULE$.extractMethod((GenericRequest<?, ?>)_$1), (List)new .colon.colon((Function1 & Serializable)_$2 -> MODULE$.extractUrl(sensitiveQueryParams, (GenericRequest<?, ?>)_$2), (List)new .colon.colon((Function1 & Serializable)_$3 -> MODULE$.extractHeaders(sensitiveHeaders, omitAcceptEncoding, (GenericRequest<?, ?>)_$3), (List)new .colon.colon((Function1 & Serializable)_$4 -> MODULE$.extractBody((GenericRequest<?, ?>)_$4), (List)new .colon.colon((Function1 & Serializable)_$5 -> MODULE$.extractOptions((GenericRequest<?, ?>)_$5), (List)Nil$.MODULE$)))))).map((Function1 & Serializable)fInput -> MODULE$.addSpaceIfNotEmpty((Function1<GenericRequest<?, ?>, String>)fInput)).reduce((Function2 & Serializable)(acc, item) -> (Function1 & Serializable)r -> new StringBuilder(0).append((String)acc.apply(r)).append(item.apply(r)).toString())).apply(request);
        return new StringBuilder(4).append("curl").append(params2).toString();
    }

    public boolean apply$default$2() {
        return false;
    }

    public Set<String> apply$default$3() {
        return HeaderNames$.MODULE$.SensitiveHeaders();
    }

    public Set<String> apply$default$4() {
        return Predef$.MODULE$.Set().empty();
    }

    private String extractMethod(GenericRequest<?, ?> r) {
        return new StringBuilder(10).append("--request ").append(r.method()).toString();
    }

    private String extractUrl(Set<String> sensitiveQueryParams, GenericRequest<?, ?> r) {
        return new StringBuilder(8).append("--url '").append(r.uri().toStringSafe(sensitiveQueryParams)).append("'").toString();
    }

    private String extractHeaders(Set<String> sensitiveHeaders, boolean omitAcceptEncoding, GenericRequest<?, ?> r) {
        return ((IterableOnceOps)(!omitAcceptEncoding ? r.headers() : (Seq)r.headers().filterNot((Function1 & Serializable)_$6 -> _$6.name().equalsIgnoreCase(HeaderNames$.MODULE$.AcceptEncoding()))).map((Function1 & Serializable)h -> new StringBuilder(11).append("--header '").append(h.toStringSafe(sensitiveHeaders)).append("'").toString())).mkString(this.newline());
    }

    private String extractBody(GenericRequest<?, ?> r) {
        GenericRequestBody<?> genericRequestBody = r.body();
        if (genericRequestBody instanceof StringBody) {
            StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)genericRequestBody);
            String string = stringBody._1();
            String string2 = stringBody._2();
            MediaType mediaType = stringBody._3();
            String text = string;
            return new StringBuilder(13).append("--data-raw '").append(text.replace("'", "\\'")).append("'").toString();
        }
        if (genericRequestBody instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody2 = ByteArrayBody$.MODULE$.unapply((ByteArrayBody)genericRequestBody);
            byte[] byArray = byteArrayBody2._1();
            MediaType mediaType = byteArrayBody2._2();
            return "--data-binary <PLACEHOLDER>";
        }
        if (genericRequestBody instanceof ByteBufferBody) {
            ByteBufferBody byteBufferBody2 = ByteBufferBody$.MODULE$.unapply((ByteBufferBody)genericRequestBody);
            ByteBuffer byteBuffer = byteBufferBody2._1();
            MediaType mediaType = byteBufferBody2._2();
            return "--data-binary <PLACEHOLDER>";
        }
        if (genericRequestBody instanceof InputStreamBody) {
            InputStreamBody inputStreamBody2 = InputStreamBody$.MODULE$.unapply((InputStreamBody)genericRequestBody);
            InputStream inputStream = inputStreamBody2._1();
            MediaType mediaType = inputStreamBody2._2();
            return "--data-binary <PLACEHOLDER>";
        }
        if (genericRequestBody instanceof StreamBody) {
            StreamBody streamBody = StreamBody$.MODULE$.unapply((StreamBody)genericRequestBody);
            Object BinaryStream = streamBody._1();
            return "--data-binary <PLACEHOLDER>";
        }
        if (genericRequestBody instanceof MultipartBody) {
            MultipartBody m = (MultipartBody)genericRequestBody;
            return this.handleMultipartBody(m.parts());
        }
        if (genericRequestBody instanceof FileBody) {
            FileBody fileBody2 = FileBody$.MODULE$.unapply((FileBody)genericRequestBody);
            SttpFile sttpFile = fileBody2._1();
            MediaType mediaType = fileBody2._2();
            SttpFile file = sttpFile;
            return new StringBuilder(15).append("--data-binary @").append(file.name()).toString();
        }
        if (NoBody$.MODULE$.equals(genericRequestBody)) {
            return "";
        }
        throw new MatchError(genericRequestBody);
    }

    public String handleMultipartBody(Seq<Part<GenericRequestBody<?>>> parts) {
        return ((IterableOnceOps)parts.map((Function1 & Serializable)p -> {
            GenericRequestBody genericRequestBody = (GenericRequestBody)p.body();
            if (genericRequestBody instanceof StringBody) {
                StringBody stringBody = StringBody$.MODULE$.unapply((StringBody)genericRequestBody);
                String string = stringBody._1();
                String string2 = stringBody._2();
                MediaType mediaType = stringBody._3();
                String s = string;
                return new StringBuilder(10).append("--form '").append(p.name()).append("=").append(s).append("'").toString();
            }
            if (genericRequestBody instanceof FileBody) {
                FileBody fileBody2 = FileBody$.MODULE$.unapply((FileBody)genericRequestBody);
                SttpFile sttpFile = fileBody2._1();
                MediaType mediaType = fileBody2._2();
                SttpFile f = sttpFile;
                return new StringBuilder(11).append("--form '").append(p.name()).append("=@").append(f.name()).append("'").toString();
            }
            return "--data-binary <PLACEHOLDER>";
        })).mkString(this.newline());
    }

    private String extractOptions(GenericRequest<?, ?> r) {
        if (r.options().followRedirects()) {
            return new StringBuilder(23).append("--location").append(this.newline()).append("--max-redirs ").append(r.options().maxRedirects()).toString();
        }
        return "";
    }

    private Function1<GenericRequest<?, ?>, String> addSpaceIfNotEmpty(Function1<GenericRequest<?, ?>, String> fInput) {
        return (Function1 & Serializable)t -> {
            if (((String)fInput.apply(t)).isEmpty()) {
                return "";
            }
            return new StringBuilder(0).append(MODULE$.newline()).append(fInput.apply(t)).toString();
        };
    }

    private String newline() {
        return " \\\n  ";
    }
}

