/*
 * Decompiled with CFR 0.152.
 */
package sttp.client4.logging;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sttp.client4.GenericRequest;
import sttp.client4.Response;
import sttp.client4.Response$;
import sttp.client4.ResponseException;
import sttp.client4.logging.Log;
import sttp.client4.logging.LogConfig;
import sttp.client4.logging.LogContext;
import sttp.client4.logging.LogLevel;
import sttp.client4.logging.Logger;
import sttp.client4.logging.ResponseTimings;
import sttp.model.ResponseMetadata;
import sttp.model.StatusCode;

public class DefaultLog<F>
implements Log<F> {
    private final Logger<F> logger;
    private final LogConfig config;
    private final LogContext logContext;

    public DefaultLog(Logger<F> logger, LogConfig config, LogContext logContext) {
        this.logger = logger;
        this.config = config;
        this.logContext = logContext;
    }

    @Override
    public F beforeRequestSend(GenericRequest<?, ?> request) {
        boolean _logRequestBody = BoxesRunTime.unboxToBoolean((Object)request.loggingOptions().logRequestBody().getOrElse(this::$anonfun$1));
        boolean _logRequestHeaders = BoxesRunTime.unboxToBoolean((Object)request.loggingOptions().logRequestHeaders().getOrElse(this::$anonfun$2));
        String _message = this.config.beforeCurlInsteadOfShow() && _logRequestBody && _logRequestHeaders ? request.toCurl(this.config.sensitiveHeaders(), this.config.sensitiveQueryParams()) : request.show(_logRequestBody, _logRequestHeaders, this.config.sensitiveHeaders(), this.config.sensitiveQueryParams());
        return this.logger.apply(this.config.beforeRequestSendLogLevel(), (Function0<String>)((Function0 & Serializable)() -> DefaultLog.beforeRequestSend$$anonfun$1(_message)), (Option<Throwable>)None$.MODULE$, this.logContext.forRequest(request));
    }

    @Override
    public F response(GenericRequest<?, ?> request, ResponseMetadata response, Option<String> responseBody, Option<ResponseTimings> timings, Option<ResponseException<?>> exception) {
        Response<Object> responseWithBody = Response$.MODULE$.apply(responseBody.getOrElse(DefaultLog::$anonfun$3), response.code(), response.statusText(), response.headers(), (List<ResponseMetadata>)package$.MODULE$.Nil(), request);
        return this.logger.apply((LogLevel)this.config.responseLogLevel().apply((Object)new StatusCode(response.code())), (Function0<String>)((Function0 & Serializable)() -> this.response$$anonfun$1(responseWithBody, responseBody, request, timings)), exception, this.logContext.forResponse(request, response, timings));
    }

    @Override
    public F requestException(GenericRequest<?, ?> request, Option<Duration> timing, Throwable exception) {
        return this.logger.apply(this.config.responseExceptionLogLevel(), (Function0<String>)((Function0 & Serializable)() -> this.requestException$$anonfun$1(request, timing)), (Option<Throwable>)Some$.MODULE$.apply((Object)exception), this.logContext.forRequest(request));
    }

    private String elapsed(Duration d) {
        return StringOps$.MODULE$.format$extension("%.3fs", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)d.toMillis() / 1000.0))}));
    }

    private String tookFromDuration(Option<Duration> timing) {
        return (String)timing.fold(DefaultLog::tookFromDuration$$anonfun$1, (Function1 & Serializable)t -> StringOps$.MODULE$.format$extension(", took: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.elapsed((Duration)t)})));
    }

    private String took(Option<ResponseTimings> timings) {
        return (String)timings.fold(DefaultLog::took$$anonfun$1, (Function1 & Serializable)t -> {
            Option<Duration> option = t.bodyReceived();
            if (None$.MODULE$.equals(option)) {
                return new StringBuilder(8).append(", took: ").append(this.elapsed(t.bodyHandled())).toString();
            }
            if (option instanceof Some) {
                Duration br = (Duration)((Some)option).value();
                return new StringBuilder(22).append(", took: (body=").append(this.elapsed(br)).append(", full=").append(this.elapsed(t.bodyHandled())).append(")").toString();
            }
            throw new MatchError(option);
        });
    }

    private final boolean $anonfun$1() {
        return this.config.logRequestBody();
    }

    private final boolean $anonfun$2() {
        return this.config.logRequestHeaders();
    }

    private static final String beforeRequestSend$$anonfun$1(String _message$1) {
        return new StringBuilder(17).append("Sending request: ").append(_message$1).toString();
    }

    private static final String $anonfun$3() {
        return "";
    }

    private final boolean $anonfun$4() {
        return this.config.logResponseBody();
    }

    private final boolean $anonfun$5() {
        return this.config.logResponseHeaders();
    }

    private final String response$$anonfun$1(Response responseWithBody$1, Option responseBody$1, GenericRequest request$1, Option timings$1) {
        String responseAsString = responseWithBody$1.show(responseBody$1.isDefined() && BoxesRunTime.unboxToBoolean((Object)request$1.loggingOptions().logResponseBody().getOrElse(this::$anonfun$4)), BoxesRunTime.unboxToBoolean((Object)request$1.loggingOptions().logResponseHeaders().getOrElse(this::$anonfun$5)), this.config.sensitiveHeaders());
        return new StringBuilder(21).append("Request: ").append(request$1.showBasicSafe(this.config.sensitiveQueryParams())).append(this.took((Option<ResponseTimings>)timings$1)).append(", response: ").append(responseAsString).toString();
    }

    private final String requestException$$anonfun$1(GenericRequest request$2, Option timing$1) {
        return new StringBuilder(32).append("Exception when sending request: ").append(request$2.showBasic()).append(this.tookFromDuration((Option<Duration>)timing$1)).toString();
    }

    private static final String tookFromDuration$$anonfun$1() {
        return "";
    }

    private static final String took$$anonfun$1() {
        return "";
    }
}

