/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.core.format;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import org.openmole.core.context.Val;
import org.openmole.core.context.Val$;
import org.openmole.core.context.Variable;
import org.openmole.core.context.Variable$;
import org.openmole.core.exception.UserBadDataError;
import org.openmole.tool.logger.Prettifier$;
import org.openmole.tool.stream.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class CSVFormat$
implements Serializable {
    public static final CSVFormat$ MODULE$ = new CSVFormat$();

    private CSVFormat$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CSVFormat$.class);
    }

    public boolean isCSV(File f) {
        return f.getName().endsWith(".csv");
    }

    public String header(Seq<Val<?>> prototypes, Seq<Object> values, boolean arrayOnRow) {
        if (!arrayOnRow) {
            return ((IterableOnceOps)prototypes.map((Function1 & Serializable)_$1 -> _$1.name())).mkString(",");
        }
        return ((IterableOnceOps)((IterableOps)prototypes.zip(values)).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Val p = (Val)tuple2._1();
                Object v = tuple2._2();
                return (Seq)this.arrayHeaders$1(v, "").map((Function1 & Serializable)h -> p.name() + h);
            }
            throw new MatchError((Object)tuple2);
        })).mkString(",");
    }

    public void writeVariablesToCSV(File file, Seq<Variable<?>> variables, boolean unrollArray, boolean arrayOnRow, boolean gzip, boolean append) {
        org.openmole.tool.file.package$.MODULE$.FileDecorator(file).withPrintStream(append, true, gzip).apply((JProcedure1 & Serializable)ps -> this.appendVariablesToCSV((PrintStream)ps, (Function0<Option<String>>)((Function0 & Serializable)() -> this.writeVariablesToCSV$$anonfun$1$$anonfun$1(variables, arrayOnRow)), (Seq<Object>)((Seq)variables.map((Function1 & Serializable)_$4 -> _$4.value())), unrollArray, arrayOnRow, this.appendVariablesToCSV$default$6()));
    }

    public boolean writeVariablesToCSV$default$3() {
        return false;
    }

    public boolean writeVariablesToCSV$default$4() {
        return false;
    }

    public boolean writeVariablesToCSV$default$5() {
        return false;
    }

    public boolean writeVariablesToCSV$default$6() {
        return false;
    }

    public void appendVariablesToCSV(PrintStream output, Function0<Option<String>> header, Seq<Object> values, boolean unrollArray, boolean arrayOnRow, String margin) {
        ((Option)header.apply()).foreach((Function1)(JProcedure1 & Serializable)h -> package$.MODULE$.OutputStreamDecorator((OutputStream)output).appendLine(margin + h));
        if (unrollArray) {
            this.unroll$1(output, margin, values);
            return;
        }
        if (arrayOnRow) {
            this.onRow$1(output, margin, values);
            return;
        }
        package$.MODULE$.OutputStreamDecorator((OutputStream)output).appendLine(margin + this.csvLine$1(values));
    }

    public None$ appendVariablesToCSV$default$2() {
        return None$.MODULE$;
    }

    public boolean appendVariablesToCSV$default$4() {
        return false;
    }

    public boolean appendVariablesToCSV$default$5() {
        return false;
    }

    public String appendVariablesToCSV$default$6() {
        return "";
    }

    public Iterator<Iterable<Variable<?>>> csvToVariables(File file, Seq<Tuple2<String, Val<?>>> columns, Option<Object> separator) {
        CSVReader reader = new CSVReader((Reader)new FileReader(file), BoxesRunTime.unboxToChar((Object)separator.getOrElse(CSVFormat$::$anonfun$4)));
        Object object = Predef$.MODULE$.refArrayOps((Object[])reader.readNext());
        String[] headers = (String[])ArrayOps$.MODULE$.toArray$extension(object, ClassTag$.MODULE$.apply(String.class));
        Seq columnsIndexes = (Seq)columns.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String name = (String)tuple2._1();
                Object object = Predef$.MODULE$.refArrayOps((Object[])headers);
                int i = ArrayOps$.MODULE$.indexOf$extension(object, (Object)name, ArrayOps$.MODULE$.indexOf$default$2$extension(object));
                if (i == -1) {
                    throw new UserBadDataError("Unknown column name : " + name);
                }
                return i;
            }
            throw new MatchError((Object)tuple2);
        });
        return scala.package$.MODULE$.Iterator().continually(() -> CSVFormat$.csvToVariables$$anonfun$1(reader)).takeWhile((Function1 & Serializable)_$8 -> _$8 != null).map((Function1 & Serializable)line -> (Seq)((IterableOps)columns.zip((IterableOnce)columnsIndexes)).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                String name = (String)tuple2._1();
                Val v = (Val)tuple2._2();
                int i = BoxesRunTime.unboxToInt((Object)tuple22._2());
                return Variable$.MODULE$.unsecure(v, MODULE$.matchConverter(v, line[i], name));
            }
            throw new MatchError((Object)tuple22);
        }));
    }

    public Option<Object> csvToVariables$default$3() {
        return None$.MODULE$;
    }

    public Object matchConverter(Val<?> v, String s, String name) {
        Val<?> val = v;
        if (val != null) {
            Option option = Val$.MODULE$.caseDouble().unapply(val);
            if (!option.isEmpty()) {
                Val val2;
                Val v2 = val2 = (Val)option.get();
                return BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(s)));
            }
            Option option2 = Val$.MODULE$.caseString().unapply(val);
            if (!option2.isEmpty()) {
                Val val3;
                Val v3 = val3 = (Val)option2.get();
                return s;
            }
            Option option3 = Val$.MODULE$.caseBoolean().unapply(val);
            if (!option3.isEmpty()) {
                Val val4;
                Val v4 = val4 = (Val)option3.get();
                return BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(s)));
            }
            Option option4 = Val$.MODULE$.caseInt().unapply(val);
            if (!option4.isEmpty()) {
                Val val5;
                Val v5 = val5 = (Val)option4.get();
                return BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s)));
            }
            Option option5 = Val$.MODULE$.caseLong().unapply(val);
            if (!option5.isEmpty()) {
                Val val6;
                Val v6 = val6 = (Val)option5.get();
                return BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(s)));
            }
            Option option6 = Val$.MODULE$.caseArrayDouble().unapply(val);
            if (!option6.isEmpty()) {
                Val val7;
                Val v7 = val7 = (Val)option6.get();
                return this.matchArray$1(s, (Function1 & Serializable)_$9 -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_$9)), ClassTag$.MODULE$.apply(Double.TYPE));
            }
            Option option7 = Val$.MODULE$.caseArrayInt().unapply(val);
            if (!option7.isEmpty()) {
                Val val8;
                Val v8 = val8 = (Val)option7.get();
                return this.matchArray$1(s, (Function1 & Serializable)_$10 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$10)), ClassTag$.MODULE$.apply(Integer.TYPE));
            }
            Option option8 = Val$.MODULE$.caseArrayLong().unapply(val);
            if (!option8.isEmpty()) {
                Val val9;
                Val v9 = val9 = (Val)option8.get();
                return this.matchArray$1(s, (Function1 & Serializable)_$11 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$11)), ClassTag$.MODULE$.apply(Long.TYPE));
            }
            Option option9 = Val$.MODULE$.caseArrayString().unapply(val);
            if (!option9.isEmpty()) {
                Val val10;
                Val v10 = val10 = (Val)option9.get();
                return this.matchArray$1(s, (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x), ClassTag$.MODULE$.apply(String.class));
            }
            Option option10 = Val$.MODULE$.caseArrayBoolean().unapply(val);
            if (!option10.isEmpty()) {
                Val val11;
                Val v11 = val11 = (Val)option10.get();
                return this.matchArray$1(s, (Function1 & Serializable)_$12 -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(_$12)), ClassTag$.MODULE$.apply(Boolean.TYPE));
            }
            Option option11 = Val$.MODULE$.caseArrayArrayDouble().unapply(val);
            if (!option11.isEmpty()) {
                Val val12;
                Val v12 = val12 = (Val)option11.get();
                return this.matchArray$1(s, (Function1 & Serializable)_$13 -> (double[])this.matchArray$1((String)_$13, (Function1 & Serializable)_$14 -> StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(_$14)), ClassTag$.MODULE$.apply(Double.TYPE)), ClassTag$.MODULE$.apply(Double.TYPE).wrap());
            }
            Option option12 = Val$.MODULE$.caseArrayArrayInt().unapply(val);
            if (!option12.isEmpty()) {
                Val val13;
                Val v13 = val13 = (Val)option12.get();
                return this.matchArray$1(s, (Function1 & Serializable)_$15 -> (int[])this.matchArray$1((String)_$15, (Function1 & Serializable)_$16 -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(_$16)), ClassTag$.MODULE$.apply(Integer.TYPE)), ClassTag$.MODULE$.apply(Integer.TYPE).wrap());
            }
            Option option13 = Val$.MODULE$.caseArrayArrayLong().unapply(val);
            if (!option13.isEmpty()) {
                Val val14;
                Val v14 = val14 = (Val)option13.get();
                return this.matchArray$1(s, (Function1 & Serializable)_$17 -> (long[])this.matchArray$1((String)_$17, (Function1 & Serializable)_$18 -> StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(_$18)), ClassTag$.MODULE$.apply(Long.TYPE)), ClassTag$.MODULE$.apply(Long.TYPE).wrap());
            }
            Option option14 = Val$.MODULE$.caseArrayArrayString().unapply(val);
            if (!option14.isEmpty()) {
                Val val15;
                Val v15 = val15 = (Val)option14.get();
                return this.matchArray$1(s, (Function1 & Serializable)_$19 -> (String[])this.matchArray$1((String)_$19, (Function1 & Serializable)x -> (String)Predef$.MODULE$.identity(x), ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(String.class).wrap());
            }
            Option option15 = Val$.MODULE$.caseArrayArrayBoolean().unapply(val);
            if (!option15.isEmpty()) {
                Val val16;
                Val v16 = val16 = (Val)option15.get();
                return this.matchArray$1(s, (Function1 & Serializable)_$20 -> (boolean[])this.matchArray$1((String)_$20, (Function1 & Serializable)_$21 -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(_$21)), ClassTag$.MODULE$.apply(Boolean.TYPE)), ClassTag$.MODULE$.apply(Boolean.TYPE).wrap());
            }
        }
        throw new UserBadDataError("Unsupported type in CSV sampling prototype " + v + " mapped to column " + name);
    }

    private final Seq arrayHeaders$1(Object v, String h) {
        Object object = v;
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object v2 = object;
            Object object2 = Predef$.MODULE$.genericArrayOps(v2);
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object2));
            return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.flatMap$extension(object3, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object e = tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return this.arrayHeaders$1(e, h + "$" + i);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(String.class)));
        }
        if (object instanceof Seq) {
            Seq v3 = (Seq)object;
            return (Seq)((IterableOps)v3.zipWithIndex()).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Object e = tuple2._1();
                    int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return this.arrayHeaders$1(e, h + "$" + i);
                }
                throw new MatchError((Object)tuple2);
            });
        }
        Object v4 = object;
        return (Seq)((SeqOps)new .colon.colon((Object)h, (List)Nil$.MODULE$));
    }

    private final String headerValue$1(Seq variables$1, boolean arrayOnRow$1) {
        return this.header((Seq)variables$1.map((Function1 & Serializable)_$2 -> _$2.prototype()), (Seq<Object>)((Seq)variables$1.map((Function1 & Serializable)_$3 -> _$3.value())), arrayOnRow$1);
    }

    private final Option writeVariablesToCSV$$anonfun$1$$anonfun$1(Seq variables$3, boolean arrayOnRow$3) {
        return Some$.MODULE$.apply((Object)this.headerValue$1(variables$3, arrayOnRow$3));
    }

    private final String format$1(Object v2) {
        Object object = v2;
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object v3 = object;
            Object object2 = Predef$.MODULE$.genericArrayOps(v3);
            return "[" + Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)v -> this.format$1(v), ClassTag$.MODULE$.apply(String.class))).mkString(",") + "]";
        }
        if (object instanceof Seq) {
            Seq v4 = (Seq)object;
            return "[" + ((IterableOnceOps)v4.map((Function1 & Serializable)v -> this.format$1(v))).mkString(",") + "]";
        }
        Object v5 = object;
        return Prettifier$.MODULE$.prettify(v5, Prettifier$.MODULE$.prettify$default$2());
    }

    private final String quote$1(Object v) {
        Object object = v;
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object v2 = object;
            return "\"" + this.format$1(v2) + "\"";
        }
        if (object instanceof Seq) {
            Seq v3 = (Seq)object;
            return "\"" + this.format$1(v3) + "\"";
        }
        Object v4 = object;
        return Prettifier$.MODULE$.prettify(v4, Prettifier$.MODULE$.prettify$default$2());
    }

    private final String csvLine$1(Seq v2) {
        return ((IterableOnceOps)v2.map((Function1 & Serializable)v -> this.quote$1(v))).mkString(",");
    }

    private final void writeLines$1(PrintStream output$3, String margin$3, Seq lists) {
        while (true) {
            Seq skipHead;
            package$.MODULE$.OutputStreamDecorator((OutputStream)output$3).appendLine(margin$3 + this.csvLine$1((Seq)lists.map((Function1 & Serializable)_$5 -> _$5.head())));
            boolean lastLine = lists.forall((Function1 & Serializable)_$6 -> ((List)_$6.tail()).isEmpty());
            if (lastLine) break;
            lists = skipHead = (Seq)lists.map((Function1 & Serializable)x$1 -> {
                List list = x$1;
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list2 = colon2.next();
                    Object h = colon2.head();
                    Nil$ nil$ = scala.package$.MODULE$.Nil();
                    List list3 = list2;
                    if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                        return scala.package$.MODULE$.Nil().$colon$colon(h);
                    }
                    List t = list2;
                    return t;
                }
                Nil$ nil$ = scala.package$.MODULE$.Nil();
                List list4 = list;
                if (!(nil$ != null ? !nil$.equals(list4) : list4 != null)) {
                    return scala.package$.MODULE$.Nil();
                }
                throw new MatchError((Object)list);
            });
        }
    }

    private final void unroll$1(PrintStream output$2, String margin$2, Seq v) {
        Seq lists = (Seq)v.map((Function1 & Serializable)x$1 -> {
            Object object = x$1;
            if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object v = object;
                return Predef$.MODULE$.genericWrapArray(v).toList();
            }
            if (object instanceof Seq) {
                Seq v = (Seq)object;
                return v.toList();
            }
            Object v = object;
            return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{v}));
        });
        if (lists.forall((Function1 & Serializable)_$7 -> !_$7.isEmpty())) {
            this.writeLines$1(output$2, margin$2, lists);
            return;
        }
    }

    private final Seq arrayValues$1(Object v2) {
        Object object = v2;
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object v3 = object;
            Object object2 = Predef$.MODULE$.genericArrayOps(v3);
            return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.flatMap$extension(object2, (Function1 & Serializable)v -> this.arrayValues$1(v), ClassTag$.MODULE$.Any()));
        }
        if (object instanceof Seq) {
            Seq v4 = (Seq)object;
            return (Seq)v4.flatMap((Function1 & Serializable)v -> this.arrayValues$1(v));
        }
        Object v5 = object;
        return (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{v5}));
    }

    private final void onRow$1(PrintStream output$4, String margin$4, Seq v) {
        package$.MODULE$.OutputStreamDecorator((OutputStream)output$4).appendLine(margin$4 + this.csvLine$1(this.arrayValues$1(v)));
    }

    private static final char $anonfun$4() {
        return ',';
    }

    private static final String[] csvToVariables$$anonfun$1(CSVReader reader$1) {
        return reader$1.readNext();
    }

    private final Object matchArray$1(String s2, Function1 convert, ClassTag evidence$1) {
        String trimed = s2.trim();
        if (!trimed.startsWith("[") || !trimed.endsWith("]")) {
            throw new UserBadDataError("Array in CSV files should have the following format [.., .., ..], found " + s2);
        }
        Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(s2), 1)), 1).split(","));
        return ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)s -> convert.apply((Object)s.trim()), evidence$1);
    }
}

