/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw.dtw;

import java.util.Iterator;
import org.openmole.tool.dtw.dtw.PartialWindowMatrix;
import org.openmole.tool.dtw.dtw.SearchWindow;
import org.openmole.tool.dtw.dtw.TimeWarpInfo;
import org.openmole.tool.dtw.dtw.WarpPath;
import org.openmole.tool.dtw.dtw.WindowMatrix;
import org.openmole.tool.dtw.matrix.ColMajorCell;
import org.openmole.tool.dtw.timeseries.TimeSeries;
import org.openmole.tool.dtw.util.DistanceFunction;

public class DTW {
    public static double calcWarpCost(WarpPath warpPath, TimeSeries timeSeries, TimeSeries timeSeries2, DistanceFunction distanceFunction) {
        double d = 0.0;
        for (int i = 0; i < warpPath.size(); ++i) {
            ColMajorCell colMajorCell = warpPath.get(i);
            d += distanceFunction.calcDistance(timeSeries.getMeasurementVector(colMajorCell.getCol()), timeSeries2.getMeasurementVector(colMajorCell.getRow()));
        }
        return d;
    }

    public static double getWarpDistBetween(TimeSeries timeSeries, TimeSeries timeSeries2, DistanceFunction distanceFunction) {
        int n;
        if (timeSeries.size() < timeSeries2.size()) {
            return DTW.getWarpDistBetween(timeSeries2, timeSeries, distanceFunction);
        }
        double[] dArray = new double[timeSeries2.size()];
        double[] dArray2 = new double[timeSeries2.size()];
        int n2 = timeSeries.size() - 1;
        int n3 = timeSeries2.size() - 1;
        dArray2[0] = distanceFunction.calcDistance(timeSeries.getMeasurementVector(0), timeSeries2.getMeasurementVector(0));
        for (n = 1; n <= n3; ++n) {
            dArray2[n] = dArray2[n - 1] + distanceFunction.calcDistance(timeSeries.getMeasurementVector(0), timeSeries2.getMeasurementVector(n));
        }
        for (n = 1; n <= n2; ++n) {
            double[] dArray3 = dArray;
            dArray = dArray2;
            dArray2 = dArray3;
            dArray2[0] = dArray[0] + distanceFunction.calcDistance(timeSeries.getMeasurementVector(n), timeSeries2.getMeasurementVector(0));
            for (int i = 1; i <= n3; ++i) {
                double d = Math.min(dArray[i], Math.min(dArray[i - 1], dArray2[i - 1]));
                dArray2[i] = d + distanceFunction.calcDistance(timeSeries.getMeasurementVector(n), timeSeries2.getMeasurementVector(i));
            }
        }
        return dArray2[n3];
    }

    public static WarpPath getWarpPathBetween(TimeSeries timeSeries, TimeSeries timeSeries2, DistanceFunction distanceFunction) {
        return DTW.DynamicTimeWarp(timeSeries, timeSeries2, distanceFunction).getPath();
    }

    public static TimeWarpInfo getWarpInfoBetween(TimeSeries timeSeries, TimeSeries timeSeries2, DistanceFunction distanceFunction) {
        return DTW.DynamicTimeWarp(timeSeries, timeSeries2, distanceFunction);
    }

    private static TimeWarpInfo DynamicTimeWarp(TimeSeries timeSeries, TimeSeries timeSeries2, DistanceFunction distanceFunction) {
        int n;
        double[][] dArray = new double[timeSeries.size()][timeSeries2.size()];
        int n2 = timeSeries.size() - 1;
        int n3 = timeSeries2.size() - 1;
        dArray[0][0] = distanceFunction.calcDistance(timeSeries.getMeasurementVector(0), timeSeries2.getMeasurementVector(0));
        for (n = 1; n <= n3; ++n) {
            dArray[0][n] = dArray[0][n - 1] + distanceFunction.calcDistance(timeSeries.getMeasurementVector(0), timeSeries2.getMeasurementVector(n));
        }
        for (n = 1; n <= n2; ++n) {
            dArray[n][0] = dArray[n - 1][0] + distanceFunction.calcDistance(timeSeries.getMeasurementVector(n), timeSeries2.getMeasurementVector(0));
            for (int i = 1; i <= n3; ++i) {
                double d = Math.min(dArray[n - 1][i], Math.min(dArray[n - 1][i - 1], dArray[n][i - 1]));
                dArray[n][i] = d + distanceFunction.calcDistance(timeSeries.getMeasurementVector(n), timeSeries2.getMeasurementVector(i));
            }
        }
        double d = dArray[n2][n3];
        WarpPath warpPath = new WarpPath(n2 + n3 - 1);
        int n4 = n2;
        int n5 = n3;
        warpPath.addFirst(n4, n5);
        while (n4 > 0 || n5 > 0) {
            double d2 = n4 > 0 && n5 > 0 ? dArray[n4 - 1][n5 - 1] : Double.POSITIVE_INFINITY;
            double d3 = n4 > 0 ? dArray[n4 - 1][n5] : Double.POSITIVE_INFINITY;
            double d4 = n5 > 0 ? dArray[n4][n5 - 1] : Double.POSITIVE_INFINITY;
            if (d2 <= d3 && d2 <= d4) {
                --n4;
                --n5;
            } else if (d3 < d2 && d3 < d4) {
                --n4;
            } else if (d4 < d2 && d4 < d3) {
                --n5;
            } else if (n4 <= n5) {
                --n5;
            } else {
                --n4;
            }
            warpPath.addFirst(n4, n5);
        }
        return new TimeWarpInfo(d, warpPath);
    }

    public static double getWarpDistBetween(TimeSeries timeSeries, TimeSeries timeSeries2, SearchWindow searchWindow, DistanceFunction distanceFunction) {
        PartialWindowMatrix partialWindowMatrix = new PartialWindowMatrix(searchWindow);
        int n = timeSeries.size() - 1;
        int n2 = timeSeries2.size() - 1;
        Iterator iterator = searchWindow.iterator();
        while (iterator.hasNext()) {
            ColMajorCell colMajorCell = (ColMajorCell)iterator.next();
            int n3 = colMajorCell.getCol();
            int n4 = colMajorCell.getRow();
            if (n3 == 0 && n4 == 0) {
                partialWindowMatrix.put(n3, n4, distanceFunction.calcDistance(timeSeries.getMeasurementVector(0), timeSeries2.getMeasurementVector(0)));
                continue;
            }
            if (n3 == 0) {
                partialWindowMatrix.put(n3, n4, distanceFunction.calcDistance(timeSeries.getMeasurementVector(0), timeSeries2.getMeasurementVector(n4)) + partialWindowMatrix.get(n3, n4 - 1));
                continue;
            }
            if (n4 == 0) {
                partialWindowMatrix.put(n3, n4, distanceFunction.calcDistance(timeSeries.getMeasurementVector(n3), timeSeries2.getMeasurementVector(0)) + partialWindowMatrix.get(n3 - 1, n4));
                continue;
            }
            double d = Math.min(partialWindowMatrix.get(n3 - 1, n4), Math.min(partialWindowMatrix.get(n3 - 1, n4 - 1), partialWindowMatrix.get(n3, n4 - 1)));
            partialWindowMatrix.put(n3, n4, d + distanceFunction.calcDistance(timeSeries.getMeasurementVector(n3), timeSeries2.getMeasurementVector(n4)));
        }
        return partialWindowMatrix.get(n, n2);
    }

    public static WarpPath getWarpPathBetween(TimeSeries timeSeries, TimeSeries timeSeries2, SearchWindow searchWindow, DistanceFunction distanceFunction) {
        return DTW.constrainedTimeWarp(timeSeries, timeSeries2, searchWindow, distanceFunction).getPath();
    }

    public static TimeWarpInfo getWarpInfoBetween(TimeSeries timeSeries, TimeSeries timeSeries2, SearchWindow searchWindow, DistanceFunction distanceFunction) {
        return DTW.constrainedTimeWarp(timeSeries, timeSeries2, searchWindow, distanceFunction);
    }

    private static TimeWarpInfo constrainedTimeWarp(TimeSeries timeSeries, TimeSeries timeSeries2, SearchWindow searchWindow, DistanceFunction distanceFunction) {
        WindowMatrix windowMatrix = new WindowMatrix(searchWindow);
        int n = timeSeries.size() - 1;
        int n2 = timeSeries2.size() - 1;
        Iterator iterator = searchWindow.iterator();
        while (iterator.hasNext()) {
            ColMajorCell colMajorCell = (ColMajorCell)iterator.next();
            int n3 = colMajorCell.getCol();
            int n4 = colMajorCell.getRow();
            if (n3 == 0 && n4 == 0) {
                windowMatrix.put(n3, n4, distanceFunction.calcDistance(timeSeries.getMeasurementVector(0), timeSeries2.getMeasurementVector(0)));
                continue;
            }
            if (n3 == 0) {
                windowMatrix.put(n3, n4, distanceFunction.calcDistance(timeSeries.getMeasurementVector(0), timeSeries2.getMeasurementVector(n4)) + windowMatrix.get(n3, n4 - 1));
                continue;
            }
            if (n4 == 0) {
                windowMatrix.put(n3, n4, distanceFunction.calcDistance(timeSeries.getMeasurementVector(n3), timeSeries2.getMeasurementVector(0)) + windowMatrix.get(n3 - 1, n4));
                continue;
            }
            double d = Math.min(windowMatrix.get(n3 - 1, n4), Math.min(windowMatrix.get(n3 - 1, n4 - 1), windowMatrix.get(n3, n4 - 1)));
            windowMatrix.put(n3, n4, d + distanceFunction.calcDistance(timeSeries.getMeasurementVector(n3), timeSeries2.getMeasurementVector(n4)));
        }
        double d = windowMatrix.get(n, n2);
        WarpPath warpPath = new WarpPath(n + n2 - 1);
        int n5 = n;
        int n6 = n2;
        warpPath.addFirst(n5, n6);
        while (n5 > 0 || n6 > 0) {
            double d2 = n5 > 0 && n6 > 0 ? windowMatrix.get(n5 - 1, n6 - 1) : Double.POSITIVE_INFINITY;
            double d3 = n5 > 0 ? windowMatrix.get(n5 - 1, n6) : Double.POSITIVE_INFINITY;
            double d4 = n6 > 0 ? windowMatrix.get(n5, n6 - 1) : Double.POSITIVE_INFINITY;
            if (d2 <= d3 && d2 <= d4) {
                --n5;
                --n6;
            } else if (d3 < d2 && d3 < d4) {
                --n5;
            } else if (d4 < d2 && d4 < d3) {
                --n6;
            } else if (n5 <= n6) {
                --n6;
            } else {
                --n5;
            }
            warpPath.addFirst(n5, n6);
        }
        windowMatrix.freeMem();
        return new TimeWarpInfo(d, warpPath);
    }
}

