/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.dtw.dtw;

import org.openmole.tool.dtw.dtw.DTW;
import org.openmole.tool.dtw.dtw.ExpandedResWindow;
import org.openmole.tool.dtw.dtw.TimeWarpInfo;
import org.openmole.tool.dtw.dtw.WarpPath;
import org.openmole.tool.dtw.timeseries.PAA;
import org.openmole.tool.dtw.timeseries.TimeSeries;
import org.openmole.tool.dtw.util.DistanceFunction;

public class FastDTW {
    static final int DEFAULT_SEARCH_RADIUS = 1;

    public static double getWarpDistBetween(TimeSeries timeSeries, TimeSeries timeSeries2, DistanceFunction distanceFunction) {
        return FastDTW.fastDTW(timeSeries, timeSeries2, 1, distanceFunction).getDistance();
    }

    public static double getWarpDistBetween(TimeSeries timeSeries, TimeSeries timeSeries2, int n, DistanceFunction distanceFunction) {
        return FastDTW.fastDTW(timeSeries, timeSeries2, n, distanceFunction).getDistance();
    }

    public static WarpPath getWarpPathBetween(TimeSeries timeSeries, TimeSeries timeSeries2, DistanceFunction distanceFunction) {
        return FastDTW.fastDTW(timeSeries, timeSeries2, 1, distanceFunction).getPath();
    }

    public static WarpPath getWarpPathBetween(TimeSeries timeSeries, TimeSeries timeSeries2, int n, DistanceFunction distanceFunction) {
        return FastDTW.fastDTW(timeSeries, timeSeries2, n, distanceFunction).getPath();
    }

    public static TimeWarpInfo getWarpInfoBetween(TimeSeries timeSeries, TimeSeries timeSeries2, int n, DistanceFunction distanceFunction) {
        return FastDTW.fastDTW(timeSeries, timeSeries2, n, distanceFunction);
    }

    private static TimeWarpInfo fastDTW(TimeSeries timeSeries, TimeSeries timeSeries2, int n, DistanceFunction distanceFunction) {
        if (n < 0) {
            n = 0;
        }
        int n2 = n + 2;
        if (timeSeries.size() <= n2 || timeSeries2.size() <= n2) {
            return DTW.getWarpInfoBetween(timeSeries, timeSeries2, distanceFunction);
        }
        PAA pAA = new PAA(timeSeries, (int)((double)timeSeries.size() / 2.0));
        PAA pAA2 = new PAA(timeSeries2, (int)((double)timeSeries2.size() / 2.0));
        ExpandedResWindow expandedResWindow = new ExpandedResWindow(timeSeries, timeSeries2, pAA, pAA2, FastDTW.getWarpPathBetween(pAA, pAA2, n, distanceFunction), n);
        return DTW.getWarpInfoBetween(timeSeries, timeSeries2, expandedResWindow, distanceFunction);
    }
}

