/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.file;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Set;
import org.openmole.tool.file.CopyDirVisitor;
import org.openmole.tool.file.FileTools$;
import org.openmole.tool.file.package$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class DirUtils$
implements Serializable {
    public static final DirUtils$ MODULE$ = new DirUtils$();

    private DirUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DirUtils$.class);
    }

    public Path copy(Path from, Path to, Set<FileVisitOption> visitOption, CopyOption[] copyOptions) throws IOException {
        this.validate((Seq<Path>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{from}));
        return Files.walkFileTree(from, visitOption, Integer.MAX_VALUE, new CopyDirVisitor(from, to, copyOptions));
    }

    public Path copy(Path from, Path to, boolean followSymlinks) throws IOException {
        Seq copyOptions = package$.MODULE$.getCopyOptions(followSymlinks);
        return this.copy(from, to, EnumSet.noneOf(FileVisitOption.class), (CopyOption[])copyOptions.toArray(ClassTag$.MODULE$.apply(CopyOption.class)));
    }

    public boolean copy$default$3() {
        return false;
    }

    public Path move(Path from, Path to) throws IOException {
        this.validate((Seq<Path>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{from}));
        this.copy(from, to, this.copy$default$3());
        this.delete(from);
        return to;
    }

    public void delete(Path p) throws IOException {
        File file = p.toFile();
        if (!package$.MODULE$.FileDecorator(package$.MODULE$.file2Path(file).toFile()).isSymbolicLink() && file.isDirectory()) {
            Object[] objectArray;
            try {
                objectArray = package$.MODULE$.FileDecorator(file).listFilesSafe();
            }
            catch (IOException t) {
                FileTools$.MODULE$.setAllPermissions(package$.MODULE$.file2Path(file));
                objectArray = package$.MODULE$.FileDecorator(file).listFilesSafe();
            }
            Object[] list = objectArray;
            Object object = Predef$.MODULE$.refArrayOps(list);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)s -> {
                if (s.isDirectory()) {
                    MODULE$.delete(s.toPath());
                    return BoxedUnit.UNIT;
                }
                return BoxesRunTime.boxToBoolean((boolean)package$.MODULE$.FileDecorator((File)s).forceFileDelete());
            });
        }
        package$.MODULE$.FileDecorator(file).forceFileDelete();
    }

    public void deleteIfExists(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            this.delete(path);
            return;
        }
    }

    private void validate(Seq<Path> paths) {
        paths.foreach((Function1)(JProcedure1 & Serializable)path -> {
            Objects.requireNonNull(path);
            if (!Files.isDirectory(path, new LinkOption[0])) {
                throw new IllegalArgumentException(path.toString() + " is not a directory");
            }
        });
    }
}

