/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.tool.file;

import com.github.f4b6a3.ulid.Ulid;
import com.github.f4b6a3.ulid.UlidCreator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.openmole.tool.file.DirUtils$;
import org.openmole.tool.file.FileTools$;
import org.openmole.tool.file.package$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.IArray;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.boundary;
import scala.util.boundary$;
import squants.time.Time;

public interface FilePackage {
    public static void $init$(FilePackage $this) {
        $this.org$openmole$tool$file$FilePackage$_setter_$EXEC_MODE_$eq(73);
        $this.org$openmole$tool$file$FilePackage$_setter_$WRITE_MODE_$eq(146);
        $this.org$openmole$tool$file$FilePackage$_setter_$READ_MODE_$eq(292);
        $this.org$openmole$tool$file$FilePackage$_setter_$fileOrdering_$eq(scala.package$.MODULE$.Ordering().by((Function1 & Serializable)_$1 -> _$1.getPath(), (Ordering)Ordering.String$.MODULE$));
    }

    public static File File$(FilePackage $this, String s) {
        return $this.File(s);
    }

    default public File File(String s) {
        return new File(s);
    }

    public static File currentDirectory$(FilePackage $this) {
        return $this.currentDirectory();
    }

    default public File currentDirectory() {
        return new File(".");
    }

    public int EXEC_MODE();

    public void org$openmole$tool$file$FilePackage$_setter_$EXEC_MODE_$eq(int var1);

    public int WRITE_MODE();

    public void org$openmole$tool$file$FilePackage$_setter_$WRITE_MODE_$eq(int var1);

    public int READ_MODE();

    public void org$openmole$tool$file$FilePackage$_setter_$READ_MODE_$eq(int var1);

    public static void copyChannel$(FilePackage $this, FileChannel source, FileChannel destination) {
        $this.copyChannel(source, destination);
    }

    default public void copyChannel(FileChannel source, FileChannel destination) {
        source.transferTo(0L, source.size(), destination);
    }

    public static Path file2Path$(FilePackage $this, File file) {
        return $this.file2Path(file);
    }

    default public Path file2Path(File file) {
        return file.toPath();
    }

    public static File path2File$(FilePackage $this, Path path) {
        return $this.path2File(path);
    }

    default public File path2File(Path path) {
        return path.toFile();
    }

    public Ordering<File> fileOrdering();

    public void org$openmole$tool$file$FilePackage$_setter_$fileOrdering_$eq(Ordering var1);

    public static FileFilter predicateToFileFilter$(FilePackage $this, Function1 predicate) {
        return $this.predicateToFileFilter((Function1<File, Object>)predicate);
    }

    default public FileFilter predicateToFileFilter(Function1<File, Object> predicate) {
        return p1 -> BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)p1));
    }

    public static Seq getCopyOptions$(FilePackage $this, boolean followSymlinks) {
        return $this.getCopyOptions(followSymlinks);
    }

    default public Seq<CopyOption> getCopyOptions(boolean followSymlinks) {
        return (Seq)((SeqOps)new .colon.colon((Object)StandardCopyOption.COPY_ATTRIBUTES, (List)new .colon.colon((Object)StandardCopyOption.REPLACE_EXISTING, (List)Nil$.MODULE$))).$plus$plus((IterableOnce)(followSymlinks ? scala.package$.MODULE$.Seq().empty() : (SeqOps)new .colon.colon((Object)LinkOption.NOFOLLOW_LINKS, (List)Nil$.MODULE$)));
    }

    public static FileDecorator FileDecorator$(FilePackage $this, File file) {
        return $this.FileDecorator(file);
    }

    default public FileDecorator FileDecorator(File file) {
        return new FileDecorator(this, file);
    }

    private boolean block(File file, Iterable<File> stopPath) {
        return stopPath.exists((Function1 & Serializable)f -> {
            if (f.exists() && file.exists()) {
                return Files.isSameFile(this.file2Path((File)f), this.file2Path(file));
            }
            return false;
        });
    }

    public static void org$openmole$tool$file$FilePackage$$recurse$(FilePackage $this, File file, Function1 operation, Iterable stopPath) {
        $this.org$openmole$tool$file$FilePackage$$recurse(file, (Function1<File, BoxedUnit>)operation, (Iterable<File>)stopPath);
    }

    default public void org$openmole$tool$file$FilePackage$$recurse(File file, Function1<File, BoxedUnit> operation, Iterable<File> stopPath) {
        if (!this.block(file, stopPath)) {
            if (file.isDirectory() && !this.FileDecorator(file).isSymbolicLink()) {
                this.authorizeListFiles$1(file, (Function0 & Serializable)() -> {
                    this.recurse$$anonfun$1(file, operation, stopPath);
                    return BoxedUnit.UNIT;
                });
            }
            operation.apply((Object)file);
            return;
        }
    }

    public static String readableByteCount$(FilePackage $this, long bytes) {
        return $this.readableByteCount(bytes);
    }

    default public String readableByteCount(long bytes) {
        long kb = 1024L;
        long mB = kb * kb;
        long gB = mB * kb;
        long tB = gB * kb;
        double doubleBytes = bytes;
        if (bytes < mB) {
            Double d = (Double)Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)(doubleBytes / (double)kb)));
            return Predef.StringFormat$.MODULE$.formatted$extension((Object)d, "%.2f").toString() + "KB";
        }
        if (bytes < gB) {
            Double d = (Double)Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)(doubleBytes / (double)mB)));
            return Predef.StringFormat$.MODULE$.formatted$extension((Object)d, "%.2f").toString() + "MB";
        }
        if (bytes < tB) {
            Double d = (Double)Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)(doubleBytes / (double)gB)));
            return Predef.StringFormat$.MODULE$.formatted$extension((Object)d, "%.2f").toString() + "GB";
        }
        Double d = (Double)Predef$.MODULE$.StringFormat((Object)BoxesRunTime.boxToDouble((double)(doubleBytes / (double)tB)));
        return Predef.StringFormat$.MODULE$.formatted$extension((Object)d, "%.2f").toString() + "TB";
    }

    public static String uniqName$(FilePackage $this, String prefix, String suffix, String separator) {
        return $this.uniqName(prefix, suffix, separator);
    }

    default public String uniqName(String prefix, String suffix, String separator) {
        Ulid ulid = UlidCreator.getUlid();
        return prefix + separator + ulid.toLowerCase() + suffix;
    }

    public static String uniqName$default$3$(FilePackage $this) {
        return $this.uniqName$default$3();
    }

    default public String uniqName$default$3() {
        return "-";
    }

    public static DirectoryStream.Filter acceptDirectory$(FilePackage $this) {
        return $this.acceptDirectory();
    }

    default public DirectoryStream.Filter<Path> acceptDirectory() {
        return new DirectoryStream.Filter<Path>(){

            public boolean accept(Path entry) {
                return Files.isDirectory(entry, new LinkOption[0]);
            }
        };
    }

    public static /* synthetic */ boolean org$openmole$tool$file$FilePackage$FileDecorator$$_$isDirectoryEmpty$$anonfun$1(DirectoryStream _$2) {
        return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(_$2.iterator()).asScala()).isEmpty();
    }

    public static File[] org$openmole$tool$file$FilePackage$FileDecorator$$_$listFilesSafe$$anonfun$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public static File[] org$openmole$tool$file$FilePackage$FileDecorator$$_$listFilesSafe$$anonfun$2() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public static File[] org$openmole$tool$file$FilePackage$FileDecorator$$_$recursiveListFilesSafe$$anonfun$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    public static /* synthetic */ void org$openmole$tool$file$FilePackage$FileDecorator$$_$copy$$anonfun$2(OutputStream to$1, FilterInputStream _$3) {
        org.openmole.tool.stream.package$.MODULE$.InputStreamDecorator((InputStream)_$3).copy(to$1);
    }

    public static /* synthetic */ void org$openmole$tool$file$FilePackage$FileDecorator$$_$copy$$anonfun$4(OutputStream to$2, int maxRead$1, Time timeout$1, ThreadPoolExecutor pool$1, FilterInputStream _$4) {
        org.openmole.tool.stream.package$.MODULE$.InputStreamDecorator((InputStream)_$4).copy(to$2, maxRead$1, timeout$1, pool$1);
    }

    private static /* synthetic */ boolean baseName$$anonfun$1(char _$5) {
        return _$5 != '.';
    }

    public static /* bridge */ /* synthetic */ boolean org$openmole$tool$file$FilePackage$FileDecorator$$_$baseName$$anonfun$adapted$1(Object _$5) {
        return FilePackage.baseName$$anonfun$1(BoxesRunTime.unboxToChar((Object)_$5));
    }

    public static boolean org$openmole$tool$file$FilePackage$FileDecorator$$_$isPosix$1() {
        return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
    }

    public static /* synthetic */ String org$openmole$tool$file$FilePackage$FileDecorator$$_$content$$anonfun$1(GZIPInputStream is) {
        return Source$.MODULE$.fromInputStream((InputStream)is, Codec$.MODULE$.fallbackSystemCodec()).mkString();
    }

    private static CharBuffer $anonfun$1(InputStream is$1, int bytes$1) {
        byte[] rBytes = is$1.readNBytes(bytes$1);
        return ((Charset)Charset.availableCharsets().get("UTF-8")).newDecoder().decode(ByteBuffer.wrap(rBytes));
    }

    public static /* synthetic */ boolean org$openmole$tool$file$FilePackage$FileDecorator$$_$isTextFile$$anonfun$1(int bytes$2, InputStream is) {
        Try res = Try$.MODULE$.apply(() -> FilePackage.$anonfun$1(is, bytes$2));
        return res.isSuccess();
    }

    public static /* synthetic */ ListBuffer org$openmole$tool$file$FilePackage$FileDecorator$$_$lastModification$$anonfun$1(ListBuffer toProceed$3, File child) {
        return (ListBuffer)toProceed$3.$plus$eq((Object)child);
    }

    public static /* synthetic */ void org$openmole$tool$file$FilePackage$FileDecorator$$_$listRecursive$$anonfun$1(Function1 filter$1, ListBuffer ret$1, File f) {
        if (BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)f))) {
            ret$1.$plus$eq((Object)f);
            return;
        }
    }

    public static /* synthetic */ boolean org$openmole$tool$file$FilePackage$FileDecorator$$_$listRecursive$default$1$$anonfun$1(File _$6) {
        return true;
    }

    private static BufferedOutputStream withLock$$anonfun$1$$anonfun$2$$anonfun$1(FileOutputStream fos$1) {
        return new BufferedOutputStream(fos$1);
    }

    public static /* synthetic */ Object org$openmole$tool$file$FilePackage$FileDecorator$$_$withLock$$anonfun$1$$anonfun$2(Function1 f$3, FileOutputStream fos) {
        return org.openmole.tool.stream.package$.MODULE$.withClosable(() -> FilePackage.withLock$$anonfun$1$$anonfun$2$$anonfun$1(fos), (Function1 & Serializable)bfos -> {
            Object object;
            FileLock lock = fos.getChannel().lock();
            try {
                object = f$3.apply(bfos);
            }
            finally {
                lock.release();
            }
            return object;
        });
    }

    public static /* synthetic */ Object org$openmole$tool$file$FilePackage$FileDecorator$$_$withLockInDirectory$$anonfun$1(Function0 f$4, OutputStream _$7) {
        return f$4.apply();
    }

    private Object authorizeListFiles$1(File f, Function0 g) {
        Object object;
        int originalMode = this.FileDecorator(f).mode();
        f.setExecutable(true);
        f.setReadable(true);
        f.setWritable(true);
        try {
            object = g.apply();
        }
        finally {
            if (f.exists()) {
                this.FileDecorator(f).mode_$eq(originalMode);
            }
        }
        return object;
    }

    private void recurse$$anonfun$1(File file$2, Function1 operation$1, Iterable stopPath$1) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.FileDecorator(file$2).listFilesSafe());
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)f -> this.org$openmole$tool$file$FilePackage$$recurse((File)f, (Function1<File, BoxedUnit>)operation$1, (Iterable<File>)stopPath$1));
    }

    public class FileDecorator {
        private final File file;
        private final /* synthetic */ FilePackage $outer;

        public FileDecorator(FilePackage $outer, File file) {
            this.file = file;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public File realFile() {
            return this.file.toPath().toRealPath(new LinkOption[0]).toFile();
        }

        public Path realPath() {
            return this.file.toPath().toRealPath(new LinkOption[0]);
        }

        public boolean isDirectoryEmpty() {
            FileDecorator fileDecorator = this.$outer.FileDecorator(this.file);
            return BoxesRunTime.unboxToBoolean(fileDecorator.withDirectoryStream(fileDecorator.withDirectoryStream$default$1(), FilePackage::org$openmole$tool$file$FilePackage$FileDecorator$$_$isDirectoryEmpty$$anonfun$1));
        }

        public boolean isEmpty() {
            if (this.file.isDirectory()) {
                return this.isDirectoryEmpty();
            }
            return this.$outer.FileDecorator(this.file).size() == 0L;
        }

        public String name() {
            return this.file.getName();
        }

        public File[] files() {
            return this.listFilesSafe();
        }

        public File[] listFilesSafe() {
            return (File[])Option$.MODULE$.apply((Object)this.file.listFiles()).getOrElse(FilePackage::org$openmole$tool$file$FilePackage$FileDecorator$$_$listFilesSafe$$anonfun$1);
        }

        public File[] listFilesSafe(Function1<File, Object> filter) {
            return (File[])Option$.MODULE$.apply((Object)this.file.listFiles(this.$outer.predicateToFileFilter(filter))).getOrElse(FilePackage::org$openmole$tool$file$FilePackage$FileDecorator$$_$listFilesSafe$$anonfun$2);
        }

        public Iterator<Path> listFileSafeIterator() {
            return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.list(this.file.toPath()).iterator()).asScala();
        }

        public File[] recursiveListFilesSafe(Function1<File, Object> filter) {
            return (File[])Option$.MODULE$.apply(this.$outer.FileDecorator(this.file).listRecursive(filter).toArray(ClassTag$.MODULE$.apply(File.class))).getOrElse(FilePackage::org$openmole$tool$file$FilePackage$FileDecorator$$_$recursiveListFilesSafe$$anonfun$1);
        }

        public File getParentFileSafe() {
            File file = this.file.getParentFile();
            if (file == null) {
                if (this.file.isAbsolute()) {
                    return this.file;
                }
                return new File(".");
            }
            File f = file;
            return f;
        }

        public void copyContent(File destination) {
            try (FileChannel ic = new FileInputStream(this.file).getChannel();
                 FileChannel oc = new FileOutputStream(destination).getChannel();){
                this.$outer.copyChannel(ic, oc);
            }
        }

        private boolean copyFile(File toF, boolean followSymlinks) {
            Seq<CopyOption> copyOptions = this.$outer.getCopyOptions(followSymlinks);
            Files.copy(this.$outer.file2Path(this.file), this.$outer.file2Path(toF), (CopyOption[])Arrays$.MODULE$.seqToArray(copyOptions, CopyOption.class));
            return this.$outer.FileDecorator(toF).mode_$eq(this.file);
        }

        private boolean copyFile$default$2() {
            return false;
        }

        public Object copy(File toF, boolean followSymlinks) {
            this.$outer.FileDecorator(toF).getParentFileSafe().mkdirs();
            if (Files.isDirectory(this.$outer.file2Path(this.file), new LinkOption[0])) {
                return DirUtils$.MODULE$.copy(this.$outer.file2Path(this.file), this.$outer.file2Path(toF), followSymlinks);
            }
            return BoxesRunTime.boxToBoolean((boolean)this.copyFile(toF, followSymlinks));
        }

        public boolean copy$default$2() {
            return false;
        }

        public void copy(OutputStream to) {
            org.openmole.tool.stream.package$.MODULE$.withClosable(this::copy$$anonfun$1, (Function1)((JProcedure1 & Serializable)arg_0 -> FilePackage.org$openmole$tool$file$FilePackage$FileDecorator$$_$copy$$anonfun$2(to, arg_0)));
        }

        public void copy(OutputStream to, int maxRead, Time timeout, ThreadPoolExecutor pool) {
            org.openmole.tool.stream.package$.MODULE$.withClosable(this::copy$$anonfun$3, (Function1)((JProcedure1 & Serializable)arg_0 -> FilePackage.org$openmole$tool$file$FilePackage$FileDecorator$$_$copy$$anonfun$4(to, maxRead, timeout, pool, arg_0)));
        }

        public File copyCompressFile(File toF) {
            return (File)org.openmole.tool.stream.package$.MODULE$.withClosable(() -> this.copyCompressFile$$anonfun$1(toF), (Function1 & Serializable)to -> {
                Files.copy(this.$outer.file2Path(this.file), to);
                return toF;
            });
        }

        public File copyUncompressFile(File toF) {
            return (File)org.openmole.tool.stream.package$.MODULE$.withClosable(this::copyUncompressFile$$anonfun$1, (Function1 & Serializable)from -> {
                Files.copy(from, this.$outer.file2Path(toF), StandardCopyOption.REPLACE_EXISTING);
                return toF;
            });
        }

        public Object move(File to) {
            return this.wrapError(() -> this.move$$anonfun$1(to));
        }

        public boolean forceFileDelete() {
            return BoxesRunTime.unboxToBoolean(this.wrapError(this::forceFileDelete$$anonfun$1));
        }

        public void recursiveDelete() {
            this.wrapError((Function0 & Serializable)() -> {
                this.recursiveDelete$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        public boolean isSymbolicLink() {
            return Files.isSymbolicLink(Paths.get(this.file.getAbsolutePath(), new String[0]));
        }

        public boolean isBrokenSymbolicLink() {
            return Files.notExists(Files.readSymbolicLink(this.$outer.file2Path(this.file)), new LinkOption[0]);
        }

        public boolean directoryContainsNoFileRecursive() {
            boolean bl;
            boundary.Label local = new boundary.Label();
            try {
                ListBuffer toProceed = new ListBuffer();
                toProceed.$plus$eq((Object)this.file);
                while (toProceed.nonEmpty()) {
                    File f = (File)toProceed.remove(0);
                    try {
                        FileDecorator fileDecorator = this.$outer.FileDecorator(f);
                        fileDecorator.withDirectoryStream(fileDecorator.withDirectoryStream$default$1(), (Function1)(JProcedure1 & Serializable)s -> ((IterableOnceOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)s).asScala()).foreach((Function1)(JProcedure1 & Serializable)f -> {
                            if (Files.isRegularFile(f, new LinkOption[0])) {
                                throw boundary$.MODULE$.break((Object)BoxesRunTime.boxToBoolean((boolean)false), local);
                            }
                            if (Files.isDirectory(f, new LinkOption[0])) {
                                toProceed.$plus$eq((Object)this.$outer.path2File((Path)f));
                                return;
                            }
                        }));
                    }
                    catch (AccessDeniedException e) {
                        Logger.getLogger(this.getClass().getName()).warning("Unable to browse directory " + e.getFile());
                    }
                }
                bl = true;
            }
            catch (boundary.Break ex) {
                if (ex.label() == local) {
                    bl = BoxesRunTime.unboxToBoolean((Object)ex.value());
                }
                throw ex;
            }
            return bl;
        }

        public String baseName() {
            return StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(this.file.getName()), FilePackage::org$openmole$tool$file$FilePackage$FileDecorator$$_$baseName$$anonfun$adapted$1);
        }

        public long size() {
            long l;
            if (!this.file.exists()) {
                return 0L;
            }
            if (this.file.isDirectory()) {
                return this.sizeOfDirectory$1(this.file);
            }
            try {
                l = Files.size(this.$outer.file2Path(this.file));
            }
            catch (NoSuchFileException e) {
                l = 0L;
            }
            return l;
        }

        public int mode() {
            Path f = this.$outer.FileDecorator(this.file).realPath();
            return (Files.isReadable(f) ? this.$outer.READ_MODE() : 0) | (Files.isWritable(f) ? this.$outer.WRITE_MODE() : 0) | (Files.isExecutable(f) ? this.$outer.EXEC_MODE() : 0);
        }

        public boolean mode_$eq(int m) {
            File f = this.$outer.FileDecorator(this.file).realFile();
            f.setReadable((m & this.$outer.READ_MODE()) != 0);
            f.setWritable((m & this.$outer.WRITE_MODE()) != 0);
            return f.setExecutable((m & this.$outer.EXEC_MODE()) != 0);
        }

        public boolean mode_$eq(File other) {
            File f = this.$outer.FileDecorator(this.file).realFile();
            Path o = this.$outer.FileDecorator(other).realPath();
            f.setReadable(Files.isReadable(o));
            f.setWritable(Files.isWritable(o));
            return f.setExecutable(Files.isExecutable(o));
        }

        public boolean setPosixMode(String m) {
            if (FilePackage.org$openmole$tool$file$FilePackage$FileDecorator$$_$isPosix$1()) {
                Set<PosixFilePermission> attrs = PosixFilePermissions.fromString(m);
                Files.setPosixFilePermissions(this.$outer.file2Path(this.file), attrs);
                return true;
            }
            return false;
        }

        public Path content_$eq(String content) {
            this.createParentDirectory();
            return Files.write(this.$outer.file2Path(this.file), content.getBytes(), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        }

        public Path $less(String c) {
            return this.content_$eq(c);
        }

        public String content() {
            return this.content(this.content$default$1());
        }

        public String content(boolean gz) {
            if (gz) {
                return (String)this.withGzippedInputStream().apply(FilePackage::org$openmole$tool$file$FilePackage$FileDecorator$$_$content$$anonfun$1);
            }
            return Files.readString(this.file.toPath());
        }

        public boolean content$default$1() {
            return false;
        }

        public Path append(String s) {
            return Files.write(this.$outer.file2Path(this.file), s.getBytes(), StandardOpenOption.APPEND);
        }

        public Path $less$less(String s) {
            return this.append(s);
        }

        public Path clear() {
            return this.content_$eq("");
        }

        public String[] lines() {
            return (String[])IArray.package.IArray$.MODULE$.unsafeFromArray(((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(this.file.toPath())).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)));
        }

        public Option<String> contentOption() {
            None$ none$;
            try {
                none$ = Some$.MODULE$.apply((Object)this.$outer.FileDecorator(this.file).content());
            }
            catch (IOException e) {
                none$ = None$.MODULE$;
            }
            return none$;
        }

        public boolean isTextFile(int bytes) {
            return BoxesRunTime.unboxToBoolean((Object)this.withInputStream().apply(arg_0 -> FilePackage.org$openmole$tool$file$FilePackage$FileDecorator$$_$isTextFile$$anonfun$1(bytes, arg_0)));
        }

        public int isTextFile$default$1() {
            return 10240;
        }

        public File $div(String s) {
            return this.$outer.path2File(Paths.get(this.file.toString(), s));
        }

        public File $div$greater(String s) {
            File dir = this.$outer.FileDecorator(this.file).$div(s);
            dir.mkdirs();
            return dir;
        }

        public long lastModification() {
            long lastModification = this.file.lastModified();
            if (this.file.isDirectory()) {
                ListBuffer toProceed = new ListBuffer();
                toProceed.$plus$eq((Object)this.file);
                while (!toProceed.isEmpty()) {
                    File f = (File)toProceed.remove(0);
                    if (f.lastModified() > lastModification) {
                        lastModification = f.lastModified();
                    }
                    if (!f.isDirectory()) continue;
                    Object object = Predef$.MODULE$.refArrayOps((Object[])this.$outer.FileDecorator(f).listFilesSafe());
                    ArrayOps$.MODULE$.foreach$extension(object, arg_0 -> FilePackage.org$openmole$tool$file$FilePackage$FileDecorator$$_$lastModification$$anonfun$1(toProceed, arg_0));
                }
            }
            return lastModification;
        }

        public ListBuffer<File> listRecursive(Function1<File, Object> filter) {
            ListBuffer ret = new ListBuffer();
            this.applyRecursive((Function1<File, BoxedUnit>)((JProcedure1 & Serializable)arg_0 -> FilePackage.org$openmole$tool$file$FilePackage$FileDecorator$$_$listRecursive$$anonfun$1(filter, ret, arg_0)));
            return ret;
        }

        public Function1<File, Object> listRecursive$default$1() {
            return FilePackage::org$openmole$tool$file$FilePackage$FileDecorator$$_$listRecursive$default$1$$anonfun$1;
        }

        public File newDirectory(String prefix, boolean create) {
            Path tempDir = Paths.get(this.file.toString(), prefix + UUID.randomUUID());
            if (create) {
                this.$outer.path2File(tempDir).mkdirs();
            }
            return tempDir.toFile();
        }

        public boolean newDirectory$default$2() {
            return false;
        }

        public File newFile(String prefix, String suffix) {
            Path f = Paths.get(this.file.toString(), prefix + UUID.randomUUID() + suffix);
            return f.toFile();
        }

        public Path createLinkTo(String target) {
            return this.createLinkTo(Paths.get(target, new String[0]));
        }

        public Path createLinkTo(Path target) {
            Path path;
            try {
                path = Files.createSymbolicLink(this.$outer.file2Path(this.file), target, new FileAttribute[0]);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                path = this.$outer.file2Path(this.unsupported$1(target));
            }
            catch (FileAlreadyExistsException e) {
                throw e;
            }
            catch (FileSystemException fileSystemException) {
                path = this.$outer.file2Path(this.unsupported$1(target));
            }
            catch (IOException e) {
                throw e;
            }
            return path;
        }

        public boolean createParentDirectory() {
            return BoxesRunTime.unboxToBoolean(this.wrapError(this::createParentDirectory$$anonfun$1));
        }

        public <T> T withLock(Function1<OutputStream, T> f) {
            return (T)package$.MODULE$.jvmLevelFileLock().locked((Object)this.file.getCanonicalPath(), () -> this.withLock$$anonfun$1(f));
        }

        public <T> T withLockInDirectory(Function0<T> f, String lockName) {
            T t;
            this.file.mkdirs();
            File lockFile = this.$outer.FileDecorator(this.file).$div(lockName);
            lockFile.createNewFile();
            try {
                t = this.$outer.FileDecorator(lockFile).withLock(arg_0 -> FilePackage.org$openmole$tool$file$FilePackage$FileDecorator$$_$withLockInDirectory$$anonfun$1(f, arg_0));
            }
            finally {
                lockFile.delete();
            }
            return t;
        }

        public <T> String withLockInDirectory$default$2() {
            return ".lock";
        }

        public FilterInputStream bufferedInputStream(boolean gz) {
            if (!gz) {
                return new BufferedInputStream(Files.newInputStream(this.$outer.file2Path(this.file), new OpenOption[0]));
            }
            return new GZIPInputStream(new BufferedInputStream(Files.newInputStream(this.$outer.file2Path(this.file), new OpenOption[0])));
        }

        public boolean bufferedInputStream$default$1() {
            return false;
        }

        private Seq<StandardOpenOption> writeOptions(boolean append) {
            if (append) {
                return (Seq)((SeqOps)new .colon.colon((Object)StandardOpenOption.CREATE, (List)new .colon.colon((Object)StandardOpenOption.APPEND, (List)new .colon.colon((Object)StandardOpenOption.WRITE, (List)Nil$.MODULE$))));
            }
            return (Seq)((SeqOps)new .colon.colon((Object)StandardOpenOption.CREATE, (List)new .colon.colon((Object)StandardOpenOption.TRUNCATE_EXISTING, (List)new .colon.colon((Object)StandardOpenOption.WRITE, (List)Nil$.MODULE$))));
        }

        public FileOutputStream fileOutputStream() {
            return new FileOutputStream(this.file);
        }

        public FileInputStream fileInputStream() {
            return new FileInputStream(this.file);
        }

        public BufferedOutputStream bufferedOutputStream(boolean append, boolean gz) {
            this.$outer.FileDecorator(this.file).createParentDirectory();
            if (!gz) {
                return new BufferedOutputStream(Files.newOutputStream(this.file.toPath(), (StandardOpenOption[])Arrays$.MODULE$.seqToArray(this.writeOptions(append), StandardOpenOption.class)));
            }
            return new BufferedOutputStream(org.openmole.tool.stream.package$.MODULE$.OutputStreamDecorator(Files.newOutputStream(this.file.toPath(), (StandardOpenOption[])Arrays$.MODULE$.seqToArray(this.writeOptions(append), StandardOpenOption.class))).toGZ());
        }

        public boolean bufferedOutputStream$default$1() {
            return false;
        }

        public boolean bufferedOutputStream$default$2() {
            return false;
        }

        public GZIPInputStream gzippedBufferedInputStream() {
            return new GZIPInputStream(this.bufferedInputStream(this.bufferedInputStream$default$1()));
        }

        public GZIPOutputStream gzippedBufferedOutputStream() {
            return new GZIPOutputStream(this.bufferedOutputStream(this.bufferedOutputStream$default$1(), this.bufferedOutputStream$default$2()));
        }

        public <T> Function1<Function1<GZIPOutputStream, T>, T> withGzippedOutputStream() {
            return (Function1 & Serializable)_$8 -> org.openmole.tool.stream.package$.MODULE$.withClosable(this::withGzippedOutputStream$$anonfun$1$$anonfun$1, _$8);
        }

        public <T> Function1<Function1<GZIPInputStream, T>, T> withGzippedInputStream() {
            return (Function1 & Serializable)_$9 -> org.openmole.tool.stream.package$.MODULE$.withClosable(this::withGzippedInputStream$$anonfun$1$$anonfun$1, _$9);
        }

        public <T> Function1<Function1<OutputStream, T>, T> withOutputStream() {
            return (Function1 & Serializable)_$10 -> org.openmole.tool.stream.package$.MODULE$.withClosable(this::withOutputStream$$anonfun$1$$anonfun$1, _$10);
        }

        public <T> Function1<Function1<PrintStream, T>, T> withPrintStream(boolean append, boolean create, boolean gz) {
            if (create) {
                this.$outer.FileDecorator(this.file).createParentDirectory();
            }
            return (Function1 & Serializable)f -> org.openmole.tool.stream.package$.MODULE$.withClosable(() -> this.withPrintStream$$anonfun$1$$anonfun$1(append, gz), f);
        }

        public boolean withPrintStream$default$1() {
            return false;
        }

        public boolean withPrintStream$default$2() {
            return false;
        }

        public boolean withPrintStream$default$3() {
            return false;
        }

        public <T> T atomicWithPrintStream(Function1<PrintStream, T> f) {
            Object object;
            this.$outer.FileDecorator(this.file).createParentDirectory();
            File tmpFile = File.createTempFile("stream", ".tmp", this.file.getParentFile());
            try {
                FileDecorator fileDecorator = this.$outer.FileDecorator(tmpFile);
                try (PrintStream printStream = new PrintStream(fileDecorator.bufferedOutputStream(fileDecorator.bufferedOutputStream$default$1(), fileDecorator.bufferedOutputStream$default$2()));){
                    object = f.apply((Object)printStream);
                }
            }
            catch (Throwable throwable) {
                Files.move(tmpFile.toPath(), this.file.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                throw throwable;
            }
            Files.move(tmpFile.toPath(), this.file.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            return (T)object;
        }

        public <T> Function1<Function1<FileOutputStream, T>, T> withFileOutputStream() {
            return (Function1 & Serializable)_$11 -> org.openmole.tool.stream.package$.MODULE$.withClosable(this::withFileOutputStream$$anonfun$1$$anonfun$1, _$11);
        }

        public <T> Function1<Function1<FileInputStream, T>, T> withFileInputStream() {
            return (Function1 & Serializable)_$12 -> org.openmole.tool.stream.package$.MODULE$.withClosable(this::withFileInputStream$$anonfun$1$$anonfun$1, _$12);
        }

        public <T> Function1<Function1<InputStream, T>, T> withInputStream() {
            return (Function1 & Serializable)_$13 -> org.openmole.tool.stream.package$.MODULE$.withClosable(this::withInputStream$$anonfun$1$$anonfun$1, _$13);
        }

        public <T> Function1<Function1<Reader, T>, T> withReader() {
            return (Function1 & Serializable)_$14 -> org.openmole.tool.stream.package$.MODULE$.withClosable(this::withReader$$anonfun$1$$anonfun$1, _$14);
        }

        public <T> Function1<Function1<Writer, T>, T> withWriter(boolean append) {
            return (Function1 & Serializable)_$15 -> org.openmole.tool.stream.package$.MODULE$.withClosable(() -> this.withWriter$$anonfun$1$$anonfun$1(append), _$15);
        }

        public boolean withWriter$default$1() {
            return false;
        }

        public <T> T withDirectoryStream(Option<DirectoryStream.Filter<Path>> filter, Function1<DirectoryStream<Path>, T> f) {
            Object object;
            try (DirectoryStream stream = this.open$1(filter);){
                object = f.apply((Object)stream);
            }
            return (T)object;
        }

        public <T> Option<DirectoryStream.Filter<Path>> withDirectoryStream$default$1() {
            return None$.MODULE$;
        }

        public <T> Function1<Function1<Source, T>, T> withSource() {
            return (Function1 & Serializable)_$16 -> org.openmole.tool.stream.package$.MODULE$.withClosable(this::withSource$$anonfun$1$$anonfun$1, _$16);
        }

        public <T> T wrapError(Function0<T> f) {
            Object object;
            try {
                object = f.apply();
            }
            catch (Throwable t) {
                throw new IOException("For file " + this.file, t);
            }
            return (T)object;
        }

        public void lockAndAppendFile(String to) {
            this.lockAndAppendFile(new File(to));
        }

        public void lockAndAppendFile(File from) {
            package$.MODULE$.jvmLevelFileLock().locked((Object)this.file.getCanonicalPath(), (Function0 & Serializable)() -> {
                this.lockAndAppendFile$$anonfun$1(from);
                return BoxedUnit.UNIT;
            });
        }

        public void applyRecursive(Function1<File, BoxedUnit> operation) {
            this.applyRecursive(operation, (Iterable<File>)Predef$.MODULE$.Set().empty());
        }

        public void applyRecursive(Function1<File, BoxedUnit> operation, Iterable<File> stopPath) {
            this.$outer.org$openmole$tool$file$FilePackage$$recurse(this.file, operation, stopPath);
        }

        public boolean isAParentOf(File f) {
            return f.getCanonicalPath().startsWith(this.file.getCanonicalPath());
        }

        public Option<Object> inode() {
            None$ none$;
            block5: {
                try {
                    Object object = Files.getAttribute(this.file.toPath(), "unix:ino", new LinkOption[0]);
                    if (object instanceof Long) {
                        long inode = BoxesRunTime.unboxToLong((Object)object);
                        none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)inode));
                        break block5;
                    }
                    none$ = None$.MODULE$;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    none$ = None$.MODULE$;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    none$ = None$.MODULE$;
                }
                catch (NoSuchFileException noSuchFileException) {
                    none$ = None$.MODULE$;
                }
            }
            return none$;
        }

        public final /* synthetic */ FilePackage org$openmole$tool$file$FilePackage$FileDecorator$$$outer() {
            return this.$outer;
        }

        private final FilterInputStream copy$$anonfun$1() {
            return this.bufferedInputStream(this.bufferedInputStream$default$1());
        }

        private final FilterInputStream copy$$anonfun$3() {
            return this.bufferedInputStream(this.bufferedInputStream$default$1());
        }

        private final GZIPOutputStream copyCompressFile$$anonfun$1(File toF$1) {
            FileDecorator fileDecorator = this.$outer.FileDecorator(toF$1);
            return new GZIPOutputStream(fileDecorator.bufferedOutputStream(fileDecorator.bufferedOutputStream$default$1(), fileDecorator.bufferedOutputStream$default$2()));
        }

        private final GZIPInputStream copyUncompressFile$$anonfun$1() {
            FileDecorator fileDecorator = this.$outer.FileDecorator(this.file);
            return new GZIPInputStream(fileDecorator.bufferedInputStream(fileDecorator.bufferedInputStream$default$1()));
        }

        private final Path move$1(File to$4) {
            return Files.move(this.$outer.file2Path(this.file), this.$outer.file2Path(to$4), StandardCopyOption.REPLACE_EXISTING);
        }

        private final Path move$$anonfun$1$$anonfun$1(File to$5) {
            return this.move$1(to$5);
        }

        private final Object move$$anonfun$1(File to$3) {
            to$3.getParentFile().mkdirs();
            if (!Files.isDirectory(this.$outer.file2Path(this.file), new LinkOption[0])) {
                return this.move$1(to$3);
            }
            Try try_ = Try$.MODULE$.apply(() -> this.move$$anonfun$1$$anonfun$1(to$3));
            if (try_ instanceof Success) {
                return BoxedUnit.UNIT;
            }
            if (try_ instanceof Failure) {
                return DirUtils$.MODULE$.move(this.$outer.file2Path(this.file), this.$outer.file2Path(to$3));
            }
            throw new MatchError((Object)try_);
        }

        private final boolean forceFileDelete$$anonfun$1() {
            boolean bl;
            try {
                bl = Files.deleteIfExists(this.$outer.file2Path(this.file));
            }
            catch (Throwable t) {
                FileTools$.MODULE$.setAllPermissions(this.$outer.file2Path(this.file));
                bl = Files.deleteIfExists(this.$outer.file2Path(this.file));
            }
            return bl;
        }

        private final void recursiveDelete$$anonfun$1() {
            DirUtils$.MODULE$.deleteIfExists(this.$outer.file2Path(this.file));
        }

        private final long sizeOfDirectory$1(File directory) {
            AtomicLong size = new AtomicLong();
            Files.walkFileTree(this.$outer.file2Path(directory), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(size){
                private final AtomicLong size$1;
                {
                    this.size$1 = size$2;
                }

                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (attrs.isRegularFile()) {
                        this.size$1.addAndGet(attrs.size());
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return size.get();
        }

        private final File unsupported$1(Path target$1) {
            Logger.getLogger(this.getClass().getName()).warning("File system doesn't support symbolic link, make a file copy instead");
            Path fileTarget = target$1.isAbsolute() ? target$1 : Paths.get(this.$outer.FileDecorator(this.file).getParentFileSafe().getPath(), this.$outer.path2File(target$1).getPath());
            Files.copy(fileTarget, this.$outer.file2Path(this.file), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            return this.file;
        }

        private final boolean createParentDirectory$$anonfun$1() {
            return this.$outer.FileDecorator(this.file.getCanonicalFile()).getParentFileSafe().mkdirs();
        }

        private final FileOutputStream withLock$$anonfun$1$$anonfun$1() {
            return new FileOutputStream(this.file, true);
        }

        private final Object withLock$$anonfun$1(Function1 f$2) {
            return org.openmole.tool.stream.package$.MODULE$.withClosable(this::withLock$$anonfun$1$$anonfun$1, arg_0 -> FilePackage.org$openmole$tool$file$FilePackage$FileDecorator$$_$withLock$$anonfun$1$$anonfun$2(f$2, arg_0));
        }

        private final GZIPOutputStream withGzippedOutputStream$$anonfun$1$$anonfun$1() {
            return this.gzippedBufferedOutputStream();
        }

        private final GZIPInputStream withGzippedInputStream$$anonfun$1$$anonfun$1() {
            return this.gzippedBufferedInputStream();
        }

        private final OutputStream withOutputStream$$anonfun$1$$anonfun$1() {
            return this.bufferedOutputStream(this.bufferedOutputStream$default$1(), this.bufferedOutputStream$default$2());
        }

        private final PrintStream withPrintStream$$anonfun$1$$anonfun$1(boolean append$2, boolean gz$2) {
            return new PrintStream(this.$outer.FileDecorator(this.file).bufferedOutputStream(append$2, gz$2));
        }

        private final FileOutputStream withFileOutputStream$$anonfun$1$$anonfun$1() {
            return this.fileOutputStream();
        }

        private final FileInputStream withFileInputStream$$anonfun$1$$anonfun$1() {
            return this.fileInputStream();
        }

        private final InputStream withInputStream$$anonfun$1$$anonfun$1() {
            return this.bufferedInputStream(this.bufferedInputStream$default$1());
        }

        private final Reader withReader$$anonfun$1$$anonfun$1() {
            return Files.newBufferedReader(this.file.toPath());
        }

        private final Writer withWriter$$anonfun$1$$anonfun$1(boolean append$4) {
            return Files.newBufferedWriter(this.file.toPath(), (StandardOpenOption[])Arrays$.MODULE$.seqToArray(this.writeOptions(append$4), StandardOpenOption.class));
        }

        private final DirectoryStream open$1(Option filter$2) {
            Option option = filter$2;
            if (None$.MODULE$.equals(option)) {
                return Files.newDirectoryStream(this.$outer.file2Path(this.file));
            }
            if (option instanceof Some) {
                DirectoryStream.Filter f = (DirectoryStream.Filter)((Some)option).value();
                return Files.newDirectoryStream(this.$outer.file2Path(this.file), f);
            }
            throw new MatchError((Object)option);
        }

        private final Source withSource$$anonfun$1$$anonfun$1() {
            return Source$.MODULE$.fromInputStream((InputStream)this.bufferedInputStream(this.bufferedInputStream$default$1()), Codec$.MODULE$.fallbackSystemCodec());
        }

        private final void lockAndAppendFile$$anonfun$1(File from$1) {
            try (FileChannel channelI = new FileInputStream(from$1).getChannel();
                 FileChannel channelO = new FileOutputStream(this.file, true).getChannel();){
                FileLock lock = channelO.lock();
                try {
                    this.$outer.copyChannel(channelI, channelO);
                }
                finally {
                    lock.release();
                }
            }
        }
    }
}

