/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.meta;

import java.util.ArrayList;
import java.util.List;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.meta.ClassSpec;
import org.apache.fory.meta.Encoders;
import org.apache.fory.meta.MetaString;
import org.apache.fory.meta.MetaStringDecoder;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.TypeResolver;
import org.apache.fory.serializer.NonexistentClass;
import org.apache.fory.util.Preconditions;

class ClassDefDecoder {
    ClassDefDecoder() {
    }

    static Tuple2<byte[], byte[]> decodeClassDefBuf(MemoryBuffer inputBuffer, TypeResolver resolver, long id) {
        MemoryBuffer encoded = MemoryBuffer.newHeapBuffer(64);
        encoded.writeInt64(id);
        int size = (int)(id & 0x7FFL);
        if (size == 2047) {
            int moreSize = inputBuffer.readVarUint32Small14();
            encoded.writeVarUint32(moreSize);
            size += moreSize;
        }
        byte[] encodedClassDef = inputBuffer.readBytes(size);
        encoded.writeBytes(encodedClassDef);
        if ((id & 0x2000L) != 0L) {
            encodedClassDef = resolver.getFory().getConfig().getMetaCompressor().decompress(encodedClassDef, 0, size);
        }
        return Tuple2.of(encodedClassDef, encoded.getBytes(0, encoded.writerIndex()));
    }

    public static ClassDef decodeClassDef(ClassResolver resolver, MemoryBuffer buffer, long id) {
        Tuple2<byte[], byte[]> decoded = ClassDefDecoder.decodeClassDefBuf(buffer, resolver, id);
        MemoryBuffer classDefBuf = MemoryBuffer.fromByteArray((byte[])decoded.f0);
        int numClasses = classDefBuf.readByte();
        if (numClasses == 15) {
            numClasses += classDefBuf.readVarUint32Small7();
        }
        ++numClasses;
        ArrayList<ClassDef.FieldInfo> classFields = new ArrayList<ClassDef.FieldInfo>();
        ClassSpec classSpec = null;
        for (int i = 0; i < numClasses; ++i) {
            String className;
            int currentClassHeader = classDefBuf.readVarUint32Small7();
            boolean isRegistered = (currentClassHeader & 1) != 0;
            int numFields = currentClassHeader >>> 1;
            if (isRegistered) {
                short registeredId = (short)classDefBuf.readVarUint32Small7();
                if (resolver.getRegisteredClass(registeredId) == null) {
                    classSpec = new ClassSpec(NonexistentClass.NonexistentMetaShared.class);
                    className = classSpec.entireClassName;
                } else {
                    Class<?> cls = resolver.getClassInfo(registeredId).getCls();
                    className = cls.getName();
                    classSpec = new ClassSpec(cls);
                }
            } else {
                String pkg = ClassDefDecoder.readPkgName(classDefBuf);
                String typeName = ClassDefDecoder.readTypeName(classDefBuf);
                classSpec = Encoders.decodePkgAndClass(pkg, typeName);
                className = classSpec.entireClassName;
                if (resolver.isRegisteredByName(className)) {
                    Class<?> cls = resolver.getRegisteredClass(className);
                    className = cls.getName();
                    classSpec = new ClassSpec(cls);
                }
            }
            List<ClassDef.FieldInfo> fieldInfos = ClassDefDecoder.readFieldsInfo(classDefBuf, resolver, className, numFields);
            classFields.addAll(fieldInfos);
        }
        Preconditions.checkNotNull(classSpec);
        boolean hasFieldsMeta = (id & 0x1000L) != 0L;
        return new ClassDef(classSpec, classFields, hasFieldsMeta, id, (byte[])decoded.f1);
    }

    private static List<ClassDef.FieldInfo> readFieldsInfo(MemoryBuffer buffer, ClassResolver resolver, String className, int numFields) {
        ArrayList<ClassDef.FieldInfo> fieldInfos = new ArrayList<ClassDef.FieldInfo>(numFields);
        for (int i = 0; i < numFields; ++i) {
            int header = buffer.readByte() & 0xFF;
            int encodingFlags = header >>> 3 & 3;
            boolean useTagID = encodingFlags == 3;
            Preconditions.checkArgument(!useTagID, "Type tag not supported currently, parsed fieldInfos %s", fieldInfos, new Object[0]);
            int size = header >>> 5;
            if (size == 7) {
                size += buffer.readVarUint32Small7();
            }
            MetaString.Encoding encoding = Encoders.fieldNameEncodings[encodingFlags];
            String fieldName = Encoders.FIELD_NAME_DECODER.decode(buffer.readBytes(++size), encoding);
            boolean isMonomorphic = (header & 4) != 0;
            boolean trackingRef = (header & 1) != 0;
            int typeId = buffer.readVarUint32Small14();
            ClassDef.FieldType fieldType = ClassDef.FieldType.read(buffer, resolver, isMonomorphic, trackingRef, typeId);
            fieldInfos.add(new ClassDef.FieldInfo(className, fieldName, fieldType));
        }
        return fieldInfos;
    }

    static String readPkgName(MemoryBuffer buffer) {
        return ClassDefDecoder.readName(Encoders.PACKAGE_DECODER, buffer, Encoders.pkgEncodings);
    }

    static String readTypeName(MemoryBuffer buffer) {
        return ClassDefDecoder.readName(Encoders.TYPE_NAME_DECODER, buffer, Encoders.typeNameEncodings);
    }

    private static String readName(MetaStringDecoder decoder, MemoryBuffer buffer, MetaString.Encoding[] encodings) {
        int header = buffer.readByte() & 0xFF;
        int encodingFlags = header & 3;
        MetaString.Encoding encoding = encodings[encodingFlags];
        int size = header >> 2;
        if (size == 63) {
            size = buffer.readVarUint32Small7() + 63;
        }
        return decoder.decode(buffer.readBytes(size), encoding);
    }
}

