/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.scala;

import java.util.Map;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.collection.AbstractMapSerializer;
import org.apache.fory.serializer.scala.MapBuilder;
import scala.collection.Factory;
import scala.collection.mutable.Builder;

public abstract class AbstractScalaMapSerializer<K, V, T>
extends AbstractMapSerializer<T> {
    private final Fory fory;

    public AbstractScalaMapSerializer(Fory fory, Class<T> cls) {
        this.fory = fory;
        super(fory, cls);
    }

    @Override
    public abstract Map<?, ?> onMapWrite(MemoryBuffer var1, T var2);

    @Override
    public T read(MemoryBuffer buffer) {
        Map<?, ?> map = this.newMap(buffer);
        int numElements = this.getAndClearNumElements();
        if (numElements != 0) {
            this.readElements(buffer, numElements, map);
        }
        return this.onMapRead(map);
    }

    @Override
    public Map<?, ?> newMap(MemoryBuffer buffer) {
        int numElements = buffer.readVarUint32();
        this.setNumElements(numElements);
        Factory factory = (Factory)this.fory.readRef(buffer);
        Builder builder = factory.newBuilder();
        builder.sizeHint(numElements);
        return new MapBuilder(builder);
    }

    @Override
    public T onMapCopy(Map<?, ?> map) {
        return (T)((MapBuilder)map).builder().result();
    }

    @Override
    public T onMapRead(Map<?, ?> map) {
        return (T)((MapBuilder)map).builder().result();
    }
}

