/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.util.function;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.unsafe._JDKAccess;

public class Functions {
    private static final Map<Tuple2<Method, Class<?>>, Object> map = GraalvmSupport.isGraalBuildtime() ? new ConcurrentHashMap() : new WeakHashMap();

    public static boolean isLambda(Class<?> clz) {
        Preconditions.checkNotNull(clz);
        return clz.getName().indexOf(47) >= 0;
    }

    public static List<Object> extractCapturedVariables(Serializable closure) {
        return Functions.extractCapturedVariables(closure, o -> true);
    }

    public static List<Object> extractCapturedVariables(Serializable closure, Predicate<Object> predicate) {
        SerializedLambda serializedLambda;
        Preconditions.checkArgument(Functions.isLambda(closure.getClass()));
        Method writeReplace = ReflectionUtils.findMethods(closure.getClass(), "writeReplace").get(0);
        writeReplace.setAccessible(true);
        try {
            serializedLambda = (SerializedLambda)writeReplace.invoke((Object)closure, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException();
        }
        ArrayList<Object> variables = new ArrayList<Object>();
        for (int i = 0; i < serializedLambda.getCapturedArgCount(); ++i) {
            Object capturedArg = serializedLambda.getCapturedArg(i);
            if (!predicate.test(capturedArg)) continue;
            variables.add(capturedArg);
        }
        return variables;
    }

    public static Object makeGetterFunction(Class<?> cls, String methodName) {
        try {
            return Functions.makeGetterFunction(cls.getDeclaredMethod(methodName, new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object makeGetterFunction(Method method) {
        return map.computeIfAbsent(Tuple2.of(method, Object.class), k -> {
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(method.getDeclaringClass());
            try {
                MethodHandle handle = lookup.unreflect(method);
                return _JDKAccess.makeGetterFunction(lookup, handle, method.getReturnType());
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public static Object makeGetterFunction(Method method, Class<?> returnType) {
        return map.computeIfAbsent(Tuple2.of(method, returnType), k -> {
            MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(method.getDeclaringClass());
            try {
                MethodHandle handle = lookup.unreflect(method);
                return _JDKAccess.makeGetterFunction(lookup, handle, returnType);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        });
    }

    public static Tuple2<Class<?>, String> getterMethodInfo(Class<?> type) {
        return _JDKAccess.getterMethodInfo(type);
    }
}

