/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.environment.egi;

import gridscale.package;
import java.io.Serializable;
import java.util.UUID;
import org.openmole.core.communication.message.FileMessage;
import org.openmole.core.preference.ConfigurationString;
import org.openmole.core.preference.Preference;
import org.openmole.plugin.environment.batch.environment.SerializedJob;
import org.openmole.plugin.environment.egi.CurlRemoteStorage;
import org.openmole.plugin.environment.egi.CurlRemoteStorage$Curl$;
import org.openmole.plugin.environment.egi.EGIEnvironment$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import squants.time.Time;

public final class JobScript$
implements Serializable {
    public static final JobScript$ MODULE$ = new JobScript$();

    private JobScript$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JobScript$.class);
    }

    public String create(SerializedJob serializedJob, String resultPath, String storageLocation, String voName, int memory, boolean debug, Option<String> proxy, Preference preference) {
        if (serializedJob.runtime().runtime().path() == null) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        int retry = 5;
        String functions = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |retry() {\n        |    local -r -i max_attempts=\"$1\"; shift\n        |    local -i attempt_num=1\n        |    until \"$@\"\n        |    do\n        |        if ((attempt_num==max_attempts))\n        |        then\n        |            echo \"Attempt $attempt_num failed and there are no more attempts left!\"\n        |            return 1\n        |        else\n        |            echo \"Attempt $attempt_num failed! Trying again in $attempt_num seconds...\"\n        |            sleep $((attempt_num++))\n        |        fi\n        |    done\n        |}\n        |\n        |"));
        String debugInfo = "echo " + storageLocation + " ; hostname ; date -R ; cat /proc/meminfo ; ulimit -n 10240 ; ulimit -a ; env ; echo $X509_USER_PROXY ; ";
        ListBuffer script = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        proxy.foreach((Function1 & Serializable)p -> (ListBuffer)script.$plus$eq((Object)("export X509_USER_PROXY=$PWD/" + p)));
        script.$plus$eq((Object)"ARGS=()");
        script.$plus$eq((Object)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("while [[ $# -gt 0 ]]; do\n                  |  case \"$1\" in\n                  |    --unique-id ) UNIQUE_ID=$2 ;;\n                  |    * ) ARGS+=(\"$1\");;\n                  |  esac\n                  |  shift\n                  |done")));
        script.$plus$eq((Object)"echo Job running for unique id: $UNIQUE_ID");
        script.$plus$eq((Object)"unset http_proxy");
        script.$plus$eq((Object)"unset https_proxy");
        script.$plus$eq((Object)"BASEPATH=$PWD");
        script.$plus$eq((Object)"CUR=$PWD/ws$RANDOM");
        script.$plus$eq((Object)"while test -e $CUR; do export CUR=$PWD/ws$RANDOM; done");
        script.$plus$eq((Object)"mkdir $CUR");
        script.$plus$eq((Object)"export HOME=$CUR");
        script.$plus$eq((Object)"cd $CUR");
        String init = script.mkString(" && ");
        ListBuffer script2 = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        script2.$plus$eq((Object)("if [ `uname -m` = x86_64 ]; then " + ("retry " + retry + " ") + this.cpCommand$1(voName, debug, preference).download(this.resolve$1(storageLocation, serializedJob.runtime().jvmLinuxX64().path()), "$PWD/jvm.tar.gz") + "; else echo \"Unsupported architecture: \" `uname -m`; exit 1; fi"));
        script2.$plus$eq((Object)"tar -xzf jvm.tar.gz >/dev/null");
        script2.$plus$eq((Object)"rm -f jvm.tar.gz");
        script2.$plus$eq((Object)("retry " + retry + " " + this.cpCommand$1(voName, debug, preference).download(this.resolve$1(storageLocation, serializedJob.runtime().runtime().path()), "$PWD/openmole.tar.gz")));
        script2.$plus$eq((Object)"tar -xzf openmole.tar.gz >/dev/null");
        script2.$plus$eq((Object)"rm -f openmole.tar.gz");
        String install = script2.mkString(" && ");
        ListBuffer script3 = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        ((IterableOnceOps)serializedJob.runtime().environmentPlugins().zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                FileMessage plugin = (FileMessage)tuple2._1();
                int index = BoxesRunTime.unboxToInt((Object)tuple2._2());
                if (plugin.path() == null) {
                    throw Scala3RunTime$.MODULE$.assertFailed();
                }
                return (ListBuffer)script3.$plus$eq((Object)("retry " + retry + " " + this.cpCommand$1(voName, debug, preference).download(this.resolve$1(storageLocation, plugin.path()), "$CUR/envplugins/plugin" + index + ".jar")));
            }
            throw new MatchError((Object)tuple2);
        });
        script3.$plus$eq((Object)("retry " + retry + " " + this.cpCommand$1(voName, debug, preference).download(this.resolve$1(storageLocation, serializedJob.remoteStorage().path()), "$CUR/storage.bin")));
        String dl = "mkdir -p envplugins && " + script3.mkString(" && ");
        ListBuffer script4 = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        script4.$plus$eq((Object)"export PATH=$PWD/jre/bin:$PATH");
        script4.$plus$eq((Object)"export HOME=$PWD");
        script4.$plus$eq((Object)("/bin/sh run.sh " + memory + "m " + UUID.randomUUID() + " -s $CUR/storage.bin -p $CUR/envplugins/ -i " + serializedJob.inputPath() + " -o " + resultPath + " --transfer-retry " + retry + (debug ? " -d 2>&1" : "")));
        String run = script4.mkString(" && ");
        String postDebugInfo = debug ? "cat *.log ; " : "";
        String finish = "cd .. &&  rm -rf $CUR";
        return functions + debugInfo + init + " && " + install + " && " + dl + " && " + run + ("; RETURNCODE=" + (debug ? "0" : "$?") + ";") + postDebugInfo + finish + "; exit $RETURNCODE;";
    }

    public Option<String> create$default$7() {
        return None$.MODULE$;
    }

    private String background(String s) {
        return "( " + s + " & )";
    }

    private final CurlRemoteStorage.Curl cpCommand$1(String voName$1, boolean debug$1, Preference preference$1) {
        return CurlRemoteStorage$Curl$.MODULE$.apply(voName$1, debug$1, (Time)preference$1.apply(EGIEnvironment$.MODULE$.RemoteCopyTimeout(), (ConfigurationString)ConfigurationString.given_ConfigurationString_Time$.MODULE$));
    }

    private final String resolve$1(String storageLocation$1, String dest) {
        return package.RemotePath$.MODULE$.child(storageLocation$1, dest);
    }
}

