/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.Capacitance$;
import squants.electro.CapacitanceUnit;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricPotential;
import squants.electro.Farads$;
import squants.electro.FaradsPerMeter$;
import squants.electro.Kilofarads$;
import squants.electro.Microfarads$;
import squants.electro.Millifarads$;
import squants.electro.Nanofarads$;
import squants.electro.Permittivity;
import squants.electro.Picofarads$;
import squants.space.Length;

public final class Capacitance
extends Quantity<Capacitance> {
    private final double value;
    private final CapacitanceUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Capacitance$.class, "0bitmap$1");

    public static Try<Capacitance> apply(Object object) {
        return Capacitance$.MODULE$.apply(object);
    }

    public static <A> Capacitance apply(A a, CapacitanceUnit capacitanceUnit, Numeric<A> numeric) {
        return Capacitance$.MODULE$.apply(a, capacitanceUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Capacitance$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Capacitance$.MODULE$.name();
    }

    public static Try<Capacitance> parseString(String string) {
        return Capacitance$.MODULE$.parseString(string);
    }

    public static <N> Try<Capacitance> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Capacitance$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Capacitance$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Capacitance$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Capacitance>> symbolToUnit(String string) {
        return Capacitance$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Capacitance$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Capacitance$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Capacitance(double value, CapacitanceUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public CapacitanceUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Capacitance> dimension() {
        return Capacitance$.MODULE$;
    }

    public ElectricCharge $times(ElectricPotential that) {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toFarads() * that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Permittivity $div(Length that) {
        return FaradsPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toFarads() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toFarads() {
        return this.to(Farads$.MODULE$);
    }

    public double toPicofarads() {
        return this.to(Picofarads$.MODULE$);
    }

    public double toNanofarads() {
        return this.to(Nanofarads$.MODULE$);
    }

    public double toMicrofarads() {
        return this.to(Microfarads$.MODULE$);
    }

    public double toMillifarads() {
        return this.to(Millifarads$.MODULE$);
    }

    public double toKilofarads() {
        return this.to(Kilofarads$.MODULE$);
    }
}

