/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.Capacitance;
import squants.electro.Coulombs$;
import squants.electro.ElectricCharge;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricFieldStrength;
import squants.electro.ElectricPotential$;
import squants.electro.ElectricPotentialUnit;
import squants.electro.ElectricalResistance;
import squants.electro.Kilovolts$;
import squants.electro.MagneticFlux;
import squants.electro.Megavolts$;
import squants.electro.Microvolts$;
import squants.electro.Millivolts$;
import squants.electro.Ohms$;
import squants.electro.Volts$;
import squants.electro.VoltsPerMeter$;
import squants.electro.Webers$;
import squants.energy.Energy;
import squants.energy.Joules$;
import squants.energy.Power;
import squants.energy.Watts$;
import squants.package$;
import squants.space.Length;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;

public final class ElectricPotential
extends Quantity<ElectricPotential>
implements TimeDerivative<MagneticFlux> {
    private final double value;
    private final ElectricPotentialUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(ElectricPotential$.class, "0bitmap$1");

    public static Try<ElectricPotential> apply(Object object) {
        return ElectricPotential$.MODULE$.apply(object);
    }

    public static <A> ElectricPotential apply(A a, ElectricPotentialUnit electricPotentialUnit, Numeric<A> numeric) {
        return ElectricPotential$.MODULE$.apply(a, electricPotentialUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return ElectricPotential$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return ElectricPotential$.MODULE$.name();
    }

    public static Try<ElectricPotential> parseString(String string) {
        return ElectricPotential$.MODULE$.parseString(string);
    }

    public static <N> Try<ElectricPotential> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return ElectricPotential$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return ElectricPotential$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return ElectricPotential$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<ElectricPotential>> symbolToUnit(String string) {
        return ElectricPotential$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return ElectricPotential$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        ElectricPotential$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public ElectricPotential(double value, ElectricPotentialUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public ElectricPotentialUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<ElectricPotential> dimension() {
        return ElectricPotential$.MODULE$;
    }

    @Override
    public MagneticFlux timeIntegrated() {
        return Webers$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toVolts()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Power $times(ElectricCurrent that) {
        return Watts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() * that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCharge $times(Capacitance that) {
        return Coulombs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() * that.toFarads())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Energy $times(ElectricCharge that) {
        return Joules$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() * that.toCoulombs())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricalResistance $div(ElectricCurrent that) {
        return Ohms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() / that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCurrent $div(ElectricalResistance that) {
        return package$.MODULE$.Amperes().apply(BoxesRunTime.boxToDouble((double)(this.toVolts() / that.toOhms())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricFieldStrength $div(Length that) {
        return VoltsPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toVolts() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toVolts() {
        return this.to(Volts$.MODULE$);
    }

    public double toMicrovolts() {
        return this.to(Microvolts$.MODULE$);
    }

    public double toMillivolts() {
        return this.to(Millivolts$.MODULE$);
    }

    public double toKilovolts() {
        return this.to(Kilovolts$.MODULE$);
    }

    public double toMegavolts() {
        return this.to(Megavolts$.MODULE$);
    }
}

