/*
 * Decompiled with CFR 0.152.
 */
package squants.electro;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.Henry$;
import squants.electro.Inductance;
import squants.electro.MagneticFlux$;
import squants.electro.MagneticFluxDensity;
import squants.electro.MagneticFluxUnit;
import squants.electro.Teslas$;
import squants.electro.Volts$;
import squants.electro.Webers$;
import squants.package$;
import squants.space.Area;
import squants.space.SquareMeters$;
import squants.time.Time;
import squants.time.TimeIntegral;

public final class MagneticFlux
extends Quantity<MagneticFlux>
implements TimeIntegral<ElectricPotential> {
    private final double value;
    private final MagneticFluxUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(MagneticFlux$.class, "0bitmap$1");

    public static Try<MagneticFlux> apply(Object object) {
        return MagneticFlux$.MODULE$.apply(object);
    }

    public static <A> MagneticFlux apply(A a, MagneticFluxUnit magneticFluxUnit, Numeric<A> numeric) {
        return MagneticFlux$.MODULE$.apply(a, magneticFluxUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return MagneticFlux$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return MagneticFlux$.MODULE$.name();
    }

    public static Try<MagneticFlux> parseString(String string) {
        return MagneticFlux$.MODULE$.parseString(string);
    }

    public static <N> Try<MagneticFlux> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return MagneticFlux$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return MagneticFlux$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return MagneticFlux$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<MagneticFlux>> symbolToUnit(String string) {
        return MagneticFlux$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return MagneticFlux$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        MagneticFlux$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public MagneticFlux(double value, MagneticFluxUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public MagneticFluxUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<MagneticFlux> dimension() {
        return MagneticFlux$.MODULE$;
    }

    @Override
    public ElectricPotential timeDerived() {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toWebers()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return package$.MODULE$.Seconds().apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public MagneticFluxDensity $div(Area that) {
        return Teslas$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWebers() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Area $div(MagneticFluxDensity that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWebers() / that.toTeslas())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Inductance $div(ElectricCurrent that) {
        return Henry$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWebers() / that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCurrent $div(Inductance that) {
        return package$.MODULE$.Amperes().apply(BoxesRunTime.boxToDouble((double)(this.toWebers() / that.toHenry())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toWebers() {
        return this.to(Webers$.MODULE$);
    }
}

