/*
 * Decompiled with CFR 0.152.
 */
package squants.energy;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.electro.Amperes$;
import squants.electro.ElectricCurrent;
import squants.electro.ElectricPotential;
import squants.electro.Volts$;
import squants.energy.BtusPerHour$;
import squants.energy.Energy;
import squants.energy.ErgsPerSecond$;
import squants.energy.Gigawatts$;
import squants.energy.Kilowatts$;
import squants.energy.Megawatts$;
import squants.energy.Milliwatts$;
import squants.energy.Power$;
import squants.energy.PowerDensity;
import squants.energy.PowerRamp;
import squants.energy.PowerUnit;
import squants.energy.SolarLuminosities$;
import squants.energy.WattHours$;
import squants.energy.Watts$;
import squants.energy.WattsPerCubicMeter$;
import squants.energy.WattsPerHour$;
import squants.package$;
import squants.radio.Irradiance;
import squants.radio.RadiantIntensity;
import squants.radio.SpectralPower;
import squants.radio.WattsPerMeter$;
import squants.radio.WattsPerSquareMeter$;
import squants.radio.WattsPerSteradian$;
import squants.space.Area;
import squants.space.Length;
import squants.space.SolidAngle;
import squants.space.SquareMeters$;
import squants.space.SquaredRadians$;
import squants.space.Volume;
import squants.time.Hours$;
import squants.time.Time;
import squants.time.TimeDerivative;
import squants.time.TimeIntegral;

public final class Power
extends Quantity<Power>
implements TimeDerivative<Energy>,
TimeIntegral<PowerRamp> {
    private final double value;
    private final PowerUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Power$.class, "0bitmap$1");

    public static Power apply(Energy energy, Time time) {
        return Power$.MODULE$.apply(energy, time);
    }

    public static Try<Power> apply(Object object) {
        return Power$.MODULE$.apply(object);
    }

    public static <A> Power apply(A a, PowerUnit powerUnit, Numeric<A> numeric) {
        return Power$.MODULE$.apply(a, powerUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return Power$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Power$.MODULE$.name();
    }

    public static Try<Power> parseString(String string) {
        return Power$.MODULE$.parseString(string);
    }

    public static <N> Try<Power> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Power$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Power$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Power$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Power>> symbolToUnit(String string) {
        return Power$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Power$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Power$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Power(double value, PowerUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public PowerUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<Power> dimension() {
        return Power$.MODULE$;
    }

    @Override
    public Energy timeIntegrated() {
        return WattHours$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toWatts()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public PowerRamp timeDerived() {
        return WattsPerHour$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toWatts()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Hours$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public SpectralPower $div(Length that) {
        return WattsPerMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Length $div(SpectralPower that) {
        return package$.MODULE$.Meters().apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toWattsPerMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Irradiance $div(Area that) {
        return WattsPerSquareMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Area $div(Irradiance that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toWattsPerSquareMeter())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public SolidAngle $div(RadiantIntensity that) {
        return SquaredRadians$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toWattsPerSteradian())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public RadiantIntensity $div(SolidAngle that) {
        return WattsPerSteradian$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toSteradians())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricCurrent $div(ElectricPotential that) {
        return Amperes$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toVolts())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public ElectricPotential $div(ElectricCurrent that) {
        return Volts$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toAmperes())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public PowerDensity $div(Volume that) {
        return WattsPerCubicMeter$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toWatts() / that.toCubicMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toMilliwatts() {
        return this.to(Milliwatts$.MODULE$);
    }

    public double toWatts() {
        return this.to(Watts$.MODULE$);
    }

    public double toKilowatts() {
        return this.to(Kilowatts$.MODULE$);
    }

    public double toMegawatts() {
        return this.to(Megawatts$.MODULE$);
    }

    public double toGigawatts() {
        return this.to(Gigawatts$.MODULE$);
    }

    public double toBtusPerHour() {
        return this.to(BtusPerHour$.MODULE$);
    }

    public double toErgsPerSecond() {
        return this.to(ErgsPerSecond$.MODULE$);
    }

    public double toSolarLuminosities() {
        return this.to(SolarLuminosities$.MODULE$);
    }
}

