/*
 * Decompiled with CFR 0.152.
 */
package squants.market;

import java.io.Serializable;
import java.util.Objects;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Set;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.Numeric;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.market.Currency;
import squants.market.CurrencyExchangeRate;
import squants.market.CurrencyExchangeRate$;
import squants.market.Money$;
import squants.market.MoneyContext;
import squants.market.Price;
import squants.market.Price$;
import squants.market.package$;

public final class Money
extends Quantity<Money> {
    private final BigDecimal amount;
    private final Currency currency;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(Money$.class, "0bitmap$1");

    public static Money apply(BigDecimal bigDecimal, Currency currency) {
        return Money$.MODULE$.apply(bigDecimal, currency);
    }

    public static Money apply(BigDecimal bigDecimal, MoneyContext moneyContext) {
        return Money$.MODULE$.apply(bigDecimal, moneyContext);
    }

    public static Try<Money> apply(BigDecimal bigDecimal, String string, MoneyContext moneyContext) {
        return Money$.MODULE$.apply(bigDecimal, string, moneyContext);
    }

    public static Money apply(double d, MoneyContext moneyContext) {
        return Money$.MODULE$.apply(d, moneyContext);
    }

    public static <A> Money apply(A a, Currency currency, Numeric<A> numeric) {
        return Money$.MODULE$.apply(a, currency, numeric);
    }

    public static <A> Try<Money> apply(A a, String string, Numeric<A> numeric, MoneyContext moneyContext) {
        return Money$.MODULE$.apply(a, string, numeric, moneyContext);
    }

    public static Try<Money> apply(String string, MoneyContext moneyContext) {
        return Money$.MODULE$.apply(string, moneyContext);
    }

    public static Dimension dimensionImplicit() {
        return Money$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return Money$.MODULE$.name();
    }

    public static Try<Money> parseString(String string) {
        return Money$.MODULE$.parseString(string);
    }

    public static <N> Try<Money> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return Money$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return Money$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return Money$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<Money>> symbolToUnit(String string) {
        return Money$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return Money$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        Money$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public Money(BigDecimal amount, Currency currency) {
        this.amount = amount;
        this.currency = currency;
    }

    public BigDecimal amount() {
        return this.amount;
    }

    public Currency currency() {
        return this.currency;
    }

    @Override
    public Dimension<Money> dimension() {
        return Money$.MODULE$;
    }

    @Override
    public UnitOfMeasure<Money> unit() {
        return this.currency();
    }

    @Override
    public double value() {
        return this.amount().toDouble();
    }

    @Override
    public String toString() {
        return this.amount().underlying().stripTrailingZeros().toString() + " " + this.currency().code();
    }

    public String toString(Currency c, MoneyContext context) {
        return this.in(c, context).toString();
    }

    public String toFormattedString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.currency().symbol());
        BigDecimal bigDecimal = this.amount();
        int n = this.currency().formatDecimals();
        scala.package$.MODULE$.BigDecimal();
        return stringBuilder.append(bigDecimal.setScale(n, BigDecimal.RoundingMode$.MODULE$.HALF_EVEN()).toString()).toString();
    }

    public String toFormattedString(Currency c, MoneyContext context) {
        return this.in(c, context).toFormattedString();
    }

    public Money moneyPlus(Money that, MoneyContext context) {
        return context.add(this, that);
    }

    public MoneyContext moneyPlus$default$2(Money that) {
        return package$.MODULE$.defaultMoneyContext();
    }

    public Money $plus(Money that, MoneyContext context) {
        return context.add(this, that);
    }

    public MoneyContext $plus$default$2(Money that) {
        return package$.MODULE$.defaultMoneyContext();
    }

    @Override
    public Money plus(Money that) {
        Currency currency = that.currency();
        Currency currency2 = this.currency();
        Currency currency3 = currency;
        if (currency2 != null ? !((Object)currency2).equals(currency3) : currency3 != null) {
            throw new UnsupportedOperationException("plus not supported for cross-currency comparison - use moneyPlus");
        }
        return new Money(this.amount().$plus(that.amount()), this.currency());
    }

    public Money moneyMinus(Money that, MoneyContext context) {
        return context.subtract(this, that);
    }

    public MoneyContext moneyMinus$default$2(Money that) {
        return package$.MODULE$.defaultMoneyContext();
    }

    public Money $minus(Money that, MoneyContext context) {
        return context.subtract(this, that);
    }

    public MoneyContext $minus$default$2(Money that) {
        return package$.MODULE$.defaultMoneyContext();
    }

    @Override
    public Money minus(Money that) {
        Currency currency = that.currency();
        Currency currency2 = this.currency();
        Currency currency3 = currency;
        if (currency2 != null ? !((Object)currency2).equals(currency3) : currency3 != null) {
            throw new UnsupportedOperationException("minus not supported for cross-currency comparison - use moneyMinus");
        }
        return new Money(this.amount().$minus(that.amount()), this.currency());
    }

    public Money times(BigDecimal that) {
        return new Money(this.amount().$times(that), this.currency());
    }

    public Money $times(BigDecimal that) {
        return this.times(that);
    }

    @Override
    public Money times(double that) {
        return new Money(this.amount().$times(BigDecimal$.MODULE$.double2bigDecimal(that)), this.currency());
    }

    @Override
    public Money $times(double that) {
        return this.times(that);
    }

    public Money $times(CurrencyExchangeRate that) {
        return that.$times(this);
    }

    public Money divide(BigDecimal that) {
        return new Money(this.amount().$div(that), this.currency());
    }

    public Money $div(BigDecimal that) {
        return this.divide(that);
    }

    @Override
    public Money divide(double that) {
        return new Money(this.amount().$div(BigDecimal$.MODULE$.double2bigDecimal(that)), this.currency());
    }

    @Override
    public Money $div(double that) {
        return this.divide(that);
    }

    public Money $percent(BigDecimal that) {
        return new Money(this.amount().$percent(that), this.currency());
    }

    @Override
    public Tuple2<Money, Money> $div$percent(BigDecimal that) {
        Tuple2 tuple2 = this.amount().$div$percent(that);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        BigDecimal q = (BigDecimal)tuple2._1();
        BigDecimal r = (BigDecimal)tuple2._2();
        return Tuple2$.MODULE$.apply((Object)new Money(q, this.currency()), (Object)new Money(r, this.currency()));
    }

    public BigDecimal moneyDivide(Money that, MoneyContext context) {
        return context.divide(this, that);
    }

    public BigDecimal $div(Money that, MoneyContext context) {
        return this.moneyDivide(that, context);
    }

    public MoneyContext $div$default$2(Money that) {
        return package$.MODULE$.defaultMoneyContext();
    }

    public <A extends Quantity<A>> Price<A> $div(A that) {
        return Price$.MODULE$.apply(this, that);
    }

    public <A extends Quantity<A>> A $div(Price<A> that) {
        return ((Quantity)that.quantity()).$times(this.$div(that.money(), this.$div$default$2(that.money())).toDouble());
    }

    @Override
    public double divide(Money that) {
        block3: {
            block4: {
                Currency currency;
                Currency currency2;
                block2: {
                    Currency currency3 = that.currency();
                    currency2 = this.currency();
                    currency = currency3;
                    if (currency2 != null) break block2;
                    if (currency == null) break block3;
                    break block4;
                }
                if (((Object)currency2).equals(currency)) break block3;
            }
            throw new UnsupportedOperationException("divide not supported for cross-currency comparison - use moneyDivide");
        }
        return this.amount().$div(that.amount()).toDouble();
    }

    @Override
    public Money max(Money that) {
        Money m;
        block3: {
            block2: {
                Money money;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)that, (Object)that.currency());
                if (tuple2 == null || (money = (Money)tuple2._1()) == null) break block2;
                m = money;
                Currency currency = this.currency();
                Object object = tuple2._2();
                if (!(currency != null ? !((Object)currency).equals(object) : object != null)) break block3;
            }
            throw new UnsupportedOperationException("max not supported for cross-currency comparison - use moneyMax");
        }
        return new Money(this.amount().max(m.amount()), this.currency());
    }

    @Override
    public Money min(Money that) {
        Money m;
        block3: {
            block2: {
                Money money;
                Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)that, (Object)that.currency());
                if (tuple2 == null || (money = (Money)tuple2._1()) == null) break block2;
                m = money;
                Currency currency = this.currency();
                Object object = tuple2._2();
                if (!(currency != null ? !((Object)currency).equals(object) : object != null)) break block3;
            }
            throw new UnsupportedOperationException("min not supported for cross-currency comparison - use moneyMin");
        }
        return new Money(this.amount().min(m.amount()), this.currency());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof Money)) return false;
        Money m = (Money)object;
        BigDecimal bigDecimal = this.amount();
        BigDecimal bigDecimal2 = m.amount();
        if (bigDecimal == null) {
            if (bigDecimal2 != null) {
                return false;
            }
        } else if (!bigDecimal.equals(bigDecimal2)) return false;
        Currency currency = this.currency();
        Currency currency2 = m.currency();
        if (currency == null) {
            if (currency2 == null) return true;
            return false;
        } else {
            if (!((Object)currency).equals(currency2)) return false;
            return true;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.amount(), this.currency());
    }

    @Override
    public int compare(Money that) {
        Currency currency = that.currency();
        Currency currency2 = this.currency();
        Currency currency3 = currency;
        if (!(currency2 != null ? !((Object)currency2).equals(currency3) : currency3 != null)) {
        } else {
            throw new UnsupportedOperationException("Comparison between Moneys of dislike Currency is not supported");
        }
        return this.amount().$greater((Object)that.amount()) ? 1 : (this.amount().$less((Object)that.amount()) ? -1 : 0);
    }

    public Money moneyMax(Money that, MoneyContext moneyContext) {
        int n = moneyContext.compare(this, that);
        return -1 == n ? that : this;
    }

    public Money moneyMin(Money that, MoneyContext moneyContext) {
        int n = moneyContext.compare(this, that);
        return 1 == n ? that : this;
    }

    public boolean moneyEquals(Money that, MoneyContext moneyContext) {
        return this.moneyCompare(that, moneyContext) == 0;
    }

    public boolean moneyNotEquals(Money that, MoneyContext moneyContext) {
        return this.moneyCompare(that, moneyContext) != 0;
    }

    public int moneyCompare(Money that, MoneyContext moneyContext) {
        return moneyContext.compare(this, that);
    }

    public boolean $eq$eq$hash(Money that, MoneyContext moneyContext) {
        return this.moneyCompare(that, moneyContext) == 0;
    }

    public boolean $bang$eq$hash(Money that, MoneyContext moneyContext) {
        return this.moneyCompare(that, moneyContext) != 0;
    }

    public boolean $greater$hash(Money that, MoneyContext moneyContext) {
        return this.moneyCompare(that, moneyContext) > 0;
    }

    public boolean $greater$eq$hash(Money that, MoneyContext moneyContext) {
        return this.moneyCompare(that, moneyContext) >= 0;
    }

    public boolean $less$hash(Money that, MoneyContext moneyContext) {
        return this.moneyCompare(that, moneyContext) < 0;
    }

    public boolean $less$eq$hash(Money that, MoneyContext moneyContext) {
        return this.moneyCompare(that, moneyContext) <= 0;
    }

    public CurrencyExchangeRate toThe(Money that) {
        Currency currency = that.currency();
        Currency currency2 = this.currency();
        Currency currency3 = currency;
        if (!(currency2 != null ? !((Object)currency2).equals(currency3) : currency3 != null)) {
            throw new IllegalArgumentException("Can not create Exchange Rate on matching currencies");
        }
        return CurrencyExchangeRate$.MODULE$.apply(that, this);
    }

    public Function1<Money, CurrencyExchangeRate> $minus$greater() {
        return (Function1 & Serializable)that -> this.toThe((Money)that);
    }

    public BigDecimal to(Currency unit, MoneyContext context) {
        return context.convert(this, unit).amount();
    }

    public Money in(Currency unit, MoneyContext context) {
        return context.convert(this, unit);
    }

    @Override
    public Money rounded(int scale, Enumeration.Value mode) {
        return this.currency().apply(this.amount().setScale(scale, mode));
    }

    @Override
    public Enumeration.Value rounded$default$2() {
        return BigDecimal.RoundingMode$.MODULE$.HALF_EVEN();
    }

    public Money mapAmount(Function1<BigDecimal, BigDecimal> f) {
        return this.currency().apply((BigDecimal)f.apply((Object)this.amount()));
    }
}

