/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.mass.Kilograms$;
import squants.mass.Mass;
import squants.motion.KilogramsPerSecond$;
import squants.motion.KilopoundsPerHour$;
import squants.motion.MassFlow$;
import squants.motion.MassFlowUnit;
import squants.motion.MegapoundsPerHour$;
import squants.motion.PoundsPerHour$;
import squants.motion.PoundsPerSecond$;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;

public final class MassFlow
extends Quantity<MassFlow>
implements TimeDerivative<Mass> {
    private final double value;
    private final MassFlowUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(MassFlow$.class, "0bitmap$1");

    public static Try<MassFlow> apply(Object object) {
        return MassFlow$.MODULE$.apply(object);
    }

    public static <A> MassFlow apply(A a, MassFlowUnit massFlowUnit, Numeric<A> numeric) {
        return MassFlow$.MODULE$.apply(a, massFlowUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return MassFlow$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return MassFlow$.MODULE$.name();
    }

    public static Try<MassFlow> parseString(String string) {
        return MassFlow$.MODULE$.parseString(string);
    }

    public static <N> Try<MassFlow> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return MassFlow$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return MassFlow$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return MassFlow$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<MassFlow>> symbolToUnit(String string) {
        return MassFlow$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return MassFlow$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        MassFlow$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public MassFlow(double value, MassFlowUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public MassFlowUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<MassFlow> dimension() {
        return MassFlow$.MODULE$;
    }

    @Override
    public Mass timeIntegrated() {
        return Kilograms$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toKilogramsPerSecond()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public double toKilogramsPerSecond() {
        return this.to(KilogramsPerSecond$.MODULE$);
    }

    public double toPoundsPerSecond() {
        return this.to(PoundsPerSecond$.MODULE$);
    }

    public double toPoundsPerHour() {
        return this.to(PoundsPerHour$.MODULE$);
    }

    public double toKilopoundsPerHour() {
        return this.to(KilopoundsPerHour$.MODULE$);
    }

    public double toMegapoundsPerHour() {
        return this.to(MegapoundsPerHour$.MODULE$);
    }
}

