/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.math.Numeric;
import squants.motion.KilogramsPerSecond$;
import squants.motion.KilopoundsPerHour$;
import squants.motion.MassFlow;
import squants.motion.MassFlowConversions$;
import squants.motion.MegapoundsPerHour$;
import squants.motion.PoundsPerHour$;
import squants.motion.PoundsPerSecond$;

public final class MassFlowConversions {
    public static <A> MassFlowConversions<A> MassFlowConversions(A a, Numeric<A> numeric) {
        return MassFlowConversions$.MODULE$.MassFlowConversions(a, numeric);
    }

    public static MassFlow kilogramPerSecond() {
        return MassFlowConversions$.MODULE$.kilogramPerSecond();
    }

    public static MassFlow kilopoundPerHour() {
        return MassFlowConversions$.MODULE$.kilopoundPerHour();
    }

    public static MassFlow megapoundPerHour() {
        return MassFlowConversions$.MODULE$.megapoundPerHour();
    }

    public static MassFlow poundPerHour() {
        return MassFlowConversions$.MODULE$.poundPerHour();
    }

    public static MassFlow poundPerSecond() {
        return MassFlowConversions$.MODULE$.poundPerSecond();
    }

    public static class MassFlowConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public <A> MassFlowConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }

        public MassFlow kilogramsPerSecond() {
            return KilogramsPerSecond$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public MassFlow poundsPerSecond() {
            return PoundsPerSecond$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public MassFlow poundsPerHour() {
            return PoundsPerHour$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public MassFlow kilopoundsPerHour() {
            return KilopoundsPerHour$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public MassFlow megapoundsPerHour() {
            return MegapoundsPerHour$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }
    }
}

