/*
 * Decompiled with CFR 0.152.
 */
package squants.motion;

import scala.math.Numeric;
import squants.motion.BarsPerSecond$;
import squants.motion.PascalsPerSecond$;
import squants.motion.PoundsPerSquareInchPerSecond$;
import squants.motion.PressureChange;
import squants.motion.PressureChangeConversions$;
import squants.motion.StandardAtmospheresPerSecond$;

public final class PressureChangeConversions {
    public static <A> PressureChangeConversions<A> PressureChangeConversions(A a, Numeric<A> numeric) {
        return PressureChangeConversions$.MODULE$.PressureChangeConversions(a, numeric);
    }

    public static PressureChange barsPerSecond() {
        return PressureChangeConversions$.MODULE$.barsPerSecond();
    }

    public static PressureChange pascalsPerSecond() {
        return PressureChangeConversions$.MODULE$.pascalsPerSecond();
    }

    public static PressureChange poundsPerSquareInchPerSecond() {
        return PressureChangeConversions$.MODULE$.poundsPerSquareInchPerSecond();
    }

    public static PressureChange standardAtmospheresPerSecond() {
        return PressureChangeConversions$.MODULE$.standardAtmospheresPerSecond();
    }

    public static class PressureChangeConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public <A> PressureChangeConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }

        public PressureChange pascalsPerSecond() {
            return PascalsPerSecond$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public PressureChange barsPerSecond() {
            return BarsPerSecond$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public PressureChange poundsPerSquareInchPerSecond() {
            return PoundsPerSquareInchPerSecond$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public PressureChange standardAtmospheresPerSecond() {
            return StandardAtmospheresPerSecond$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }
    }
}

