/*
 * Decompiled with CFR 0.152.
 */
package squants.photo;

import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.util.Try;
import squants.Dimension;
import squants.PrimaryUnit;
import squants.Quantity;
import squants.SiUnit;
import squants.UnitOfMeasure;
import squants.package$;
import squants.photo.Illuminance;
import squants.photo.LumenSeconds$;
import squants.photo.Lumens$;
import squants.photo.LuminousEnergy;
import squants.photo.LuminousFlux$;
import squants.photo.LuminousFluxUnit;
import squants.photo.LuminousIntensity;
import squants.photo.Lux$;
import squants.space.Area;
import squants.space.SolidAngle;
import squants.space.SquareMeters$;
import squants.space.SquaredRadians$;
import squants.time.Seconds$;
import squants.time.Time;
import squants.time.TimeDerivative;

public final class LuminousFlux
extends Quantity<LuminousFlux>
implements TimeDerivative<LuminousEnergy> {
    private final double value;
    private final LuminousFluxUnit unit;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffset(LuminousFlux$.class, "0bitmap$1");

    public static Try<LuminousFlux> apply(Object object) {
        return LuminousFlux$.MODULE$.apply(object);
    }

    public static <A> LuminousFlux apply(A a, LuminousFluxUnit luminousFluxUnit, Numeric<A> numeric) {
        return LuminousFlux$.MODULE$.apply(a, luminousFluxUnit, numeric);
    }

    public static Dimension dimensionImplicit() {
        return LuminousFlux$.MODULE$.dimensionImplicit();
    }

    public static String name() {
        return LuminousFlux$.MODULE$.name();
    }

    public static Try<LuminousFlux> parseString(String string) {
        return LuminousFlux$.MODULE$.parseString(string);
    }

    public static <N> Try<LuminousFlux> parseTuple(Tuple2<N, String> tuple2, Numeric<N> numeric) {
        return LuminousFlux$.MODULE$.parseTuple((Tuple2)tuple2, (Numeric)numeric);
    }

    public static PrimaryUnit primaryUnit() {
        return LuminousFlux$.MODULE$.primaryUnit();
    }

    public static SiUnit siUnit() {
        return LuminousFlux$.MODULE$.siUnit();
    }

    public static Option<UnitOfMeasure<LuminousFlux>> symbolToUnit(String string) {
        return LuminousFlux$.MODULE$.symbolToUnit(string);
    }

    public static Set units() {
        return LuminousFlux$.MODULE$.units();
    }

    public static void squants$Dimension$_setter_$dimensionImplicit_$eq(Dimension dimension) {
        LuminousFlux$.MODULE$.squants$Dimension$_setter_$dimensionImplicit_$eq(dimension);
    }

    public LuminousFlux(double value, LuminousFluxUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    @Override
    public double value() {
        return this.value;
    }

    public LuminousFluxUnit unit() {
        return this.unit;
    }

    @Override
    public Dimension<LuminousFlux> dimension() {
        return LuminousFlux$.MODULE$;
    }

    @Override
    public LuminousEnergy timeIntegrated() {
        return LumenSeconds$.MODULE$.apply(BoxesRunTime.boxToDouble((double)this.toLumens()), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    @Override
    public Time time() {
        return Seconds$.MODULE$.apply(BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$);
    }

    public Illuminance $div(Area that) {
        return Lux$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toLumens() / that.toSquareMeters())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public Area $div(Illuminance that) {
        return SquareMeters$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toLumens() / that.toLux())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public LuminousIntensity $div(SolidAngle that) {
        return package$.MODULE$.Candelas().apply(BoxesRunTime.boxToDouble((double)(this.toLumens() / that.toSquaredRadians())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public SolidAngle $div(LuminousIntensity that) {
        return SquaredRadians$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(this.toLumens() / that.toCandelas())), (Numeric)Numeric.DoubleIsFractional$.MODULE$);
    }

    public double toLumens() {
        return this.to(Lumens$.MODULE$);
    }
}

