/*
 * Decompiled with CFR 0.152.
 */
package squants.time;

import scala.math.Numeric;
import squants.time.Frequency;
import squants.time.FrequencyConversions$;
import squants.time.Gigahertz$;
import squants.time.Hertz$;
import squants.time.Kilohertz$;
import squants.time.Megahertz$;
import squants.time.RevolutionsPerMinute$;
import squants.time.Terahertz$;

public final class FrequencyConversions {
    public static <A> FrequencyConversions<A> FrequencyConversions(A a, Numeric<A> numeric) {
        return FrequencyConversions$.MODULE$.FrequencyConversions(a, numeric);
    }

    public static class FrequencyConversions<A> {
        private final A n;
        private final Numeric<A> num;

        public <A> FrequencyConversions(A n, Numeric<A> num) {
            this.n = n;
            this.num = num;
        }

        public Frequency hertz() {
            return Hertz$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Frequency kilohertz() {
            return Kilohertz$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Frequency megahertz() {
            return Megahertz$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Frequency gigahertz() {
            return Gigahertz$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Frequency terahertz() {
            return Terahertz$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }

        public Frequency rpm() {
            return RevolutionsPerMinute$.MODULE$.apply((Object)this.n, (Numeric)this.num);
        }
    }
}

