/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.gui.server.git;

import java.io.File;
import java.io.Serializable;
import java.nio.file.OpenOption;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.loader.KeyPairResourceParser;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.git.transport.GitSshdSessionFactory;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.StashApplyFailureException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.URIish;
import org.openmole.gui.server.git.GitAuthentication;
import org.openmole.gui.server.git.GitService;
import org.openmole.gui.server.git.GitService$Factory$;
import org.openmole.gui.shared.data.MergeStatus;
import org.openmole.gui.shared.data.MergeStatus$;
import org.openmole.gui.shared.data.PushStatus;
import org.openmole.gui.shared.data.PushStatus$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class GitService$
implements Serializable {
    public static final GitService$Factory$ Factory;
    public static final GitService$ MODULE$;

    private GitService$() {
    }

    static {
        MODULE$ = new GitService$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GitService$.class);
    }

    public Option<Git> git(File file, File ceilingDirectory) {
        FileRepositoryBuilder builder = (FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment().addCeilingDirectory(ceilingDirectory).findGitDir(file);
        File file2 = builder.getGitDir();
        if (file2 == null) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)new Git(builder.build()));
    }

    public <T> Option<T> withGit(File fromFile, File ceilingDir, Function1<Git, T> g) {
        return this.git(fromFile, ceilingDir).map((Function1 & Serializable)git -> {
            Object object;
            try {
                object = g.apply(git);
            }
            finally {
                git.close();
            }
            return object;
        });
    }

    public String rootPath(Git git) {
        return git.getRepository().getDirectory().getParentFile().getAbsolutePath();
    }

    public String relativeName(File f, Git git) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])f.getAbsolutePath().split("/"));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.diff$extension(object, (Seq)Predef$.MODULE$.wrapRefArray((Object[])this.rootPath(git).split("/")))).mkString("/");
    }

    public Git clone(String remoteURL, File destination, scala.collection.immutable.Seq<GitAuthentication.PrivateKey> authentication) {
        destination.getParentFile().mkdirs();
        return (Git)this.withConfiguredTransport(authentication, Git.cloneRepository(), (Function1 & Serializable)_$1 -> _$1.setURI(remoteURL).setDirectory(destination).call());
    }

    public RevCommit commit(scala.collection.immutable.Seq<File> files, String message, Git git) {
        return this.addCommitedFiles$1(git, files, git.commit()).setMessage(message).call();
    }

    public void revert(scala.collection.immutable.Seq<File> files, Git git) {
        this.addPath0$1(git, files, git.checkout()).call();
    }

    public DirCache add(scala.collection.immutable.Seq<File> files, Git git) {
        return this.addPath0$2(git, files, git.add()).call();
    }

    public MergeStatus pull(Git git, scala.collection.immutable.Seq<GitAuthentication.PrivateKey> authentication) {
        if (!git.stashList().call().isEmpty()) {
            MergeStatus mergeStatus;
            try {
                this.withConfiguredTransport(authentication, git.pull(), (Function1 & Serializable)_$2 -> _$2.call());
                mergeStatus = MergeStatus$.Ok;
            }
            catch (CheckoutConflictException e) {
                mergeStatus = MergeStatus$.ChangeToBeResolved;
            }
            catch (TransportException e) {
                mergeStatus = MergeStatus$.ConnectionFailed;
            }
            return mergeStatus;
        }
        return MergeStatus$.Empty;
    }

    public PushStatus push(Git git, scala.collection.immutable.Seq<GitAuthentication.PrivateKey> authentication) {
        PushStatus pushStatus;
        try {
            this.withConfiguredTransport(authentication, git.push(), (Function1 & Serializable)_$3 -> _$3.call());
            pushStatus = PushStatus$.Ok;
        }
        catch (TransportException e) {
            pushStatus = PushStatus$.AuthenticationRequired;
        }
        return pushStatus;
    }

    public scala.collection.immutable.Seq<String> branchList(Git git) {
        return (scala.collection.immutable.Seq)((SeqOps)CollectionConverters$.MODULE$.ListHasAsScala(git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call()).asScala().toSeq().map((Function1 & Serializable)_$4 -> _$4.getName())).sorted((Ordering)Ordering.String$.MODULE$);
    }

    public Object checkout(String branchName, Git git) {
        if (((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(git.branchList().call()).asScala().toSeq().map((Function1 & Serializable)_$5 -> _$5.getName())).exists((Function1 & Serializable)_$6 -> _$6.contains(branchName))) {
            return git.checkout().setName(branchName).call();
        }
        ((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call()).asScala().toSeq().filter((Function1 & Serializable)b -> b.getName().contains(branchName))).headOption().foreach((Function1 & Serializable)ref -> {
            String remote = ref.getName().split("/")[2];
            return git.checkout().setCreateBranch(true).setName(branchName).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint(remote + "/" + branchName).call();
        });
        return BoxedUnit.UNIT;
    }

    public void stash(Git git) {
        git.stashCreate().call();
    }

    public MergeStatus stashPop(Git git) {
        if (!git.stashList().call().isEmpty()) {
            MergeStatus mergeStatus;
            try {
                git.stashApply().call();
                mergeStatus = MergeStatus$.Ok;
            }
            catch (StashApplyFailureException e) {
                mergeStatus = MergeStatus$.ChangeToBeResolved;
            }
            return mergeStatus;
        }
        return MergeStatus$.Empty;
    }

    private IndexedSeq<String> getAllSubPaths(String path) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])path.split("/"));
        Object[] allDirs = (String[])ArrayOps$.MODULE$.dropRight$extension(object, 1);
        Object object2 = Predef$.MODULE$.refArrayOps(allDirs);
        int size = ArrayOps$.MODULE$.size$extension(object2);
        return (IndexedSeq)RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), size).map(arg_0 -> GitService$.getAllSubPaths$$anonfun$adapted$1((String[])allDirs, size, arg_0)).$colon$plus((Object)path);
    }

    public scala.collection.immutable.Seq<String> getModified(Git git) {
        Status status = git.status().call();
        return (scala.collection.immutable.Seq)((IterableOps)CollectionConverters$.MODULE$.SetHasAsScala(status.getModified()).asScala().toSeq().$plus$plus((IterableOnce)CollectionConverters$.MODULE$.SetHasAsScala(status.getAdded()).asScala().toSeq())).flatMap((Function1 & Serializable)path -> MODULE$.getAllSubPaths((String)path));
    }

    public scala.collection.immutable.Seq<String> getUntracked(Git git) {
        return (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.SetHasAsScala(git.status().call().getUntracked()).asScala().toSeq().flatMap((Function1 & Serializable)path -> MODULE$.getAllSubPaths((String)path));
    }

    public scala.collection.immutable.Seq<String> getConflicting(Git git) {
        return (scala.collection.immutable.Seq)CollectionConverters$.MODULE$.SetHasAsScala(git.status().call().getConflicting()).asScala().toSeq().flatMap((Function1 & Serializable)path -> MODULE$.getAllSubPaths((String)path));
    }

    public <T extends TransportCommand<?, ?>, R> R withConfiguredTransport(scala.collection.immutable.Seq<GitAuthentication.PrivateKey> authentication, T transportCommand, Function1<T, R> f) {
        Object object;
        CredentialsProvider prov = new CredentialsProvider(){

            public boolean isInteractive() {
                return false;
            }

            public boolean supports(scala.collection.immutable.Seq items) {
                return true;
            }

            public /* synthetic */ boolean supports(CredentialItem ... items) {
                return this.supports((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])items));
            }

            public boolean get(URIish uri, scala.collection.immutable.Seq items) {
                return true;
            }

            public /* synthetic */ boolean get(URIish uri, CredentialItem ... items) {
                return this.get(uri, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])items));
            }
        };
        try (GitService.Factory factory = this.sshdSessionFactory(authentication);){
            transportCommand.setCredentialsProvider(prov);
            transportCommand.setTransportConfigCallback(x$1 -> {
                Transport transport = x$1;
                if (transport instanceof SshTransport) {
                    SshTransport t = (SshTransport)transport;
                    t.setSshSessionFactory(factory.factory());
                    return;
                }
            });
            object = f.apply(transportCommand);
        }
        return (R)object;
    }

    public GitService.Factory sshdSessionFactory(scala.collection.immutable.Seq<GitAuthentication.PrivateKey> authentications) {
        SshClient sshClient = (SshClient)ClientBuilder.builder().build();
        sshClient.setServerKeyVerifier((ServerKeyVerifier)AcceptAllServerKeyVerifier.INSTANCE);
        sshClient.setSignatureFactories(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)BuiltinSignatures.ed25519, (List)new .colon.colon((Object)BuiltinSignatures.ed25519_cert, (List)new .colon.colon((Object)BuiltinSignatures.sk_ssh_ed25519, (List)Nil$.MODULE$)))).asJava());
        KeyPairResourceParser loader = SecurityUtils.getKeyPairResourceParser();
        scala.collection.immutable.Seq keys = (scala.collection.immutable.Seq)authentications.flatMap((Function1 & Serializable)git -> CollectionConverters$.MODULE$.CollectionHasAsScala(loader.loadKeyPairs(null, git.privateKey().toPath(), FilePasswordProvider.of((String)git.password()), new OpenOption[0])).asScala());
        keys.foreach((Function1)(JProcedure1 & Serializable)x$0 -> sshClient.addPublicKeyIdentity(x$0));
        sshClient.setHostConfigEntryResolver((host, port, socketAddress, username, jump, attributeRepository) -> {
            int portValue = port < 0 ? 22 : port;
            return new HostConfigEntry(host, host, portValue, username, jump);
        });
        GitSshdSessionFactory sshSessionFactory = new GitSshdSessionFactory(sshClient);
        return GitService$Factory$.MODULE$.apply((SshSessionFactory)sshSessionFactory, sshClient);
    }

    private final CommitCommand addCommitedFiles$1(Git git$1, scala.collection.immutable.Seq fs, CommitCommand commitCommand) {
        while (!fs.isEmpty()) {
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)fs.tail();
            CommitCommand commitCommand2 = commitCommand.setOnly(this.relativeName((File)fs.head(), git$1));
            fs = seq;
            commitCommand = commitCommand2;
        }
        return commitCommand;
    }

    private final CheckoutCommand addPath0$1(Git git$2, scala.collection.immutable.Seq fs, CheckoutCommand checkoutCommand) {
        while (!fs.isEmpty()) {
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)fs.tail();
            CheckoutCommand checkoutCommand2 = checkoutCommand.addPath(this.relativeName((File)fs.head(), git$2));
            fs = seq;
            checkoutCommand = checkoutCommand2;
        }
        return checkoutCommand;
    }

    private final AddCommand addPath0$2(Git git$3, scala.collection.immutable.Seq fs, AddCommand addCommand) {
        while (!fs.isEmpty()) {
            scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)fs.tail();
            AddCommand addCommand2 = addCommand.addFilepattern(this.relativeName((File)fs.head(), git$3));
            fs = seq;
            addCommand = addCommand2;
        }
        return addCommand;
    }

    private static final /* synthetic */ String getAllSubPaths$$anonfun$1(String[] allDirs$1, int size$1, int i) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])allDirs$1);
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.dropRight$extension(object, size$1 - i)).mkString("/");
    }

    private static /* bridge */ /* synthetic */ String getAllSubPaths$$anonfun$adapted$1(String[] allDirs$2, int size$2, Object i) {
        return GitService$.getAllSubPaths$$anonfun$1(allDirs$2, size$2, BoxesRunTime.unboxToInt((Object)i));
    }
}

