/*
 * Decompiled with CFR 0.152.
 */
package gridscale.dirac;

import gridscale.authentication.P12Authentication;
import gridscale.dirac.package;
import gridscale.dirac.package$DIRACServer$;
import gridscale.dirac.package$DIRACState$;
import gridscale.dirac.package$JobDescription$;
import gridscale.dirac.package$JobID$;
import gridscale.dirac.package$Service$;
import gridscale.dirac.package$Token$;
import gridscale.http.package;
import gridscale.package;
import gridscale.tools.FileSystem$;
import gridscale.tools.ManifestCompat$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JString;
import org.json4s.JString$;
import org.json4s.JValue;
import org.json4s.MonadicJValue$;
import org.json4s.jackson.JsonMethods$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import squants.time.Time;
import squants.time.TimeConversions$;

public final class package$
implements Serializable {
    public static final package$JobDescription$ JobDescription;
    public static final package$Token$ Token;
    public static final package$DIRACServer$ DIRACServer;
    public static final package$Service$ Service;
    public static final package$JobID$ JobID;
    public static final package$DIRACState$ DIRACState;
    public static final package$ MODULE$;

    private package$() {
    }

    static {
        MODULE$ = new package$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(package$.class);
    }

    public DefaultFormats format() {
        return DefaultFormats$.MODULE$;
    }

    public package.Service getService(String vo, File certificatesDirectory, Time timeout, package.HTTP x$4) {
        Map<String, package.Service> services = this.getServices(certificatesDirectory, timeout, this.getServices$default$3(), x$4);
        return (package.Service)services.getOrElse((Object)vo, () -> package$.getService$$anonfun$1(vo));
    }

    public Time getService$default$3() {
        return TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).minutes();
    }

    public Map<String, package.Service> getServices(File certificatesDirectory, Time timeout, String directoryURL, package.HTTP http) {
        Vector certificates = package.HTTPS$.MODULE$.readPEMCertificates(certificatesDirectory);
        Function1 factory = package.HTTPS$.MODULE$.socketFactory(certificates, "", false, package.HTTPS$.MODULE$.socketFactory$default$4());
        package.HTTPSServer indexServer = package.HTTPSServer$.MODULE$.apply(directoryURL, factory, timeout, package.HTTPSServer$.MODULE$.apply$default$4(), package.HTTPSServer$.MODULE$.apply$default$5());
        return this.getService$1(gridscale.http.package$.MODULE$.read((package.Server)indexServer, "", gridscale.http.package$.MODULE$.read$default$3(), http));
    }

    public Time getServices$default$2() {
        return TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).minutes();
    }

    public String getServices$default$3() {
        return "https://dirac.france-grilles.fr/defaults/DiracServices.json";
    }

    public Iterable<String> supportedVOs(File certificatesDirectory, Time timeout, package.HTTP x$3) {
        return this.getServices(certificatesDirectory, timeout, this.getServices$default$3(), x$3).keys();
    }

    public Time supportedVOs$default$2() {
        return TimeConversions$.MODULE$.TimeConversions((Object)BoxesRunTime.boxToInteger((int)1), (Numeric)Numeric.IntIsIntegral$.MODULE$).minutes();
    }

    public package.DIRACServer server(package.Service service, P12Authentication p12, File certificateDirectory, package.HTTP x$4) {
        package.HTTPS$.KeyStoreOperations$.Credential userCertificate = package.HTTPS$.MODULE$.readP12(p12.certificate(), p12.password());
        Vector certificates = package.HTTPS$.MODULE$.readPEMCertificates(certificateDirectory);
        Function1 factory = package.HTTPS$.MODULE$.socketFactory((Vector)certificates.$plus$plus((IterableOnce)scala.package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new package.HTTPS$.KeyStoreOperations$.Credential[]{userCertificate}))), p12.password(), package.HTTPS$.MODULE$.socketFactory$default$3(), package.HTTPS$.MODULE$.socketFactory$default$4());
        package.HTTPSServer server = package.HTTPSServer$.MODULE$.apply(service.service(), factory, package.HTTPSServer$.MODULE$.apply$default$3(), package.HTTPSServer$.MODULE$.apply$default$4(), package.HTTPSServer$.MODULE$.apply$default$5());
        return package$DIRACServer$.MODULE$.apply(server, service);
    }

    public package.Token token(package.DIRACServer server, String setup, package.HTTP x$3) {
        URI uri = new URIBuilder().setParameter("grant_type", "client_credentials").setParameter("group", server.service().group()).setParameter("setup", setup).build();
        String r = gridscale.http.package$.MODULE$.read((package.Server)server.server(), this.auth2Auth$1() + "?" + uri.getQuery(), gridscale.http.package$.MODULE$.read$default$3(), x$3);
        JValue parsed = JsonMethods$.MODULE$.parse((Object)r.trim(), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput());
        return package$Token$.MODULE$.apply((String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(parsed), "token")), (Formats)this.format(), ManifestCompat$.MODULE$.classTagToManifest((ClassTag)ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class)))), TimeConversions$.MODULE$.TimeConversions(ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(parsed), "expires_in")), (Formats)this.format(), ManifestCompat$.MODULE$.classTagToManifest((ClassTag)ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(Long.TYPE)))), (Numeric)Numeric.LongIsIntegral$.MODULE$).seconds());
    }

    public String token$default$2() {
        return "Dirac-Production";
    }

    public String jobsLocation() {
        return "/jobs";
    }

    public package.JobID submit(package.DIRACServer server, package.JobDescription jobDescription, package.Token token, Option<String> jobGroup, package.HTTP x$5) {
        String r = gridscale.http.package$.MODULE$.read((package.Server)server.server(), this.jobsLocation(), (package.HTTPMethod)package.Post$.MODULE$.apply((Function0 & Serializable)() -> this.files$1(jobDescription, token, jobGroup), package.Post$.MODULE$.$lessinit$greater$default$2()), x$5);
        String id = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(JsonMethods$.MODULE$.parse((Object)r, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput())), "jids").apply(0)), (Formats)this.format(), ManifestCompat$.MODULE$.classTagToManifest((ClassTag)ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
        return package$JobID$.MODULE$.apply(id, (Option<package.JobDescription>)Some$.MODULE$.apply((Object)jobDescription));
    }

    public Option<String> submit$default$4() {
        return None$.MODULE$;
    }

    public package.JobState state(package.DIRACServer server, package.Token token, package.JobID jobId, package.HTTP x$4) {
        URI uri = new URIBuilder().setParameter("access_token", token.token()).build();
        String r = gridscale.http.package$.MODULE$.read((package.Server)server.server(), this.jobsLocation() + "/" + jobId.id() + "?" + uri.getQuery(), gridscale.http.package$.MODULE$.read$default$3(), x$4);
        String s = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(JsonMethods$.MODULE$.parse((Object)r, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput())), "status")), (Formats)this.format(), ManifestCompat$.MODULE$.classTagToManifest((ClassTag)ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
        return this.translateState(s);
    }

    public package.JobState translateState(String s) {
        package.DIRACState dIRACState = package$DIRACState$.MODULE$.withName(s);
        package.DIRACState dIRACState2 = package$DIRACState$.Received;
        package.DIRACState dIRACState3 = dIRACState;
        if (!(dIRACState2 != null ? !dIRACState2.equals(dIRACState3) : dIRACState3 != null)) {
            return package.JobState$.Submitted;
        }
        package.DIRACState dIRACState4 = package$DIRACState$.Checking;
        package.DIRACState dIRACState5 = dIRACState;
        if (!(dIRACState4 != null ? !dIRACState4.equals(dIRACState5) : dIRACState5 != null)) {
            return package.JobState$.Submitted;
        }
        package.DIRACState dIRACState6 = package$DIRACState$.Staging;
        package.DIRACState dIRACState7 = dIRACState;
        if (!(dIRACState6 != null ? !dIRACState6.equals(dIRACState7) : dIRACState7 != null)) {
            return package.JobState$.Submitted;
        }
        package.DIRACState dIRACState8 = package$DIRACState$.Waiting;
        package.DIRACState dIRACState9 = dIRACState;
        if (!(dIRACState8 != null ? !dIRACState8.equals(dIRACState9) : dIRACState9 != null)) {
            return package.JobState$.Submitted;
        }
        package.DIRACState dIRACState10 = package$DIRACState$.Matched;
        package.DIRACState dIRACState11 = dIRACState;
        if (!(dIRACState10 != null ? !dIRACState10.equals(dIRACState11) : dIRACState11 != null)) {
            return package.JobState$.Submitted;
        }
        package.DIRACState dIRACState12 = package$DIRACState$.Running;
        package.DIRACState dIRACState13 = dIRACState;
        if (!(dIRACState12 != null ? !dIRACState12.equals(dIRACState13) : dIRACState13 != null)) {
            return package.JobState$.Running;
        }
        package.DIRACState dIRACState14 = package$DIRACState$.Completing;
        package.DIRACState dIRACState15 = dIRACState;
        if (!(dIRACState14 != null ? !dIRACState14.equals(dIRACState15) : dIRACState15 != null)) {
            return package.JobState$.Running;
        }
        package.DIRACState dIRACState16 = package$DIRACState$.Completed;
        package.DIRACState dIRACState17 = dIRACState;
        if (!(dIRACState16 != null ? !dIRACState16.equals(dIRACState17) : dIRACState17 != null)) {
            return package.JobState$.Running;
        }
        package.DIRACState dIRACState18 = package$DIRACState$.Stalled;
        package.DIRACState dIRACState19 = dIRACState;
        if (!(dIRACState18 != null ? !dIRACState18.equals(dIRACState19) : dIRACState19 != null)) {
            return package.JobState$.Running;
        }
        package.DIRACState dIRACState20 = package$DIRACState$.Killed;
        package.DIRACState dIRACState21 = dIRACState;
        if (!(dIRACState20 != null ? !dIRACState20.equals(dIRACState21) : dIRACState21 != null)) {
            return package.JobState$.Failed$.MODULE$.apply("Job was killed");
        }
        package.DIRACState dIRACState22 = package$DIRACState$.Deleted;
        package.DIRACState dIRACState23 = dIRACState;
        if (!(dIRACState22 != null ? !dIRACState22.equals(dIRACState23) : dIRACState23 != null)) {
            return package.JobState$.Failed$.MODULE$.apply("Job was deleted");
        }
        package.DIRACState dIRACState24 = package$DIRACState$.Done;
        package.DIRACState dIRACState25 = dIRACState;
        if (!(dIRACState24 != null ? !dIRACState24.equals(dIRACState25) : dIRACState25 != null)) {
            return package.JobState$.Done;
        }
        package.DIRACState dIRACState26 = package$DIRACState$.Failed;
        package.DIRACState dIRACState27 = dIRACState;
        if (!(dIRACState26 != null ? !dIRACState26.equals(dIRACState27) : dIRACState27 != null)) {
            return package.JobState$.Failed$.MODULE$.apply(package.JobState$.Failed$.MODULE$.$lessinit$greater$default$1());
        }
        throw new MatchError((Object)dIRACState);
    }

    public Vector<Tuple2<String, package.JobState>> queryState(package.DIRACServer server, package.Token token, Option<String> groupId2, Option<String> userId2, Seq<package.DIRACState> states, package.HTTP x$6) {
        URIBuilder uri = new URIBuilder(server.server().url()).setParameter("access_token", token.token()).setParameter("startJob", BoxesRunTime.boxToInteger((int)0).toString()).setParameter("maxJobs", BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE).toString());
        groupId2.foreach((Function1 & Serializable)groupId -> uri.setParameter("jobGroup", groupId));
        userId2.foreach((Function1 & Serializable)userId -> uri.setParameter("owner", userId));
        URI uri2 = uri.build();
        JValue json = (JValue)gridscale.http.package$.MODULE$.readStream((package.Server)server.server(), this.jobsLocation() + "?" + uri2.getQuery() + this.statusesQuery$1(states), (Function1 & Serializable)is -> JsonMethods$.MODULE$.parse(is, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.streamAsJsonInput()), gridscale.http.package$.MODULE$.readStream$default$4(), x$6);
        return MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(json), "jobs").children().map((Function1 & Serializable)j -> {
            String status = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(j), "status")), (Formats)MODULE$.format(), ManifestCompat$.MODULE$.classTagToManifest((ClassTag)ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
            String string = (String)Predef$.MODULE$.ArrowAssoc(ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(j), "jid")), (Formats)MODULE$.format(), ManifestCompat$.MODULE$.classTagToManifest((ClassTag)ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class)))));
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)MODULE$.translateState(status));
        }).toVector();
    }

    public Option<String> queryState$default$3() {
        return None$.MODULE$;
    }

    public Option<String> queryState$default$4() {
        return None$.MODULE$;
    }

    public Seq<package.DIRACState> queryState$default$5() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])package$DIRACState$.MODULE$.values());
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.filter$extension(object, (Function1 & Serializable)s -> {
            package.DIRACState dIRACState = s;
            package.DIRACState dIRACState2 = package$DIRACState$.Killed;
            if (dIRACState == null) {
                if (dIRACState2 == null) return false;
            } else if (dIRACState.equals(dIRACState2)) return false;
            package.DIRACState dIRACState3 = s;
            package.DIRACState dIRACState4 = package$DIRACState$.Deleted;
            if (dIRACState3 == null) {
                if (dIRACState4 == null) return false;
                return true;
            } else if (dIRACState3.equals(dIRACState4)) return false;
            return true;
        }));
    }

    public IndexedSeq<BoxedUnit> delete(package.DIRACServer server, package.Token token, package.JobID jobId, package.HTTP x$4) {
        URI uri = new URIBuilder().setParameter("access_token", token.token()).build();
        return StringOps$.MODULE$.map$extension(Predef$.MODULE$.augmentString(gridscale.http.package$.MODULE$.read((package.Server)server.server(), this.jobsLocation() + "/" + jobId.id() + "?" + uri.getQuery(), (package.HTTPMethod)package.Delete$.MODULE$.apply(package.Delete$.MODULE$.$lessinit$greater$default$1()), x$4)), (Function1 & Serializable)v1 -> {
            package$.delete$$anonfun$1(BoxesRunTime.unboxToChar((Object)v1));
            return BoxedUnit.UNIT;
        });
    }

    public void downloadOutputSandbox(package.DIRACServer server, package.Token token, package.JobID jobId, File outputDirectory, package.HTTP x$5) {
        URI uri = new URIBuilder().setParameter("access_token", token.token()).build();
        gridscale.http.package$.MODULE$.readStream((package.Server)server.server(), this.jobsLocation() + "/" + jobId.id() + "/outputsandbox?" + uri.getQuery(), (Function1)(JProcedure1 & Serializable)is -> this.extract$1((InputStream)is, outputDirectory), gridscale.http.package$.MODULE$.readStream$default$4(), x$5);
    }

    public void delegate(package.DIRACServer server, P12Authentication p12, package.Token token, package.HTTP x$4) {
        gridscale.http.package$.MODULE$.read((package.Server)server.server(), this.delegation$1(server), (package.HTTPMethod)package.Post$.MODULE$.apply((Function0 & Serializable)() -> this.entity$1(p12, token), package.Post$.MODULE$.$lessinit$greater$default$2()), x$4);
    }

    public static final /* synthetic */ JString gridscale$dirac$package$JobDescription$$$_$inputSandboxArray$1$$anonfun$1(File f) {
        return JString$.MODULE$.apply(f.getName());
    }

    public static final /* synthetic */ JString gridscale$dirac$package$JobDescription$$$_$outputSandboxArray$1$$anonfun$1(String f) {
        return JString$.MODULE$.apply(f);
    }

    public static final /* synthetic */ JString gridscale$dirac$package$JobDescription$$$_$platformsArray$1$$anonfun$1(String f) {
        return JString$.MODULE$.apply(f);
    }

    public static final /* synthetic */ Tuple2 gridscale$dirac$package$JobDescription$$$_$_$$anonfun$1(String s) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"StdOutput");
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)JString$.MODULE$.apply(s));
    }

    public static final /* synthetic */ Tuple2 gridscale$dirac$package$JobDescription$$$_$_$$anonfun$2(String s) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"StdError");
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)JString$.MODULE$.apply(s));
    }

    public static final /* synthetic */ Tuple2 gridscale$dirac$package$JobDescription$$$_$_$$anonfun$3(Time s) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"CPUTime");
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)JString$.MODULE$.apply(BoxesRunTime.boxToDouble((double)s.toSeconds()).toString()));
    }

    public static final /* synthetic */ Tuple2 gridscale$dirac$package$JobDescription$$$_$_$$anonfun$4(String s) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"JobGroup");
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)JString$.MODULE$.apply(s));
    }

    private static final /* synthetic */ Tuple2 $anonfun$5(int c) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"NumberOfProcessors");
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)JString$.MODULE$.apply(BoxesRunTime.boxToInteger((int)c).toString()));
    }

    public static /* bridge */ /* synthetic */ Tuple2 gridscale$dirac$package$JobDescription$$$_$_$$anonfun$adapted$1(Object c) {
        return package$.$anonfun$5(BoxesRunTime.unboxToInt((Object)c));
    }

    public static final /* synthetic */ Tuple2 gridscale$dirac$package$JobDescription$$$_$_$$anonfun$6(String s) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Site");
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)JString$.MODULE$.apply(s));
    }

    public static final /* synthetic */ Tuple2 gridscale$dirac$package$DIRACState$$$_$stateIndex$lzyINIT1$$anonfun$1(package.DIRACState v) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)package$DIRACState$.MODULE$.name(v).toLowerCase());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)v);
    }

    public static final package.DIRACState gridscale$dirac$package$DIRACState$$$_$withName$$anonfun$1(String s$1) {
        throw new RuntimeException("Unmatched state " + s$1);
    }

    private static final package.Service getService$$anonfun$1(String vo$1) {
        throw new RuntimeException("Service not fond for the vo " + vo$1 + " in the DIRAC service directory");
    }

    private final Map getService$1(String json) {
        return JsonMethods$.MODULE$.parse((Object)json, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()).children().map((Function1 & Serializable)s -> {
            String vo = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(s), "DIRACVOName")), (Formats)MODULE$.format(), ManifestCompat$.MODULE$.classTagToManifest((ClassTag)ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
            String server = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(s), "RESTServer")), (Formats)MODULE$.format(), ManifestCompat$.MODULE$.classTagToManifest((ClassTag)ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
            String group = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(s), "DIRACDefaultGroup")), (Formats)MODULE$.format(), ManifestCompat$.MODULE$.classTagToManifest((ClassTag)ManifestCompat$.MODULE$.classTagToManifest(ClassTag$.MODULE$.apply(String.class))));
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)vo);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package$Service$.MODULE$.apply("https://" + server, group));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private final String auth2Auth$1() {
        return "/oauth2/token";
    }

    private final HttpEntity files$1(package.JobDescription jobDescription$4, package.Token token$2, Option jobGroup$1) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        jobDescription$4.inputSandbox().foreach((Function1 & Serializable)f -> builder.addBinaryBody(f.getName(), f));
        builder.addTextBody("access_token", token$2.token());
        builder.addTextBody("manifest", package$JobDescription$.MODULE$.toJSON(jobDescription$4, (Option<String>)jobGroup$1));
        return builder.build();
    }

    private final String statusesQuery$1(Seq states$1) {
        if (states$1.isEmpty()) {
            return "";
        }
        return "&" + ((IterableOnceOps)states$1.map((Function1 & Serializable)s -> "status=" + package$DIRACState$.MODULE$.name((package.DIRACState)s))).mkString("&");
    }

    private static final /* synthetic */ void delete$$anonfun$1(char _$1) {
    }

    private static final TarArchiveEntry extract$1$$anonfun$1(TarArchiveInputStream is$1) {
        return is$1.getNextEntry();
    }

    private final void extract$1(InputStream str, File outputDirectory) {
        outputDirectory.mkdirs();
        try (TarArchiveInputStream is = new TarArchiveInputStream(new BZip2CompressorInputStream(str));){
            scala.package$.MODULE$.Iterator().continually(() -> package$.extract$1$$anonfun$1(is)).takeWhile((Function1 & Serializable)_$2 -> _$2 != null).foreach((Function1 & Serializable)e -> BoxesRunTime.unboxToLong((Object)FileSystem$.MODULE$.writeStream(new File(outputDirectory, e.getName()), (Function1 & Serializable)os -> IOUtils.copy(is, os))));
        }
    }

    private final HttpEntity entity$1(P12Authentication p12$1, package.Token token$3) {
        MultipartEntityBuilder entity = MultipartEntityBuilder.create();
        entity.addBinaryBody("p12", p12$1.certificate());
        entity.addTextBody("Password", p12$1.password());
        entity.addTextBody("access_token", token$3.token());
        return entity.build();
    }

    private final String delegation$1(package.DIRACServer server$2) {
        return "/proxy/unknown/" + server$2.service().group();
    }
}

