/*
 * Decompiled with CFR 0.152.
 */
package org.openmole.plugin.tool.netlogo7;

import java.util.AbstractCollection;
import java.util.LinkedList;
import org.nlogo.agent.Observer;
import org.nlogo.agent.World;
import org.nlogo.api.LogoException;
import org.nlogo.api.LogoListBuilder;
import org.nlogo.core.LogoList;
import org.nlogo.headless.HeadlessWorkspace;
import org.nlogo.nvm.Procedure;
import org.openmole.plugin.tool.netlogo.NetLogo;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters;

public class NetLogo7
implements NetLogo {
    protected HeadlessWorkspace workspace = null;

    private HeadlessWorkspace getWorkspace() {
        if (this.workspace == null) {
            System.setProperty("netlogo.libraries.disabled", "true");
            this.workspace = HeadlessWorkspace.newInstance();
        }
        return this.workspace;
    }

    public void open(String string, boolean bl) throws Exception {
        if (bl && string.endsWith("3d")) {
            System.setProperty("org.nlogo.is3d", "true");
        } else {
            System.setProperty("org.nlogo.is3d", "false");
        }
        this.getWorkspace().open(string, false);
    }

    public void command(String string) throws Exception {
        this.getWorkspace().command(string);
    }

    public boolean isNetLogoException(Throwable throwable) {
        return LogoException.class.isAssignableFrom(throwable.getClass());
    }

    public Object report(String string) throws Exception {
        Object object = this.getWorkspace().report(string);
        if (object instanceof LogoList) {
            return NetLogo7.listToCollection((LogoList)object);
        }
        return object;
    }

    public void setGlobal(String string, Object object) throws Exception {
        if (object instanceof Object[]) {
            this.workspace.world().setObserverVariableByName(string, (Object)NetLogo7.arrayToList((Object[])object));
        } else {
            this.workspace.world().setObserverVariableByName(string, object);
        }
    }

    public void dispose() throws Exception {
        this.getWorkspace().dispose();
    }

    public String[] globals() {
        World world = this.getWorkspace().world();
        Observer observer = world.observer();
        String[] stringArray = new String[world.getVariablesArraySize(observer)];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = world.observerOwnsNameAt(i);
        }
        return stringArray;
    }

    public String[] reporters() {
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Tuple2 tuple2 : JavaConverters.asJavaCollectionConverter((Iterable)this.getWorkspace().procedures()).asJavaCollection()) {
            if (!((Procedure)tuple2._2()).isReporter()) continue;
            linkedList.add((String)tuple2._1());
        }
        return linkedList.toArray(new String[0]);
    }

    public ClassLoader getNetLogoClassLoader() {
        return HeadlessWorkspace.class.getClassLoader();
    }

    private static LogoList arrayToList(Object[] objectArray) {
        LogoListBuilder logoListBuilder = new LogoListBuilder();
        for (Object object : objectArray) {
            if (object instanceof Object[]) {
                logoListBuilder.add((Object)NetLogo7.arrayToList((Object[])object));
                continue;
            }
            logoListBuilder.add(object);
        }
        return logoListBuilder.toLogoList();
    }

    private static AbstractCollection listToCollection(LogoList logoList) {
        LinkedList linkedList = new LinkedList();
        for (Object e : logoList.toJava()) {
            if (e instanceof LogoList) {
                ((AbstractCollection)linkedList).add(NetLogo7.listToCollection((LogoList)e));
                continue;
            }
            ((AbstractCollection)linkedList).add(e);
        }
        return linkedList;
    }
}

